/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools;

import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.rtc.cli.infrastructure.internal.Messages;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommand;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.OptionGroupUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class GenerateHelpCmd
implements ISubcommand,
IOptionSource {
    IClientConfiguration config = null;
    String lang = null;
    public static final String NO_HELP_STRING = Messages.HelpCmd_0;
    public static final String HELP_FOLDERNAME = "scmclihelp";
    public static final String HELP_FILENAME = "scm_cli.html";
    public static PositionalOptionDefinition OPT_DIRECTORY = new PositionalOptionDefinition("directory", 1, 1);
    public static final NamedOptionDefinition OPT_LANG = new NamedOptionDefinition("l", "lang", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp("Generate html help for all the subcommands.");
        options.addOption((IPositionalOptionDefinition)OPT_DIRECTORY, "The directory where the help files are written.");
        options.addOption((INamedOptionDefinition)OPT_LANG, "The language to be set in the HTML tag.");
        return options;
    }

    public void initialize(IClientConfiguration config) {
    }

    public int run(IClientConfiguration config) throws CLIClientException {
        ILocation helpFolderLoc;
        this.config = config;
        ICommandLine subargs = config.getSubcommandCommandLine();
        if (subargs.hasOption((IOptionKey)OPT_LANG)) {
            this.lang = subargs.getOption((IOptionKey)OPT_LANG);
        }
        String helpFolderPath = subargs.getOption((IOptionKey)OPT_DIRECTORY);
        try {
            helpFolderLoc = SubcommandUtil.makeAbsolutePath((String)config.getContext().getCurrentWorkingDirectory(), (String)helpFolderPath);
        }
        catch (FileSystemException e) {
            throw new CLIClientException((Throwable)e);
        }
        File helpFolder = new File(helpFolderLoc.toOSString(), HELP_FOLDERNAME);
        helpFolder.mkdirs();
        try {
            this.generateHelp(helpFolder);
        }
        catch (FileSystemException e) {
            throw new CLIClientException((Throwable)e);
        }
        return 0;
    }

    private void generateHelp(File helpFolder) throws FileSystemException {
        File helpFilePath = new File(helpFolder, HELP_FILENAME);
        Writer writer = null;
        try {
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(helpFilePath), "UTF-8"));
                this.writeHTMLTopPart((BufferedWriter)writer, null);
                writer.write("<body>");
                ((BufferedWriter)writer).newLine();
                ArrayList subcommands = new ArrayList(this.config.getSubcommandDefinitions());
                Collections.sort(subcommands, new SubcommandNameCompator());
                LinkedList<FileSystemException> exceptions = new LinkedList<FileSystemException>();
                StringBuffer erroringNames = new StringBuffer();
                for (ISubcommandDefinition defn : subcommands) {
                    if (!defn.showInHelpListing(this.config) || (defn.isParent() ? defn.isDeprecated() && !this.hasVisibleChildren(defn) : defn.isDeprecated())) continue;
                    try {
                        this.generateSubcommandHelp(this.config, defn, helpFolder, (BufferedWriter)writer);
                    }
                    catch (FileSystemException e) {
                        this.config.getContext().stderr().println(NLS.bind((String)Messages.HelpCmd_9, (Object)defn.getFullSubcommandName()));
                        exceptions.add(e);
                        if (erroringNames.length() > 0) {
                            erroringNames.append(Messages.HelpCmd_10);
                        }
                        erroringNames.append(defn.getFullSubcommandName());
                    }
                }
                if (exceptions.size() > 0) {
                    throw StatusHelper.internalError((String)NLS.bind((String)Messages.HelpCmd_11, (Object)erroringNames.toString()), exceptions);
                }
            }
            catch (IOException e) {
                this.config.getContext().stderr().println("IOException when creating a writer for " + helpFilePath.getAbsolutePath());
                try {
                    if (writer != null) {
                        writer.write("</body></html>");
                        ((BufferedWriter)writer).flush();
                        ((BufferedWriter)writer).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.write("</body></html>");
                    ((BufferedWriter)writer).flush();
                    ((BufferedWriter)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void writeHTMLTopPart(BufferedWriter writer, String commandName) throws IOException {
        if (this.lang != null) {
            writer.write("<html lang=\"" + this.lang + "\">");
        } else {
            writer.write("<html>");
        }
        writer.newLine();
        writer.write("<head>");
        writer.newLine();
        String title = commandName != null ? commandName : Messages.HelpCmd_title;
        writer.write("<title>" + title + "</title>");
        writer.newLine();
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        writer.newLine();
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"PLUGINS_ROOT/com.ibm.help.common.resources.doc/css/help.css\" />");
        writer.newLine();
        writer.write("</head>");
        writer.newLine();
    }

    private Options getOptions(ISubcommandDefinition defn) throws CLIFileSystemClientException {
        Options options;
        String commandName = defn.getFullSubcommandName();
        try {
            options = defn.getOptions();
        }
        catch (ISubcommandDefinition.LoadOptionsException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.HelpCmd_16, (Object)commandName, (Object)e.getCause().getMessage()), (Throwable)e);
        }
        catch (ConflictingOptionException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.HelpCmd_17, (Object)commandName, (Object)e.getMessage()), (Throwable)e);
        }
        return options;
    }

    private void generateSubcommandHelp(IClientConfiguration config, ISubcommandDefinition defn, File helpFolder, BufferedWriter writer) throws FileSystemException, IOException {
        List ancestors = defn.getAncestors();
        StringBuffer commandNameHierarchy = new StringBuffer();
        for (ISubcommandDefinition ancestor : ancestors) {
            commandNameHierarchy.append(ancestor.getFullSubcommandName());
            commandNameHierarchy.append(" ");
        }
        commandNameHierarchy.append(defn.getFullSubcommandName());
        String commandName = commandNameHierarchy.toString();
        if (ancestors == null || ancestors.size() == 0) {
            boolean isLink = true;
            if (defn.isParent()) {
                isLink = false;
                if (defn.isRunnable() && !defn.isDeprecated()) {
                    isLink = true;
                }
            }
            this.writeSubcommandName(writer, commandName, null, isLink);
            String help = defn.getShortHelp();
            if (help != null && help.length() > 0) {
                this.writeDescription(writer, help);
            }
            this.writeNewLine(writer);
        }
        if (defn.isParent()) {
            ArrayList children = new ArrayList(defn.getChildren());
            Collections.sort(children, new SubcommandNameCompator());
            writer.write("<table border=\"0\">");
            writer.newLine();
            for (ISubcommandDefinition child : children) {
                writer.write("<tr>");
                writer.newLine();
                writer.write("<td style=\"width: 50px\">");
                writer.write("</td>");
                writer.newLine();
                writer.write("<td>");
                writer.write("<p>");
                this.writeSubcommandName(writer, child.getFullSubcommandName(), commandName, !child.isParent());
                String help = child.getShortHelp();
                if (help != null && help.length() > 0) {
                    writer.write(help);
                }
                writer.write("</p>");
                writer.write("</td>");
                writer.newLine();
                writer.write("</tr>");
                writer.newLine();
            }
            writer.write("</table>");
            writer.newLine();
            if (!defn.isRunnable()) {
                return;
            }
            if (defn.isDeprecated()) {
                return;
            }
        }
        String subcommandHelpFileName = String.valueOf(commandName.replace(' ', '_')) + ".html";
        File subcommandHelpFile = new File(helpFolder, subcommandHelpFileName);
        this.generateSubcommandHelp(defn, commandName, subcommandHelpFile);
    }

    private void generateSubcommandHelp(ISubcommandDefinition defn, String commandName, File subcommandHelpFile) throws IOException, FileSystemException {
        Options options = this.getOptions(defn);
        String commandHelp = options.getLongHelp();
        if (commandHelp == null || commandHelp.length() == 0) {
            commandHelp = defn.getShortHelp();
        }
        Writer subCmdWriter = null;
        try {
            try {
                String[] aliases;
                subCmdWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(subcommandHelpFile), "UTF-8"));
                this.writeHTMLTopPart((BufferedWriter)subCmdWriter, commandName);
                subCmdWriter.write("<body>");
                ((BufferedWriter)subCmdWriter).newLine();
                this.writeSubcommandName((BufferedWriter)subCmdWriter, commandName, null, false);
                if (commandHelp != null && commandHelp.length() > 0) {
                    this.writeDescription((BufferedWriter)subCmdWriter, commandHelp);
                }
                List ancestors = defn.getAncestors();
                StringBuffer parentCommands = new StringBuffer();
                if (ancestors != null) {
                    boolean trailing = false;
                    for (ISubcommandDefinition ancestor : ancestors) {
                        if (trailing) {
                            parentCommands.append(Messages.HelpCmd_13);
                        }
                        trailing = true;
                        parentCommands.append(ancestor.getFullSubcommandName());
                    }
                }
                if ((aliases = defn.getAliases()).length > 0) {
                    this.writeText((BufferedWriter)subCmdWriter, Messages.HelpCmd_21, true);
                    boolean trailing = false;
                    StringBuffer aliasesStr = new StringBuffer();
                    String[] stringArray = aliases;
                    int n = aliases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String alias = stringArray[n2];
                        if (trailing) {
                            aliasesStr.append(Messages.HelpCmd_10);
                        }
                        trailing = true;
                        aliasesStr.append(parentCommands.toString().isEmpty() ? alias : String.valueOf(parentCommands.toString()) + Messages.HelpCmd_13 + alias);
                        ++n2;
                    }
                    this.writeText((BufferedWriter)subCmdWriter, aliasesStr.toString(), false);
                }
                if (options.getSupportsNewHelp()) {
                    this.showNewUsage((BufferedWriter)subCmdWriter, options, commandName);
                } else {
                    this.showUsage((BufferedWriter)subCmdWriter, options, commandName);
                }
                this.writeNewLine((BufferedWriter)subCmdWriter);
                subCmdWriter.write("<a href=\"");
                String exampleLink = subcommandHelpFile.getName().replaceAll(".html", "_ex.html");
                subCmdWriter.write(exampleLink);
                subCmdWriter.write("\">");
                this.writeText((BufferedWriter)subCmdWriter, Messages.HelpCmd_Example, true);
                subCmdWriter.write("</a>");
            }
            catch (IOException iOException) {
                if (subCmdWriter != null) {
                    subCmdWriter.write("</body></html>");
                    ((BufferedWriter)subCmdWriter).flush();
                    ((BufferedWriter)subCmdWriter).close();
                }
            }
        }
        finally {
            if (subCmdWriter != null) {
                subCmdWriter.write("</body></html>");
                ((BufferedWriter)subCmdWriter).flush();
                ((BufferedWriter)subCmdWriter).close();
            }
        }
    }

    private void showNewUsage(BufferedWriter subCmdWriter, Options options, String fullSubcommandName) throws IOException {
        List resultOptStrings = OptionGroupUtil.getShortUsageHelpForHtml((Options)options);
        StringBuffer usageString = new StringBuffer();
        if (resultOptStrings.size() > 1) {
            subCmdWriter.write("<b>");
            subCmdWriter.write(NLS.bind((String)Messages.HelpCmd_23, (Object)""));
            subCmdWriter.write("</b>");
            subCmdWriter.newLine();
        } else {
            usageString = new StringBuffer(NLS.bind((String)Messages.HelpCmd_23, (Object)this.config.getContext().getAppName()));
            usageString.append(" ");
        }
        usageString.append(fullSubcommandName);
        for (StringBuffer resultOptString : resultOptStrings) {
            subCmdWriter.write("<p>");
            subCmdWriter.write("<table border=\"0\">");
            subCmdWriter.newLine();
            subCmdWriter.write("<tr>");
            subCmdWriter.newLine();
            subCmdWriter.write("<td nowrap valign=\"top\">");
            subCmdWriter.write("<b>");
            subCmdWriter.write(usageString.toString());
            subCmdWriter.write("</b>");
            subCmdWriter.write("</td>");
            subCmdWriter.newLine();
            subCmdWriter.write("<td valign=\"top\">");
            subCmdWriter.write("<b>");
            subCmdWriter.write(resultOptString.toString());
            subCmdWriter.write("</b>");
            subCmdWriter.write("</td>");
            subCmdWriter.newLine();
            subCmdWriter.write("</tr>");
            subCmdWriter.newLine();
            subCmdWriter.write("</table>");
            subCmdWriter.write("</p>");
        }
        this.showUsageCommon(subCmdWriter, options, true);
    }

    private void showUsage(BufferedWriter subCmdWriter, Options options, String fullSubcommandName) throws IOException {
        StringBuffer usageLine = new StringBuffer(NLS.bind((String)Messages.HelpCmd_23, (Object)this.config.getContext().getAppName()));
        usageLine.append(" ");
        usageLine.append(fullSubcommandName);
        if (options.getNamedOptions().size() > 0) {
            usageLine.append(" ").append(Messages.HelpCmd_29);
        }
        for (IPositionalOptionDefinition opt : options.getPositionalOptions()) {
            boolean isRequired;
            boolean bl = isRequired = opt.getMinCount() > 0;
            if (isRequired) {
                usageLine.append("&lt;");
            } else {
                usageLine.append("[");
            }
            usageLine.append(opt.getName());
            if (opt.getMaxCount() == -1) {
                usageLine.append("...");
            }
            if (isRequired) {
                usageLine.append("&gt;");
                continue;
            }
            usageLine.append("]");
        }
        this.writeText(subCmdWriter, usageLine.toString(), true);
        this.showUsageCommon(subCmdWriter, options, false);
    }

    private void showUsageCommon(BufferedWriter subCmdWriter, Options options, boolean isNewStyle) throws IOException {
        subCmdWriter.write("<table border=\"0\">");
        subCmdWriter.newLine();
        for (IPositionalOptionDefinition opt : options.getPositionalOptions()) {
            subCmdWriter.write("<tr>");
            subCmdWriter.newLine();
            subCmdWriter.write("<td valign=\"top\">");
            subCmdWriter.write(opt.getName());
            subCmdWriter.write("</td>");
            subCmdWriter.newLine();
            subCmdWriter.write("<td valign=\"top\">");
            subCmdWriter.write(options.getHelpFor(opt.getId()));
            subCmdWriter.write("</td>");
            subCmdWriter.newLine();
            subCmdWriter.write("</tr>");
            subCmdWriter.newLine();
        }
        subCmdWriter.write("</table>");
        subCmdWriter.newLine();
        if (options.getNamedOptions().size() > 0) {
            this.writeText(subCmdWriter, Messages.HelpCmd_31, true);
        }
        ArrayList namedOptions = new ArrayList(options.getNamedOptions());
        if (!isNewStyle) {
            Collections.sort(namedOptions, new NamedOptionComparator());
        }
        subCmdWriter.write("<table border=\"0\">");
        subCmdWriter.newLine();
        for (INamedOptionDefinition opt : namedOptions) {
            if (opt.isHidden()) continue;
            StringBuffer buf = new StringBuffer();
            this.getFormattedNamedOption(opt, buf, isNewStyle);
            subCmdWriter.write("<tr>");
            subCmdWriter.newLine();
            subCmdWriter.write("<td valign=\"top\">");
            subCmdWriter.write(buf.toString());
            subCmdWriter.write("</td>");
            subCmdWriter.newLine();
            subCmdWriter.write("<td valign=\"top\">");
            subCmdWriter.write(options.getHelpFor(opt.getId()));
            subCmdWriter.write("</td>");
            subCmdWriter.newLine();
            subCmdWriter.write("</tr>");
            subCmdWriter.newLine();
        }
        subCmdWriter.write("</table>");
        this.writeNewLine(subCmdWriter);
    }

    private void getFormattedNamedOption(INamedOptionDefinition opt, StringBuffer buf, boolean isNewStyle) {
        block14: {
            int i;
            block13: {
                if (isNewStyle) break block13;
                boolean hasShortOpt = false;
                if (opt.getShortOpt() != null) {
                    buf.append("-" + opt.getShortOpt());
                    hasShortOpt = true;
                }
                if (opt.getLongOpt() == null) break block14;
                if (hasShortOpt) {
                    buf.append(" ");
                }
                if (hasShortOpt) {
                    buf.append("[");
                }
                buf.append("--" + opt.getLongOpt());
                if (!hasShortOpt) break block14;
                buf.append("]");
                break block14;
            }
            boolean hasShortOpt = false;
            if (opt.getShortOpt() != null) {
                buf.append("-" + opt.getShortOpt());
                hasShortOpt = true;
            }
            if (opt.getLongOpt() != null) {
                String commaSequence = ", ";
                if (hasShortOpt) {
                    buf.append(commaSequence);
                } else {
                    int whiteSpaceLength = "-".length() + 1 + commaSequence.length();
                    i = 0;
                    while (i < whiteSpaceLength) {
                        buf.append("&nbsp;");
                        ++i;
                    }
                }
                buf.append("--" + opt.getLongOpt());
            }
            if (opt.getArgCount() == -1) {
                buf.append(" &lt;arg ...&gt;");
            } else {
                int minArgCount = opt.getMinArgCount();
                int argCount = opt.getArgCount();
                i = 0;
                while (i < argCount) {
                    if (i < minArgCount) {
                        buf.append(" &lt;arg&gt;");
                    } else {
                        buf.append(Messages.HelpCmd_38);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean hasVisibleChildren(ISubcommandDefinition defn) {
        ArrayList children = new ArrayList(defn.getChildren());
        for (ISubcommandDefinition child : children) {
            if (!child.showInHelpListing(this.config) || child.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    private void writeSubcommandName(BufferedWriter writer, String name, String ancestorName, boolean asLink) throws IOException {
        writer.write("<h3>");
        if (asLink) {
            String subcommandLink = name;
            if (ancestorName != null) {
                subcommandLink = String.valueOf(ancestorName) + " " + name;
            }
            subcommandLink = String.valueOf(subcommandLink.replace(' ', '_')) + ".html";
            writer.write("<a href=\"");
            writer.write(subcommandLink);
            writer.write("\">");
        }
        writer.write(name);
        if (asLink) {
            writer.write("</a>");
        }
        writer.write("</h3>");
        writer.newLine();
    }

    private void writeDescription(BufferedWriter writer, String help) throws IOException {
        writer.write("<p>");
        writer.write(help);
        writer.write("</p>");
        writer.newLine();
    }

    private void writeText(BufferedWriter writer, String text, boolean isBold) throws IOException {
        writer.write("<p>");
        if (isBold) {
            writer.write("<b>");
        }
        writer.write(text);
        if (isBold) {
            writer.write("</b>");
        }
        writer.write("</p>");
        writer.newLine();
    }

    private void writeNewLine(BufferedWriter writer) throws IOException {
        writer.write("<br/>");
        writer.newLine();
    }

    private static final class NamedOptionComparator
    implements Comparator<INamedOptionDefinition> {
        private NamedOptionComparator() {
        }

        @Override
        public int compare(INamedOptionDefinition o1, INamedOptionDefinition o2) {
            String s1 = o1.getShortOpt();
            String s2 = o2.getShortOpt();
            if (s1 == null && s2 == null) {
                s1 = o1.getLongOpt();
                s2 = o2.getLongOpt();
            }
            if (s1 != null && s2 != null) {
                return s1.compareToIgnoreCase(s2);
            }
            if (s1 != null) {
                return 1;
            }
            if (s2 != null) {
                return -1;
            }
            return o1.getArgCount() - o2.getArgCount();
        }
    }

    public static class SubcommandNameCompator
    implements Comparator<ISubcommandDefinition> {
        @Override
        public int compare(ISubcommandDefinition o1, ISubcommandDefinition o2) {
            return o1.getFullSubcommandName().compareTo(o2.getFullSubcommandName());
        }
    }
}

