/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.Baseline;
import com.ibm.team.scm.common.internal.ComponentEntry;
import com.ibm.team.scm.common.internal.HistoricBasis;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DumpStreamsAndComponentsCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final PositionalOptionDefinition OPT_PROJECT_AREA = new PositionalOptionDefinition("pa", 0, 1);
    private static final int MY_FETCH_PAGE_SIZE = 500;

    public void run() throws FileSystemException {
        BufferedWriter baselines;
        BufferedWriter streams;
        BufferedWriter processAreas;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        String projectAreaName = subargs.getOption((IOptionKey)OPT_PROJECT_AREA, null);
        ConnectionInfo connection = this.config.getConnectionInfo();
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)this.config, (ConnectionInfo)connection);
        try {
            processAreas = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("processAreas.json")));
            streams = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("streams.json")));
            baselines = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("baselines.json")));
        }
        catch (FileNotFoundException e) {
            throw new FileSystemException((Throwable)e);
        }
        try {
            List<IProcessAreaHandle> owners;
            try {
                owners = this.fetchProjectAreas(processAreas, projectAreaName, repo);
            }
            catch (RuntimeException e) {
                System.out.println(e.getMessage());
                try {
                    processAreas.close();
                }
                catch (IOException e2) {
                    throw new FileSystemException((Throwable)e2);
                }
                try {
                    streams.close();
                }
                catch (IOException e3) {
                    throw new FileSystemException((Throwable)e3);
                }
                try {
                    baselines.close();
                }
                catch (IOException e4) {
                    throw new FileSystemException((Throwable)e4);
                }
                return;
            }
            try {
                this.fetchStreamsAndBaselines(streams, baselines, owners, repo);
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        finally {
            try {
                processAreas.close();
            }
            catch (IOException e) {
                throw new FileSystemException((Throwable)e);
            }
            try {
                streams.close();
            }
            catch (IOException e) {
                throw new FileSystemException((Throwable)e);
            }
            try {
                baselines.close();
            }
            catch (IOException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
    }

    private List<IProcessAreaHandle> fetchProjectAreas(BufferedWriter processAreas, String rootProcessAreaName, ITeamRepository repo) throws TeamRepositoryException, IOException {
        System.out.println("Fetch project areas");
        IProcessItemService process = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        List<Object> allProjectAreas = process.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
        if (rootProcessAreaName != null) {
            IProjectArea foundRoot = null;
            for (IProjectArea iProjectArea : allProjectAreas) {
                if (!rootProcessAreaName.equals(iProjectArea.getName())) continue;
                foundRoot = iProjectArea;
                break;
            }
            if (foundRoot == null) {
                System.out.println("Known project areas:");
                for (IProcessArea iProcessArea : allProjectAreas) {
                    System.out.println("  " + iProcessArea.getName());
                }
                throw new RuntimeException("Unable to find project area named " + rootProcessAreaName);
            }
            allProjectAreas = Collections.singletonList(foundRoot);
            System.out.println("Found project area " + rootProcessAreaName);
        }
        System.out.println("Recording project areas");
        ArrayList<IProcessAreaHandle> owners = new ArrayList<IProcessAreaHandle>();
        for (IProjectArea iProjectArea : allProjectAreas) {
            List teamAreas = repo.itemManager().fetchCompleteItems(iProjectArea.getTeamAreas(), 0, null);
            JSONObject paJSON = new JSONObject();
            paJSON.put((Object)"paName", (Object)iProjectArea.getName());
            paJSON.put((Object)"paUuid", (Object)iProjectArea.getItemId().getUuidValue());
            paJSON.serialize((Writer)processAreas);
            processAreas.write("\n");
            owners.add((IProcessAreaHandle)iProjectArea);
            ITeamAreaHierarchy hier = iProjectArea.getTeamAreaHierarchy();
            for (ITeamArea ta : teamAreas) {
                owners.add((IProcessAreaHandle)ta);
                JSONObject taJSON = new JSONObject();
                taJSON.put((Object)"taName", (Object)ta.getName());
                taJSON.put((Object)"taUuid", (Object)ta.getItemId().getUuidValue());
                if (hier.getParent((ITeamAreaHandle)ta) != null) {
                    taJSON.put((Object)"taParent", (Object)hier.getParent((ITeamAreaHandle)ta).getItemId().getUuidValue());
                }
                taJSON.put((Object)"paUuid", (Object)iProjectArea.getItemId().getUuidValue());
                taJSON.serialize((Writer)processAreas);
                processAreas.write("\n");
            }
        }
        processAreas.close();
        return owners;
    }

    private void fetchStreamsAndBaselines(BufferedWriter streams, BufferedWriter baselines, List<IProcessAreaHandle> owners, ITeamRepository repo) throws TeamRepositoryException, IOException {
        IWorkspaceSearchCriteria search = IWorkspaceSearchCriteria.FACTORY.newInstance();
        search.setKind(1);
        if (owners != null) {
            search.getFilterByOwnerOptional().addAll(owners);
        }
        HashMap<UUID, IComponent> comps = new HashMap<UUID, IComponent>();
        HashSet<UUID> baselineUuids = new HashSet<UUID>();
        System.out.println("Fetching stream list");
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        List workspaces = manager.findWorkspaces(search, Integer.MAX_VALUE, null);
        System.out.println(String.valueOf(workspaces.size()) + " streams to query");
        IScmService scmService = ((WorkspaceManager)manager).getServerConfigurationService();
        int cur = 0;
        int written = 0;
        BaselinePagerAndWriter blPagerAndWriter = new BaselinePagerAndWriter(repo, baselines);
        while (cur < workspaces.size()) {
            ArrayList<IWorkspaceHandle> currentPage = new ArrayList<IWorkspaceHandle>(500);
            int endOfPage = cur + 500;
            while (cur < endOfPage && cur < workspaces.size()) {
                currentPage.add((IWorkspaceHandle)workspaces.get(cur));
                ++cur;
            }
            List fullWorkspaces = repo.itemManager().fetchCompleteItems(currentPage, 0, null);
            for (IWorkspace ws : fullWorkspaces) {
                if (ws == null) continue;
                Collection entries = ((WorkspaceManager)manager).getComponentEntries((IWorkspaceHandle)ws, null);
                this.updateComponentList(repo, entries, comps);
                System.out.println("Dumping stream " + ws.getName() + " [" + written++ + "/" + workspaces.size() + "]");
                IWorkspaceConnection conn = manager.getWorkspaceConnection((IWorkspaceHandle)ws, null);
                this.dump(streams, blPagerAndWriter, repo, scmService, ws, conn, entries, baselineUuids, comps);
                ((WorkspaceManager)manager).clearCaches();
            }
        }
        blPagerAndWriter.doFetch();
    }

    private void updateComponentList(ITeamRepository repo, Collection<ComponentEntry> entries, Map<UUID, IComponent> comps) throws TeamRepositoryException {
        ArrayList<IComponentHandle> toFetch = new ArrayList<IComponentHandle>(entries.size());
        for (ComponentEntry ce : entries) {
            IComponentHandle comp = ce.getComponent();
            if (comps.containsKey(comp.getItemId())) continue;
            toFetch.add(comp);
        }
        List fetched = repo.itemManager().fetchCompleteItems(toFetch, 0, null);
        for (IComponent f : fetched) {
            if (f == null) continue;
            comps.put(f.getItemId(), f);
        }
    }

    private void dump(Writer stream, BaselinePagerAndWriter blPagerAndWriter, ITeamRepository repo, IScmService scmService, IWorkspace ws, IWorkspaceConnection conn, Collection<ComponentEntry> entries, Set<UUID> baselineUuids, Map<UUID, IComponent> comps) throws TeamRepositoryException, IOException {
        int ct = 0;
        for (ComponentEntry ce : entries) {
            IComponent comp = comps.get(ce.getComponent().getItemId());
            System.out.println("  Dumping " + ws.getName() + " / " + comp.getName() + " [" + ct++ + "/" + entries.size() + "]");
            JSONArray compBaselines = new JSONArray();
            int componentOffset = 0;
            long totalBasis = conn.getComponentInfo(ce.getComponent()).numBasisInHistory();
            while ((long)compBaselines.size() < totalBasis) {
                HistoricBasis[] historicBasis = scmService.getComponentHistory((IWorkspaceHandle)ws, ce.getComponent(), (long)componentOffset, totalBasis - (long)componentOffset, null, null);
                if (historicBasis.length == 0) break;
                componentOffset += historicBasis.length;
                HistoricBasis[] historicBasisArray = historicBasis;
                int n = historicBasis.length;
                int n2 = 0;
                while (n2 < n) {
                    HistoricBasis hb = historicBasisArray[n2];
                    JSONObject hbJSON = new JSONObject();
                    hbJSON.put((Object)"deliveredBy", (Object)hb.getDeliveredBy().getItemId().getUuidValue());
                    if (hb.getBasis() == null) {
                        System.out.println("null basis");
                    } else {
                        hbJSON.put((Object)"basis", (Object)hb.getBasis().getItemId().getUuidValue());
                        if (!baselineUuids.contains(hb.getBasis().getItemId())) {
                            blPagerAndWriter.record(hb.getBasis());
                            baselineUuids.add(hb.getBasis().getItemId());
                        }
                    }
                    hbJSON.put((Object)"deliveredDate", (Object)hb.getDeliveryDate().toGMTString());
                    hbJSON.put((Object)"isReplace", (Object)hb.isReplace());
                    compBaselines.add((Object)hbJSON);
                    ++n2;
                }
                System.out.println("    Recorded " + componentOffset + "/" + totalBasis + " baselines");
            }
            JSONObject wsJSON = new JSONObject();
            wsJSON.put((Object)"type", (Object)"compHistory");
            wsJSON.put((Object)"workspaceName", (Object)ws.getName());
            wsJSON.put((Object)"workspaceUuid", (Object)ws.getItemId().getUuidValue());
            wsJSON.put((Object)"ownerUuid", (Object)ws.getOwner().getItemId().getUuidValue());
            wsJSON.put((Object)"componentUuid", (Object)ce.getComponent().getItemId().getUuidValue());
            wsJSON.put((Object)"componentName", (Object)comp.getName());
            wsJSON.put((Object)"baselines", (Object)compBaselines);
            wsJSON.serialize(stream);
            stream.write("\n");
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)OPT_PROJECT_AREA, "Optional project area name. If specified, only streams in that project area will be queried.");
        return options;
    }

    public static class BaselinePagerAndWriter {
        private final ITeamRepository repo;
        private final Writer stream;
        private List<IBaselineHandle> toFetch;

        public BaselinePagerAndWriter(ITeamRepository repo, Writer stream) {
            this.repo = repo;
            this.stream = stream;
            this.toFetch = new ArrayList<IBaselineHandle>(600);
        }

        public void record(IBaselineHandle toWrite) throws IOException, TeamRepositoryException {
            this.toFetch.add(toWrite);
            if (this.toFetch.size() >= 500) {
                this.doFetch();
            }
        }

        public void doFetch() throws IOException, TeamRepositoryException {
            List fullBaselines = this.repo.itemManager().fetchCompleteItems(this.toFetch, 0, null);
            for (IBaseline bl : fullBaselines) {
                if (bl == null) continue;
                JSONObject blJSON = new JSONObject();
                blJSON.put((Object)"blNumber", (Object)bl.getId());
                blJSON.put((Object)"blName", (Object)bl.getName());
                blJSON.put((Object)"blUuid", (Object)bl.getItemId().getUuidValue());
                blJSON.put((Object)"componentUuid", (Object)bl.getComponent().getItemId().getUuidValue());
                blJSON.put((Object)"historyUuid", (Object)((Baseline)bl).getHistory().getItemId().getUuidValue());
                blJSON.put((Object)"graphNode", (Object)((Baseline)bl).getHistoryGraphNode());
                blJSON.serialize(this.stream);
                this.stream.write("\n");
            }
            this.toFetch = new ArrayList<IBaselineHandle>(600);
            System.out.println("    Wrote " + fullBaselines.size() + " baselines");
        }
    }
}

