/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestRunTimeComparator {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Expected three arguments: test1.xml test2.xml outputfile.csv");
        }
        File test1 = new File(args[0]);
        File test2 = new File(args[1]);
        File output = new File(args[2]);
        TestRun t1 = TestRunTimeComparator.parse(test1);
        TestRun t2 = TestRunTimeComparator.parse(test2);
        TestRunTimeComparator.writeComparison(t1, t2, output);
    }

    private static void writeComparison(TestRun t1, TestRun t2, File output) throws IOException {
        try (FileWriter writer = new FileWriter(output);){
            writer.write("Test, ");
            writer.write(t1.file.getName());
            writer.write(", ");
            writer.write(t2.file.getName());
            writer.write(", \n");
            for (String test : t1.tests.keySet()) {
                double diff = t1.tests.get((Object)test).duration - t2.tests.get((Object)test).duration;
                String pf = String.valueOf(t1.tests.get((Object)test).passed ? "p" : "f") + (t2.tests.get((Object)test).passed ? "p" : "f");
                writer.write(String.valueOf(test) + ", " + t1.tests.get((Object)test).duration + ", " + t2.tests.get((Object)test).duration + ", " + diff + ", " + pf + "\n");
            }
        }
    }

    private static TestRun parse(File test) throws IOException {
        Pattern p = Pattern.compile("<testcase name=\"([^\"]+)\" classname=\"([^\"]+)\" time=\"([^\"]+)\"(/?)>");
        try (BufferedReader reader = new BufferedReader(new FileReader(test));){
            String line;
            TestRun testRun = new TestRun(test);
            while ((line = reader.readLine()) != null) {
                Matcher m = p.matcher(line.trim());
                if (!m.matches()) continue;
                String name = String.valueOf(m.group(2)) + "." + m.group(1);
                TestResult result = new TestResult(Double.parseDouble(m.group(3)), m.group(4).length() == 1);
                testRun.tests.put(name, result);
            }
            TestRun testRun2 = testRun;
            return testRun2;
        }
    }

    private static class TestResult {
        final double duration;
        final boolean passed;

        TestResult(double t, boolean p) {
            this.duration = t;
            this.passed = p;
        }
    }

    private static class TestRun {
        final LinkedHashMap<String, TestResult> tests = new LinkedHashMap();
        final File file;

        public TestRun(File file) {
            this.file = file;
        }
    }
}

