/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.TreeSet;

public class GenerateShellScript {
    private static String[] requiredPaths = new String[]{"com.ibm.team.filesystem.cli.minimal", "com.ibm.team.rtc.cli.infrastructure", "com.ibm.team.filesystem.cli.core", "com.ibm.team.filesystem.client.daemon", "org.eclipse.equinox.common", "com.ibm.team.filesystem.client", "org.eclipse.osgi", "com.ibm.team.repository.common"};
    private static final String DEFAULT_JAVA_EXECUTABLE = "../../client/eclipse/jdk/jre/bin/java";
    private static final String LSCM_USE_JAVA_FEC = "LSCM_USE_JAVA_FEC";

    public static void main(String[] args) throws IOException {
        String javaPath;
        if (args.length != 4 && args.length != 5) {
            System.err.println("Require 4 or 5 arguments: path-to-plugins-dir, output-path-directory, filename, daemon-command-name, optional-java-path");
            System.exit(1);
        }
        File pluginsDir = new File(args[0]).getCanonicalFile();
        File outputPath = new File(args[1]);
        String suffix = args[2];
        String daemonCommandName = args[3];
        String string = javaPath = args.length == 4 ? null : args[4];
        if (!outputPath.exists() || !outputPath.isDirectory()) {
            System.err.println("output-path-directory must be an existing directory");
            System.exit(1);
        }
        String[] pluginPaths = new String[requiredPaths.length];
        int i = 0;
        while (i < requiredPaths.length) {
            final String prefix = requiredPaths[i];
            String[] matches = pluginsDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
            TreeSet set = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            Collections.addAll(set, matches);
            pluginPaths[i] = (String)set.last();
            ++i;
        }
        File batchFile = new File(outputPath + File.separator + suffix + ".bat");
        GenerateShellScript.writeBatchFile(javaPath, batchFile, pluginPaths);
        File shellFile = new File(outputPath + File.separator + suffix);
        GenerateShellScript.writeScript(javaPath, shellFile, pluginPaths, daemonCommandName);
        File macShellFile = new File(outputPath + File.separator + suffix + ".sh.mac");
        GenerateShellScript.writeMacScript(macShellFile, pluginPaths, daemonCommandName);
    }

    private static void writeBatchFile(String javaPath, File outputPath, String[] pluginPaths) throws IOException {
        FileOutputStream out = new FileOutputStream(outputPath);
        if (javaPath == null) {
            javaPath = "%PRGPATH%/../../client/eclipse/jdk/jre/bin/java";
        }
        if (javaPath.charAt(0) == '/') {
            javaPath = javaPath.substring(1);
        }
        if ((javaPath = javaPath.replace('/', '\\')).charAt(0) != '\"') {
            javaPath = "\"" + javaPath + "\"";
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, Charset.defaultCharset());
            writer.write("@echo off\r\n");
            writer.write("SET PRGPATH=%~dp0\r\n");
            writer.write("SET JAVA=");
            writer.write(javaPath);
            writer.write("\r\n");
            writer.write("SET SCM_DAEMON_PATH=\"%PRGPATH%scm.exe\"\r\n");
            String fecSelectionLogic = "SET USE_NATIVE=1\r\n\r\nIF NOT \"%LSCM_USE_JAVA_FEC%\"==\"\" ( \r\n    SET USE_NATIVE=0\r\n)\r\n\r\nIF NOT \"%SCM_DAEMON_START_DEBUG%\"==\"\" ( \r\n    SET USE_NATIVE=0\r\n)\r\n\r\nIF NOT EXIST \"%PRGPATH%fec.exe\" (\r\n    SET USE_NATIVE=0\r\n)\r\n";
            writer.write(fecSelectionLogic);
            writer.write("\r\nIF \"%USE_NATIVE%\"==\"1\" (\r\n");
            writer.write("    \"%PRGPATH%fec.exe\" %*\r\n");
            writer.write(") ELSE (\r\n");
            writer.write("    %JAVA% -Xquickstart -Xshareclasses -classpath \"");
            boolean needsSep = false;
            String[] stringArray = pluginPaths;
            int n = pluginPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String plugin = stringArray[n2];
                if (needsSep) {
                    writer.write(";");
                }
                needsSep = true;
                writer.write("%PRGPATH%\\plugins\\" + plugin);
                ++n2;
            }
            String appName = GenerateShellScript.guessAppName(outputPath);
            writer.write("\" com.ibm.team.filesystem.cli.minimal.client.FrontEndClient \"" + appName + "\" %*\r\n)\r\n");
            writer.close();
        }
        finally {
            out.close();
        }
    }

    private static String guessAppName(File outputPath) {
        String name = outputPath.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(0, lastDot);
    }

    private static void writeScript(String javaPath, File outputPath, String[] pluginPaths, String daemonCommandName) throws IOException {
        FileOutputStream out = new FileOutputStream(outputPath);
        if (javaPath == null) {
            javaPath = "${PRGPATH}/../../client/eclipse/jdk/jre/bin/java";
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, Charset.defaultCharset());
            writer.write("#!/bin/sh\n");
            writer.write("PRGPATH=\"`dirname \"$0\"`\"\n");
            writer.write("export PRGPATH\n");
            writer.write("SCM_DAEMON_PATH=\"${PRGPATH}/" + daemonCommandName + "\"\n");
            writer.write("export SCM_DAEMON_PATH\n");
            writer.write("if [ `uname` = SunOS ];\n");
            writer.write("then\n");
            writer.write("\tEXTRA_JAVA_OPTS=\"\"\n");
            writer.write("else\n");
            writer.write("\tEXTRA_JAVA_OPTS=\"-Xquickstart -Xshareclasses\"\n");
            writer.write("fi\n");
            String fecSelectionLogic = "\nUSE_NATIVE=\"1\"\n\nif [ -n \"$LSCM_USE_JAVA_FEC\" ]; then\n    USE_NATIVE=\"0\"\nelif [ -n \"$SCM_DAEMON_START_DEBUG\" ]; then\n    USE_NATIVE=\"0\"\nelif [ ! -x \"${PRGPATH}/fec\" ]; then\n    USE_NATIVE=\"0\"\nfi\n\n";
            writer.write(fecSelectionLogic);
            writer.write("\nif [ \"$USE_NATIVE\" = \"1\" ]; then\n");
            writer.write("    \"${PRGPATH}/fec\" \"$@\"\n");
            writer.write("else\n");
            writer.write("    " + javaPath);
            writer.write(" $EXTRA_JAVA_OPTS -classpath \"");
            boolean needsSep = false;
            String[] stringArray = pluginPaths;
            int n = pluginPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String plugin = stringArray[n2];
                if (needsSep) {
                    writer.write(":");
                }
                needsSep = true;
                writer.write("${PRGPATH}/plugins/" + plugin);
                ++n2;
            }
            writer.write("\" com.ibm.team.filesystem.cli.minimal.client.FrontEndClient \"$0\" \"$@\"");
            writer.write("\nfi\n");
            writer.close();
        }
        finally {
            out.close();
        }
    }

    private static void writeMacScript(File outputPath, String[] pluginPaths, String daemonCommandName) throws IOException {
        try (FileOutputStream out = new FileOutputStream(outputPath);){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, Charset.defaultCharset());
            writer.write("#!/bin/sh\n");
            writer.write("PRGPATH=\"`dirname \"$0\"`\"\n");
            writer.write("export PRGPATH\n");
            writer.write("SCM_DAEMON_PATH=\"${PRGPATH}/" + daemonCommandName + "\"\n");
            writer.write("export SCM_DAEMON_PATH\n");
            String fecSelectionLogic = "\nUSE_NATIVE=\"1\"\n\nif [ -n \"$LSCM_USE_JAVA_FEC\" ]; then\n    USE_NATIVE=\"0\"\nelif [ -n \"$SCM_DAEMON_START_DEBUG\" ]; then\n    USE_NATIVE=\"0\"\nelif [ ! -x \"${PRGPATH}/fec\" ]; then\n    USE_NATIVE=\"0\"\nfi\n\n";
            writer.write(fecSelectionLogic);
            writer.write("\nif [ \"$USE_NATIVE\" = \"1\" ]; then\n");
            writer.write("    \"${PRGPATH}/fec\" \"$@\"\n");
            writer.write("else\n");
            writer.write("    java -classpath \"");
            boolean needsSep = false;
            String[] stringArray = pluginPaths;
            int n = pluginPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String plugin = stringArray[n2];
                if (needsSep) {
                    writer.write(":");
                }
                needsSep = true;
                writer.write("${PRGPATH}/plugins/" + plugin);
                ++n2;
            }
            writer.write("\" com.ibm.team.filesystem.cli.minimal.client.FrontEndClient \"$0\" \"$@\"");
            writer.write("\nfi\n");
            writer.close();
        }
    }
}

