/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.protocol;

import com.ibm.team.filesystem.cli.minimal.client.HttpSwitchingClient;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;

public abstract class ProtocolUtil {
    public static final String PROTOCOL_NAME = "vnd.ibm.jazz.cli.minimal-1.0";
    static final byte STRING_DELIM = 34;
    static final byte FIELD_SEPARATOR = 32;
    static final byte MESSAGE_TYPE_TERMINATOR = 46;
    static byte MINIMAL_NEWLINE = (byte)10;
    static byte[] HTTP_NEWLINE = new byte[]{13, 10};
    public static final String CHARSET_NAME_UTF8 = "UTF-8";
    static final byte ESCAPE_CHAR = 92;
    private static final byte[] ESCAPE_ESCAPE = new byte[]{92, 53, 99};
    private static final byte[] ESCAPE_QUOTE = new byte[]{92, 50, 50};
    private static final byte[] ESCAPE_CR = new byte[]{92, 48, 100};
    private static final byte[] ESCAPE_LF = new byte[]{92, 48, 97};

    public static boolean isCharsetUtf8(Charset charset) {
        if (charset == null || !Charset.isSupported(charset.name())) {
            return false;
        }
        if (CHARSET_NAME_UTF8.equalsIgnoreCase(charset.name())) {
            return true;
        }
        for (String alias : charset.aliases()) {
            if (!CHARSET_NAME_UTF8.equalsIgnoreCase(alias)) continue;
            return true;
        }
        return false;
    }

    public static byte[] transcodeToUtf8(byte[] input, Charset srcCharset) throws UnsupportedEncodingException {
        if (input == null || input.length < 0 || srcCharset == null) {
            throw new IllegalArgumentException();
        }
        if (ProtocolUtil.isCharsetUtf8(srcCharset)) {
            return input;
        }
        if (input.length == 0) {
            return input;
        }
        byte[] utf8Bytes = null;
        String srcStr = new String(input, srcCharset);
        try {
            utf8Bytes = srcStr.getBytes(CHARSET_NAME_UTF8);
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
        return utf8Bytes;
    }

    public static void writeLine(OutputStream out, String toWrite) throws IOException {
        out.write(toWrite.getBytes(CHARSET_NAME_UTF8));
        out.write(HTTP_NEWLINE);
    }

    public static void writeHttpBlockTerminator(OutputStream out) throws IOException {
        out.write(HTTP_NEWLINE);
    }

    public static String readLine(InputStream in) throws IOException {
        int read;
        StringBuilder b = new StringBuilder();
        boolean inText = true;
        while (true) {
            if ((read = in.read()) == -1) {
                if (b.length() == 0 && inText) {
                    return null;
                }
                throw new IOException("Client closed connection. Received: " + b);
            }
            if (read == 13 && inText) {
                inText = false;
                continue;
            }
            if (read == 10 && !inText) {
                return b.toString();
            }
            if (!inText) break;
            b.append((char)read);
        }
        throw new IOException("Unexpected state/input. State: " + (inText ? "inText" : "!inText") + " input: " + read + "  current line: " + b);
    }

    private static void writeEscaped(OutputStream out, byte[] arg) throws IOException {
        out.write(34);
        byte[] byArray = arg;
        int n = arg.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            switch (b) {
                case 92: {
                    out.write(ESCAPE_ESCAPE);
                    break;
                }
                case 34: {
                    out.write(ESCAPE_QUOTE);
                    break;
                }
                case 13: {
                    out.write(ESCAPE_CR);
                    break;
                }
                case 10: {
                    out.write(ESCAPE_LF);
                    break;
                }
                default: {
                    out.write(b);
                }
            }
            ++n2;
        }
        out.write(34);
    }

    public static void writeMessage(OutputStream out, MessageType msg, byte[] ... args) throws IOException {
        if (args.length != msg.getCardinality()) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream toWrite = new ByteArrayOutputStream();
        toWrite.write(msg.getWireText().getBytes(CHARSET_NAME_UTF8));
        toWrite.write(46);
        byte[][] byArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] arg = byArray[n2];
            toWrite.write(32);
            ProtocolUtil.writeEscaped(toWrite, arg);
            ++n2;
        }
        toWrite.write(MINIMAL_NEWLINE);
        out.write(toWrite.toByteArray());
    }

    public static void writeSubcommandDescription(HttpSwitchingClient.HttpSwitchResult conn, String appName, String[] args, Map<String, String> env, String cwd) throws IOException {
        OutputStream out = conn.getOutputStream();
        String UTF8 = CHARSET_NAME_UTF8;
        ProtocolUtil.writeMessage(out, MessageType.APP_NAME, new byte[][]{appName.getBytes(CHARSET_NAME_UTF8)});
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            ProtocolUtil.writeMessage(out, MessageType.ARGUMENT, new byte[][]{arg.getBytes(CHARSET_NAME_UTF8)});
            ++n2;
        }
        for (Map.Entry<String, String> entry : env.entrySet()) {
            ProtocolUtil.writeMessage(out, MessageType.ENVIRONMENT, entry.getKey().getBytes(CHARSET_NAME_UTF8), entry.getValue().getBytes(CHARSET_NAME_UTF8));
        }
        ProtocolUtil.writeMessage(out, MessageType.CWD, new byte[][]{cwd.getBytes(CHARSET_NAME_UTF8)});
        ProtocolUtil.writeMessage(out, MessageType.PREAMBLE_DONE, new byte[0][]);
        out.flush();
    }

    public static void writeMessage(OutputStream out, MessageType type, String[] strings) throws IOException {
        byte[][] arrays = new byte[strings.length][];
        int i = 0;
        while (i < strings.length) {
            arrays[i] = strings[i].getBytes(CHARSET_NAME_UTF8);
            ++i;
        }
        ProtocolUtil.writeMessage(out, type, arrays);
    }
}

