/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.protocol;

public enum MessageType {
    APP_NAME("app", 1),
    ARGUMENT("arg", 1),
    ENVIRONMENT("env", 2),
    PREAMBLE_DONE("preamble-done", 0),
    STDOUT("stdout", 1),
    STDERR("stderr", 1),
    EXIT_CODE("exit-code", 1),
    PASSWORD_READ("password-read", 2),
    PASSWORD_RESPONSE("password-entered", 1),
    STDIN_READ("stdin-request", 1),
    STDIN_RESPONSE("stdin-response", 1),
    STDIN_CLOSED("stdin-closed", 0),
    CWD("cwd", 1);

    private final String text;
    private final int cardinality;

    private MessageType(String text, int cardinality) {
        this.text = text;
        this.cardinality = cardinality;
    }

    public String getWireText() {
        return this.text;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    static MessageType fromWireFormat(String s) {
        MessageType[] messageTypeArray = MessageType.values();
        int n = messageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageType t = messageTypeArray[n2];
            if (t.getWireText().equals(s)) {
                return t;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown message type \"" + s + "\"");
    }
}

