/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.util;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemRestClient;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsWorkItem;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsWorkItemHierarchy;
import com.ibm.team.filesystem.common.internal.rest.client.core.ChangeSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.WorkItemHierarchyDTO;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.WorkItemHierarchyNodeDTO;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.WorkItemHierarchyRootDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ChangeSetUtil {
    public Map<String, ITeamRepository> repoStrToRepo = new HashMap<String, ITeamRepository>();

    public void validateRepoAndLogin(List<IScmCommandLineArgument> selectors, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine cli, boolean errorOnNoRepo) throws FileSystemException {
        block0: for (IScmCommandLineArgument selector : selectors) {
            if (selector.getRepositorySelector() == null) {
                if (!errorOnNoRepo) continue;
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetLocateCmd_UNABLE_TO_DETERMINE_REPO, (Object)selector.getItemSelector(), (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_URI).getName()));
            }
            if (this.repoStrToRepo.keySet().contains(selector.getRepositorySelector())) continue;
            for (Map.Entry<String, ITeamRepository> entry : this.repoStrToRepo.entrySet()) {
                if (!RepoUtil.isRepoUriSame((String)entry.getValue().getRepositoryURI(), (String)selector.getRepositorySelector(), (IScmClientConfiguration)config)) continue;
                this.repoStrToRepo.put(selector.getRepositorySelector(), entry.getValue());
                continue block0;
            }
            ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)config.getConnectionInfo(selector.getRepositorySelector()));
            this.repoStrToRepo.put(selector.getRepositorySelector(), repo);
        }
    }

    public Map<String, ChangeSetSyncDTO> getChangeSetsFromWorkitem(List<IScmCommandLineArgument> selectors, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config, boolean includeChildWorkitems) throws FileSystemException {
        ArrayList<WorkItemHierarchyNodeDTO> wiHierarchyList = new ArrayList<WorkItemHierarchyNodeDTO>();
        return this.getChangeSetsFromWorkitem(selectors, repo, client, config, includeChildWorkitems, wiHierarchyList);
    }

    public Map<String, ChangeSetSyncDTO> getChangeSetsFromWorkitem(List<IScmCommandLineArgument> selectors, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config, boolean includeChildWorkitems, List<WorkItemHierarchyNodeDTO> wiHierarchyList) throws FileSystemException {
        HashMap repoToWiList = new HashMap();
        ArrayList<ParmsWorkItem> wiSpecifiedList = new ArrayList<ParmsWorkItem>();
        for (IScmCommandLineArgument selector : selectors) {
            int wiNumber;
            try {
                wiNumber = Integer.parseInt(selector.getItemSelector());
            }
            catch (NumberFormatException e) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_2, (Object)selector.getItemSelector()));
            }
            ITeamRepository wiRepo = repo;
            if (selector.getRepositorySelector() != null) {
                wiRepo = this.repoStrToRepo.get(selector.getRepositorySelector());
            }
            IWorkItem workItem = RepoUtil.findWorkItem((int)wiNumber, (ITeamRepository)wiRepo, (IScmClientConfiguration)config);
            ArrayList<ParmsWorkItem> wiList = (ArrayList<ParmsWorkItem>)repoToWiList.get(wiRepo);
            if (wiList == null) {
                wiList = new ArrayList<ParmsWorkItem>();
                repoToWiList.put(wiRepo, wiList);
            }
            ParmsWorkItem wiParm = new ParmsWorkItem(workItem.getItemId().getUuidValue(), wiRepo.getRepositoryURI());
            wiList.add(wiParm);
            wiSpecifiedList.add(wiParm);
        }
        IFileSystemWorkItemRestClient wiClient = (IFileSystemWorkItemRestClient)SubcommandUtil.startDaemon(IFileSystemWorkItemRestClient.class, (ISandbox[])config.getSandboxes(), (IScmClientConfiguration)config);
        HashMap<String, ChangeSetSyncDTO> csIdToDTO = new HashMap<String, ChangeSetSyncDTO>();
        ArrayList<WorkItemHierarchyNodeDTO> wiResultHierarchyList = new ArrayList<WorkItemHierarchyNodeDTO>();
        for (Map.Entry entry : repoToWiList.entrySet()) {
            Map<String, ChangeSetSyncDTO> csIdToDTOTemp = this.getChangeSetsFromWorkItem((ITeamRepository)entry.getKey(), (List)entry.getValue(), wiClient, client, config, includeChildWorkitems, wiResultHierarchyList);
            csIdToDTO.putAll(csIdToDTOTemp);
        }
        for (ParmsWorkItem wi : wiSpecifiedList) {
            for (WorkItemHierarchyNodeDTO wiHierarchy : wiResultHierarchyList) {
                if (!wiHierarchy.getWorkItem().getItemId().equals(wi.workItemId)) continue;
                wiHierarchyList.add(wiHierarchy);
            }
        }
        return csIdToDTO;
    }

    private Map<String, ChangeSetSyncDTO> getChangeSetsFromWorkItem(ITeamRepository repo, List<ParmsWorkItem> wiList, IFileSystemWorkItemRestClient wiClient, IFilesystemRestClient client, IScmClientConfiguration config, boolean includeChildWorkitems, List<WorkItemHierarchyNodeDTO> wiHierarchyList) throws FileSystemException {
        ParmsWorkItemHierarchy parms = new ParmsWorkItemHierarchy();
        parms.repositoryUrl = repo.getRepositoryURI();
        parms.workItems = wiList.toArray(new ParmsWorkItem[wiList.size()]);
        if (includeChildWorkitems) {
            parms.searchDepth = -1;
        }
        WorkItemHierarchyRootDTO result = null;
        try {
            result = wiClient.getWorkItemHierarchy(parms, null);
            wiHierarchyList.addAll(result.getChildren());
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangesetLocateCmd_UNABLE_TO_FETCH_WORKITEM_HIERARCHY, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        Map<String, ChangeSetSyncDTO> csIdToDTO = new HashMap<String, ChangeSetSyncDTO>();
        if (result != null) {
            ArrayList<ChangeSetDTO> csList = new ArrayList<ChangeSetDTO>();
            this.getChangeSets((WorkItemHierarchyDTO)result, csList);
            ArrayList<String> csIds = new ArrayList<String>();
            for (ChangeSetDTO cs : csList) {
                if (csIds.contains(cs.getItemId())) continue;
                csIds.add(cs.getItemId());
            }
            csIdToDTO = this.getChangeSetsFromRepo(csIds, repo, client, config);
        }
        return csIdToDTO;
    }

    private void getChangeSets(WorkItemHierarchyDTO wiHierarchy, List<ChangeSetDTO> csList) {
        List csListForWi;
        List wiHierarchyList = wiHierarchy.getChildren();
        if (wiHierarchyList != null) {
            for (WorkItemHierarchyDTO wiH : wiHierarchyList) {
                this.getChangeSets(wiH, csList);
            }
        }
        if ((csListForWi = wiHierarchy.getChangeSets()) != null && csListForWi.size() > 0) {
            csList.addAll(csListForWi);
        }
    }

    public Map<String, ChangeSetSyncDTO> getChangeSets(List<IScmCommandLineArgument> csSelectors, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ITeamRepository, ArrayList<String>> repoToCsSelectors = new HashMap<ITeamRepository, ArrayList<String>>();
        for (IScmCommandLineArgument csSelector : csSelectors) {
            ArrayList<String> csList;
            ITeamRepository csRepo = repo;
            if (csSelector.getRepositorySelector() != null) {
                csRepo = this.repoStrToRepo.get(csSelector.getRepositorySelector());
            }
            if ((csList = (ArrayList<String>)repoToCsSelectors.get(csRepo)) == null) {
                csList = new ArrayList<String>();
                repoToCsSelectors.put(csRepo, csList);
            }
            csList.add(csSelector.getItemSelector());
        }
        HashMap<String, ChangeSetSyncDTO> csList = new HashMap<String, ChangeSetSyncDTO>();
        for (Map.Entry entry : repoToCsSelectors.entrySet()) {
            Map<String, ChangeSetSyncDTO> csListTemp = this.getChangeSetsFromRepo((List)entry.getValue(), (ITeamRepository)entry.getKey(), client, config);
            csList.putAll(csListTemp);
        }
        return csList;
    }

    private Map<String, ChangeSetSyncDTO> getChangeSetsFromRepo(List<String> csSelectors, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ChangeSetSyncDTO[] csDTOList = RepoUtil.findChangeSets(csSelectors, (boolean)false, null, null, (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        HashMap<String, ChangeSetSyncDTO> csList = null;
        if (csDTOList != null) {
            csList = new HashMap<String, ChangeSetSyncDTO>(csDTOList.length);
            ChangeSetSyncDTO[] changeSetSyncDTOArray = csDTOList;
            int n = csDTOList.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSetSyncDTO csDTO = changeSetSyncDTOArray[n2];
                if (!csList.containsKey(csDTO.getChangeSetItemId())) {
                    csList.put(csDTO.getChangeSetItemId(), csDTO);
                }
                ++n2;
            }
        }
        ArrayList<String> csNotFoundList = new ArrayList<String>(csSelectors);
        if (csList != null) {
            Iterator csIterator = csNotFoundList.iterator();
            while (csIterator.hasNext()) {
                String csSelector = (String)csIterator.next();
                IUuidAliasRegistry.IUuidAlias csAlias = RepoUtil.lookupUuidAndAlias((String)csSelector, (String)repo.getRepositoryURI());
                if (!csList.keySet().contains(csAlias.getUuid().getUuidValue())) continue;
                csIterator.remove();
            }
        }
        if (csNotFoundList.size() > 0) {
            IndentingPrintStream err = config.getWrappedErrorStream();
            err.println((CharSequence)Messages.Common_CS_NOT_FOUND_HEADER);
            err = err.indent();
            for (String csSelector : csNotFoundList) {
                err.println((CharSequence)csSelector);
            }
            throw StatusHelper.itemNotFound((String)Messages.Common_CS_NOT_FOUND);
        }
        return csList;
    }
}

