/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.WorkspaceCustomAttributesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class WorkspaceShowCustomAttributesCmd {
    protected static boolean hasAllWorkspaceProperties(JSONArray jWsArray) {
        for (Object obj : jWsArray) {
            JSONObject jWs = (JSONObject)obj;
            Long statusCode = (Long)jWs.get((Object)"status-code");
            if (statusCode == 0L) continue;
            return false;
        }
        return true;
    }

    public static void showCustomAttributes(List<IScmCommandLineArgument> wsSelectorList, String propertyName, String key, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        boolean retrievedWorkspaceProperties;
        JSONArray jWsArray = new JSONArray();
        for (IScmCommandLineArgument wsSelector : wsSelectorList) {
            JSONObject jWs = WorkspaceShowCustomAttributesCmd.jsonizeWorkspaces(wsSelector, key, client, config);
            jWsArray.add((Object)jWs);
        }
        if (config.isJSONEnabled()) {
            if (!jWsArray.isEmpty()) {
                JSONObject jResult = new JSONObject();
                jResult.put((Object)"workspaces", (Object)jWsArray);
                config.getOutputStream().print((CharSequence)jResult.toString());
            }
            retrievedWorkspaceProperties = WorkspaceShowCustomAttributesCmd.hasAllWorkspaceProperties(jWsArray);
        } else {
            retrievedWorkspaceProperties = WorkspaceShowCustomAttributesCmd.printWorkspaces(jWsArray, propertyName == null, config);
        }
        if (!retrievedWorkspaceProperties) {
            throw StatusHelper.propertiesUnavailable((String)Messages.WorkspaceCustomAttributesCmd_PROPERTY_LIST_FAILURE);
        }
    }

    private static JSONObject jsonizeWorkspaces(IScmCommandLineArgument wsSelector, String key, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jWs = new JSONObject();
        long statusCode = 0L;
        String errorMsg = null;
        ITeamRepository repo = null;
        IWorkspace ws = null;
        try {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            JSONObject jProps = WorkspaceShowCustomAttributesCmd.getCustomAttributes(ws, key, repo, client, config);
            jWs.put((Object)"workspace", (Object)ws.getName());
            jWs.put((Object)"properties", (Object)jProps);
        }
        catch (CLIFileSystemClientException e) {
            statusCode = e.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            CLIFileSystemClientException exp = StatusHelper.wrap((String)"", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            statusCode = exp.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (Exception e) {
            statusCode = 3L;
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        if (ws == null) {
            jWs.put((Object)"workspace", (Object)wsSelector.getItemSelector());
        }
        if (errorMsg != null) {
            jWs.put((Object)"error-message", (Object)errorMsg);
        }
        jWs.put((Object)"status-code", (Object)statusCode);
        return jWs;
    }

    protected static JSONObject getCustomAttributes(IWorkspace ws, String key, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws TeamRepositoryException {
        JSONObject jProps = new JSONObject();
        ParmsWorkspace parmsWs = new ParmsWorkspace(repo.getRepositoryURI(), ws.getItemId().getUuidValue());
        WorkspaceCustomAttributesDTO wsCustomAttrs = client.getWorkspaceCustomAttributes(parmsWs, null);
        WorkspaceDetailsDTO wsDetails = wsCustomAttrs.getWorkspace();
        jProps.put((Object)"name", (Object)wsDetails.getName());
        jProps.put((Object)"uuid", (Object)wsDetails.getItemId());
        jProps.put((Object)"url", (Object)wsDetails.getRepositoryURL());
        jProps.put((Object)"type", (Object)(wsDetails.isStream() ? RepoUtil.ItemType.STREAM.toString() : RepoUtil.ItemType.WORKSPACE.toString()));
        ArrayList map = new ArrayList(wsCustomAttrs.getCustomAttributes().entrySet());
        JSONArray props = new JSONArray();
        for (Map.Entry entry : map) {
            JSONObject prop = new JSONObject();
            if (key != null && !key.equals(entry.getKey())) continue;
            prop.put((Object)"property", entry.getKey());
            prop.put((Object)"value", entry.getValue());
            props.add((Object)prop);
        }
        if (props.size() > 0) {
            jProps.put((Object)"custom_attributes", (Object)props);
        }
        return jProps;
    }

    private static boolean printWorkspaces(JSONArray jWsArray, boolean printCaption, IScmClientConfiguration config) throws FileSystemException {
        boolean retrievedAllWorkspaceProperties = true;
        IndentingPrintStream out = config.getWrappedOutputStream();
        IndentingPrintStream err = config.getWrappedErrorStream();
        for (Object obj : jWsArray) {
            JSONObject jWs = (JSONObject)obj;
            boolean result = WorkspaceShowCustomAttributesCmd.printWorkspace(jWs, printCaption, out, err);
            if (result) continue;
            retrievedAllWorkspaceProperties = false;
        }
        return retrievedAllWorkspaceProperties;
    }

    public static boolean printWorkspace(JSONObject jWs, boolean printCaption, IndentingPrintStream out, IndentingPrintStream err) {
        String ws = (String)jWs.get((Object)"workspace");
        long statusCode = (Long)jWs.get((Object)"status-code");
        if (statusCode != 0L) {
            String errorMsg = (String)jWs.get((Object)"error-message");
            err.println((CharSequence)ws);
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_CODE, (Object)statusCode));
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_MESSAGE, (Object)errorMsg));
            return false;
        }
        JSONObject jProps = (JSONObject)jWs.get((Object)"properties");
        String name = (String)jProps.get((Object)"name");
        String itemId = (String)jProps.get((Object)"uuid");
        String repoUri = (String)jProps.get((Object)"url");
        RepoUtil.ItemType itemType = RepoUtil.ItemType.valueOf((String)((String)jProps.get((Object)"type")));
        String wsTitle = AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)itemType);
        out.println((CharSequence)wsTitle);
        WorkspaceShowCustomAttributesCmd.printCustomAttibutes(jProps, out.indent());
        return true;
    }

    private static void printCustomAttibutes(JSONObject fileProp, IndentingPrintStream out) {
        if (fileProp == null) {
            return;
        }
        JSONArray props = (JSONArray)fileProp.get((Object)"custom_attributes");
        if (props == null) {
            return;
        }
        int maxWidth = 0;
        for (Object entry : props) {
            JSONObject prop = (JSONObject)entry;
            String property = (String)prop.get((Object)"property");
            maxWidth = Math.max(maxWidth, property.length());
        }
        IndentingPrintStream indent = out.indent();
        for (Object entry : props) {
            JSONObject prop = (JSONObject)entry;
            indent.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)((String)prop.get((Object)"property")), (int)maxWidth), (Object)prop.get((Object)"value")));
        }
    }
}

