/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProperty;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceCustomAttributes;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class WorkspaceSetCustomAttributeCmd {
    protected static boolean checkReturnStatus(JSONArray jWsArray) {
        for (Object obj : jWsArray) {
            JSONObject jWs = (JSONObject)obj;
            Long statusCode = (Long)jWs.get((Object)"status-code");
            if (statusCode == 0L) continue;
            return false;
        }
        return true;
    }

    public static void setCustomAttributes(List<IScmCommandLineArgument> wsSelectorList, Map<String, String> customAttrs, IFilesystemRestClient client, IScmClientConfiguration config) throws TeamRepositoryException {
        boolean setAllWorkspaceProperties;
        JSONArray jWsArray = new JSONArray();
        for (IScmCommandLineArgument wsSelector : wsSelectorList) {
            JSONObject jWs = WorkspaceSetCustomAttributeCmd.setCustomAttributes(wsSelector, customAttrs, client, config);
            jWsArray.add((Object)jWs);
        }
        if (config.isJSONEnabled()) {
            if (!jWsArray.isEmpty()) {
                JSONObject jResult = new JSONObject();
                jResult.put((Object)"workspaces", (Object)jWsArray);
                config.getOutputStream().print((CharSequence)jResult.toString());
            }
            setAllWorkspaceProperties = WorkspaceSetCustomAttributeCmd.checkReturnStatus(jWsArray);
        } else {
            setAllWorkspaceProperties = WorkspaceSetCustomAttributeCmd.printResult(jWsArray, config);
            if (setAllWorkspaceProperties) {
                config.getWrappedOutputStream().println((CharSequence)Messages.WorkspaceCustomAttributesCmd_PROPERTY_SET_SUCCESS);
            }
        }
        if (!setAllWorkspaceProperties) {
            throw StatusHelper.propertiesUnavailable((String)Messages.WorkspaceCustomAttributesCmd_PROPERTY_SET_FAILURE);
        }
    }

    private static JSONObject setCustomAttributes(IScmCommandLineArgument wsSelector, Map<String, String> customAttrs, IFilesystemRestClient client, IScmClientConfiguration config) throws TeamRepositoryException {
        JSONObject jWs = new JSONObject();
        Object errorMsg = null;
        long statusCode = 0L;
        ITeamRepository repo = null;
        IWorkspace ws = null;
        boolean success = false;
        repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
        jWs.put((Object)"workspace", (Object)ws.getName());
        jWs.put((Object)"uuid", (Object)ws.getItemId().getUuidValue());
        jWs.put((Object)"url", (Object)repo.getRepositoryURI());
        jWs.put((Object)"type", (Object)(ws.isStream() ? RepoUtil.ItemType.STREAM.toString() : RepoUtil.ItemType.WORKSPACE.toString()));
        WorkspaceSetCustomAttributeCmd.setCustomAttrs(ws, customAttrs, repo, client, config);
        success = true;
        if (ws == null) {
            jWs.put((Object)"workspace", (Object)wsSelector.getItemSelector());
        }
        jWs.put((Object)"status-code", (Object)statusCode);
        if (!success) {
            jWs.put((Object)"error-message", errorMsg);
        }
        StringBuffer propertyNames = new StringBuffer();
        for (String property : customAttrs.keySet()) {
            if (propertyNames.length() != 0) {
                propertyNames.append(", ");
            }
            propertyNames.append(property);
        }
        jWs.put((Object)"property", (Object)propertyNames.toString());
        return jWs;
    }

    public static void setCustomAttrs(IWorkspace ws, Map<String, String> customAttrs, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws TeamRepositoryException {
        ParmsWorkspaceCustomAttributes parms = new ParmsWorkspaceCustomAttributes();
        parms.workspace = new ParmsWorkspace(repo.getRepositoryURI(), ws.getItemId().getUuidValue());
        ParmsProperty[] properties = new ParmsProperty[customAttrs.size()];
        int i = 0;
        for (String key : customAttrs.keySet()) {
            ParmsProperty prop = new ParmsProperty(key, customAttrs.get(key));
            properties[i++] = prop;
        }
        parms.setCustomAttrs = properties;
        client.postWorkspaceCustomAttributes(parms, null);
    }

    private static boolean printResult(JSONArray jWsArray, IScmClientConfiguration config) {
        IndentingPrintStream err = config.getWrappedErrorStream();
        boolean setAllWorkspaceProperties = true;
        for (Object obj : jWsArray) {
            long statusCode;
            JSONObject jWs = (JSONObject)obj;
            String ws = (String)jWs.get((Object)"workspace");
            if (jWs.get((Object)"uuid") != null) {
                String wsItemId = (String)jWs.get((Object)"uuid");
                String repoUri = (String)jWs.get((Object)"url");
                RepoUtil.ItemType itemType = RepoUtil.ItemType.valueOf((String)((String)jWs.get((Object)"type")));
                ws = AliasUtil.selector((String)ws, (UUID)UUID.valueOf((String)wsItemId), (String)repoUri, (RepoUtil.ItemType)itemType);
            }
            if ((statusCode = ((Long)jWs.get((Object)"status-code")).longValue()) == 0L) continue;
            String errorMsg = (String)jWs.get((Object)"error-message");
            err.println((CharSequence)ws);
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_CODE, (Object)statusCode));
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_MESSAGE, (Object)errorMsg));
            setAllWorkspaceProperties = false;
        }
        return setAllWorkspaceProperties;
    }
}

