/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.workspace.WorkspacePropertyCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsReadScope;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class WorkspacePropertySetCmd
extends WorkspacePropertyCmd
implements IOptionSource {
    public static final PositionalOptionDefinition OPT_PROPERTY_NAME = new PositionalOptionDefinition("property-name", 1, 1);
    public static final PositionalOptionDefinition OPT_PROPERTY_VALUE = new PositionalOptionDefinition("property-value", 1, 1);
    public static final NamedOptionDefinition OPT_PROJECT_IDENTIFIER = new NamedOptionDefinition("p", "process-area", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)OPT_PROPERTY_NAME, NLS.bind((String)Messages.WorkspacePropertiesCmdOptions_OPT_PROPERTY_SET_NAME_HELP, (Object[])new String[]{"name", "ownedby", "owned", "visibility", "visi", "description", "desc", "auto-lock-files"})).addOption((IPositionalOptionDefinition)OPT_PROPERTY_VALUE, NLS.bind((String)Messages.WorkspacePropertiesCmdOptions_OPT_PROPERTY_VALUE_HELP, (Object[])new String[]{"visibility", "public", "private", "teamarea", "projectarea"})).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, -1, "@"), Messages.WorkspacePropertiesCmdOptions_SET_WORKSPACE_HELP).addOption((INamedOptionDefinition)OPT_PROJECT_IDENTIFIER, NLS.bind((String)Messages.WorkspacePropertiesCmdOptions_OPT_PROJECT_IDENTIFIER_HELP, (Object[])new String[]{"visibility", "teamarea", "projectarea"})).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        return options;
    }

    @Override
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        String propertyName = cli.getOption((IOptionKey)OPT_PROPERTY_NAME, null);
        ScmCommandLineArgument propertyValue = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PROPERTY_VALUE, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument projectSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PROJECT_IDENTIFIER, null), (IScmClientConfiguration)this.config);
        this.initializeArgs(propertyName);
        HashMap<String, IScmCommandLineArgument> properties = new HashMap<String, IScmCommandLineArgument>();
        properties.put(propertyName.toLowerCase(), (IScmCommandLineArgument)propertyValue);
        WorkspacePropertySetCmd.setProperties(this.wsSelectorList, properties, (IScmCommandLineArgument)projectSelector, this.client, this.config);
    }

    public static void setProperties(List<IScmCommandLineArgument> wsSelectorList, Map<String, IScmCommandLineArgument> properties, IScmCommandLineArgument visibilitySelector, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        boolean setAllWorkspaceProperties;
        JSONArray jWsArray = new JSONArray();
        for (IScmCommandLineArgument wsSelector : wsSelectorList) {
            JSONObject jWs = WorkspacePropertySetCmd.setProperties(wsSelector, properties, visibilitySelector, client, config);
            jWsArray.add((Object)jWs);
        }
        if (config.isJSONEnabled()) {
            if (!jWsArray.isEmpty()) {
                JSONObject jResult = new JSONObject();
                jResult.put((Object)"workspaces", (Object)jWsArray);
                config.getOutputStream().print((CharSequence)jResult.toString());
            }
            setAllWorkspaceProperties = WorkspacePropertySetCmd.hasAllWorkspaceProperties(jWsArray);
        } else {
            setAllWorkspaceProperties = WorkspacePropertySetCmd.printResult(jWsArray, config);
            if (setAllWorkspaceProperties) {
                config.getWrappedOutputStream().println((CharSequence)Messages.WorkspacePropertiesCmd_PROPERTY_SET_SUCCESS);
            }
        }
        if (!setAllWorkspaceProperties) {
            throw StatusHelper.propertiesUnavailable((String)Messages.WorkspacePropertiesCmd_PROPERTY_SET_FAILURE);
        }
    }

    private static JSONObject setProperties(IScmCommandLineArgument wsSelector, Map<String, IScmCommandLineArgument> properties, IScmCommandLineArgument visibilitySelector, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jWs = new JSONObject();
        String errorMsg = null;
        long statusCode = 0L;
        ITeamRepository repo = null;
        IWorkspace ws = null;
        boolean success = false;
        try {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            jWs.put((Object)"workspace", (Object)ws.getName());
            jWs.put((Object)"uuid", (Object)ws.getItemId().getUuidValue());
            jWs.put((Object)"url", (Object)repo.getRepositoryURI());
            jWs.put((Object)"type", (Object)(ws.isStream() ? RepoUtil.ItemType.STREAM.toString() : RepoUtil.ItemType.WORKSPACE.toString()));
            WorkspacePropertySetCmd.setProperties(ws, properties, visibilitySelector, repo, client, config);
            success = true;
        }
        catch (CLIFileSystemClientException e) {
            statusCode = e.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            CLIFileSystemClientException exp = StatusHelper.wrap((String)"", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            statusCode = exp.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (Exception e) {
            statusCode = 3L;
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        if (ws == null) {
            jWs.put((Object)"workspace", (Object)wsSelector.getItemSelector());
        }
        jWs.put((Object)"status-code", (Object)statusCode);
        if (!success) {
            jWs.put((Object)"error-message", (Object)errorMsg);
        }
        StringBuffer propertyNames = new StringBuffer();
        for (String property : properties.keySet()) {
            if (propertyNames.length() != 0) {
                propertyNames.append(", ");
            }
            propertyNames.append(property);
        }
        jWs.put((Object)"property", (Object)propertyNames.toString());
        return jWs;
    }

    protected static void setProperties(IWorkspace ws, Map<String, IScmCommandLineArgument> properties, IScmCommandLineArgument visibilitySelector, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        IScmCommandLineArgument propertyValue;
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.workspace = new ParmsWorkspace(repo.getRepositoryURI(), ws.getItemId().getUuidValue());
        if (properties.containsKey("name")) {
            parms.name = properties.get("name").getItemSelector();
        }
        IProcessArea owningProcessArea = null;
        if (properties.containsKey("ownedby") || properties.containsKey("owned")) {
            propertyValue = properties.get("ownedby");
            if (propertyValue == null) {
                propertyValue = properties.get("owned");
            }
            if (ws.isStream()) {
                SubcommandUtil.validateArgument((IScmCommandLineArgument)propertyValue, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.PROJECTAREA, RepoUtil.ItemType.TEAMAREA});
                owningProcessArea = RepoUtil.getProcessArea((IScmCommandLineArgument)propertyValue, null, (ITeamRepository)repo, (IScmClientConfiguration)config);
                parms.newOwnerItemId = owningProcessArea.getItemId().getUuidValue();
                parms.newOwnerItemType = owningProcessArea.getItemType().getName();
                parms.readScope = new ParmsReadScope();
                parms.readScope.scope = "process_area_scope";
            } else {
                IContributor contributor = RepoUtil.fetchContributor((String)propertyValue.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                if (contributor == null) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)propertyValue.getItemSelector(), (Object)repo.getRepositoryURI()));
                }
                parms.newOwnerItemId = contributor.getItemId().getUuidValue();
                parms.newOwnerItemType = IContributor.ITEM_TYPE.getName();
            }
        }
        if (properties.containsKey("visibility") || properties.containsKey("visi")) {
            propertyValue = properties.get("visibility");
            if (propertyValue == null) {
                propertyValue = properties.get("visi");
            }
            WorkspaceDetailsDTO wsDetails = null;
            if (propertyValue.getItemSelector().equalsIgnoreCase("teamarea") || propertyValue.getItemSelector().equalsIgnoreCase("projectarea")) {
                ParmsWorkspace parmsWs = new ParmsWorkspace(repo.getRepositoryURI(), ws.getItemId().getUuidValue());
                wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(parmsWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
            }
            IItemType ownerType = IContributor.ITEM_TYPE;
            ownerType = parms.newOwnerItemType != null ? SubcommandUtil.getOwnerType((String)parms.newOwnerItemType) : (wsDetails != null ? wsDetails.getOwner().getItemType() : IContributor.ITEM_TYPE);
            IProcessArea owner = null;
            if (owningProcessArea != null) {
                owner = owningProcessArea;
            } else if (wsDetails != null) {
                owner = wsDetails.getOwner();
            }
            parms.readScope = new ParmsReadScope();
            if (propertyValue.getItemSelector().equalsIgnoreCase("public")) {
                if (ws.isStream()) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_STREAM_PROPERTY_VALUE, (Object[])new String[]{"public", "projectarea", "teamarea"}));
                }
                parms.readScope.scope = "public_scope";
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("private")) {
                if (ws.isStream()) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_STREAM_PROPERTY_VALUE, (Object[])new String[]{"private", "projectarea", "teamarea"}));
                }
                parms.readScope.scope = "private_scope";
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("teamarea")) {
                if (!ws.isStream()) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_WS_PROPERTY_VALUE, (Object[])new String[]{"teamarea", "public", "private", "projectarea"}));
                }
                if (IProjectArea.ITEM_TYPE.equals(ownerType)) {
                    throw StatusHelper.inappropriateArgument((String)Messages.WorkspacePropertiesCmd_SPECIFIY_PROJECTAREA);
                }
                SubcommandUtil.validateArgument((IScmCommandLineArgument)visibilitySelector, (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA);
                IProcessArea processArea = null;
                if (visibilitySelector != null) {
                    processArea = RepoUtil.getProcessArea((IScmCommandLineArgument)visibilitySelector, (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA, (ITeamRepository)repo, (IScmClientConfiguration)config);
                }
                if (visibilitySelector != null && !processArea.sameItemId((IItemHandle)owner)) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_TEAMAREA_ALREADY_SET, (Object)AliasUtil.selector((String)processArea.getName(), (UUID)processArea.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA)));
                }
                if (wsDetails.getReadScope().getReadScope().equalsIgnoreCase("team_area_private_scope")) {
                    return;
                }
                parms.readScope.scope = "team_area_private_scope";
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("projectarea")) {
                IProcessArea processArea = null;
                if (visibilitySelector != null) {
                    SubcommandUtil.validateArgument((IScmCommandLineArgument)visibilitySelector, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA);
                    processArea = RepoUtil.getProcessArea((IScmCommandLineArgument)visibilitySelector, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA, (ITeamRepository)repo, (IScmClientConfiguration)config);
                }
                if (!ws.isStream()) {
                    if (visibilitySelector == null) {
                        throw StatusHelper.argSyntax((String)Messages.WorkspacePropertiesCmd_SPECIFY_PROJECT_IDENTIFIER);
                    }
                    parms.readScope.scope = "contributor_deferring_scope";
                    parms.readScope.defer_to = processArea.getItemId().getUuidValue();
                } else {
                    ITeamArea teamArea;
                    IProjectArea projArea;
                    parms.readScope.scope = "process_area_scope";
                    if (IProjectArea.ITEM_TYPE.equals(ownerType)) {
                        if (visibilitySelector != null && !processArea.sameItemId((IItemHandle)owner)) {
                            String ownerName = RepoUtil.getOwnerName((IAuditableHandle)wsDetails.getOwner(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_PROJECTAREA_ALREADY_SET, (Object)AliasUtil.selector((String)ownerName, (UUID)owner.getItemId(), (String)wsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA)));
                        }
                    } else if (processArea != null && !(projArea = (IProjectArea)RepoUtil.getItem((IItemType)IProjectArea.ITEM_TYPE, (UUID)(teamArea = (ITeamArea)RepoUtil.getItem((IItemType)ITeamArea.ITEM_TYPE, (UUID)owner.getItemId(), (ITeamRepository)repo, (int)1, (IScmClientConfiguration)config)).getProjectArea().getItemId(), (ITeamRepository)repo, (IScmClientConfiguration)config)).getItemId().equals((Object)processArea.getItemId())) {
                        throw StatusHelper.inappropriateArgument((String)Messages.WorkspacePropertiesCmd_PROJECTAREA_INVALID);
                    }
                }
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("accessgroup")) {
                if (visibilitySelector == null) {
                    throw StatusHelper.argSyntax((String)Messages.WorkspacePropertiesCmd_SPECIFY_ACCESS_GROUP);
                }
                SubcommandUtil.validateArgument((IScmCommandLineArgument)visibilitySelector, (RepoUtil.ItemType)RepoUtil.ItemType.ACCESSGROUP);
                IAccessGroup accessGroup = RepoUtil.getAccessGroup((IScmCommandLineArgument)visibilitySelector, (ITeamRepository)repo, (IScmClientConfiguration)config);
                if (accessGroup == null) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_ACCESS_GROUP, (Object)visibilitySelector));
                }
                parms.readScope.scope = "access_group_scope";
                parms.readScope.defer_to = accessGroup.getGroupContextId().getUuidValue();
            } else {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_PROPERTY_VALUE, (Object)propertyValue.getItemSelector()));
            }
        }
        if (properties.containsKey("description") || properties.containsKey("desc")) {
            propertyValue = properties.get("description");
            if (propertyValue == null) {
                propertyValue = properties.get("desc");
            }
            parms.description = propertyValue.getItemSelector();
        }
        if (properties.containsKey("auto-lock-files") && (propertyValue = properties.get("auto-lock-files")) != null) {
            if (!ws.isStream()) {
                throw StatusHelper.propertiesUnavailable((String)NLS.bind((String)Messages.Stream_ONLY_OPTION, (Object)"auto-lock-files"));
            }
            parms.exclusiveFileLockPatterns = propertyValue.getItemSelector();
        }
        try {
            client.postPutWorkspace(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.WorkspacePropertiesCmd_PROPERTY_SET_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }

    private static boolean printResult(JSONArray jWsArray, IScmClientConfiguration config) {
        IndentingPrintStream err = config.getWrappedErrorStream();
        boolean setAllWorkspaceProperties = true;
        for (Object obj : jWsArray) {
            long statusCode;
            JSONObject jWs = (JSONObject)obj;
            String ws = (String)jWs.get((Object)"workspace");
            if (jWs.get((Object)"uuid") != null) {
                String wsItemId = (String)jWs.get((Object)"uuid");
                String repoUri = (String)jWs.get((Object)"url");
                RepoUtil.ItemType itemType = RepoUtil.ItemType.valueOf((String)((String)jWs.get((Object)"type")));
                ws = AliasUtil.selector((String)ws, (UUID)UUID.valueOf((String)wsItemId), (String)repoUri, (RepoUtil.ItemType)itemType);
            }
            if ((statusCode = ((Long)jWs.get((Object)"status-code")).longValue()) == 0L) continue;
            String errorMsg = (String)jWs.get((Object)"error-message");
            err.println((CharSequence)ws);
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_CODE, (Object)statusCode));
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_MESSAGE, (Object)errorMsg));
            setAllWorkspaceProperties = false;
        }
        return setAllWorkspaceProperties;
    }
}

