/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.workspace.WorkspacePropertyCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.ContributorNameDTO;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class WorkspacePropertyListCmd
extends WorkspacePropertyCmd
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, -1, "@"), Messages.WorkspacePropertiesCmdOptions_LIST_WORKSPACE_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        return options;
    }

    @Override
    public void run() throws FileSystemException {
        this.initializeArgs(null);
        this.listProperties(null);
    }

    protected void listProperties(String propertyName) throws FileSystemException {
        ArrayList<String> propertyNames = null;
        if (propertyName != null) {
            propertyNames = new ArrayList<String>(1);
            propertyNames.add(propertyName.toLowerCase());
        }
        WorkspacePropertyListCmd.listProperties(this.wsSelectorList, propertyName, propertyNames, this.client, this.config);
    }

    public static void listProperties(List<IScmCommandLineArgument> wsSelectorList, String propertyName, List<String> propertyNames, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        boolean retrievedWorkspaceProperties;
        JSONArray jWsArray = new JSONArray();
        for (IScmCommandLineArgument wsSelector : wsSelectorList) {
            JSONObject jWs = WorkspacePropertyListCmd.listProperties(wsSelector, propertyNames, client, config);
            jWsArray.add((Object)jWs);
        }
        if (config.isJSONEnabled()) {
            if (!jWsArray.isEmpty()) {
                JSONObject jResult = new JSONObject();
                jResult.put((Object)"workspaces", (Object)jWsArray);
                config.getOutputStream().print((CharSequence)jResult.toString());
            }
            retrievedWorkspaceProperties = WorkspacePropertyListCmd.hasAllWorkspaceProperties(jWsArray);
        } else {
            retrievedWorkspaceProperties = WorkspacePropertyListCmd.printProperties(jWsArray, propertyName == null, config);
        }
        if (!retrievedWorkspaceProperties) {
            throw StatusHelper.propertiesUnavailable((String)Messages.WorkspacePropertiesCmd_PROPERTY_LIST_FAILURE);
        }
    }

    private static JSONObject listProperties(IScmCommandLineArgument wsSelector, List<String> propertyNames, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jWs = new JSONObject();
        long statusCode = 0L;
        String errorMsg = null;
        ITeamRepository repo = null;
        IWorkspace ws = null;
        try {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            JSONObject jProps = WorkspacePropertyListCmd.getProperties(ws, propertyNames, repo, client, config);
            jWs.put((Object)"workspace", (Object)ws.getName());
            jWs.put((Object)"properties", (Object)jProps);
        }
        catch (CLIFileSystemClientException e) {
            statusCode = e.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            CLIFileSystemClientException exp = StatusHelper.wrap((String)"", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            statusCode = exp.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (Exception e) {
            statusCode = 3L;
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        if (ws == null) {
            jWs.put((Object)"workspace", (Object)wsSelector.getItemSelector());
        }
        if (errorMsg != null) {
            jWs.put((Object)"error-message", (Object)errorMsg);
        }
        jWs.put((Object)"status-code", (Object)statusCode);
        return jWs;
    }

    protected static JSONObject getProperties(IWorkspace ws, List<String> propertyNames, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jProps = new JSONObject();
        IndentingPrintStream out = config.getWrappedOutputStream();
        ParmsWorkspace parmsWs = new ParmsWorkspace(repo.getRepositoryURI(), ws.getItemId().getUuidValue());
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(parmsWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        jProps.put((Object)"name", (Object)wsDetails.getName());
        jProps.put((Object)"uuid", (Object)wsDetails.getItemId());
        jProps.put((Object)"url", (Object)wsDetails.getRepositoryURL());
        jProps.put((Object)"type", (Object)(wsDetails.isStream() ? RepoUtil.ItemType.STREAM.toString() : RepoUtil.ItemType.WORKSPACE.toString()));
        if (wsDetails.isStream() && (propertyNames == null || propertyNames.contains("auto-lock-files"))) {
            jProps.put((Object)"auto-lock-files", (Object)wsDetails.getExclusiveFileLockPatterns());
        } else if (!wsDetails.isStream() && propertyNames != null && propertyNames.contains("auto-lock-files")) {
            throw StatusHelper.propertiesUnavailable((String)NLS.bind((String)Messages.Stream_ONLY_OPTION, (Object)"auto-lock-files"));
        }
        ContributorNameDTO streamLockOwner = wsDetails.getLockedBy();
        JSONPrintUtil.addJsonizedLockOwner((JSONObject)jProps, (ContributorNameDTO)streamLockOwner);
        String ownerName = RepoUtil.getOwnerName((IAuditableHandle)wsDetails.getOwner(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        if (propertyNames == null || propertyNames.contains("ownedby") || propertyNames.contains("owned")) {
            JSONObject jOwnedBy = new JSONObject();
            jOwnedBy.put((Object)"name", (Object)ownerName);
            jOwnedBy.put((Object)"uuid", (Object)wsDetails.getOwner().getItemId().getUuidValue());
            jOwnedBy.put((Object)"url", (Object)wsDetails.getRepositoryURL());
            jOwnedBy.put((Object)"type", (Object)SubcommandUtil.getItemType((IItemType)wsDetails.getOwner().getItemType()).toString());
            jProps.put((Object)"ownedby", (Object)jOwnedBy);
        }
        if (propertyNames == null || propertyNames.contains("visibility") || propertyNames.contains("visi")) {
            JSONObject jVisibility = new JSONObject();
            JSONObject jInfo = null;
            if (wsDetails.getReadScope().getReadScope().equalsIgnoreCase("public_scope")) {
                jVisibility.put((Object)"type", (Object)"public");
            } else if (wsDetails.getReadScope().getReadScope().equalsIgnoreCase("private_scope")) {
                jVisibility.put((Object)"type", (Object)"private");
            } else if (wsDetails.getReadScope().getReadScope().equalsIgnoreCase("contributor_deferring_scope")) {
                jVisibility.put((Object)"type", (Object)"projectarea");
                String defersTo = RepoUtil.getOwnerName((IAuditableHandle)wsDetails.getReadScope().getDefersTo(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                jInfo = new JSONObject();
                jInfo.put((Object)"name", (Object)defersTo);
                jInfo.put((Object)"uuid", (Object)wsDetails.getReadScope().getDefersTo().getItemId().getUuidValue());
                jInfo.put((Object)"url", (Object)wsDetails.getRepositoryURL());
                jInfo.put((Object)"type", (Object)SubcommandUtil.getItemType((IItemType)wsDetails.getReadScope().getDefersTo().getItemType()).toString());
                jInfo.put((Object)"contributor-deferring", (Object)Boolean.TRUE);
            } else if (wsDetails.getReadScope().getReadScope().equalsIgnoreCase("process_area_scope")) {
                jVisibility.put((Object)"type", (Object)"projectarea");
                IProjectArea projArea = null;
                if (ITeamArea.ITEM_TYPE.equals(wsDetails.getOwner().getItemType())) {
                    ITeamArea teamArea = (ITeamArea)RepoUtil.getItem((IItemType)ITeamArea.ITEM_TYPE, (UUID)wsDetails.getOwner().getItemId(), (ITeamRepository)repo, (int)1, (IScmClientConfiguration)config);
                    projArea = (IProjectArea)RepoUtil.getItem((IItemType)IProjectArea.ITEM_TYPE, (UUID)teamArea.getProjectArea().getItemId(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                } else if (IProjectArea.ITEM_TYPE.equals(wsDetails.getOwner().getItemType())) {
                    projArea = (IProjectArea)RepoUtil.getItem((IItemType)IProjectArea.ITEM_TYPE, (UUID)wsDetails.getOwner().getItemId(), (ITeamRepository)repo, (int)1, (IScmClientConfiguration)config);
                }
                if (projArea != null) {
                    jInfo = new JSONObject();
                    jInfo.put((Object)"name", (Object)projArea.getName());
                    jInfo.put((Object)"uuid", (Object)projArea.getItemId().getUuidValue());
                    jInfo.put((Object)"url", (Object)wsDetails.getRepositoryURL());
                    jInfo.put((Object)"type", (Object)RepoUtil.ItemType.PROJECTAREA.toString());
                }
            } else if (wsDetails.getReadScope().getReadScope().equalsIgnoreCase("team_area_private_scope")) {
                jVisibility.put((Object)"type", (Object)"teamarea");
                jInfo = new JSONObject();
                jInfo.put((Object)"name", (Object)ownerName);
                jInfo.put((Object)"uuid", (Object)wsDetails.getOwner().getItemId().getUuidValue());
                jInfo.put((Object)"url", (Object)wsDetails.getRepositoryURL());
                jInfo.put((Object)"type", (Object)RepoUtil.ItemType.TEAMAREA.toString());
            } else if (wsDetails.getReadScope().getReadScope().equalsIgnoreCase("access_group_scope")) {
                jVisibility.put((Object)"type", (Object)"accessgroup");
                UUID accessGroupId = wsDetails.getReadScope().getDefersTo().getItemId();
                IAccessGroup accessGroup = RepoUtil.getAccessGroup((UUID)accessGroupId, (ITeamRepository)repo, (IScmClientConfiguration)config);
                if (accessGroup != null) {
                    jInfo = new JSONObject();
                    jInfo.put((Object)"name", (Object)accessGroup.getName());
                    jInfo.put((Object)"uuid", (Object)accessGroup.getGroupContextId().getUuidValue());
                    jInfo.put((Object)"url", (Object)wsDetails.getRepositoryURL());
                    jInfo.put((Object)"type", (Object)RepoUtil.ItemType.ACCESSGROUP.toString());
                }
            } else {
                jVisibility.put((Object)"type", (Object)"unknown");
            }
            if (jInfo != null) {
                jVisibility.put((Object)"info", jInfo);
            }
            jProps.put((Object)"visibility", (Object)jVisibility);
        }
        if (propertyNames == null || propertyNames.contains("description") || propertyNames.contains("desc")) {
            jProps.put((Object)"description", (Object)wsDetails.getDescription());
        }
        return jProps;
    }

    private static boolean printProperties(JSONArray jWsArray, boolean printCaption, IScmClientConfiguration config) throws FileSystemException {
        boolean retrievedAllWorkspaceProperties = true;
        IndentingPrintStream out = config.getWrappedOutputStream();
        IndentingPrintStream err = config.getWrappedErrorStream();
        for (Object obj : jWsArray) {
            JSONObject jWs = (JSONObject)obj;
            boolean result = WorkspacePropertyListCmd.printProperties(jWs, printCaption, out, err);
            if (result) continue;
            retrievedAllWorkspaceProperties = false;
        }
        return retrievedAllWorkspaceProperties;
    }

    public static boolean printProperties(JSONObject jWs, boolean printCaption, IndentingPrintStream out, IndentingPrintStream err) {
        String lockedby;
        String description;
        JSONObject jVisibility;
        JSONObject jOwnedBy;
        String ws = (String)jWs.get((Object)"workspace");
        long statusCode = (Long)jWs.get((Object)"status-code");
        if (statusCode != 0L) {
            String errorMsg = (String)jWs.get((Object)"error-message");
            err.println((CharSequence)ws);
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_CODE, (Object)statusCode));
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_MESSAGE, (Object)errorMsg));
            return false;
        }
        JSONObject jProps = (JSONObject)jWs.get((Object)"properties");
        String name = (String)jProps.get((Object)"name");
        String itemId = (String)jProps.get((Object)"uuid");
        String repoUri = (String)jProps.get((Object)"url");
        RepoUtil.ItemType itemType = RepoUtil.ItemType.valueOf((String)((String)jProps.get((Object)"type")));
        String autoFileLockPatterns = (String)jProps.get((Object)"auto-lock-files");
        String wsTitle = AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)itemType);
        out.println((CharSequence)wsTitle);
        if (printCaption) {
            out.indent().println((CharSequence)NLS.bind((String)Messages.WorkspacePropertiesCmd_REPOSITORY, (Object)repoUri));
        }
        if ((jOwnedBy = (JSONObject)jProps.get((Object)"ownedby")) != null) {
            String ownedbyName = (String)jOwnedBy.get((Object)"name");
            String ownedbyUuid = (String)jOwnedBy.get((Object)"uuid");
            String ownedbyUri = (String)jOwnedBy.get((Object)"url");
            RepoUtil.ItemType ownedbyType = RepoUtil.ItemType.valueOf((String)((String)jOwnedBy.get((Object)"type")));
            String ownedbyInfo = AliasUtil.selector((String)ownedbyName, (UUID)UUID.valueOf((String)ownedbyUuid), (String)ownedbyUri, (RepoUtil.ItemType)ownedbyType);
            out.indent().println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_OWNEDBY, (Object)ownedbyInfo) : ownedbyInfo));
        }
        if ((jVisibility = (JSONObject)jProps.get((Object)"visibility")) != null) {
            String infoName;
            JSONObject jInfo;
            String visibilityType = (String)jVisibility.get((Object)"type");
            String visibilityInfo = Messages.Common_UNKNOWN;
            if (visibilityType.equals("public")) {
                visibilityInfo = Messages.Common_PUBLIC;
            } else if (visibilityType.equals("private")) {
                visibilityInfo = Messages.Common_PRIVATE;
            } else if (visibilityType.equals("accessgroup")) {
                jInfo = (JSONObject)jVisibility.get((Object)"info");
                if (jInfo != null) {
                    infoName = (String)jInfo.get((Object)"name");
                    String infoUuid = (String)jInfo.get((Object)"uuid");
                    String infoUri = (String)jInfo.get((Object)"url");
                    RepoUtil.ItemType infoType = RepoUtil.ItemType.valueOf((String)((String)jInfo.get((Object)"type")));
                    String selector = AliasUtil.selector((String)infoName, (UUID)UUID.valueOf((String)infoUuid), (String)infoUri, (RepoUtil.ItemType)infoType);
                    visibilityInfo = NLS.bind((String)Messages.WorkspacePropertiesCmd_ACCESS_GROUP, (Object)selector);
                } else {
                    visibilityInfo = NLS.bind((String)Messages.WorkspacePropertiesCmd_ACCESS_GROUP, (Object)"unknown");
                }
            } else if ((visibilityType.equals("projectarea") || visibilityType.equals("teamarea")) && (jInfo = (JSONObject)jVisibility.get((Object)"info")) != null) {
                infoName = (String)jInfo.get((Object)"name");
                String infoUuid = (String)jInfo.get((Object)"uuid");
                String infoUri = (String)jInfo.get((Object)"url");
                RepoUtil.ItemType infoType = RepoUtil.ItemType.valueOf((String)((String)jInfo.get((Object)"type")));
                visibilityInfo = AliasUtil.selector((String)infoName, (UUID)UUID.valueOf((String)infoUuid), (String)infoUri, (RepoUtil.ItemType)infoType);
                if (jInfo.get((Object)"contributor-deferring") != null) {
                    visibilityInfo = NLS.bind((String)Messages.WorkspacePropertiesCmd_PROJECT_SCOPED, (Object)visibilityInfo);
                }
            }
            out.indent().println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_VISIBILITY, (Object)visibilityInfo) : visibilityInfo));
        }
        if ((description = (String)jProps.get((Object)"description")) != null && !description.isEmpty()) {
            if (printCaption) {
                out.indent().println((CharSequence)Messages.WorkspacePropertiesCmd_DESCRIPTION);
            }
            out.indent().println((CharSequence)description);
        }
        if (autoFileLockPatterns != null) {
            out.indent().println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_AUTO_FILE_LOCK_PATTERNS, (Object)autoFileLockPatterns) : autoFileLockPatterns));
        }
        if ((lockedby = JSONPrintUtil.getLockOwnerName((JSONObject)jProps)) != null) {
            out.indent().println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertyListCmd_0, (Object)lockedby) : lockedby));
        }
        return true;
    }
}

