/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class WorkspacePropertyCmd
extends AbstractSubcommand {
    IFilesystemRestClient client = null;
    List<IScmCommandLineArgument> wsSelectorList = null;
    public static final String NAME_PROPERTY = "name";
    public static final String OWNEDBY_PROPERTY = "ownedby";
    public static final String OWNEDBY_ALIAS_PROPERTY = "owned";
    public static final String VISIBILITY_PROPERTY = "visibility";
    public static final String VISIBILITY_ALIAS_PROPERTY = "visi";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String DESCRIPTION_ALIAS_PROPERTY = "desc";
    public static final String TEAMAREA_VISIBILITY = "teamarea";
    public static final String PROJECTAREA_VISIBILITY = "projectarea";
    public static final String ACCESSGROUP_VISIBILITY = "accessgroup";
    public static final String PUBLIC_VISIBILITY = "public";
    public static final String PRIVATE_VISIBILITY = "private";
    public static final String AUTO_FILE_LOCK_PATTTERN_PROPERTY = "auto-lock-files";
    public static final String UNKNOWN = "unknown";
    public static final String[] PROPERTIES = new String[]{"name", "ownedby", "owned", "visibility", "visi", "description", "desc", "auto-lock-files"};

    protected void initializeArgs(String propertyName) throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        this.wsSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument(this.wsSelectorList, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        if (propertyName != null && !Arrays.asList(PROPERTIES).contains(propertyName)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_PROPERTY_NAME, (Object)propertyName));
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
    }

    protected static boolean hasAllWorkspaceProperties(JSONArray jWsArray) {
        for (Object obj : jWsArray) {
            JSONObject jWs = (JSONObject)obj;
            Long statusCode = (Long)jWs.get((Object)"status-code");
            if (statusCode == 0L) continue;
            return false;
        }
        return true;
    }

    public void run() throws FileSystemException {
    }
}

