/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentHierarchyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentHierarchyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.InvalidStreamOperationException;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class UpdateSubcomponentsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_PARENT_COMPONENT = new OptionKey("parent-component");
    public static final IOptionKey OPT_SUBCOMPONENTS = new OptionKey("subcomponents");
    private Set<String> workspaceComponentUuids = null;
    private String successMessage;
    private String unchangedMessage;
    private String parentComponentOptionHelpText;
    private String subcomponentOptionHelpText;

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.UpdateSubcomponentsCmd_WORKSPACE_HELP_TEXT).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_PARENT_COMPONENT, "parent-component", 1, 1), this.parentComponentOptionHelpText).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_SUBCOMPONENTS, "subcomponents", 1, -1), this.subcomponentOptionHelpText);
        return options;
    }

    public UpdateSubcomponentsCmd(String parentComponentOptionHelpText, String subcomponentsOptionHelpText, String successMessage, String unchangedMessage) {
        this.parentComponentOptionHelpText = parentComponentOptionHelpText;
        this.subcomponentOptionHelpText = subcomponentsOptionHelpText;
        this.successMessage = successMessage;
        this.unchangedMessage = unchangedMessage;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace workspace = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ScmCommandLineArgument parentComponentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_PARENT_COMPONENT), (IScmClientConfiguration)this.config);
        ArrayList<String> invalidOrInaccessibleComps = new ArrayList<String>();
        IComponent parentComponent = null;
        List<IComponent> parentComp = this.getComponentsFromSelectors(repo, Collections.singletonList(parentComponentSelector.getItemSelector()), false, invalidOrInaccessibleComps);
        if (!parentComp.isEmpty()) {
            parentComponent = parentComp.get(0);
        }
        List componentSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(OPT_SUBCOMPONENTS), (IScmClientConfiguration)this.config);
        List compSelectors = RepoUtil.getSelectors((List)componentSelectors);
        List<IComponent> subcomponents = this.getComponentsFromSelectors(repo, compSelectors, true, invalidOrInaccessibleComps);
        this.validateComponentsInWorkspace(repo, workspace, subcomponents, parentComponent, client);
        PutWorkspaceResultDTO result = this.putWorkspace(repo, workspace, parentComponent, subcomponents, client);
        String changesetUuid = result.getComponentHierarchyUpdateResult().getAffectedChangeSetItemId();
        if (changesetUuid == null) {
            this.throwWorkspaceUnchanged(repo, parentComponent);
        }
        this.validateUpdatedSubcomponents(repo, parentComponent, subcomponents, result);
        this.printResult(repo, workspace, parentComponent, subcomponents, changesetUuid, client, this.config);
    }

    private List<ComponentHierarchyDTO> getSubComponentsList(List<ComponentHierarchyDTO> compHierarchy, IComponent parentComponent, boolean getAllNestedSubComps) {
        List<Object> subCompList = new ArrayList<ComponentHierarchyDTO>();
        for (ComponentHierarchyDTO comp : compHierarchy) {
            if (comp.getComponentItemId().equals(parentComponent.getItemId().getUuidValue())) {
                subCompList = comp.getSubcomponents();
                List<Object> list = subCompList = subCompList.isEmpty() ? null : subCompList;
                if (getAllNestedSubComps && subCompList != null) {
                    ArrayList<ComponentHierarchyDTO> allNestedSubComps = new ArrayList<ComponentHierarchyDTO>();
                    for (ComponentHierarchyDTO componentHierarchyDTO : subCompList) {
                        allNestedSubComps.addAll(this.getAllNestedSubComps(componentHierarchyDTO));
                    }
                    subCompList.addAll(allNestedSubComps);
                }
                return subCompList;
            }
            subCompList = this.getSubComponentsList(comp.getSubcomponents(), parentComponent, getAllNestedSubComps);
            if (subCompList == null) {
                return null;
            }
            if (subCompList.isEmpty()) continue;
            return subCompList;
        }
        return subCompList;
    }

    private List<ComponentHierarchyDTO> getAllNestedSubComps(ComponentHierarchyDTO component) {
        List subCompList = new ArrayList();
        ArrayList<ComponentHierarchyDTO> result = new ArrayList<ComponentHierarchyDTO>();
        subCompList = component.getSubcomponents();
        result.addAll(subCompList);
        for (ComponentHierarchyDTO subComp : subCompList) {
            result.addAll(this.getAllNestedSubComps(subComp));
        }
        return result;
    }

    private void validateComponentsInWorkspace(ITeamRepository repo, IWorkspace workspace, List<IComponent> subCompList, IComponent parentComponent, IFilesystemRestClient client) throws FileSystemException {
        boolean PARENT_COMPONENT_COUNT = true;
        ArrayList<IComponent> allComp = new ArrayList<IComponent>(subCompList.size() + 1);
        allComp.addAll(subCompList);
        allComp.add(parentComponent);
        List<IComponent> componentsNotInWorkspace = this.checkIfComponentsInWorkspace(allComp, repo, workspace, client);
        if (!componentsNotInWorkspace.isEmpty()) {
            IndentingPrintStream err = this.config.getWrappedErrorStream();
            err.println((CharSequence)NLS.bind((String)Messages.UpdateSubcomponentsCmd_INVALID_COMP_SELECTORS_IN_WS_LIST, (Object)workspace.getName(), (Object[])new Object[0]));
            for (IComponent comp : componentsNotInWorkspace) {
                err.indent().println((CharSequence)comp.getName());
            }
            throw StatusHelper.itemNotFound((String)Messages.UpdateSubcomponentsCmd_INVALID_COMP_SELECTORS);
        }
    }

    private List<IComponent> checkIfComponentsInWorkspace(List<IComponent> components, ITeamRepository repo, IWorkspace workspace, IFilesystemRestClient client) throws FileSystemException {
        ArrayList<IComponent> componentsNotInWorkspace = new ArrayList<IComponent>();
        this.getWorkspaceComponents(repo, workspace, client);
        for (IComponent component : components) {
            if (this.workspaceComponentUuids.contains(component.getItemId().getUuidValue())) continue;
            componentsNotInWorkspace.add(component);
        }
        return componentsNotInWorkspace;
    }

    private Set<String> getWorkspaceComponents(ITeamRepository repo, IWorkspace workspace, IFilesystemRestClient client) throws FileSystemException {
        if (this.workspaceComponentUuids == null) {
            ParmsWorkspace parmsWorkspace = new ParmsWorkspace(repo.getRepositoryURI(), workspace.getItemId().getUuidValue());
            WorkspaceDetailsDTO workspaceDetailsDto = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(parmsWorkspace), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, (boolean)true).get(0);
            this.workspaceComponentUuids = new HashSet<String>();
            List componentHierarchyDtoList = workspaceDetailsDto.getComponentHierarchies();
            this.addToWorkspaceComponentsList(this.workspaceComponentUuids, componentHierarchyDtoList);
        }
        return this.workspaceComponentUuids;
    }

    private void addToWorkspaceComponentsList(Set<String> workspaceCompnentIds, List<ComponentHierarchyDTO> componentHierarchyDtoList) {
        if (workspaceCompnentIds == null) {
            workspaceCompnentIds = new HashSet<String>();
        }
        for (ComponentHierarchyDTO compHierarchyDto : componentHierarchyDtoList) {
            workspaceCompnentIds.add(compHierarchyDto.getComponentItemId());
            List subComponentHierarchyDtoList = compHierarchyDto.getSubcomponents();
            if (subComponentHierarchyDtoList == null || subComponentHierarchyDtoList.size() <= 0) continue;
            this.addToWorkspaceComponentsList(workspaceCompnentIds, subComponentHierarchyDtoList);
        }
    }

    private List<IComponent> getComponentsFromSelectors(ITeamRepository repo, List<String> compSelectors, boolean handleExceptions, List<String> invalidOrInaccessibleComps) throws FileSystemException {
        HashSet<IComponent> uniqueComponents = new HashSet<IComponent>(compSelectors.size());
        for (String compSelector : compSelectors) {
            try {
                IComponent component = RepoUtil.getComponent((String)compSelector, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                uniqueComponents.add(component);
            }
            catch (CLIFileSystemClientException e) {
                if (e.getStatus().getCode() == 18 || e.getStatus().getCode() == 25) {
                    invalidOrInaccessibleComps.add(compSelector);
                    continue;
                }
                throw e;
            }
        }
        if (handleExceptions && !invalidOrInaccessibleComps.isEmpty()) {
            IndentingPrintStream err = this.config.getWrappedErrorStream();
            err.println((CharSequence)Messages.UpdateSubcomponentsCmd_INVALID_OR_INACCESSIBLE_COMP_SELECTORS);
            for (String invalidOrInaccessibleComp : invalidOrInaccessibleComps) {
                err.indent().println((CharSequence)invalidOrInaccessibleComp);
            }
            throw StatusHelper.itemNotFound((String)Messages.UpdateSubcomponentsCmd_INVALID_COMP_SELECTORS);
        }
        return new ArrayList<IComponent>(uniqueComponents);
    }

    private PutWorkspaceResultDTO putWorkspace(ITeamRepository repo, IWorkspace workspace, IComponent parentComponent, List<IComponent> subComponents, IFilesystemRestClient client) throws CLIFileSystemClientException, FileSystemException {
        List<IComponent> cycleCreatingComps;
        List<String> InvalidSubCompList;
        ParmsPutWorkspace parms = this.createPutWorkspaceParms(repo, workspace, parentComponent, subComponents);
        if (parms.componentHierarchyChanges.subcomponentsToRemoveUuids != null && !(InvalidSubCompList = this.checkIfCompIsValidSubcompOfParent(repo, workspace, parentComponent, subComponents, false, client)).isEmpty()) {
            IndentingPrintStream err = this.config.getWrappedErrorStream();
            err.println((CharSequence)NLS.bind((String)Messages.UpdateSubcomponentsCmd_INVALID_COMP_SELECTOR_LIST, (Object)parentComponent.getName(), (Object[])new Object[0]));
            for (String comp : InvalidSubCompList) {
                err.indent().println((CharSequence)comp);
            }
            throw StatusHelper.itemNotFound((String)Messages.UpdateSubcomponentsCmd_INVALID_SUB_COMP_SELECTOR);
        }
        if (parms.componentHierarchyChanges.subcomponentsToAddUuids != null && !(cycleCreatingComps = this.formsCycle(repo, workspace, parentComponent, subComponents, client)).isEmpty()) {
            IndentingPrintStream err = this.config.getWrappedErrorStream();
            err.println((CharSequence)NLS.bind((String)Messages.UpdateSubcomponentsCmd_COMPS_FORM_CYCLE, (Object)parentComponent.getName(), (Object[])new Object[0]));
            for (IComponent comp : cycleCreatingComps) {
                err.indent().println((CharSequence)comp.getName());
            }
            throw StatusHelper.disallowed((String)Messages.UpdateSubcomponentsCmd_INVALID_COMP_SELECTORS);
        }
        try {
            return client.postPutWorkspace(parms, null);
        }
        catch (InvalidStreamOperationException e) {
            throw StatusHelper.disallowed((String)Messages.UpdateSubcomponentsCmd_INVALID_STREAM_OPERATION);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.UpdateSubcomponentsCmd_COULD_NOT_UPDATE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }

    public List<IComponent> formsCycle(ITeamRepository repo, IWorkspace workspace, IComponent parentComponent, List<IComponent> subComponents, IFilesystemRestClient client) throws FileSystemException {
        ArrayList<IComponent> cycleCreatingComps = new ArrayList<IComponent>();
        for (IComponent subComp : subComponents) {
            boolean isFormsCycle;
            if (parentComponent.getItemId().getUuidValue().equals(subComp.getItemId().getUuidValue())) {
                cycleCreatingComps.add(subComp);
                continue;
            }
            boolean bl = isFormsCycle = this.checkIfCompIsValidSubcompOfParent(repo, workspace, subComp, Collections.singletonList(parentComponent), true, client).isEmpty();
            if (!isFormsCycle) continue;
            cycleCreatingComps.add(subComp);
        }
        return cycleCreatingComps;
    }

    private List<String> checkIfCompIsValidSubcompOfParent(ITeamRepository repo, IWorkspace workspace, IComponent parentComponent, List<IComponent> subcomponents, boolean getAllNestedSubComps, IFilesystemRestClient client) throws FileSystemException {
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), workspace.getItemId().getUuidValue());
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, (boolean)true).get(0);
        List compHierarchyRoot = wsDetails.getComponentHierarchies();
        ArrayList<String> InvalidSubCompList = new ArrayList<String>();
        List<ComponentHierarchyDTO> subCompList = this.getSubComponentsList(compHierarchyRoot, parentComponent, getAllNestedSubComps);
        if (subCompList == null) {
            for (IComponent comp : subcomponents) {
                ScmComponent2 invalidComp = RepoUtil.getComponentById((String)comp.getItemId().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                InvalidSubCompList.add(invalidComp.getName());
            }
        } else {
            ArrayList<String> subCompIds = new ArrayList<String>(subCompList.size());
            for (ComponentHierarchyDTO subComp : subCompList) {
                subCompIds.add(subComp.getComponentItemId());
            }
            for (IComponent comp : subcomponents) {
                if (subCompIds.contains(comp.getItemId().getUuidValue())) continue;
                ScmComponent2 invalidComp = RepoUtil.getComponentById((String)comp.getItemId().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                InvalidSubCompList.add(invalidComp.getName());
            }
        }
        return InvalidSubCompList;
    }

    private ParmsPutWorkspace createPutWorkspaceParms(ITeamRepository repo, IWorkspace workspace, IComponent parentComponent, List<IComponent> subcomponents) {
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.workspace = new ParmsWorkspace();
        parms.workspace.repositoryUrl = repo.getRepositoryURI();
        parms.workspace.workspaceItemId = workspace.getItemId().getUuidValue();
        parms.componentHierarchyChanges = new ParmsComponentHierarchyChange();
        parms.componentHierarchyChanges.parentComponentUuid = parentComponent.getItemId().getUuidValue();
        String[] subcomponentUuids = new String[subcomponents.size()];
        int i = 0;
        while (i < subcomponents.size()) {
            IComponent subcomponent = subcomponents.get(i);
            subcomponentUuids[i] = subcomponent.getItemId().getUuidValue();
            ++i;
        }
        this.setSubcomponentsOnParms(parms.componentHierarchyChanges, subcomponentUuids);
        return parms;
    }

    protected abstract void setSubcomponentsOnParms(ParmsComponentHierarchyChange var1, String[] var2);

    private void validateUpdatedSubcomponents(ITeamRepository repo, IComponent parentComponent, List<IComponent> specifiedSubcomponents, PutWorkspaceResultDTO result) throws CLIFileSystemClientException {
        Map<UUID, IComponent> intersection = this.getUpdatedSubcomponentsIntersection(specifiedSubcomponents, result);
        this.validateUpdatedSubcomponents(repo, parentComponent, specifiedSubcomponents, intersection);
    }

    private Map<UUID, IComponent> getUpdatedSubcomponentsIntersection(List<IComponent> specifiedSubcomponents, PutWorkspaceResultDTO result) {
        HashSet<String> updatedChildrenUuids = new HashSet<String>();
        for (String childUuid : result.getComponentHierarchyUpdateResult().getUpdatedChildrenItemIds()) {
            updatedChildrenUuids.add(childUuid);
        }
        HashMap<UUID, IComponent> intersection = new HashMap<UUID, IComponent>();
        for (IComponent component : specifiedSubcomponents) {
            UUID itemId = component.getItemId();
            if (!updatedChildrenUuids.contains(itemId.getUuidValue())) continue;
            intersection.put(itemId, component);
        }
        return intersection;
    }

    private void throwWorkspaceUnchanged(ITeamRepository repo, IComponent parentComponent) throws CLIFileSystemClientException {
        this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)this.unchangedMessage, (Object)AliasUtil.selector((String)parentComponent.getName(), (UUID)parentComponent.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), (Object[])new Object[0]));
        StatusHelper.workspaceUnchanged();
    }

    public abstract void validateUpdatedSubcomponents(ITeamRepository var1, IComponent var2, List<IComponent> var3, Map<UUID, IComponent> var4) throws CLIFileSystemClientException;

    private void printResult(ITeamRepository repo, IWorkspace workspace, IComponent parentComponent, List<IComponent> subcomponents, String changesetUuid, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream printStream = config.getWrappedOutputStream();
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enableFilter(1);
        options.enableFilter(4);
        options.addFilter(UUID.valueOf((String)changesetUuid), 4);
        options.addFilter(parentComponent.getItemId(), 1);
        options.enablePrinter(0);
        options.enablePrinter(1);
        options.enablePrinter(4);
        options.enablePrinter(8);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), workspace.getItemId().getUuidValue());
        JSONArray workspaces = JSONPrintUtil.jsonizePendingChanges3((IFilesystemRestClient)client, Arrays.asList(ws), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)config);
        PendingChangesUtil.printWorkspaces((JSONArray)workspaces, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)printStream);
        printStream.print((CharSequence)NLS.bind((String)this.successMessage, (Object)AliasUtil.selector((String)parentComponent.getName(), (UUID)parentComponent.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), (Object[])new Object[]{AliasUtil.alias((UUID)UUID.valueOf((String)changesetUuid), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET)}));
        printStream = printStream.indent();
        for (IComponent component : subcomponents) {
            printStream.println((CharSequence)AliasUtil.selector((String)component.getName(), (UUID)component.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
        }
    }
}

