/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPath;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnload;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceComponent;
import com.ibm.team.filesystem.client.util.IRepositoryRecord;
import com.ibm.team.filesystem.client.util.IRepositoryRegistry;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChanges2DTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.UnLoadResultDTO;
import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class UnloadWorkspaceCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IPositionalOptionDefinition OPT_SELECTORS = new PositionalOptionDefinition("selectors", 0, -1, "@");
    public static final INamedOptionDefinition OPT_WORKSPACE = new NamedOptionDefinition("w", "workspace", 1, "@");
    public static final INamedOptionDefinition OPT_COMPONENTS = new NamedOptionDefinition("C", "components", 0);
    public static final INamedOptionDefinition OPT_PATHS = new NamedOptionDefinition("p", "paths", 0);
    public static final NamedOptionDefinition OPT_OVERWRITE_UNCOMMITTED_DEPRECATED = new NamedOptionDefinition("o", "overwrite-uncommitted", 0);
    public static final IOptionKey OPT_DELETE = new OptionKey("delete");
    public static final NamedOptionDefinition OPT_IGNORE_UNCOMMITTED = new NamedOptionDefinition("i", "ignore-uncommitted", 0);
    private List<String> unloadedWorkspaces = new ArrayList<String>();

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        OPT_OVERWRITE_UNCOMMITTED_DEPRECATED.hideOption();
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS).addOption((INamedOptionDefinition)OPT_OVERWRITE_UNCOMMITTED_DEPRECATED, Messages.UnloadWorkspaceCmdOptions_OVERWRITE_UNCOMMITTED_HELP).addOption((INamedOptionDefinition)OPT_IGNORE_UNCOMMITTED, Messages.UnloadWorkspaceCmdOptions_OVERWRITE_UNCOMMITTED_HELP).addOption(OPT_DELETE, "D", "delete", Messages.UnloadWOrkspaceCmdOptions_DELETE_HELP, 0).addOption((INamedOptionDefinition)CommonOptions.OPT_ALL, Messages.UnloadWorkspaceCmdOptions_UNLOAD_ALL_HELP).addOption(OPT_WORKSPACE, Messages.UnloadWorkspaceCmdOptions_WS_HELP).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption(OPT_COMPONENTS, CommonOptions.OPT_COMPONENTS_SELECTOR_HELP, false).addOption(OPT_PATHS, Messages.UnloadWorkspaceCmdOptions_ROOT_PATHS_HELP, false)).addOption(OPT_SELECTORS, Messages.UnloadWorkspaceCmdOptions_SELECTOR_HELP);
        return options;
    }

    private Map<ITeamRepository, List<IComponent>> getLoadedComponents(ITeamRepository repo, List<ParmsWorkspace> wsList, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ITeamRepository, List<IComponent>> repoToComps = new HashMap<ITeamRepository, List<IComponent>>();
        ArrayList components = new ArrayList();
        for (ParmsWorkspace ws : wsList) {
            Map compList = RepoUtil.getComponentsInSandbox((String)ws.workspaceItemId, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            components.addAll(RepoUtil.getComponents(new ArrayList(compList.keySet()), (ITeamRepository)repo, (IScmClientConfiguration)config));
        }
        if (!components.isEmpty()) {
            repoToComps.put(repo, components);
        }
        return repoToComps;
    }

    private Map<ITeamRepository, List<IComponent>> getComponentsFromSelectors(List<IScmCommandLineArgument> selectors, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ITeamRepository, ArrayList<String>> repoToCompSelectors = new HashMap<ITeamRepository, ArrayList<String>>();
        List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)config);
        for (IScmCommandLineArgument compSelector : selectors) {
            ITeamRepository iTeamRepository = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)compSelector);
            List<String> compSelectors = (List)repoToCompSelectors.get(iTeamRepository);
            if (compSelectors == null) {
                compSelectors = new ArrayList<String>();
                repoToCompSelectors.put(iTeamRepository, (ArrayList<String>)compSelectors);
            }
            compSelectors.add(compSelector.getItemSelector());
        }
        ArrayList<String> compNotFound = new ArrayList<String>();
        HashMap<ITeamRepository, List<IComponent>> repoToComps = new HashMap<ITeamRepository, List<IComponent>>();
        for (Map.Entry entry : repoToCompSelectors.entrySet()) {
            ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>();
            for (ISandboxWorkspace ws1 : wsInSandboxList) {
                if (!((ITeamRepository)entry.getKey()).getId().getUuidValue().equals(ws1.getRepositoryId())) continue;
                wsList.add(new ParmsWorkspace(((ITeamRepository)entry.getKey()).getRepositoryURI(), ws1.getWorkspaceItemId()));
            }
            this.populateRepoToComps((List)entry.getValue(), client, config, (ITeamRepository)entry.getKey(), wsList, compNotFound, repoToComps);
        }
        if (!compNotFound.isEmpty()) {
            IndentingPrintStream indentingPrintStream = config.getWrappedErrorStream();
            indentingPrintStream.println((CharSequence)Messages.UnloadCmd_INVALID_COMP_SELECTOR_LIST);
            for (String comp1 : compNotFound) {
                indentingPrintStream.indent().println((CharSequence)comp1);
            }
            throw StatusHelper.itemNotFound((String)Messages.UnloadCmd_INVALID_COMP_SELECTOR);
        }
        return repoToComps;
    }

    private Map<ITeamRepository, List<IComponent>> getComponentsFromSelectors(List<IScmCommandLineArgument> selectors, IFilesystemRestClient client, IScmClientConfiguration config, ITeamRepository repo, ParmsWorkspace ws) throws FileSystemException {
        ArrayList<String> compSelectors = new ArrayList<String>();
        for (IScmCommandLineArgument compSelector : selectors) {
            compSelectors.add(compSelector.getItemSelector());
        }
        HashMap<ITeamRepository, List<IComponent>> repoToComps = new HashMap<ITeamRepository, List<IComponent>>();
        ArrayList<String> compNotFound = new ArrayList<String>();
        this.populateRepoToComps(compSelectors, client, config, repo, Arrays.asList(ws), compNotFound, repoToComps);
        if (!compNotFound.isEmpty()) {
            IndentingPrintStream err = config.getWrappedErrorStream();
            err.println((CharSequence)Messages.UnloadCmd_INVALID_COMP_SELECTOR_LIST);
            for (String comp1 : compNotFound) {
                err.indent().println((CharSequence)comp1);
            }
            throw StatusHelper.itemNotFound((String)Messages.UnloadCmd_INVALID_COMP_SELECTOR);
        }
        return repoToComps;
    }

    private void populateRepoToComps(List<String> compSelectors, IFilesystemRestClient client, IScmClientConfiguration config, ITeamRepository repo, List<ParmsWorkspace> wsList, List<String> compNotFound, Map<ITeamRepository, List<IComponent>> repoToComps) throws FileSystemException {
        ArrayList<IComponent> comp = new ArrayList<IComponent>();
        for (String compSelector : compSelectors) {
            try {
                WorkspaceComponentDTO comps = RepoUtil.getComponent((String)compSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)config, wsList, (boolean)true);
                comp.add((IComponent)RepoUtil.getItem((IItemType)IComponent.ITEM_TYPE, (UUID)UUID.valueOf((String)comps.getItemId()), (ITeamRepository)repo, (IScmClientConfiguration)config));
            }
            catch (CLIFileSystemClientException e) {
                if (e.getStatus().getCode() == 25) {
                    compNotFound.add(compSelector);
                    continue;
                }
                throw e;
            }
        }
        if (!comp.isEmpty()) {
            repoToComps.put(repo, comp);
        }
    }

    private List<IWorkspace> populateLoadedWorkspaceHavingSelector(String wsSelector, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<String> wsId = new ArrayList<String>();
        List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)config);
        for (ISandboxWorkspace ws1 : wsInSandboxList) {
            wsId.add(ws1.getWorkspaceItemId());
        }
        List wsList = RepoUtil.getWorkspaces((String)wsSelector, (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)config);
        Iterator wsItr = wsList.iterator();
        while (wsItr.hasNext()) {
            IWorkspace ws = (IWorkspace)wsItr.next();
            if (wsId.contains(ws.getItemId().getUuidValue())) continue;
            wsItr.remove();
        }
        return wsList;
    }

    private IWorkspace checkForWSAmbiguityInSandbox(String wsSelector, IFilesystemRestClient client, IScmClientConfiguration config, ITeamRepository repo) throws FileSystemException {
        List<IWorkspace> wsList = this.populateLoadedWorkspaceHavingSelector(wsSelector, repo, client, config);
        if (wsList.size() == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.UnloadCmd_INVALID_WS, (Object)wsSelector));
        }
        if (wsList.size() > 1) {
            ArrayList<IAuditableHandle> workspaceOwnerHandles = new ArrayList<IAuditableHandle>();
            for (IWorkspace ws : wsList) {
                IAuditableHandle wsOwnerHandle = ws.getOwner();
                if (wsOwnerHandle == null || workspaceOwnerHandles.contains(wsOwnerHandle)) continue;
                workspaceOwnerHandles.add(wsOwnerHandle);
            }
            Map wsOwnerIdToOwnerName = new HashMap();
            if (!workspaceOwnerHandles.isEmpty()) {
                wsOwnerIdToOwnerName = RepoUtil.getOwnerName(workspaceOwnerHandles, (ITeamRepository)repo, (IScmClientConfiguration)config);
            }
            ArrayList<SubcommandUtil.ItemInfo> wsFoundList = new ArrayList<SubcommandUtil.ItemInfo>(wsList.size());
            for (IWorkspace ws : wsList) {
                String ownerName = ws.getOwner() != null ? (String)wsOwnerIdToOwnerName.get(ws.getOwner().getItemId()) : null;
                SubcommandUtil.ItemInfo itemInfo = new SubcommandUtil.ItemInfo(ws.getName(), ws.getItemId().getUuidValue(), repo.getRepositoryURI(), ownerName, ws.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE);
                wsFoundList.add(itemInfo);
            }
            SubcommandUtil.displayAmbiguousSelectorException((String)wsSelector, wsFoundList, (IScmClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.UnloadCmd_AMBIGUOUS_ITEM, (Object)"workspace", (Object)wsSelector));
        }
        return wsList.get(0);
    }

    private ParmsWorkspaceComponent[] generateParmsWorkspaceComponent(ParmsWorkspace ws, Map<ITeamRepository, List<IComponent>> repoToComps, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)config);
        HashMap<ParmsWorkspace, ArrayList<String>> wsToComp = new HashMap<ParmsWorkspace, ArrayList<String>>();
        ArrayList<String> matchedComps = new ArrayList<String>();
        int totalCompSelectors = 0;
        for (Map.Entry<ITeamRepository, List<IComponent>> entry : repoToComps.entrySet()) {
            totalCompSelectors += entry.getValue().size();
            for (ISandboxWorkspace wsInSandbox : wsInSandboxList) {
                if (!wsInSandbox.getRepositoryId().equals(entry.getKey().getId().getUuidValue()) || ws != null && !wsInSandbox.getWorkspaceItemId().equals(ws.workspaceItemId)) continue;
                ITeamRepository wsRepo = RepoUtil.getSharedRepository((String)RepoUtil.getRepoUri((IScmClientConfiguration)config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox)), (boolean)false);
                ParmsWorkspace pw = new ParmsWorkspace(wsRepo.getRepositoryURI(), wsInSandbox.getWorkspaceItemId());
                if (!entry.getKey().getId().equals((Object)wsRepo.getId())) continue;
                Map compList = RepoUtil.getComponentsInSandbox((String)wsInSandbox.getWorkspaceItemId(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                block2: for (IComponent comp : entry.getValue()) {
                    for (String wsCompId : compList.keySet()) {
                        if (!comp.getItemId().getUuidValue().equals(wsCompId)) continue;
                        ArrayList<String> wsCompIds = (ArrayList<String>)wsToComp.get(pw);
                        if (wsCompIds == null) {
                            wsCompIds = new ArrayList<String>();
                            wsToComp.put(pw, wsCompIds);
                        }
                        wsCompIds.add(wsCompId);
                        matchedComps.add(wsCompId);
                        continue block2;
                    }
                }
            }
        }
        if (matchedComps.size() != totalCompSelectors) {
            IndentingPrintStream err = config.getWrappedErrorStream();
            err.println((CharSequence)Messages.UnloadCmd_INVALID_COMP_SELECTOR_LIST);
            for (Map.Entry<Object, Object> entry : repoToComps.entrySet()) {
                for (IComponent comp : (List)entry.getValue()) {
                    if (matchedComps.contains(comp.getItemId().getUuidValue())) continue;
                    err.indent().println((CharSequence)AliasUtil.selector((String)comp.getName(), (UUID)comp.getItemId(), (String)((ITeamRepository)entry.getKey()).getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
                }
            }
            throw StatusHelper.ambiguousSelector((String)Messages.UnloadCmd_INVALID_COMP_SELECTOR);
        }
        ArrayList<ParmsWorkspaceComponent> parmsWsComp = new ArrayList<ParmsWorkspaceComponent>();
        for (Map.Entry<Object, Object> entry : wsToComp.entrySet()) {
            for (String compId : (List)entry.getValue()) {
                ParmsWorkspaceComponent wsComp = new ParmsWorkspaceComponent();
                wsComp.workspace = (ParmsWorkspace)entry.getKey();
                wsComp.componentItemId = compId;
                parmsWsComp.add(wsComp);
            }
        }
        return parmsWsComp.toArray(new ParmsWorkspaceComponent[parmsWsComp.size()]);
    }

    private ILocation getValidSandBoxPathLocation(String selector, IScmClientConfiguration config, StringBuffer path) throws FileSystemException {
        ILocation absolutePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)config, (String)selector);
        if (path != null && path.length() > 0) {
            path.delete(0, path.length());
        }
        path.append(absolutePath.toOSString());
        if (!SubcommandUtil.exists((ILocation)absolutePath, null)) {
            return null;
        }
        return absolutePath;
    }

    private boolean isValidRepo(IRepositoryRegistry repoRegistry, String repoStr) {
        if (StringUtils.isEmpty((String)repoStr)) {
            return false;
        }
        for (IRepositoryRecord rec : repoRegistry) {
            if (!repoStr.equals(rec.getNickname()) && !repoStr.equals(rec.getUrl())) continue;
            return true;
        }
        return false;
    }

    private Map<String, ILocation> getValidSandBoxPaths(List<IScmCommandLineArgument> repoItems, IScmClientConfiguration config) throws FileSystemException {
        IRepositoryRegistry repoRegistry = config.getRepositoryRegistry();
        String repoString = "";
        String selectorStr = "";
        StringBuffer path = new StringBuffer();
        HashMap<String, ILocation> selectorToLocationMap = new HashMap<String, ILocation>();
        ILocation validLocation = null;
        for (IScmCommandLineArgument arg : repoItems) {
            selectorStr = arg.getItemSelector();
            validLocation = this.getValidSandBoxPathLocation(selectorStr, config, path);
            if (validLocation != null && !StringUtils.isEmpty((String)validLocation.toOSString())) {
                selectorToLocationMap.put(selectorStr, validLocation);
                continue;
            }
            if (arg.isRepoExplicit()) {
                boolean validRepo = false;
                repoString = arg.getRepositorySelector();
                validRepo = this.isValidRepo(repoRegistry, repoString);
                if (validRepo) {
                    throw StatusHelper.disallowed((String)NLS.bind((String)Messages.AnnotateCmd_PathDoesNotExist, (Object)path.toString()));
                }
                selectorStr = arg.getStringValue();
                validLocation = this.getValidSandBoxPathLocation(selectorStr, config, path);
                if (validLocation != null && !StringUtils.isEmpty((String)validLocation.toOSString())) {
                    selectorToLocationMap.put(selectorStr, validLocation);
                    continue;
                }
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.AnnotateCmd_PathDoesNotExist, (Object)path.toString()));
            }
            throw StatusHelper.disallowed((String)NLS.bind((String)Messages.AnnotateCmd_PathDoesNotExist, (Object)path.toString()));
        }
        return selectorToLocationMap;
    }

    private ParmsPath[] generateSharePaths(Map<String, ILocation> locMap, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<File, ArrayList<ILocation>> cfaRootToshareRoots = new HashMap<File, ArrayList<ILocation>>();
        ArrayList<String> nonShareRoots = new ArrayList<String>();
        HashMap<Sandbox, IShare[]> sandboxShares = new HashMap<Sandbox, IShare[]>();
        for (Map.Entry<String, ILocation> locEntry : locMap.entrySet()) {
            ILocation absolutePath = locEntry.getValue();
            String selector = locEntry.getKey();
            File cfaRoot = SubcommandUtil.findAncestorCFARoot((String)absolutePath.toOSString());
            if (cfaRoot == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_PathIsNotShared, (Object)selector));
            }
            Sandbox sandbox = new Sandbox((ILocation)new PathLocation(cfaRoot.getAbsolutePath()));
            IShare[] shares = null;
            if (sandboxShares.containsKey(sandbox)) {
                shares = (IShare[])sandboxShares.get(sandbox);
            } else {
                shares = sandbox.allShares(null);
                sandboxShares.put(sandbox, shares);
            }
            boolean isShareRoot = false;
            IShare[] iShareArray = shares;
            int n = shares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                if (share.getFullPath().equals((Object)absolutePath)) {
                    isShareRoot = true;
                    break;
                }
                ++n2;
            }
            if (!isShareRoot) {
                nonShareRoots.add(selector);
                continue;
            }
            ArrayList<ILocation> shareRoots = (ArrayList<ILocation>)cfaRootToshareRoots.get(cfaRoot);
            if (shareRoots == null) {
                shareRoots = new ArrayList<ILocation>();
                cfaRootToshareRoots.put(cfaRoot, shareRoots);
            }
            shareRoots.add(absolutePath);
        }
        if (nonShareRoots.size() > 0) {
            IndentingPrintStream out = config.getWrappedOutputStream();
            out.println((CharSequence)Messages.UnloadWorkspaceCmd_PathsAreNotShareRoots);
            for (String selector : nonShareRoots) {
                out.indent().println((CharSequence)selector);
            }
        }
        ArrayList<ParmsPath> shareRoots = new ArrayList<ParmsPath>();
        for (Map.Entry entry : cfaRootToshareRoots.entrySet()) {
            for (ILocation shareRoot : (List)entry.getValue()) {
                String cfaRootPath = ((File)entry.getKey()).getAbsolutePath();
                IRelativeLocation relativePath = shareRoot.getLocationRelativeTo((ILocation)new PathLocation(cfaRootPath));
                RepoUtil.loginOnPath((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ILocation)shareRoot);
                ParmsPath path = new ParmsPath();
                path.sandboxPath = ((File)entry.getKey()).getAbsolutePath();
                path.relativePath = relativePath.toString();
                shareRoots.add(path);
            }
        }
        return shareRoots.toArray(new ParmsPath[shareRoots.size()]);
    }

    private void generateUnloadParms(ParmsUnload parms, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) && cli.hasOption(OPT_WORKSPACE.getId())) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.UnloadWorkspaceCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_ALL).getName(), (Object)cli.getDefinition().getOption(OPT_WORKSPACE.getId()).getName()));
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) && cli.hasOption(OPT_COMPONENTS.getId())) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.UnloadWorkspaceCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_ALL).getName(), (Object)cli.getDefinition().getOption(OPT_COMPONENTS.getId()).getName()));
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) && cli.hasOption(OPT_PATHS.getId())) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.UnloadWorkspaceCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_ALL).getName(), (Object)cli.getDefinition().getOption(OPT_PATHS.getId()).getName()));
        }
        if (cli.hasOption(OPT_COMPONENTS.getId()) && cli.hasOption(OPT_PATHS.getId())) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.UnloadWorkspaceCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object[])new String[]{OPT_COMPONENTS.toString(), OPT_PATHS.toString()}));
        }
        if ((cli.hasOption(OPT_COMPONENTS.getId()) || cli.hasOption(OPT_PATHS.getId())) && !cli.hasOption(OPT_SELECTORS.getId())) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.UnloadWorkspaceCmd_NO_SELECTORS, (Object)(cli.hasOption(OPT_COMPONENTS.getId()) ? OPT_COMPONENTS.toString() : OPT_PATHS.toString())));
        }
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL)) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)config);
            ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>();
            repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)config, (IFilesystemRestClient)client);
            for (ISandboxWorkspace ws1 : wsInSandboxList) {
                String wsRepoUri = RepoUtil.getRepoUri((IScmClientConfiguration)config, (IFilesystemRestClient)client, (String)ws1.getRepositoryId());
                if (!repo.getRepositoryURI().equals(wsRepoUri)) continue;
                wsList.add(new ParmsWorkspace(repo.getRepositoryURI(), ws1.getWorkspaceItemId()));
            }
            if (wsList.isEmpty()) {
                throw StatusHelper.itemNotFound((String)Messages.UnloadWorkspaceCmd_NO_OPERATION_TO_PERFORM);
            }
            Map<ITeamRepository, List<IComponent>> repoToComps = this.getLoadedComponents(repo, wsList, client, config);
            if (!repoToComps.isEmpty()) {
                parms.unloadRequests = this.generateParmsWorkspaceComponent(null, repoToComps, client, config);
            }
            for (ParmsWorkspace ws1 : wsList) {
                this.unloadedWorkspaces.add(ws1.workspaceItemId);
            }
        } else {
            if (cli.hasOption(OPT_WORKSPACE.getId())) {
                ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE.getId()), (IScmClientConfiguration)config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
                repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
                IWorkspace wsFound = this.checkForWSAmbiguityInSandbox(wsSelector.getItemSelector(), client, config, repo);
                ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
            }
            if (cli.hasOption(OPT_SELECTORS.getId())) {
                List selectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(OPT_SELECTORS.getId()), (IScmClientConfiguration)config);
                if (cli.hasOption(OPT_PATHS.getId())) {
                    Map<String, ILocation> selectorToLocationMap = this.getValidSandBoxPaths(selectors, config);
                    parms.fullSharePaths = this.generateSharePaths(selectorToLocationMap, client, config);
                    if (parms.fullSharePaths.length == 0) {
                        config.getWrappedOutputStream().println((CharSequence)Messages.UnloadWorkspaceCmd_NO_OPERATION_TO_PERFORM);
                        StatusHelper.workspaceUnchanged();
                    }
                } else {
                    Map<ITeamRepository, List<IComponent>> repoToComps = null;
                    SubcommandUtil.validateArgument((List)selectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                    if (ws != null) {
                        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, (List)selectors, (ITeamRepository)repo, (IScmClientConfiguration)config);
                        repoToComps = this.getComponentsFromSelectors(selectors, client, config, repo, ws);
                        if (repoToComps.isEmpty()) {
                            throw StatusHelper.itemNotFound((String)Messages.UnloadWorkspaceCmd_NO_OPERATION_TO_PERFORM);
                        }
                        parms.unloadRequests = this.generateParmsWorkspaceComponent(ws, repoToComps, client, config);
                    } else {
                        repoToComps = this.getComponentsFromSelectors(selectors, client, config);
                        if (repoToComps.isEmpty()) {
                            throw StatusHelper.itemNotFound((String)Messages.UnloadWorkspaceCmd_NO_OPERATION_TO_PERFORM);
                        }
                        parms.unloadRequests = this.generateParmsWorkspaceComponent(null, repoToComps, client, config);
                    }
                }
            } else {
                Map<ITeamRepository, List<IComponent>> repoToComps;
                if (ws == null) {
                    ws = RepoUtil.findWorkspaceInSandbox(null, null, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                    repo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)config.getConnectionInfo(ws.repositoryUrl));
                }
                if (!(repoToComps = this.getLoadedComponents(repo, Arrays.asList(ws), client, config)).isEmpty()) {
                    parms.unloadRequests = this.generateParmsWorkspaceComponent(ws, repoToComps, client, config);
                }
                this.unloadedWorkspaces.add(ws.workspaceItemId);
            }
        }
        parms.deleteContent = cli.hasOption(OPT_DELETE);
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)OPT_OVERWRITE_UNCOMMITTED_DEPRECATED) || cli.hasOption((IOptionKey)OPT_IGNORE_UNCOMMITTED) ? "no" : "cancel";
    }

    public void run() throws FileSystemException {
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ParmsUnload parms = new ParmsUnload();
        this.generateUnloadParms(parms, client, this.config);
        if (parms.fullSharePaths != null && parms.fullSharePaths.length > 0 || parms.unloadRequests != null && parms.unloadRequests.length > 0) {
            try {
                UnLoadResultDTO result = client.postUnloadCFA(parms, null);
                if (result.isCancelled()) {
                    int noOfUncheckedInChanges = 0;
                    List configsWithUncheckedInChanges = result.getConfigurationsWithUncheckedInChanges();
                    for (ConfigurationWithUncheckedInChanges2DTO configWithUncheckedInChanges : configsWithUncheckedInChanges) {
                        noOfUncheckedInChanges += configWithUncheckedInChanges.getChangeCount();
                    }
                    if (noOfUncheckedInChanges > 0) {
                        throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)OPT_IGNORE_UNCOMMITTED.getName()));
                    }
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.UnloadWorkspaceCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
        }
        if (!this.unloadedWorkspaces.isEmpty()) {
            File cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)this.config.getContext().getCurrentWorkingDirectory());
            this.config.getSandboxHistoryRegistry().removeWorkspaces((ILocation)new PathLocation(cfaRootPath.getAbsolutePath()), this.unloadedWorkspaces);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.UnloadWorkspaceCmd_Success);
    }
}

