/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.workspace.ReplaceComponentsCmdOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceComponentReplaceWithBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithHistory;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithSnapshot;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class ReplaceComponentsCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        WorkspaceUpdateResultDTO result;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ParmsWorkspaceUpdate parms = new ParmsWorkspaceUpdate();
        this.generateReplaceComponentParms(cli, client, parms, this.config);
        if (this.config.isDryRun()) {
            return;
        }
        try {
            result = client.postWorkspaceUpdate(parms, null);
        }
        catch (TeamRepositoryException e) {
            PermissionDeniedException pde = (PermissionDeniedException)((Object)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e));
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)((Object)pde), (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            throw StatusHelper.wrap((String)Messages.ReplaceComponentsCmd_COULD_NOT_UPDATE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        if (result.isCancelled()) {
            int noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges());
            if (noOfUncheckedInChanges > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.CreateBaselineCmd_ERROR_UNCOMMITTED_CHANGES_TO_LOCAL_FILESYSTEM, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
            }
            if (result.getNoBackupBaselinesComponents().size() > 0) {
                throw StatusHelper.noBackupBaseline((String)NLS.bind((String)Messages.ReplaceComponentsCmd_NO_BACKUP_BASELINE, (Object)ReplaceComponentsCmdOptions.OPT_NO_BACKUP.getName()));
            }
            if (result.getSubcomponentsInMultipleHierarchies().size() > 0 || result.getSelectedComponentsInMultipleHierarchies().size() > 0) {
                throw StatusHelper.componentsInMultipleHierarchies((String)NLS.bind((String)Messages.ReplaceComponentsCmd_MULTI_HIERARCHY, (Object)ReplaceComponentsCmdOptions.OPT_ALLOW_MULTIPLE_HIERARCHY.getName()));
            }
            if (result.getInaccessibleComponentsNotInSeed().size() > 0) {
                throw StatusHelper.inaccessibleComponentsNotInSeed((String)NLS.bind((String)Messages.ReplaceComponentsCmd_INACCESSIBLE_COMPONENTS_NOT_IN_SEED, (Object)ReplaceComponentsCmdOptions.OPT_ALLOW_MULTIPLE_HIERARCHY.getName()));
            }
        }
        this.showResult(result, this.config);
    }

    private void showResult(WorkspaceUpdateResultDTO result, IScmClientConfiguration config) {
        IndentingPrintStream out = config.getWrappedOutputStream();
        if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0) {
            SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getSandboxUpdateDilemma().getBackedUpToShed());
        }
        if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
            SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)out);
        }
        if (result.isSetEclipseReadFailureMessage()) {
            IndentingPrintStream err = config.getWrappedErrorStream();
            for (Object nextMsg : result.getEclipseReadFailureMessage()) {
                err.println((CharSequence)((String)nextMsg));
            }
        } else {
            out.println((CharSequence)Messages.ReplaceComponentsCmd_SUCCESS);
        }
    }

    private void generateReplaceComponentParms(ICommandLine cli, IFilesystemRestClient client, ParmsWorkspaceUpdate parms, IScmClientConfiguration config) throws FileSystemException {
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
        parms.workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parms.workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        parms.workspaceUpdateDilemmaHandler.componentFlowDirection = "no";
        parms.workspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection = "continue";
        parms.workspaceUpdateDilemmaHandler.activeChangeSetsDirection = "no";
        parms.workspaceUpdateDilemmaHandler.activeChangeSetsOverlapDirection = "no";
        parms.workspaceUpdateDilemmaHandler.noBackupBaselineDirection = cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_NO_BACKUP) ? "continue" : "cancel";
        parms.workspaceUpdateDilemmaHandler.componentInMultipleHierarchiesDirection = cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_ALLOW_MULTIPLE_HIERARCHY) ? "continue" : "cancel";
        parms.workspaceUpdateDilemmaHandler.inaccessibleComponentsNotInSeedDirection = cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_SKIP_INACCESSIBLE_COMPONENTS) ? "continue" : "cancel";
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "load";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "load";
        parms.outOfSyncInstructions.deleteRemovedShares = true;
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        ReplaceType replaceType = this.findType(cli.getOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_TYPE));
        if (replaceType == ReplaceType.SNAPSHOT && cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_BASELINE)) {
            throw StatusHelper.argSyntax((String)Messages.ReplaceComponentsCmd_SNAPSHOT_INVALID_OPTION);
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) && cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_COMPONENTS_SELECTOR)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ReplaceComponentsCmd_COMPONENT_SELECTOR_CANNOT_SPECIFY_BOTH, (Object)CommonOptions.OPT_ALL.getName()));
        }
        if (!cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) && !cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_COMPONENTS_SELECTOR)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ReplaceComponentsCmd_COMPONENT_SELECTOR_SPECIFY_ONE, (Object)CommonOptions.OPT_ALL.getName()));
        }
        ScmCommandLineArgument targetWsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ReplaceComponentsCmdOptions.OPT_TARGET_WORKSPACE), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)targetWsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository targetRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)targetWsSelector);
        IWorkspace targetWs = RepoUtil.getWorkspace((String)targetWsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)targetRepo, (IScmClientConfiguration)config);
        if (replaceType == ReplaceType.WORKSPACE) {
            if (cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_BASELINE)) {
                parms.workspaceReplaceWithBaseline = this.generateBaselineParms(targetWs, targetRepo, config, client, cli);
            } else {
                parms.workspaceReplaceWithWorkspace = this.generateWorkspaceParms(targetWs, targetRepo, config, client, cli);
            }
            if (cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_HIERARCHY)) {
                parms.hierarchicalOperation = true;
                parms.workspaceUpdateDilemmaHandler.componentFlowDirection = "continue";
            }
        } else if (replaceType == ReplaceType.BASELINE) {
            parms.workspaceReplaceWithBaseline = this.generateBaselineParms(targetWs, targetRepo, config, client, cli, true);
        } else if (replaceType == ReplaceType.HISTORY_REFERENCE) {
            ScmCommandLineArgument sourceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_ITEM), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)sourceSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE);
            ITeamRepository sourceRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)sourceSelector);
            IAlias alias = RepoUtil.lookupByIdOrAlias((String)sourceSelector.getItemSelector(), (String)sourceRepo.getRepositoryURI());
            if (alias == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_INVALID_ALIAS_UUID, (Object)sourceSelector.getItemSelector()));
            }
            if (!alias.getItemType().equals((Object)RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE)) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_NOT_A_HISTORY_REF, (Object)sourceSelector.getItemSelector()));
            }
            ParmsWorkspace parmsWorkspace = new ParmsWorkspace(targetRepo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
            ParmsHistoryReference parmsHistoryReference = SubcommandUtil.createParmsHistoryReference((String)alias.getId(), (String)sourceRepo.getRepositoryURI());
            if (parmsHistoryReference == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_NOT_A_HISTORY_REF, (Object)alias.getId()));
            }
            ParmsWorkspaceReplaceWithHistory parmsReplaceWithHistory = new ParmsWorkspaceReplaceWithHistory(parmsWorkspace, parmsHistoryReference);
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL)) {
                parmsReplaceWithHistory.componentItemIds = null;
            } else {
                Set<String> componentIds = this.getComponentsToBeReplaced(targetWs, sourceRepo, targetRepo, cli, config, client).keySet();
                parmsReplaceWithHistory.componentItemIds = componentIds.toArray(new String[componentIds.size()]);
            }
            parms.workspaceReplaceWithHistory = new ParmsWorkspaceReplaceWithHistory[]{parmsReplaceWithHistory};
        } else {
            parms.workspaceReplaceWithSnapshot = this.generateSnapshotParms(targetWs, targetRepo, config, client, cli);
        }
    }

    private ParmsWorkspaceReplaceWithWorkspace[] generateWorkspaceParms(IWorkspace targetWs, ITeamRepository targetRepo, IScmClientConfiguration config, IFilesystemRestClient client, ICommandLine cli) throws FileSystemException {
        ScmCommandLineArgument selector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_ITEM), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository srcRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
        IWorkspace ws = RepoUtil.getWorkspace((String)selector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)srcRepo, (IScmClientConfiguration)config);
        Map<String, String> componentIdsToName = this.getComponentsToBeReplaced(targetWs, srcRepo, targetRepo, cli, config, client);
        ParmsWorkspace sourceWs = new ParmsWorkspace(srcRepo.getRepositoryURI(), ws.getItemId().getUuidValue());
        WorkspaceDetailsDTO sourceWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(sourceWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        List sourceWsComps = sourceWsDetails.getComponents();
        ArrayList<String> componentsSkipped = new ArrayList<String>(componentIdsToName.values());
        ArrayList<String> componentsToBeReplaced = new ArrayList<String>();
        for (WorkspaceComponentDTO comp : sourceWsComps) {
            if (!componentIdsToName.keySet().contains(comp.getItemId())) continue;
            componentsToBeReplaced.add(comp.getItemId());
            componentsSkipped.remove(componentIdsToName.get(comp.getItemId()));
        }
        if (componentsSkipped.size() > 0) {
            IndentingPrintStream out = config.getWrappedOutputStream();
            out.println((CharSequence)NLS.bind((String)Messages.ReplaceComponentsCmd_COMPONENT_NOT_IN_WORKSPACE, (Object)AliasUtil.selector((String)sourceWsDetails.getName(), (UUID)UUID.valueOf((String)sourceWsDetails.getItemId()), (String)sourceWsDetails.getRepositoryURL(), (RepoUtil.ItemType)(sourceWsDetails.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE))));
            out.indent();
            for (String comp : componentsSkipped) {
                out.println((CharSequence)comp);
            }
        }
        ParmsWorkspaceReplaceWithWorkspace[] parms = new ParmsWorkspaceReplaceWithWorkspace[]{new ParmsWorkspaceReplaceWithWorkspace()};
        parms[0].sourceWorkspace = new ParmsWorkspace(srcRepo.getRepositoryURI(), sourceWs.workspaceItemId);
        parms[0].workspace = new ParmsWorkspace(targetRepo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
        parms[0].componentItemIds = componentsToBeReplaced.toArray(new String[componentsToBeReplaced.size()]);
        return parms;
    }

    private ParmsWorkspaceComponentReplaceWithBaseline[] generateBaselineParms(IWorkspace targetWs, ITeamRepository targetRepo, IScmClientConfiguration config, IFilesystemRestClient client, ICommandLine cli) throws FileSystemException {
        return this.generateBaselineParms(targetWs, targetRepo, config, client, cli, false);
    }

    private ParmsWorkspaceComponentReplaceWithBaseline[] generateBaselineParms(IWorkspace targetWs, ITeamRepository targetRepo, IScmClientConfiguration config, IFilesystemRestClient client, ICommandLine cli, boolean replaceTypeBaseline) throws FileSystemException {
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_ITEM), (IScmClientConfiguration)config);
        ScmCommandLineArgument blSelector = null;
        blSelector = !replaceTypeBaseline ? ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ReplaceComponentsCmdOptions.OPT_BASELINE), (IScmClientConfiguration)config) : wsSelector;
        SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
        ScmCommandLineArgument sourceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ReplaceComponentsCmdOptions.OPT_SOURCE, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)sourceSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository srcRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace ws = null;
        ws = !replaceTypeBaseline ? RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)srcRepo, (IScmClientConfiguration)config) : targetWs;
        Map<String, String> componentIdsToName = this.getComponentsToBeReplaced(targetWs, srcRepo, targetRepo, cli, config, client);
        ParmsWorkspace sourceWs = new ParmsWorkspace(srcRepo.getRepositoryURI(), ws.getItemId().getUuidValue());
        WorkspaceDetailsDTO sourceWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(sourceWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        List sourceWsComps = sourceWsDetails.getComponents();
        ArrayList<IBaseline> baselines = new ArrayList<IBaseline>();
        for (WorkspaceComponentDTO sourceComp : sourceWsComps) {
            if (!componentIdsToName.keySet().contains(sourceComp.getItemId())) continue;
            IBaseline baseline = RepoUtil.getBaseline((String)blSelector.getItemSelector(), (String)sourceComp.getItemId(), (String)sourceComp.getName(), (ITeamRepository)srcRepo, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            baselines.add(baseline);
        }
        ArrayList<String> baselineIds = new ArrayList<String>();
        for (IBaseline baseline : baselines) {
            IComponentHandle compHandle = baseline.getComponent();
            if (!componentIdsToName.keySet().contains(compHandle.getItemId().getUuidValue())) continue;
            baselineIds.add(baseline.getItemId().getUuidValue());
        }
        if (baselineIds.size() == 0) {
            config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ReplaceComponentsCmd_BASELINE_NOT_IN_COMPONENT, (Object)blSelector.getItemSelector()));
        }
        ParmsWorkspaceComponentReplaceWithBaseline[] parms = new ParmsWorkspaceComponentReplaceWithBaseline[baselineIds.size()];
        IWorkspace operationSource = null;
        ITeamRepository sourceRepo = null;
        if (cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_SOURCE)) {
            sourceRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)sourceSelector);
            operationSource = RepoUtil.getWorkspace((String)sourceSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)sourceRepo, (IScmClientConfiguration)config);
        }
        int count = 0;
        for (String baselineId : baselineIds) {
            ParmsWorkspaceComponentReplaceWithBaseline replaceWithBaseline = new ParmsWorkspaceComponentReplaceWithBaseline();
            replaceWithBaseline.workspace = new ParmsWorkspace(targetRepo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
            replaceWithBaseline.baseline = new ParmsBaseline();
            replaceWithBaseline.baseline.baselineItemId = baselineId;
            replaceWithBaseline.baseline.repositoryUrl = srcRepo.getRepositoryURI();
            if (operationSource != null && sourceRepo != null) {
                replaceWithBaseline.sourceWorkspace = new ParmsWorkspace(sourceRepo.getRepositoryURI(), operationSource.getItemId().getUuidValue());
            }
            parms[count++] = replaceWithBaseline;
        }
        return parms;
    }

    private ParmsWorkspaceReplaceWithSnapshot[] generateSnapshotParms(IWorkspace targetWs, ITeamRepository targetRepo, IScmClientConfiguration config, IFilesystemRestClient client, ICommandLine cli) throws FileSystemException {
        ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_ITEM), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
        ScmCommandLineArgument sourceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ReplaceComponentsCmdOptions.OPT_SOURCE, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)sourceSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository srcRepo = null;
        String selector = ssSelector.getItemSelector();
        srcRepo = ssSelector.getRepositorySelector() != null && ssSelector.isRepoExplicit() ? RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector) : targetRepo;
        Map<String, String> componentIdsToName = this.getComponentsToBeReplaced(targetWs, srcRepo, targetRepo, cli, config, client);
        IBaselineSet snapshot = RepoUtil.getSnapshot(null, (String)selector, (ITeamRepository)srcRepo, (IScmClientConfiguration)config);
        ArrayList<String> componentsToBeReplaced = new ArrayList<String>();
        ArrayList<String> componentsSkipped = new ArrayList<String>(componentIdsToName.values());
        List baselines = RepoUtil.getExistingAccessibleItems((IItemType)IBaseline.ITEM_TYPE, (List)snapshot.getBaselines(), (ITeamRepository)srcRepo, (IScmClientConfiguration)config);
        for (IBaseline baseline : baselines) {
            String compId = baseline.getComponent().getItemId().getUuidValue();
            if (!componentIdsToName.keySet().contains(compId)) continue;
            componentsToBeReplaced.add(compId);
            componentsSkipped.remove(componentIdsToName.get(compId));
        }
        if (componentsSkipped.size() > 0) {
            IndentingPrintStream out = config.getWrappedOutputStream();
            out.println((CharSequence)NLS.bind((String)Messages.ReplaceComponentsCmd_COMPONENT_NOT_IN_WORKSPACE, (Object)AliasUtil.selector((String)snapshot.getName(), (UUID)snapshot.getItemId(), (String)srcRepo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT)));
            out.indent();
            for (String comp : componentsSkipped) {
                out.println((CharSequence)comp);
            }
        }
        IWorkspace operationSource = null;
        ITeamRepository sourceRepo = null;
        if (cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_SOURCE)) {
            sourceRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)sourceSelector);
            operationSource = RepoUtil.getWorkspace((String)sourceSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)sourceRepo, (IScmClientConfiguration)config);
        }
        ParmsWorkspaceReplaceWithSnapshot[] parms = new ParmsWorkspaceReplaceWithSnapshot[]{new ParmsWorkspaceReplaceWithSnapshot()};
        parms[0].workspace = new ParmsWorkspace(targetRepo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
        parms[0].componentItemIds = componentsToBeReplaced.toArray(new String[componentsToBeReplaced.size()]);
        parms[0].baselineSet = new ParmsBaselineSet();
        parms[0].baselineSet.baselineSetItemId = snapshot.getItemId().getUuidValue();
        parms[0].baselineSet.repositoryUrl = srcRepo.getRepositoryURI();
        if (operationSource != null && sourceRepo != null) {
            parms[0].sourceWorkspace = new ParmsWorkspace(sourceRepo.getRepositoryURI(), operationSource.getItemId().getUuidValue());
        }
        return parms;
    }

    private Map<String, String> getComponentsToBeReplaced(IWorkspace ws, ITeamRepository srcRepo, ITeamRepository targetRepo, ICommandLine cli, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        ParmsWorkspace targetWs = new ParmsWorkspace(targetRepo.getRepositoryURI(), ws.getItemId().getUuidValue());
        WorkspaceDetailsDTO targetWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(targetWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        List targetWsComps = targetWsDetails.getComponents();
        HashMap<String, String> componentIdsToName = new HashMap<String, String>();
        if (cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_COMPONENTS_SELECTOR)) {
            List componentSelectors = cli.getOptions((IOptionKey)ReplaceComponentsCmdOptions.OPT_COMPONENTS_SELECTOR);
            boolean found = false;
            for (String selector : componentSelectors) {
                IUuidAliasRegistry.IUuidAlias uuid = RepoUtil.lookupUuidAndAlias((String)selector);
                int matched = 0;
                for (WorkspaceComponentDTO comp : targetWsComps) {
                    if ((uuid == null || !RepoUtil.uuidAndRepoMatches((UUID)UUID.valueOf((String)comp.getItemId()), (ITeamRepository)targetRepo, (IUuidAliasRegistry.IUuidAlias)uuid)) && !selector.equals(comp.getName())) continue;
                    componentIdsToName.put(comp.getItemId(), comp.getName());
                    ++matched;
                    found = true;
                }
                if (matched == 0) {
                    config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ReplaceComponentsCmd_SKIPPING_COMPONENT, (Object)selector));
                    continue;
                }
                if (matched <= true) continue;
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_AMBIGUOUS_COMPONENT, (Object)selector));
            }
            if (!found) {
                throw StatusHelper.failure((String)Messages.ReplaceComponentsCmd_NOTHING_TO_REPLACE, null);
            }
        } else if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL)) {
            for (WorkspaceComponentDTO comp : targetWsComps) {
                componentIdsToName.put(comp.getItemId(), comp.getName());
            }
        }
        return componentIdsToName;
    }

    private ReplaceType findType(String typeString) throws FileSystemException {
        ReplaceType[] replaceTypeArray = ReplaceType.values();
        int n = replaceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReplaceType t = replaceTypeArray[n2];
            String[] stringArray = t.getNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String candidate = stringArray[n4];
                if (candidate.equals(typeString)) {
                    return t;
                }
                ++n4;
            }
            ++n2;
        }
        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ReplaceComponentsCmd_UNKNOWN_TYPE_STRING, (Object[])new String[]{typeString, ReplaceType.NAMES[0], ReplaceType.NAMES[1], ReplaceType.NAMES[2], ReplaceType.NAMES[3], ReplaceType.NAMES[4]}));
    }

    static enum ReplaceType {
        WORKSPACE("workspace", "workspace", "stream", "ws", "s"),
        SNAPSHOT("baselineset", "snapshot", "ss"),
        HISTORY_REFERENCE("historyRef", "historyRef", "hr"),
        BASELINE("baseline", "baseline", "bl");

        static final String[] NAMES;
        final String[] typeStrings;
        final String wireName;

        static {
            NAMES = new String[]{ReplaceType.WORKSPACE.typeStrings[0], ReplaceType.WORKSPACE.typeStrings[1], ReplaceType.SNAPSHOT.typeStrings[0], ReplaceType.HISTORY_REFERENCE.typeStrings[0], ReplaceType.BASELINE.typeStrings[0]};
        }

        private ReplaceType(String wireName, String ... t) {
            this.wireName = wireName;
            this.typeStrings = t;
        }

        String[] getNames() {
            return this.typeStrings;
        }

        String getWireName() {
            return this.wireName;
        }
    }
}

