/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class RemoveFlowTargetsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final PositionalOptionDefinition OPT_TARGETS = new PositionalOptionDefinition("target-workspace", 1, -1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.FlowTargetCmdOptions_WORKSPACE_HELP).addOption((IPositionalOptionDefinition)OPT_TARGETS, Messages.RemoveFlowTargetsCmdOptions_TARGET_HELP);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument srcSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)srcSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)srcSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)srcSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        List wsFlowList = wsDetails.getFlowEntries();
        List targetSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_TARGETS), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)targetSelectorList, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        HashMap<String, String> targetItemIdsToSelectors = new HashMap<String, String>();
        HashSet<String> targetNames = new HashSet<String>();
        for (IScmCommandLineArgument targetSelector : targetSelectorList) {
            IUuidAliasRegistry.IUuidAlias targetAlias = targetSelector.getUuidAlias();
            if (targetAlias != null) {
                targetItemIdsToSelectors.put(targetAlias.getUuid().getUuidValue(), targetSelector.getItemSelector());
                continue;
            }
            targetNames.add(targetSelector.getItemSelector());
        }
        ArrayList<ParmsWorkspace> targetWsList = new ArrayList<ParmsWorkspace>();
        for (String targetItemId : targetItemIdsToSelectors.keySet()) {
            WorkspaceFlowEntryDTO foundTarget = null;
            for (WorkspaceFlowEntryDTO wsFlow : wsFlowList) {
                if (!targetItemId.equals(wsFlow.getWorkspaceItemId())) continue;
                foundTarget = wsFlow;
                break;
            }
            if (foundTarget == null) {
                targetNames.add(targetItemId);
                continue;
            }
            targetWsList.add(new ParmsWorkspace(foundTarget.getRepositoryURL(), foundTarget.getWorkspaceItemId()));
        }
        ArrayList<String> unmatchedTargets = new ArrayList<String>();
        if (!targetNames.isEmpty()) {
            HashMap<String, ArrayList<ParmsWorkspace>> wsNameToWsParms = new HashMap<String, ArrayList<ParmsWorkspace>>();
            for (WorkspaceFlowEntryDTO wsFlow : wsFlowList) {
                ITeamRepository flowRepo = null;
                try {
                    flowRepo = RepoUtil.getSharedRepository((String)wsFlow.getRepositoryURL(), (boolean)true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (flowRepo == null) {
                    try {
                        flowRepo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(wsFlow.getRepositoryURL(), null, false, true, false));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (flowRepo == null) continue;
                IWorkspace flowWs = null;
                try {
                    flowWs = RepoUtil.getWorkspace((String)wsFlow.getWorkspaceItemId(), (boolean)true, (boolean)true, (ITeamRepository)flowRepo, (IScmClientConfiguration)this.config);
                    ArrayList<ParmsWorkspace> wsParmsList = (ArrayList<ParmsWorkspace>)wsNameToWsParms.get(flowWs.getName());
                    if (wsParmsList == null) {
                        wsParmsList = new ArrayList<ParmsWorkspace>();
                        wsNameToWsParms.put(flowWs.getName(), wsParmsList);
                    }
                    wsParmsList.add(new ParmsWorkspace(wsFlow.getRepositoryURL(), wsFlow.getWorkspaceItemId()));
                }
                catch (Exception wsParmsList) {
                    // empty catch block
                }
            }
            for (String targetName : targetNames) {
                List wsParmsList = (List)wsNameToWsParms.get(targetName);
                if (wsParmsList != null) {
                    if (wsParmsList.size() == 1) {
                        targetWsList.add((ParmsWorkspace)wsParmsList.get(0));
                        continue;
                    }
                    HashMap flowRepoToFlowOwnerHandles = new HashMap();
                    for (ParmsWorkspace wsParms : wsParmsList) {
                        ITeamRepository flowRepo;
                        IAuditableHandle flowOwnerHandle;
                        try {
                            flowOwnerHandle = wsParms.getWorkspaceConnection(null).getOwner();
                            flowRepo = wsParms.getTeamRepository();
                        }
                        catch (TeamRepositoryException e) {
                            throw StatusHelper.wrap((String)Messages.RemoveFlowTargetsCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)wsParms.repositoryUrl);
                        }
                        if (flowOwnerHandle == null || flowRepo == null) continue;
                        if (!flowRepoToFlowOwnerHandles.containsKey(flowRepo)) {
                            ArrayList<IAuditableHandle> flowOwnerHandleList = new ArrayList<IAuditableHandle>();
                            flowOwnerHandleList.add(flowOwnerHandle);
                            flowRepoToFlowOwnerHandles.put(flowRepo, flowOwnerHandleList);
                            continue;
                        }
                        if (((List)flowRepoToFlowOwnerHandles.get(flowRepo)).contains(flowOwnerHandle)) continue;
                        ((List)flowRepoToFlowOwnerHandles.get(flowRepo)).add(flowOwnerHandle);
                    }
                    HashMap flowOwnerIdToOwnerName = new HashMap();
                    for (ITeamRepository flowRepo : flowRepoToFlowOwnerHandles.keySet()) {
                        List flowOwnerHandles = (List)flowRepoToFlowOwnerHandles.get(flowRepo);
                        flowOwnerIdToOwnerName.putAll(RepoUtil.getOwnerName((List)flowOwnerHandles, (ITeamRepository)flowRepo, (IScmClientConfiguration)this.config));
                    }
                    ArrayList<SubcommandUtil.ItemInfo> flowsMatched = new ArrayList<SubcommandUtil.ItemInfo>(wsParmsList.size());
                    for (ParmsWorkspace wsParms : wsParmsList) {
                        try {
                            IWorkspace workspace = wsParms.getWorkspaceConnection(null).getResolvedWorkspace();
                            String ownerName = workspace.getOwner() != null ? (String)flowOwnerIdToOwnerName.get(workspace.getOwner().getItemId()) : null;
                            flowsMatched.add(new SubcommandUtil.ItemInfo(targetName, wsParms.workspaceItemId, wsParms.repositoryUrl, ownerName, workspace.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE));
                        }
                        catch (TeamRepositoryException e) {
                            throw StatusHelper.wrap((String)Messages.RemoveFlowTargetsCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)wsParms.repositoryUrl);
                        }
                    }
                    SubcommandUtil.displayAmbiguousSelectorException((String)targetName, flowsMatched, (IScmClientConfiguration)this.config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.RemoveFlowTargetsCmd_AMBIGUOUS_FLOWTARGET, (Object)targetName));
                }
                String unmatchedTarget = targetName;
                if (targetItemIdsToSelectors.containsKey(targetName)) {
                    unmatchedTarget = (String)targetItemIdsToSelectors.get(targetName);
                }
                unmatchedTargets.add(unmatchedTarget);
            }
        }
        if (!targetWsList.isEmpty()) {
            ParmsPutWorkspace parms = new ParmsPutWorkspace();
            parms.workspace = ws;
            parms.flowTargetsToRemove = targetWsList.toArray(new ParmsWorkspace[targetWsList.size()]);
            try {
                client.postPutWorkspace(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.RemoveFlowTargetsCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
            }
        }
        if (!unmatchedTargets.isEmpty()) {
            IndentingPrintStream err = this.config.getWrappedErrorStream();
            err.println((CharSequence)Messages.RemoveFlowTargetsCmd_TARGETS_NOT_FOUND_HEADER);
            for (String unmatchedTarget : unmatchedTargets) {
                err.indent().println((CharSequence)unmatchedTarget);
            }
            throw StatusHelper.itemNotFound((String)Messages.RemoveFlowTargetsCmd_TARGETS_NOT_FOUND);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.RemoveFlowTargetsCmd_SUCCESS);
    }
}

