/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class RemoveComponentsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_COMPONENTS = new OptionKey("components");
    public static final NamedOptionDefinition OPT_OVERWRITE_UNCOMMITTED_DEPRECATED = new NamedOptionDefinition("o", "overwrite-uncommitted", 0);
    public static final NamedOptionDefinition OPT_IGNORE_UNCOMMITTED = new NamedOptionDefinition("i", "ignore-uncommitted", 0);
    public static final NamedOptionDefinition OPT_NO_BACKUP = new NamedOptionDefinition("n", "nobackup", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        OPT_OVERWRITE_UNCOMMITTED_DEPRECATED.hideOption();
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS).addOption((INamedOptionDefinition)OPT_OVERWRITE_UNCOMMITTED_DEPRECATED, Messages.Common_FORCE_OVERWRITE_UNCOMMITTED).addOption((INamedOptionDefinition)OPT_IGNORE_UNCOMMITTED, Messages.RemoveComponentsCmd_IGNORE_UNCOMMITTED).addOption((INamedOptionDefinition)OPT_NO_BACKUP, Messages.RemoveComponentsCmd_NOBACKUP).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.RemoveComponentsCmd_WorkspaceToRemoveComponents).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_COMPONENTS, "components", 1, -1), Messages.RemoveComponentsCmd_ComponentsToRemove);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace targetWs = new ParmsWorkspace(repo.getRepositoryURI(), ws.getItemId().getUuidValue());
        WorkspaceDetailsDTO targetWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(targetWs), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        List targetWsComps = targetWsDetails.getComponents();
        HashMap<String, WorkspaceComponentDTO> targetWsCompIds = new HashMap<String, WorkspaceComponentDTO>(targetWsComps.size());
        for (WorkspaceComponentDTO comp : targetWsComps) {
            targetWsCompIds.put(comp.getItemId(), comp);
        }
        List componentSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(OPT_COMPONENTS), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)componentSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, (List)componentSelectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        List compSelectors = RepoUtil.getSelectors((List)componentSelectors);
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        boolean printSkipHeader = true;
        HashMap<String, WorkspaceComponentDTO> filteredComponents = new HashMap<String, WorkspaceComponentDTO>();
        for (String compSelector : compSelectors) {
            boolean found = false;
            IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector, (String)repo.getRepositoryURI());
            for (WorkspaceComponentDTO compDTO : targetWsComps) {
                if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(compDTO.getItemId())) && !compSelector.equals(compDTO.getName())) continue;
                filteredComponents.put(compDTO.getItemId(), compDTO);
                found = true;
                break;
            }
            if (found) continue;
            if (printSkipHeader) {
                out.println((CharSequence)Messages.RemoveComponentsCmd_ComponentNotFoundInWorkspace);
                printSkipHeader = false;
            }
            out.indent().println((CharSequence)compSelector);
        }
        if (!filteredComponents.isEmpty()) {
            this.putWorkspace(this.config, client, repo, ws, filteredComponents);
        }
    }

    private void putWorkspace(IScmClientConfiguration config, IFilesystemRestClient client, ITeamRepository repo, IWorkspace workspace, Map<String, WorkspaceComponentDTO> compIdToObj) throws FileSystemException {
        PutWorkspaceResultDTO result;
        this.validateComponentRemoval(config, client, repo, workspace, compIdToObj);
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.configurationChanges = new ParmsConfigurationChanges();
        parms.configurationChanges.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.configurationChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.configurationChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        parms.configurationChanges.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.configurationChanges.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.configurationChanges.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.configurationChanges.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.configurationChanges.pendingChangesDilemmaHandler.pendingChangesInstruction = config.getSubcommandCommandLine().hasOption((IOptionKey)OPT_OVERWRITE_UNCOMMITTED_DEPRECATED) || config.getSubcommandCommandLine().hasOption((IOptionKey)OPT_IGNORE_UNCOMMITTED) ? "no" : "cancel";
        parms.workspace = new ParmsWorkspace();
        parms.workspace.repositoryUrl = repo.getRepositoryURI();
        parms.workspace.workspaceItemId = workspace.getItemId().getUuidValue();
        parms.configurationChanges.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
        parms.configurationChanges.components = new ParmsComponentChange[compIdToObj.size()];
        parms.configurationChanges.hierarchicalOperation = true;
        ArrayList<ParmsComponentChange> compChanges = new ArrayList<ParmsComponentChange>();
        for (Map.Entry<String, WorkspaceComponentDTO> entry : compIdToObj.entrySet()) {
            ParmsComponentChange change = new ParmsComponentChange();
            change.cmd = "removeComponent";
            change.componentItemId = entry.getKey();
            compChanges.add(change);
        }
        parms.configurationChanges.components = compChanges.toArray(new ParmsComponentChange[compChanges.size()]);
        ParmsWorkspaceUpdateDilemmaHandler parmsWorkspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parmsWorkspaceUpdateDilemmaHandler.noBackupBaselineDirection = config.getSubcommandCommandLine().hasOption((IOptionKey)OPT_NO_BACKUP) ? "continue" : "cancel";
        parmsWorkspaceUpdateDilemmaHandler.componentFlowDirection = "continue";
        parmsWorkspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        parms.configurationChanges.workspaceUpdateDilemmaHandler = parmsWorkspaceUpdateDilemmaHandler;
        try {
            result = client.postPutWorkspace(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.RemoveComponentsCmd_CannotRemoveComponents, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        if (result.isCancelled()) {
            int noOfUncheckedInChanges;
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
            }
            if ((noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)OPT_IGNORE_UNCOMMITTED.getName()));
            }
            if (result.getNoBackupBaselinesComponents().size() > 0) {
                throw StatusHelper.noBackupBaseline((String)NLS.bind((String)Messages.RemoveComponentsCmd_NO_BACKUP_BASELINE, (Object)OPT_NO_BACKUP.getName()));
            }
        }
        this.printResult(config, result, repo);
    }

    private void validateComponentRemoval(IScmClientConfiguration config, IFilesystemRestClient client, ITeamRepository repo, IWorkspace workspace, Map<String, WorkspaceComponentDTO> compIdToObj) throws FileSystemException {
        PathLocation cwd = new PathLocation(config.getContext().getCurrentWorkingDirectory());
        File cfaRoot = SubcommandUtil.findAncestorCFARoot((File)((File)cwd.getAdapter(File.class)));
        if (cfaRoot != null) {
            List shares = RepoUtil.getSharesInSandbox(null, (ILocation)cwd, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            for (ShareDTO share : shares) {
                RelativeLocation sharePath = new RelativeLocation(share.getPath().getSegments());
                ILocation shareAbsPath = new PathLocation(share.getSandboxPath()).append((IRelativeLocation)sharePath);
                if (!shareAbsPath.isPrefixOf((ILocation)cwd) || !compIdToObj.containsKey(share.getComponentItemId())) continue;
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.RemoveComponentsCmd_CannotUnloadCWD, (Object)AliasUtil.selector((String)share.getComponentName(), (UUID)UUID.valueOf((String)share.getComponentItemId()), (String)RepoUtil.getRepoUri((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ShareDTO)share), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
            }
        }
    }

    private void printResult(IScmClientConfiguration config, PutWorkspaceResultDTO result, ITeamRepository repo) throws FileSystemException {
        for (ComponentDTO component : result.getComponentsRemoved()) {
            config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.RemoveComponentsCmd_ComponentSuccessfullyRemoved, (Object)AliasUtil.selector((String)component.getName(), (UUID)UUID.valueOf((String)component.getItemId()), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
        }
    }
}

