/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.FlowComponentTargetCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.FlowWorkspaceTargetCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsFlowTargetChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class FlowTargetCmd2
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client = null;
    public static final PositionalOptionDefinition OPT_TARGET = new PositionalOptionDefinition("target-workspace", 0, 1, "@");
    public static final NamedOptionDefinition OPT_FLOW_DIRECTION = new NamedOptionDefinition(null, "flow-direction", 1, 1, null);
    public static final NamedOptionDefinition OPT_DEFAULT = new NamedOptionDefinition(null, "default", 0, 1, null);
    public static final NamedOptionDefinition OPT_CURRENT = new NamedOptionDefinition(null, "current", 0, 1, null);
    public static final NamedOptionDefinition OPT_FLOW_COMPS = new NamedOptionDefinition(null, "flow-components", -1);
    public static final NamedOptionDefinition OPT_FLOW_ALL_COMPS = new NamedOptionDefinition(null, "flow-all-components", 0);
    public static final NamedOptionDefinition OPT_COMPONENT = new NamedOptionDefinition("C", "component", 1);
    public static final NamedOptionDefinition OPT_SAME_AS_WORKSPACE = new NamedOptionDefinition("s", "same-as-workspace", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)OPT_COMPONENT, Messages.FlowTargetCmd2Options_COMPONENT_HELP, false).addOption((INamedOptionDefinition)OPT_SAME_AS_WORKSPACE, Messages.FlowTargetCmdOptions_SAME_AS_WORKSPACE_HELP, false)).addOption((IOptionGroup)new ContinuousGroup().addOption(new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_FLOW_ALL_COMPS, Messages.FlowTargetCmdOptions_FLOW_ALL_COMPONENTS_HELP, false).addOption((INamedOptionDefinition)OPT_FLOW_COMPS, Messages.FlowTargetCmdOptions_FLOW_COMPONENTS_HELP, false)).addOption((INamedOptionDefinition)OPT_FLOW_DIRECTION, Messages.FlowTargetCmdOptions_FLOW_DIRECTION_HELP, false).addOption((INamedOptionDefinition)OPT_DEFAULT, Messages.FlowTargetCmdOptions_DEFAULT_HELP, false).addOption((INamedOptionDefinition)OPT_CURRENT, Messages.FlowTargetCmdOptions_CURRENT_HELP, false).addOption((INamedOptionDefinition)CommonOptions.OPT_POSITIONAL_ARG_SEPARATOR, NLS.bind((String)Messages.PositionalArgSeparator_Help, (Object)OPT_FLOW_COMPS.getName()), false)).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.FlowTargetCmdOptions_SOURCEWS_HELP).addOption((IPositionalOptionDefinition)OPT_TARGET, NLS.bind((String)Messages.FlowTargetCmd2Options_TARGETWS_HELP, (Object)OPT_SAME_AS_WORKSPACE.getName()));
        return options;
    }

    public void run() throws FileSystemException {
        String value;
        boolean setFlowTarget;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        boolean setFlowTargetDetails = cli.hasOption((IOptionKey)OPT_FLOW_ALL_COMPS) || cli.hasOption((IOptionKey)OPT_FLOW_COMPS) || cli.hasOption((IOptionKey)OPT_DEFAULT) || cli.hasOption((IOptionKey)OPT_CURRENT) || cli.hasOption((IOptionKey)OPT_FLOW_DIRECTION);
        boolean bl = setFlowTarget = !setFlowTargetDetails;
        if (cli.hasOption((IOptionKey)OPT_COMPONENT) && setFlowTargetDetails) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.FlowTargetCmd2_COMPONENT_MUTUALLY_EXCLUSIVE, (Object[])new String[]{OPT_CURRENT.getName(), OPT_DEFAULT.getName(), OPT_FLOW_DIRECTION.getName(), OPT_FLOW_COMPS.getName(), OPT_FLOW_ALL_COMPS.getName(), OPT_COMPONENT.getName()}));
        }
        if (cli.hasOption((IOptionKey)OPT_FLOW_ALL_COMPS) && cli.hasOption((IOptionKey)OPT_FLOW_COMPS)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)OPT_FLOW_ALL_COMPS.getName(), (Object)OPT_FLOW_COMPS.getName()));
        }
        if (cli.hasOption((IOptionKey)OPT_FLOW_DIRECTION)) {
            value = cli.getOption((IOptionKey)OPT_FLOW_DIRECTION);
            if (!(value.equalsIgnoreCase("i") || value.equalsIgnoreCase("o") || value.equalsIgnoreCase("b"))) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.FlowtargetCmd_INVALID_OPTION_VALUE, (Object)OPT_FLOW_DIRECTION.getName()));
            }
            if (cli.hasOption((IOptionKey)OPT_COMPONENT) && (value.equalsIgnoreCase("i") || value.equalsIgnoreCase("o"))) {
                throw StatusHelper.argSyntax((String)Messages.FlowtargetCmd_INVALID_COMPONENT_FLOW);
            }
        }
        if (cli.hasOption((IOptionKey)OPT_DEFAULT) && !(value = cli.getOption((IOptionKey)OPT_DEFAULT, "b")).equalsIgnoreCase("i") && !value.equalsIgnoreCase("o") && !value.equalsIgnoreCase("b")) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.FlowtargetCmd_INVALID_OPTION_VALUE, (Object)OPT_DEFAULT.getName()));
        }
        if (cli.hasOption((IOptionKey)OPT_CURRENT) && !(value = cli.getOption((IOptionKey)OPT_CURRENT, "b")).equalsIgnoreCase("i") && !value.equalsIgnoreCase("o") && !value.equalsIgnoreCase("b")) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.FlowtargetCmd_INVALID_OPTION_VALUE, (Object)OPT_CURRENT.getName()));
        }
        if (!cli.hasOption((IOptionKey)OPT_TARGET) && !cli.hasOption((IOptionKey)OPT_SAME_AS_WORKSPACE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.FlowtargetCmd_MISSING_REQUIRED_TARGET, (Object)OPT_SAME_AS_WORKSPACE.getName()));
        }
        if (!cli.hasOption((IOptionKey)OPT_COMPONENT) && cli.hasOption((IOptionKey)OPT_SAME_AS_WORKSPACE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.FlowtargetCmd_SAME_AS_WORKSPACE_INVALID_OPTION, (Object)OPT_SAME_AS_WORKSPACE.getName(), (Object)OPT_COMPONENT.getName()));
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument srcSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)srcSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)srcSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)srcSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        ParmsWorkspace targetWs = null;
        ScmCommandLineArgument targetSelector = null;
        if (!cli.hasOption((IOptionKey)OPT_SAME_AS_WORKSPACE)) {
            targetSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_TARGET), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)targetSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            ITeamRepository repo2 = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)targetSelector);
            wsFound = RepoUtil.getWorkspace((String)targetSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo2, (IScmClientConfiguration)this.config);
            targetWs = new ParmsWorkspace(repo2.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        }
        if (setFlowTarget) {
            if (cli.hasOption((IOptionKey)OPT_COMPONENT)) {
                ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
                if (cli.hasOption((IOptionKey)OPT_SAME_AS_WORKSPACE)) {
                    FlowComponentTargetCmd.setComponentFlowTarget(ws, null, (IScmCommandLineArgument)compSelector, this.client, this.config);
                } else {
                    FlowComponentTargetCmd.setComponentFlowTarget(ws, targetWs, (IScmCommandLineArgument)compSelector, this.client, this.config);
                }
            } else {
                FlowWorkspaceTargetCmd.setWorkspaceFlowTarget(ws, targetWs, this.client, this.config);
            }
        } else {
            this.setFlowTargetDetails(ws, (IScmCommandLineArgument)targetSelector);
        }
    }

    private void setFlowTargetDetails(ParmsWorkspace ws, IScmCommandLineArgument targetSelector) throws FileSystemException {
        IUuidAliasRegistry.IUuidAlias targetAlias = targetSelector.getUuidAlias();
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        HashMap<String, ArrayList<String>> flowNameToItemId = new HashMap<String, ArrayList<String>>();
        HashMap<String, Object> flowItemIdToInfo = new HashMap<String, Object>();
        List wsFlowList = wsDetails.getFlowEntries();
        for (WorkspaceFlowEntryDTO wsFlow : wsFlowList) {
            ITeamRepository flowRepo = null;
            try {
                flowRepo = RepoUtil.getSharedRepository((String)wsFlow.getRepositoryURL(), (boolean)true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (flowRepo == null) {
                try {
                    flowRepo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (ConnectionInfo)this.config.getConnectionInfo(wsFlow.getRepositoryURL(), null, false, true, false));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            FlowInfo flowInfo = new FlowInfo();
            flowInfo.entryDTO = wsFlow;
            if (flowRepo != null) {
                IWorkspace flowWs = null;
                try {
                    flowInfo.ws = flowWs = RepoUtil.getWorkspace((String)wsFlow.getWorkspaceItemId(), (boolean)true, (boolean)true, (ITeamRepository)flowRepo, (IScmClientConfiguration)this.config);
                    ArrayList<String> flowList = (ArrayList<String>)flowNameToItemId.get(flowWs.getName());
                    if (flowList == null) {
                        flowList = new ArrayList<String>();
                        flowNameToItemId.put(flowWs.getName(), flowList);
                    }
                    flowList.add(wsFlow.getWorkspaceItemId());
                }
                catch (Exception flowList) {
                    // empty catch block
                }
            }
            flowItemIdToInfo.put(wsFlow.getWorkspaceItemId(), flowInfo);
        }
        if (targetAlias != null && flowItemIdToInfo.keySet().contains(targetAlias.getUuid().getUuidValue())) {
            this.peformUpdate(wsDetails, (FlowInfo)flowItemIdToInfo.get(targetAlias.getUuid().getUuidValue()));
            return;
        }
        List flowList = (List)flowNameToItemId.get(targetSelector.getItemSelector());
        if (flowList != null) {
            if (flowList.size() != 1) {
                HashMap repoToFlowOwnerHandles = new HashMap();
                for (String flowItemId : flowList) {
                    FlowInfo flowInfo = (FlowInfo)flowItemIdToInfo.get(flowItemId);
                    IAuditableHandle flowOwnerHandle = flowInfo.ws.getOwner();
                    ITeamRepository repo = RepoUtil.getTeamRepository((UUID)UUID.valueOf((String)flowInfo.entryDTO.getRepositoryId()));
                    if (flowOwnerHandle == null || repo == null) continue;
                    if (!repoToFlowOwnerHandles.containsKey(repo)) {
                        ArrayList<IAuditableHandle> flowOwnerHandleList = new ArrayList<IAuditableHandle>();
                        flowOwnerHandleList.add(flowOwnerHandle);
                        repoToFlowOwnerHandles.put(repo, flowOwnerHandleList);
                        continue;
                    }
                    if (((List)repoToFlowOwnerHandles.get(repo)).contains(flowOwnerHandle)) continue;
                    ((List)repoToFlowOwnerHandles.get(repo)).add(flowOwnerHandle);
                }
                HashMap flowOwnerIdToOwnerName = new HashMap();
                for (ITeamRepository repo : repoToFlowOwnerHandles.keySet()) {
                    List flowOwnerHandles = (List)repoToFlowOwnerHandles.get(repo);
                    flowOwnerIdToOwnerName.putAll(RepoUtil.getOwnerName((List)flowOwnerHandles, (ITeamRepository)repo, (IScmClientConfiguration)this.config));
                }
                ArrayList<SubcommandUtil.ItemInfo> flowsMatched = new ArrayList<SubcommandUtil.ItemInfo>(flowList.size());
                for (String flowItemId : flowList) {
                    FlowInfo flowInfo = (FlowInfo)flowItemIdToInfo.get(flowItemId);
                    String ownerName = flowInfo.ws.getOwner() != null ? (String)flowOwnerIdToOwnerName.get(flowInfo.ws.getOwner().getItemId()) : null;
                    flowsMatched.add(new SubcommandUtil.ItemInfo(targetSelector.getItemSelector(), flowInfo.entryDTO.getWorkspaceItemId(), flowInfo.entryDTO.getRepositoryURL(), ownerName, flowInfo.ws.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE));
                }
                SubcommandUtil.displayAmbiguousSelectorException((String)targetSelector.getItemSelector(), flowsMatched, (IScmClientConfiguration)this.config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.RemoveFlowTargetsCmd_AMBIGUOUS_FLOWTARGET, (Object)targetSelector.getItemSelector()));
            }
        } else {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.FlowTargetCmd_FLOW_TARGET_NOT_FOUND, (Object)targetSelector.getItemSelector()));
        }
        this.peformUpdate(wsDetails, (FlowInfo)flowItemIdToInfo.get(flowList.get(0)));
    }

    private void peformUpdate(WorkspaceDetailsDTO wsDetails, FlowInfo flowInfo) throws FileSystemException {
        boolean currentIncoming;
        String currentValue;
        boolean defaultIncoming;
        String defaultValue;
        boolean incomingFlow;
        String flowDirectionValue;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ParmsWorkspace ws = new ParmsWorkspace(wsDetails.getRepositoryURL(), wsDetails.getItemId());
        if (flowInfo.ws == null && cli.hasOption((IOptionKey)OPT_FLOW_COMPS)) {
            throw StatusHelper.disallowed((String)Messages.FlowTargetCmd_TARGET_NOT_LOGGED_IN);
        }
        List<String> compIds = null;
        if (cli.hasOption((IOptionKey)OPT_FLOW_COMPS)) {
            List compSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_FLOW_COMPS), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)compSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            compIds = this.getComponentItemIds(flowInfo.entryDTO, compSelectors);
        }
        String string = flowDirectionValue = cli.hasOption((IOptionKey)OPT_FLOW_DIRECTION) ? cli.getOption((IOptionKey)OPT_FLOW_DIRECTION, "b") : null;
        boolean bl = flowDirectionValue == null ? false : (incomingFlow = flowDirectionValue.equalsIgnoreCase("i") || flowDirectionValue.equalsIgnoreCase("b"));
        boolean outgoingFlow = flowDirectionValue == null ? false : flowDirectionValue.equalsIgnoreCase("o") || flowDirectionValue.equalsIgnoreCase("b");
        String string2 = defaultValue = cli.hasOption((IOptionKey)OPT_DEFAULT) ? cli.getOption((IOptionKey)OPT_DEFAULT, "b") : null;
        boolean bl2 = defaultValue == null ? false : (defaultIncoming = defaultValue.equalsIgnoreCase("i") || defaultValue.equalsIgnoreCase("b"));
        boolean defaultOutgoing = defaultValue == null ? false : defaultValue.equalsIgnoreCase("o") || defaultValue.equalsIgnoreCase("b");
        String string3 = currentValue = cli.hasOption((IOptionKey)OPT_CURRENT) ? cli.getOption((IOptionKey)OPT_CURRENT, "b") : null;
        boolean bl3 = currentValue == null ? false : (currentIncoming = currentValue.equalsIgnoreCase("i") || currentValue.equalsIgnoreCase("b"));
        boolean currentOutgoing = currentValue == null ? false : currentValue.equalsIgnoreCase("o") || currentValue.equalsIgnoreCase("b");
        ParmsWorkspace defaultIncomingFlow = null;
        ParmsWorkspace defaultOutgoingFlow = null;
        ParmsWorkspace currentIncomingFlow = null;
        ParmsWorkspace currentOutgoingFlow = null;
        if (incomingFlow && !outgoingFlow) {
            if (!defaultOutgoing && flowInfo.entryDTO.isDefaultOutgoingFlow()) {
                defaultOutgoingFlow = ws;
            }
            if (!currentOutgoing && flowInfo.entryDTO.isCurrentOutgoingFlow()) {
                currentOutgoingFlow = ws;
            }
        }
        if (!incomingFlow && outgoingFlow) {
            if (!defaultIncoming && flowInfo.entryDTO.isDefaultIncomingFlow()) {
                defaultIncomingFlow = ws;
            }
            if (!currentIncoming && flowInfo.entryDTO.isCurrentIncomingFlow()) {
                currentIncomingFlow = ws;
            }
        }
        ParmsWorkspace flowWs = new ParmsWorkspace(flowInfo.entryDTO.getRepositoryURL(), flowInfo.entryDTO.getWorkspaceItemId());
        if (defaultIncoming) {
            defaultIncomingFlow = flowWs;
            if (!incomingFlow) {
                incomingFlow = true;
                boolean bl4 = outgoingFlow = outgoingFlow ? true : flowInfo.entryDTO.isOutgoingFlow();
            }
            if (!defaultOutgoing && flowInfo.entryDTO.isDefaultOutgoingFlow()) {
                defaultOutgoingFlow = ws;
            }
        }
        if (defaultOutgoing) {
            defaultOutgoingFlow = flowWs;
            if (!outgoingFlow) {
                outgoingFlow = true;
                boolean bl5 = incomingFlow = incomingFlow ? true : flowInfo.entryDTO.isIncomingFlow();
            }
            if (!defaultIncoming && flowInfo.entryDTO.isDefaultIncomingFlow()) {
                defaultIncomingFlow = ws;
            }
        }
        if (currentIncoming) {
            currentIncomingFlow = flowWs;
            if (!incomingFlow) {
                incomingFlow = true;
                boolean bl6 = outgoingFlow = outgoingFlow ? true : flowInfo.entryDTO.isOutgoingFlow();
            }
            if (!currentOutgoing && flowInfo.entryDTO.isCurrentOutgoingFlow()) {
                currentOutgoingFlow = ws;
            }
        }
        if (currentOutgoing) {
            currentOutgoingFlow = flowWs;
            if (!outgoingFlow) {
                outgoingFlow = true;
                boolean bl7 = incomingFlow = incomingFlow ? true : flowInfo.entryDTO.isIncomingFlow();
            }
            if (!currentIncoming && flowInfo.entryDTO.isCurrentIncomingFlow()) {
                currentIncomingFlow = ws;
            }
        }
        this.updateFlowTarget(ws, flowWs, incomingFlow, outgoingFlow, defaultIncomingFlow, defaultOutgoingFlow, currentIncomingFlow, currentOutgoingFlow, cli.hasOption((IOptionKey)OPT_FLOW_ALL_COMPS), compIds);
    }

    private List<String> getComponentItemIds(WorkspaceFlowEntryDTO wsFlow, List<IScmCommandLineArgument> compSelectors) throws FileSystemException {
        ArrayList<String> compIds = new ArrayList<String>();
        ParmsWorkspace parmsFlowWs = new ParmsWorkspace(wsFlow.getRepositoryURL(), wsFlow.getWorkspaceItemId());
        WorkspaceDetailsDTO flowWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(parmsFlowWs), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        ITeamRepository repo = RepoUtil.getTeamRepository((UUID)UUID.valueOf((String)wsFlow.getRepositoryId()));
        for (IScmCommandLineArgument compSelector : compSelectors) {
            IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector.getItemSelector());
            ArrayList<WorkspaceComponentDTO> compsFound = new ArrayList<WorkspaceComponentDTO>();
            for (WorkspaceComponentDTO compDTO : flowWsDetails.getComponents()) {
                if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(compDTO.getItemId())) && !compSelector.getItemSelector().equals(compDTO.getName())) continue;
                compsFound.add(compDTO);
            }
            if (compsFound.isEmpty()) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.FlowTargetCmd_COMP_NOT_FOUND_IN_WS, (Object)compSelector.getItemSelector(), (Object)AliasUtil.selector((String)flowWsDetails.getName(), (UUID)UUID.valueOf((String)flowWsDetails.getItemId()), (String)flowWsDetails.getRepositoryURL(), (RepoUtil.ItemType)(flowWsDetails.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE))));
            }
            if (compsFound.size() > 1) {
                int noOfRepos = 1;
                HashMap<ITeamRepository, ArrayList<WorkspaceComponentDTO>> repoToCompsFound = new HashMap<ITeamRepository, ArrayList<WorkspaceComponentDTO>>(noOfRepos);
                repoToCompsFound.put(repo, compsFound);
                RepoUtil.displayAmbiguousComponents((String)compSelector.getItemSelector(), repoToCompsFound, (IScmClientConfiguration)this.config);
            }
            compIds.add(((WorkspaceComponentDTO)compsFound.get(0)).getItemId());
        }
        return compIds;
    }

    private void updateFlowTarget(ParmsWorkspace ws, ParmsWorkspace flowWs, boolean setIncomingFlow, boolean setOutgoingFlow, ParmsWorkspace defaultIncomingFlow, ParmsWorkspace defaultOutgoingFlow, ParmsWorkspace currentIncomingFlow, ParmsWorkspace currentOutgoingFlow, boolean allComps, List<String> compIds) throws FileSystemException {
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.workspace = ws;
        parms.defaultIncomingFlowTarget = defaultIncomingFlow;
        parms.defaultOutgoingFlowTarget = defaultOutgoingFlow;
        parms.currentIncomingFlowTarget = currentIncomingFlow;
        parms.currentOutgoingFlowTarget = currentOutgoingFlow;
        if (allComps || compIds != null || setIncomingFlow || setOutgoingFlow) {
            parms.flowTargets = new ParmsFlowTargetChange[1];
            ParmsFlowTargetChange flowTargetChange = new ParmsFlowTargetChange();
            flowTargetChange.workspace = flowWs;
            if (compIds != null) {
                flowTargetChange.scopedComponentItemIds = compIds.toArray(new String[compIds.size()]);
            }
            if (allComps) {
                flowTargetChange.scopedComponentItemIds = new String[0];
            }
            if (setIncomingFlow && setOutgoingFlow) {
                flowTargetChange.flowDirection = "incoming_outgoing";
            } else if (setIncomingFlow) {
                flowTargetChange.flowDirection = "incoming";
            } else if (setOutgoingFlow) {
                flowTargetChange.flowDirection = "outgoing";
            }
            parms.flowTargets[0] = flowTargetChange;
        }
        try {
            this.client.postPutWorkspace(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowTargetsCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.FlowTargetsCmd_SUCCESS);
    }

    class FlowInfo {
        public IWorkspace ws;
        public WorkspaceFlowEntryDTO entryDTO;

        FlowInfo() {
        }
    }
}

