/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListFlowTargetsCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsFlowTargetChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class FlowTargetCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client = null;
    public static final PositionalOptionDefinition OPT_TARGET = new PositionalOptionDefinition("target-workspace", 1, 1);
    public static final NamedOptionDefinition OPT_DEFAULT = new NamedOptionDefinition(null, "default", 0, 1, null);
    public static final NamedOptionDefinition OPT_CURRENT = new NamedOptionDefinition(null, "current", 0, 1, null);
    public static final NamedOptionDefinition OPT_FLOW_COMPS = new NamedOptionDefinition("C", "flow-components", -1);
    public static final NamedOptionDefinition OPT_FLOW_ALL_COMPS = new NamedOptionDefinition("a", "flow-all-components", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.FlowTargetCmdOptions_SOURCEWS_HELP).addOption((IPositionalOptionDefinition)OPT_TARGET, Messages.FlowTargetCmdOptions_TARGETWS_HELP).addOption((INamedOptionDefinition)OPT_DEFAULT, Messages.FlowTargetCmdOptions_DEFAULT_HELP).addOption((INamedOptionDefinition)OPT_CURRENT, Messages.FlowTargetCmdOptions_CURRENT_HELP).addOption((INamedOptionDefinition)OPT_FLOW_ALL_COMPS, Messages.FlowTargetCmdOptions_FLOW_ALL_COMPONENTS_HELP).addOption((INamedOptionDefinition)OPT_FLOW_COMPS, Messages.FlowTargetCmdOptions_FLOW_COMPONENTS_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        return options;
    }

    public void run() throws FileSystemException {
        String value;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)OPT_FLOW_ALL_COMPS) && cli.hasOption((IOptionKey)OPT_FLOW_COMPS)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)OPT_FLOW_ALL_COMPS.getName(), (Object)OPT_FLOW_COMPS.getName()));
        }
        if (cli.hasOption((IOptionKey)OPT_DEFAULT) && !(value = cli.getOption((IOptionKey)OPT_DEFAULT, "b")).equalsIgnoreCase("i") && !value.equalsIgnoreCase("o") && !value.equalsIgnoreCase("b")) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.FlowtargetCmd_INVALID_OPTION_VALUE, (Object)OPT_DEFAULT.getName()));
        }
        if (cli.hasOption((IOptionKey)OPT_CURRENT) && !(value = cli.getOption((IOptionKey)OPT_CURRENT, "b")).equalsIgnoreCase("i") && !value.equalsIgnoreCase("o") && !value.equalsIgnoreCase("b")) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.FlowtargetCmd_INVALID_OPTION_VALUE, (Object)OPT_CURRENT.getName()));
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument srcSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)srcSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)srcSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)srcSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        ScmCommandLineArgument targetSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_TARGET), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)targetSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IUuidAliasRegistry.IUuidAlias targetAlias = targetSelector.getUuidAlias();
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        HashMap<String, ArrayList<String>> flowNameToItemId = new HashMap<String, ArrayList<String>>();
        HashMap<String, Object> flowItemIdToInfo = new HashMap<String, Object>();
        List wsFlowList = wsDetails.getFlowEntries();
        for (WorkspaceFlowEntryDTO wsFlow : wsFlowList) {
            ITeamRepository flowRepo = null;
            try {
                flowRepo = RepoUtil.getSharedRepository((String)wsFlow.getRepositoryURL(), (boolean)true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (flowRepo == null) {
                try {
                    flowRepo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (ConnectionInfo)this.config.getConnectionInfo(wsFlow.getRepositoryURL(), null, false, true, false));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            FlowInfo flowInfo = new FlowInfo();
            flowInfo.entryDTO = wsFlow;
            if (flowRepo != null) {
                IWorkspace flowWs = null;
                try {
                    flowInfo.ws = flowWs = RepoUtil.getWorkspace((String)wsFlow.getWorkspaceItemId(), (boolean)true, (boolean)true, (ITeamRepository)flowRepo, (IScmClientConfiguration)this.config);
                    ArrayList<String> flowList = (ArrayList<String>)flowNameToItemId.get(flowWs.getName());
                    if (flowList == null) {
                        flowList = new ArrayList<String>();
                        flowNameToItemId.put(flowWs.getName(), flowList);
                    }
                    flowList.add(wsFlow.getWorkspaceItemId());
                }
                catch (Exception flowList) {
                    // empty catch block
                }
            }
            flowItemIdToInfo.put(wsFlow.getWorkspaceItemId(), flowInfo);
        }
        if (targetAlias != null && flowItemIdToInfo.keySet().contains(targetAlias.getUuid().getUuidValue())) {
            this.peformOperation(ws, (FlowInfo)flowItemIdToInfo.get(targetAlias.getUuid().getUuidValue()), cli);
            return;
        }
        List flowList = (List)flowNameToItemId.get(targetSelector.getItemSelector());
        if (flowList != null) {
            if (flowList.size() != 1) {
                HashMap flowRepoToFlowOwnerHandles = new HashMap();
                for (String flowItemId : flowList) {
                    FlowInfo flowInfo = (FlowInfo)flowItemIdToInfo.get(flowItemId);
                    IAuditableHandle flowOwnerHandle = flowInfo.ws.getOwner();
                    ITeamRepository flowRepo = RepoUtil.getTeamRepository((UUID)UUID.valueOf((String)flowInfo.entryDTO.getRepositoryId()));
                    if (flowOwnerHandle == null || flowRepo == null) continue;
                    if (!flowRepoToFlowOwnerHandles.containsKey(flowRepo)) {
                        ArrayList<IAuditableHandle> flowOwnerHandleList = new ArrayList<IAuditableHandle>();
                        flowOwnerHandleList.add(flowOwnerHandle);
                        flowRepoToFlowOwnerHandles.put(flowRepo, flowOwnerHandleList);
                        continue;
                    }
                    if (((List)flowRepoToFlowOwnerHandles.get(flowRepo)).contains(flowOwnerHandle)) continue;
                    ((List)flowRepoToFlowOwnerHandles.get(flowRepo)).add(flowOwnerHandle);
                }
                HashMap flowOwnerIdToOwnerName = new HashMap();
                for (ITeamRepository flowRepo : flowRepoToFlowOwnerHandles.keySet()) {
                    List flowOwnerHandles = (List)flowRepoToFlowOwnerHandles.get(flowRepo);
                    flowOwnerIdToOwnerName.putAll(RepoUtil.getOwnerName((List)flowOwnerHandles, (ITeamRepository)flowRepo, (IScmClientConfiguration)this.config));
                }
                ArrayList<SubcommandUtil.ItemInfo> flowsMatched = new ArrayList<SubcommandUtil.ItemInfo>(flowList.size());
                for (String flowItemId : flowList) {
                    FlowInfo flowInfo = (FlowInfo)flowItemIdToInfo.get(flowItemId);
                    String flowOwnerName = flowInfo.ws.getOwner() != null ? (String)flowOwnerIdToOwnerName.get(flowInfo.ws.getOwner().getItemId()) : null;
                    flowsMatched.add(new SubcommandUtil.ItemInfo(targetSelector.getItemSelector(), flowInfo.entryDTO.getWorkspaceItemId(), flowInfo.entryDTO.getRepositoryURL(), flowOwnerName, flowInfo.ws.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE));
                }
                SubcommandUtil.displayAmbiguousSelectorException((String)targetSelector.getItemSelector(), flowsMatched, (IScmClientConfiguration)this.config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.RemoveFlowTargetsCmd_AMBIGUOUS_FLOWTARGET, (Object)targetSelector.getItemSelector()));
            }
        } else {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.FlowTargetCmd_FLOW_TARGET_NOT_FOUND, (Object)targetSelector.getItemSelector()));
        }
        this.peformOperation(ws, (FlowInfo)flowItemIdToInfo.get(flowList.get(0)), cli);
    }

    private void peformOperation(ParmsWorkspace ws, FlowInfo flowInfo, ICommandLine cli) throws FileSystemException {
        boolean update = false;
        if (cli.hasOption((IOptionKey)OPT_CURRENT) || cli.hasOption((IOptionKey)OPT_DEFAULT) || cli.hasOption((IOptionKey)OPT_FLOW_ALL_COMPS) || cli.hasOption((IOptionKey)OPT_FLOW_COMPS)) {
            update = true;
        }
        if (update) {
            boolean currentIncoming;
            String currentValue;
            boolean defaultIncoming;
            String defaultValue;
            if (flowInfo.ws == null && cli.hasOption((IOptionKey)OPT_FLOW_COMPS)) {
                throw StatusHelper.disallowed((String)Messages.FlowTargetCmd_TARGET_NOT_LOGGED_IN);
            }
            List<String> compIds = null;
            if (cli.hasOption((IOptionKey)OPT_FLOW_COMPS)) {
                List compSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_FLOW_COMPS), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((List)compSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                compIds = this.getComponentItemIds(flowInfo.entryDTO, compSelectors);
            }
            String string = defaultValue = cli.hasOption((IOptionKey)OPT_DEFAULT) ? cli.getOption((IOptionKey)OPT_DEFAULT, "b") : null;
            boolean bl = defaultValue == null ? false : (defaultIncoming = defaultValue.equalsIgnoreCase("i") || defaultValue.equalsIgnoreCase("b"));
            boolean defaultOutgoing = defaultValue == null ? false : defaultValue.equalsIgnoreCase("o") || defaultValue.equalsIgnoreCase("b");
            String string2 = currentValue = cli.hasOption((IOptionKey)OPT_CURRENT) ? cli.getOption((IOptionKey)OPT_CURRENT, "b") : null;
            boolean bl2 = currentValue == null ? false : (currentIncoming = currentValue.equalsIgnoreCase("i") || currentValue.equalsIgnoreCase("b"));
            boolean currentOutgoing = currentValue == null ? false : currentValue.equalsIgnoreCase("o") || currentValue.equalsIgnoreCase("b");
            this.updateFlowTarget(ws, flowInfo.entryDTO, defaultIncoming, defaultOutgoing, currentIncoming, currentOutgoing, cli.hasOption((IOptionKey)OPT_FLOW_ALL_COMPS), compIds);
        } else {
            JSONObject jFlowTarget = this.getFlowTargetInfo(flowInfo.entryDTO, flowInfo.ws);
            this.printFlowTarget(jFlowTarget);
        }
    }

    private List<String> getComponentItemIds(WorkspaceFlowEntryDTO wsFlow, List<IScmCommandLineArgument> compSelectors) throws FileSystemException {
        ArrayList<String> compIds = new ArrayList<String>();
        ParmsWorkspace parmsFlowWs = new ParmsWorkspace(wsFlow.getRepositoryURL(), wsFlow.getWorkspaceItemId());
        WorkspaceDetailsDTO flowWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(parmsFlowWs), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        ITeamRepository repo = RepoUtil.getTeamRepository((UUID)UUID.valueOf((String)wsFlow.getRepositoryId()));
        for (IScmCommandLineArgument compSelector : compSelectors) {
            IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector.getItemSelector());
            ArrayList<WorkspaceComponentDTO> compsFound = new ArrayList<WorkspaceComponentDTO>();
            for (WorkspaceComponentDTO compDTO : flowWsDetails.getComponents()) {
                if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(compDTO.getItemId())) && !compSelector.getItemSelector().equals(compDTO.getName())) continue;
                compsFound.add(compDTO);
            }
            if (compsFound.isEmpty()) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.FlowTargetCmd_COMP_NOT_FOUND_IN_WS, (Object)compSelector.getItemSelector(), (Object)AliasUtil.selector((String)flowWsDetails.getName(), (UUID)UUID.valueOf((String)flowWsDetails.getItemId()), (String)flowWsDetails.getRepositoryURL(), (RepoUtil.ItemType)(flowWsDetails.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE))));
            }
            if (compsFound.size() > 1) {
                int noOfRepos = 1;
                HashMap<ITeamRepository, ArrayList<WorkspaceComponentDTO>> repoToCompsFound = new HashMap<ITeamRepository, ArrayList<WorkspaceComponentDTO>>(noOfRepos);
                repoToCompsFound.put(repo, compsFound);
                RepoUtil.displayAmbiguousComponents((String)compSelector.getItemSelector(), repoToCompsFound, (IScmClientConfiguration)this.config);
            }
            compIds.add(((WorkspaceComponentDTO)compsFound.get(0)).getItemId());
        }
        return compIds;
    }

    private void updateFlowTarget(ParmsWorkspace ws, WorkspaceFlowEntryDTO wsFlow, boolean setDefaultIncoming, boolean setDefaultOutgoing, boolean setCurrentIncoming, boolean setCurrentOutgoing, boolean allComps, List<String> compIds) throws FileSystemException {
        ParmsWorkspace flowWs = new ParmsWorkspace(wsFlow.getRepositoryURL(), wsFlow.getWorkspaceItemId());
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.workspace = ws;
        if (setDefaultIncoming) {
            parms.defaultIncomingFlowTarget = flowWs;
        }
        if (setDefaultOutgoing) {
            parms.defaultOutgoingFlowTarget = flowWs;
        }
        if (setCurrentIncoming) {
            parms.currentIncomingFlowTarget = flowWs;
        }
        if (setCurrentOutgoing) {
            parms.currentOutgoingFlowTarget = flowWs;
        }
        if (allComps || compIds != null) {
            parms.flowTargets = new ParmsFlowTargetChange[1];
            ParmsFlowTargetChange flowTargetChange = new ParmsFlowTargetChange();
            flowTargetChange.workspace = flowWs;
            if (compIds != null) {
                flowTargetChange.scopedComponentItemIds = compIds.toArray(new String[compIds.size()]);
            }
            if (allComps) {
                flowTargetChange.scopedComponentItemIds = new String[0];
            }
            parms.flowTargets[0] = flowTargetChange;
        }
        try {
            this.client.postPutWorkspace(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowTargetsCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.FlowTargetsCmd_SUCCESS);
    }

    private JSONObject getFlowTargetInfo(WorkspaceFlowEntryDTO wsFlow, IWorkspace flowWs) throws FileSystemException {
        JSONArray jCompArray;
        JSONObject jFlowTarget = new JSONObject();
        jFlowTarget.put((Object)"incoming-flow", (Object)(wsFlow.isIncomingFlow() ? Boolean.TRUE : Boolean.FALSE));
        jFlowTarget.put((Object)"outgoing-flow", (Object)(wsFlow.isOutgoingFlow() ? Boolean.TRUE : Boolean.FALSE));
        jFlowTarget.put((Object)"default-incoming", (Object)(wsFlow.isDefaultIncomingFlow() ? Boolean.TRUE : Boolean.FALSE));
        jFlowTarget.put((Object)"default-outgoing", (Object)(wsFlow.isDefaultOutgoingFlow() ? Boolean.TRUE : Boolean.FALSE));
        jFlowTarget.put((Object)"current-incoming", (Object)(wsFlow.isCurrentIncomingFlow() ? Boolean.TRUE : Boolean.FALSE));
        jFlowTarget.put((Object)"current-outgoing", (Object)(wsFlow.isCurrentOutgoingFlow() ? Boolean.TRUE : Boolean.FALSE));
        jFlowTarget.put((Object)"uuid", (Object)wsFlow.getWorkspaceItemId());
        jFlowTarget.put((Object)"url", (Object)wsFlow.getRepositoryURL());
        jFlowTarget.put((Object)"scoped", (Object)(wsFlow.getScopedComponentItemIds().isEmpty() ? Boolean.FALSE : Boolean.TRUE));
        HashMap<String, String> compIdToName = new HashMap<String, String>();
        if (flowWs != null) {
            jFlowTarget.put((Object)"name", (Object)flowWs.getName());
            jFlowTarget.put((Object)"type", (Object)(flowWs.isStream() ? RepoUtil.ItemType.STREAM.toString() : RepoUtil.ItemType.WORKSPACE.toString()));
            jCompArray = new JSONArray();
            if (!wsFlow.getScopedComponentItemIds().isEmpty()) {
                WorkspaceDetailsDTO flowTargetDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(new ParmsWorkspace(wsFlow.getRepositoryURL(), wsFlow.getWorkspaceItemId())), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
                for (WorkspaceComponentDTO compDTO : flowTargetDetails.getComponents()) {
                    compIdToName.put(compDTO.getItemId(), compDTO.getName());
                }
            }
        } else {
            jFlowTarget.put((Object)"name", (Object)wsFlow.getWorkspaceItemId());
            jFlowTarget.put((Object)"type", (Object)RepoUtil.ItemType.UNKNOWN.toString());
        }
        jCompArray = new JSONArray();
        for (String compId : wsFlow.getScopedComponentItemIds()) {
            JSONObject jComp = new JSONObject();
            jComp.put((Object)"uuid", (Object)compId);
            if (compIdToName.containsKey(compId)) {
                jComp.put((Object)"name", compIdToName.get(compId));
            } else {
                jComp.put((Object)"name", (Object)compId);
            }
            jCompArray.add((Object)jComp);
        }
        jFlowTarget.put((Object)"components", (Object)jCompArray);
        return jFlowTarget;
    }

    private void printFlowTarget(JSONObject jFlowTarget) {
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)jFlowTarget.toString());
            return;
        }
        ListFlowTargetsCmd.printFlowTarget(jFlowTarget, out);
    }

    class FlowInfo {
        public IWorkspace ws;
        public WorkspaceFlowEntryDTO entryDTO;

        FlowInfo() {
        }
    }
}

