/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeleteWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;

public class DeleteWorkspaceCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_PEER_WORKSPACE = new NamedOptionDefinition("b", "backup-workspace", 1);
    protected boolean peerWkspRequired = true;

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        if (this.peerWkspRequired) {
            options.addOption((INamedOptionDefinition)OPT_PEER_WORKSPACE, Messages.DeleteWorkspaceCmdOptions_PEER_WS_HELP);
        }
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, this.getItemName(), 1, 1, "@"), this.getItemHelp());
        return options;
    }

    public String getItemHelp() {
        return Messages.DeleteWorkspaceCmdOptions_WS_HELP;
    }

    public String getItemName() {
        return "workspace";
    }

    public void run() throws FileSystemException {
        DeleteWorkspaceCmd.deleteWorkspace(true, true, this.config, Messages.DeleteWorkspaceCmd_SUCCESS, Messages.DeleteWorkspaceCmd_FAILURE);
    }

    public static void deleteWorkspace(boolean delWorkspace, boolean delStream, IScmClientConfiguration config, String successMessage, String failureMessage) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ScmCommandLineArgument peerWsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PEER_WORKSPACE, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)peerWsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        if (peerWsSelector != null && peerWsSelector.getRepositorySelector() != null && !RepoUtil.isRepoUriSame((String)wsSelector.getRepositorySelector(), (String)peerWsSelector.getRepositorySelector(), (IScmClientConfiguration)config)) {
            throw StatusHelper.argSyntax((String)Messages.DeleteWorkspaceCmd_MUST_HAVE_SAME_REPO);
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)delWorkspace, (boolean)delStream, (ITeamRepository)repo, (IScmClientConfiguration)config);
        if (!ws.isStream() && cli.hasOption((IOptionKey)OPT_PEER_WORKSPACE)) {
            throw StatusHelper.argSyntax((String)Messages.DeleteWorkspaceCmd_PEER_WS_FOR_STREAM);
        }
        ParmsDeleteWorkspace parms = new ParmsDeleteWorkspace();
        parms.workspace = new ParmsWorkspace(repo.getRepositoryURI(), ws.getItemId().getUuidValue());
        if (cli.hasOption((IOptionKey)OPT_PEER_WORKSPACE)) {
            IWorkspace peerWs = RepoUtil.getWorkspace((String)peerWsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            parms.peerWorkspace = new ParmsWorkspace(repo.getRepositoryURI(), peerWs.getItemId().getUuidValue());
        }
        try {
            client.postDeleteWorkspace(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)failureMessage, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.workspace.repositoryUrl);
        }
        config.getWrappedOutputStream().println((CharSequence)successMessage);
    }
}

