/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.workspace.UpdateSubcomponentsCmd;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentHierarchyChange;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import java.util.List;
import java.util.Map;

public class AddSubcomponentsCmd
extends UpdateSubcomponentsCmd {
    public AddSubcomponentsCmd() {
        super(Messages.AddSubcomponentsCmd_PARENT_COMPONENT_HELP_TEXT, Messages.AddSubcomponentsCmd_SUBCOMPONENT_HELP_TEXT, Messages.AddSubcomponentsCmd_SUCCESS, Messages.AddSubcomponentsCmd_UNCHANGED);
    }

    @Override
    protected void setSubcomponentsOnParms(ParmsComponentHierarchyChange parms, String[] subcomponentUuids) {
        parms.subcomponentsToAddUuids = subcomponentUuids;
    }

    @Override
    public void validateUpdatedSubcomponents(ITeamRepository repo, IComponent parentComponent, List<IComponent> specifiedSubComponents, Map<UUID, IComponent> intersection) throws CLIFileSystemClientException {
        if (intersection.size() != specifiedSubComponents.size()) {
            StringBuilder builder = new StringBuilder(Messages.AddSubcomponentsCmd_FAILURE);
            for (IComponent component : intersection.values()) {
                builder.append("  ");
                builder.append(AliasUtil.selector((String)component.getName(), (UUID)component.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
                builder.append("\n");
            }
            throw StatusHelper.failure((String)NLS.bind((String)builder.toString(), (Object)AliasUtil.selector((String)parentComponent.getName(), (UUID)parentComponent.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), (Object[])new Object[0]), null);
        }
    }
}

