/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentSeed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithHistory;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class AddComponentsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_COMPONENTS = new OptionKey("components", "@");
    public static final NamedOptionDefinition OPT_FLOW_FROM_WORKSPACE = new NamedOptionDefinition("s", "source-workspace", 1, "@");
    public static final NamedOptionDefinition OPT_FLOW_FROM_BASELINE = new NamedOptionDefinition("b", "baseline", 1, "@");
    public static final NamedOptionDefinition OPT_ALLOW_MULTIPLE_HIERARCHY = new NamedOptionDefinition("m", "multiple-hierarchy", 0);
    public static final NamedOptionDefinition OPT_SKIP_INACCESSIBLE_COMPONENTS = new NamedOptionDefinition("i", "skip-inaccessible", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)OPT_ALLOW_MULTIPLE_HIERARCHY, Messages.AddComponentsCmdOptions_MULTI_HELP).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((IOptionKey)OPT_FLOW_FROM_WORKSPACE, "s", "source-workspace", Messages.AddComponentCommand_WorkspaceForInitialHistory, 1, false).addOption((IOptionKey)OPT_FLOW_FROM_BASELINE, "b", "baseline", Messages.AddComponentCommand_BaselineForInitialHistory, 1, false)).addOption((INamedOptionDefinition)OPT_SKIP_INACCESSIBLE_COMPONENTS, Messages.AddComponentCommand_INACCESSIBLE_HELP).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.AddComponentCommand_WorkspaceToAddComponents).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_COMPONENTS, "components", 1, -1, "@"), Messages.AddComponentCommand_ComponentsToAdd);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)OPT_FLOW_FROM_WORKSPACE) && cli.hasOption((IOptionKey)OPT_FLOW_FROM_BASELINE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AddComponentCommand_INVALID_USE_OF_OPTIONS, (Object)OPT_FLOW_FROM_WORKSPACE.toString(), (Object)OPT_FLOW_FROM_BASELINE.toString()));
        }
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository targetRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace targetWorkspace = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)targetRepo, (IScmClientConfiguration)this.config);
        List componentSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(OPT_COMPONENTS), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)componentSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        HashMap<ITeamRepository, HashSet<String>> repoToCompSelectors = new HashMap<ITeamRepository, HashSet<String>>();
        for (IScmCommandLineArgument compSelector : componentSelectors) {
            ITeamRepository compRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)compSelector);
            HashSet<String> compSelectors = (HashSet<String>)repoToCompSelectors.get(compRepo);
            if (compSelectors == null) {
                compSelectors = new HashSet<String>();
                repoToCompSelectors.put(compRepo, compSelectors);
            }
            compSelectors.add(compSelector.getItemSelector());
        }
        HashMap<IComponent, ITeamRepository> componentsToRepo = new HashMap<IComponent, ITeamRepository>();
        for (Map.Entry entry : repoToCompSelectors.entrySet()) {
            List comps = RepoUtil.getComponents(new ArrayList((Collection)entry.getValue()), (ITeamRepository)((ITeamRepository)entry.getKey()), (IScmClientConfiguration)this.config);
            for (IComponent comp : comps) {
                componentsToRepo.put(comp, (ITeamRepository)entry.getKey());
            }
        }
        Object var9_11 = null;
        ScmCommandLineArgument itemSelector = null;
        if (cli.hasOption((IOptionKey)OPT_FLOW_FROM_WORKSPACE)) {
            RepoUtil.ItemType itemType = RepoUtil.ItemType.WORKSPACE;
            itemSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_FLOW_FROM_WORKSPACE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)itemSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM, RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE});
            if (itemSelector.getAlias() != null && itemSelector.getAlias().getItemType().equals((Object)RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE)) {
                RepoUtil.ItemType itemType2 = RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE;
            }
        } else if (cli.hasOption((IOptionKey)OPT_FLOW_FROM_BASELINE)) {
            RepoUtil.ItemType itemType = RepoUtil.ItemType.BASELINE;
            itemSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_FLOW_FROM_BASELINE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)itemSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
        }
        ParmsWorkspace targetWorkspaceParms = new ParmsWorkspace(targetRepo.getRepositoryURI(), targetWorkspace.getItemId().getUuidValue());
        WorkspaceDetailsDTO targetWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(targetWorkspaceParms), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        List targetWsComps = targetWsDetails.getComponents();
        HashMap<String, WorkspaceComponentDTO> targetWsCompIds = new HashMap<String, WorkspaceComponentDTO>(targetWsComps.size());
        for (WorkspaceComponentDTO comp : targetWsComps) {
            targetWsCompIds.put(comp.getItemId(), comp);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        boolean printSkipHeader = true;
        HashMap<IComponent, ITeamRepository> filteredComponentsToRepo = new HashMap<IComponent, ITeamRepository>();
        for (Map.Entry entry : componentsToRepo.entrySet()) {
            WorkspaceComponentDTO comp = (WorkspaceComponentDTO)targetWsCompIds.get(((IComponent)entry.getKey()).getItemId().getUuidValue());
            if (comp == null) {
                filteredComponentsToRepo.put((IComponent)entry.getKey(), (ITeamRepository)entry.getValue());
                continue;
            }
            if (printSkipHeader) {
                out.println((CharSequence)Messages.AddComponentCommand_SkippingComponentAlreadyFound);
                printSkipHeader = false;
            }
            out.indent().println((CharSequence)AliasUtil.selector((String)comp.getName(), (UUID)UUID.valueOf((String)comp.getItemId()), (String)targetWorkspaceParms.repositoryUrl, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
        }
        if (!filteredComponentsToRepo.isEmpty()) {
            void var9_15;
            if (itemSelector != null && itemSelector.getAlias() != null && RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE.equals((Object)var9_15)) {
                this.addFromHistoryReference(cli, client, targetRepo, targetWorkspace, filteredComponentsToRepo, itemSelector.getAlias());
            } else {
                this.putWorkspace(this.config, cli, client, targetRepo, targetWorkspace, filteredComponentsToRepo, (RepoUtil.ItemType)var9_15, (IScmCommandLineArgument)itemSelector);
            }
        }
    }

    private WorkspaceUpdateResultDTO addFromHistoryReference(ICommandLine cli, IFilesystemRestClient client, ITeamRepository targetRepo, IWorkspace targetWorkspace, Map<IComponent, ITeamRepository> filteredComponentsToRepo, IAlias alias) throws FileSystemException {
        WorkspaceUpdateResultDTO result;
        ParmsWorkspaceUpdate parmsWorkspaceUpdate = new ParmsWorkspaceUpdate();
        parmsWorkspaceUpdate.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        this.configureDilemmaHandler(cli, parmsWorkspaceUpdate);
        ParmsWorkspace parmsWorkspace = new ParmsWorkspace(targetRepo.getRepositoryURI(), targetWorkspace.getItemId().getUuidValue());
        ParmsHistoryReference parmsHistoryReference = SubcommandUtil.createParmsHistoryReference((String)alias.getId(), (String)alias.getRepositoryUrl());
        if (parmsHistoryReference == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_NOT_A_HISTORY_REF, (Object)alias.getId()));
        }
        ParmsWorkspaceReplaceWithHistory parmsReplaceWithHistory = new ParmsWorkspaceReplaceWithHistory(parmsWorkspace, parmsHistoryReference);
        String[] componentIds = new String[filteredComponentsToRepo.keySet().size()];
        int index = 0;
        for (IComponent component : filteredComponentsToRepo.keySet()) {
            componentIds[index++] = component.getItemId().getUuidValue();
        }
        parmsReplaceWithHistory.componentItemIds = componentIds;
        parmsWorkspaceUpdate.workspaceReplaceWithHistory = new ParmsWorkspaceReplaceWithHistory[]{parmsReplaceWithHistory};
        if (this.config.isDryRun()) {
            return null;
        }
        try {
            result = client.postWorkspaceUpdate(parmsWorkspaceUpdate, null);
        }
        catch (TeamRepositoryException e) {
            PermissionDeniedException pde = (PermissionDeniedException)((Object)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e));
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)((Object)pde), (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            throw StatusHelper.wrap((String)Messages.AddComponentCommand_CannotAddComponents, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        this.printResult(this.config, new ArrayList<IComponent>(filteredComponentsToRepo.keySet()), targetRepo.getRepositoryURI(), result.getComponentsAdded(), result.getSandboxUpdateDilemma().getDeletedContentShareables(), null, null);
        return result;
    }

    private void configureDilemmaHandler(ICommandLine cli, ParmsWorkspaceUpdate parmsWorkspaceUpdate) {
        ParmsWorkspaceUpdateDilemmaHandler parmsWorkspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parmsWorkspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        parmsWorkspaceUpdateDilemmaHandler.componentFlowDirection = "continue";
        parmsWorkspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection = "no";
        parmsWorkspaceUpdateDilemmaHandler.activeChangeSetsDirection = "no";
        parmsWorkspaceUpdateDilemmaHandler.activeChangeSetsOverlapDirection = "no";
        parmsWorkspaceUpdateDilemmaHandler.noBackupBaselineDirection = "cancel";
        parmsWorkspaceUpdateDilemmaHandler.componentInMultipleHierarchiesDirection = cli.hasOption((IOptionKey)OPT_ALLOW_MULTIPLE_HIERARCHY) ? "continue" : "cancel";
        parmsWorkspaceUpdateDilemmaHandler.inaccessibleComponentsNotInSeedDirection = cli.hasOption((IOptionKey)OPT_SKIP_INACCESSIBLE_COMPONENTS) ? "continue" : "cancel";
        parmsWorkspaceUpdate.workspaceUpdateDilemmaHandler = parmsWorkspaceUpdateDilemmaHandler;
        parmsWorkspaceUpdate.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parmsWorkspaceUpdate.outOfSyncInstructions.outOfSyncNoPendingChanges = "load";
        parmsWorkspaceUpdate.outOfSyncInstructions.outOfSyncWithPendingChanges = "load";
        parmsWorkspaceUpdate.outOfSyncInstructions.deleteRemovedShares = true;
        parmsWorkspaceUpdate.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parmsWorkspaceUpdate.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        parmsWorkspaceUpdate.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parmsWorkspaceUpdate.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parmsWorkspaceUpdate.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parmsWorkspaceUpdate.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parmsWorkspaceUpdate.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
    }

    private void putWorkspace(IScmClientConfiguration config, ICommandLine cli, IFilesystemRestClient client, ITeamRepository repo, IWorkspace workspace, Map<IComponent, ITeamRepository> compToRepo, RepoUtil.ItemType type, IScmCommandLineArgument itemSelector) throws FileSystemException {
        PutWorkspaceResultDTO result;
        UUID wsUuid = null;
        String sourceWsName = null;
        HashSet<UUID> componentUuid = new HashSet<UUID>();
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.configurationChanges = new ParmsConfigurationChanges();
        parms.configurationChanges.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.configurationChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.configurationChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        parms.configurationChanges.hierarchicalOperation = true;
        ParmsWorkspaceUpdateDilemmaHandler parmsWorkspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parmsWorkspaceUpdateDilemmaHandler.componentFlowDirection = "continue";
        parmsWorkspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        parmsWorkspaceUpdateDilemmaHandler.noBackupBaselineDirection = "continue";
        parmsWorkspaceUpdateDilemmaHandler.multipleParticipantsDirection = "continue";
        parmsWorkspaceUpdateDilemmaHandler.inaccessibleComponentsNotInSeedDirection = cli.hasOption((IOptionKey)OPT_SKIP_INACCESSIBLE_COMPONENTS) ? "continue" : "cancel";
        parms.configurationChanges.workspaceUpdateDilemmaHandler = parmsWorkspaceUpdateDilemmaHandler;
        parmsWorkspaceUpdateDilemmaHandler.componentInMultipleHierarchiesDirection = cli.hasOption((IOptionKey)OPT_ALLOW_MULTIPLE_HIERARCHY) ? "continue" : "cancel";
        parms.workspace = new ParmsWorkspace();
        parms.workspace.repositoryUrl = repo.getRepositoryURI();
        parms.workspace.workspaceItemId = workspace.getItemId().getUuidValue();
        if (type == RepoUtil.ItemType.WORKSPACE) {
            ITeamRepository repo2 = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)itemSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)itemSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo2, (IScmClientConfiguration)config);
            wsUuid = ws.getItemId();
            ParmsWorkspace sourceWs = new ParmsWorkspace(repo2.getRepositoryURI(), ws.getItemId().getUuidValue());
            WorkspaceDetailsDTO sourceWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(sourceWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
            List sourceWsComps = sourceWsDetails.getComponents();
            sourceWsName = sourceWsDetails.getName();
            for (WorkspaceComponentDTO component : sourceWsComps) {
                componentUuid.add(UUID.valueOf((String)component.getItemId()));
            }
        }
        HashMap<IComponent, String> compNotInSourceWsToRepoUrl = null;
        ArrayList<IComponent> comps = new ArrayList<IComponent>(compToRepo.keySet());
        LinkedList<ParmsComponentChange> changeList = new LinkedList<ParmsComponentChange>();
        int i = 0;
        while (i < comps.size()) {
            block14: {
                ParmsComponentChange change;
                block15: {
                    IComponent comp;
                    block11: {
                        block12: {
                            block13: {
                                change = new ParmsComponentChange();
                                change.cmd = "addComponent";
                                comp = (IComponent)comps.get(i);
                                change.componentItemId = comp.getItemId().getUuidValue();
                                if (type == null) break block11;
                                change.seed = new ParmsComponentSeed();
                                change.seed.repositoryUrl = compToRepo.get(comp).getRepositoryURI();
                                if (type != RepoUtil.ItemType.WORKSPACE) break block12;
                                if (componentUuid.contains(comp.getItemId())) break block13;
                                if (compNotInSourceWsToRepoUrl == null) {
                                    compNotInSourceWsToRepoUrl = new HashMap<IComponent, String>();
                                }
                                compNotInSourceWsToRepoUrl.put(comp, compToRepo.get(comp).getRepositoryURI());
                                break block14;
                            }
                            change.seed.itemTypeId = "workspace";
                            if (wsUuid != null) {
                                change.seed.itemId = wsUuid.getUuidValue();
                            }
                            break block15;
                        }
                        change.seed.itemTypeId = "baseline";
                        ITeamRepository blRepo = compToRepo.get(comp);
                        IBaseline baseline = RepoUtil.getBaseline((String)itemSelector.getItemSelector(), (String)comp.getItemId().getUuidValue(), (String)comp.getName(), (ITeamRepository)blRepo, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                        change.seed.itemId = baseline.getItemId().getUuidValue();
                        break block15;
                    }
                    if (!compToRepo.get(comp).getId().equals((Object)repo.getId())) {
                        change.seed = new ParmsComponentSeed();
                        change.seed.repositoryUrl = compToRepo.get(comp).getRepositoryURI();
                        change.seed.itemTypeId = "baseline";
                        change.seed.itemId = comp.getInitialBaseline().getItemId().getUuidValue();
                    }
                }
                changeList.add(change);
            }
            ++i;
        }
        parms.configurationChanges.components = changeList.toArray(new ParmsComponentChange[changeList.size()]);
        try {
            result = client.postPutWorkspace(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.AddComponentCommand_CannotAddComponents, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        if (result.isCancelled()) {
            if (result.getSelectedComponentsWithMultipleParticipants().size() > 0 || result.getSubcomponentsWithMultipleParticipants().size() > 0) {
                throw StatusHelper.componentsInMultipleHierarchies((String)NLS.bind((String)Messages.AddComponentsCmd_MULTI_HIERARCHY, (Object)OPT_ALLOW_MULTIPLE_HIERARCHY.getName()));
            }
            if (result.getInaccessibleComponentsNotInSeed().size() > 0) {
                throw StatusHelper.inaccessibleComponentsNotInSeed((String)NLS.bind((String)Messages.AddComponentsCmd_INACCESSIBLE_COMPONENTS_NOT_IN_SEED, (Object)OPT_ALLOW_MULTIPLE_HIERARCHY.getName()));
            }
        }
        this.printResult(config, comps, result.getWorkspace().getRepositoryURL(), result.getComponentsAdded(), result.getSandboxUpdateDilemma().getDeletedContentShareables(), compNotInSourceWsToRepoUrl, sourceWsName);
    }

    private void printResult(IScmClientConfiguration config, List<IComponent> values, String repositoryURI, List<ConfigurationDescriptorDTO> componentsAddedDTO, List<ShareableDTO> deletedContentShareables, Map<IComponent, String> compNotInSourceWsToRepoUrl, String sourceWsName) throws FileSystemException {
        IndentingPrintStream out = config.getWrappedOutputStream();
        if (!componentsAddedDTO.isEmpty()) {
            final HashMap<UUID, String> uuidToName = new HashMap<UUID, String>();
            for (IComponent component : values) {
                uuidToName.put(component.getItemId(), component.getName());
            }
            ArrayList<ConfigurationDescriptorDTO> componentsAdded = new ArrayList<ConfigurationDescriptorDTO>(componentsAddedDTO);
            out.println((CharSequence)Messages.AddComponentCommand_ComponentSuccessfullyAdded);
            this.getNamesForNewlyAddedComponents(config, repositoryURI, componentsAdded, uuidToName);
            Collections.sort(componentsAdded, new Comparator<ConfigurationDescriptorDTO>(){

                @Override
                public int compare(ConfigurationDescriptorDTO object1, ConfigurationDescriptorDTO object2) {
                    UUID uuid1 = UUID.valueOf((String)object1.getComponentItemId());
                    UUID uuid2 = UUID.valueOf((String)object2.getComponentItemId());
                    String name1 = (String)uuidToName.get(uuid1);
                    String name2 = (String)uuidToName.get(uuid2);
                    return name1.compareTo(name2);
                }
            });
            IndentingPrintStream componentsOutput = out.indent();
            for (ConfigurationDescriptorDTO componentDTO : componentsAdded) {
                UUID componentItemId = UUID.valueOf((String)componentDTO.getComponentItemId());
                componentsOutput.println((CharSequence)AliasUtil.selector((String)((String)uuidToName.get(componentItemId)), (UUID)componentItemId, (String)componentDTO.getConnection().getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
            }
            if (!deletedContentShareables.isEmpty()) {
                SubcommandUtil.showDeletedContent(deletedContentShareables, (IndentingPrintStream)out);
            }
        }
        if (compNotInSourceWsToRepoUrl != null) {
            out.println((CharSequence)NLS.bind((String)Messages.AddComponentCommand_ComponentNotFoundInSourceWorkspace, (Object)sourceWsName));
            for (Map.Entry<IComponent, String> entry : compNotInSourceWsToRepoUrl.entrySet()) {
                IComponent component = entry.getKey();
                String repoUrl = entry.getValue();
                out.indent().println((CharSequence)AliasUtil.selector((String)component.getName(), (UUID)component.getItemId(), (String)repoUrl, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
            }
        }
        if (componentsAddedDTO.isEmpty()) {
            throw StatusHelper.failure((String)Messages.AddComponentCommand_CannotAddComponents, null);
        }
        if (componentsAddedDTO.size() < values.size()) {
            throw StatusHelper.partialStatus();
        }
    }

    private void getNamesForNewlyAddedComponents(IScmClientConfiguration config, String repositoryURL, List<ConfigurationDescriptorDTO> componentsAdded, Map<UUID, String> uuidToName) throws FileSystemException {
        ArrayList<String> componentUuids = new ArrayList<String>();
        for (ConfigurationDescriptorDTO componentDTO : componentsAdded) {
            componentUuids.add(componentDTO.getComponentItemId());
        }
        List components = RepoUtil.getComponents(componentUuids, (ITeamRepository)RepoUtil.getSharedRepository((String)repositoryURL, (boolean)false), (IScmClientConfiguration)config);
        for (IComponent component : components) {
            uuidToName.put(component.getItemId(), component.getName());
        }
    }
}

