/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.users;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorRecord;
import com.ibm.team.repository.common.IContributorRecordHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.scm.client.internal.ScmContributorUtil;
import org.eclipse.osgi.util.NLS;

public class SetUserCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_USER_ALIAS = new OptionKey("selector");
    public static final IOptionKey OPT_USER_ID = new OptionKey("userId");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_USER_ALIAS, "selector", 1, 1, "@"), Messages.SetUserCmd_USER_ALIAS).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_USER_ID, "userId", 1, 1), Messages.SetUserCmd_USER_ID);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument cmdLineArg = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_USER_ALIAS), (IScmClientConfiguration)this.config);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)cmdLineArg);
        String selector = cmdLineArg.getItemSelector();
        IUuidAliasRegistry.IUuidAlias uuidAlias = RepoUtil.lookupUuidAndAlias((String)selector);
        if (uuidAlias == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.SetUserCmd_USER_NOT_FOUND, (Object)selector));
        }
        IContributorRecordHandle crh = (IContributorRecordHandle)IContributorRecord.ITEM_TYPE.createItemHandle(uuidAlias.getUuid(), null);
        IContributorRecord cr = null;
        try {
            cr = (IContributorRecord)repo.itemManager().fetchCompleteItem((IItemHandle)crh, 1, null);
        }
        catch (ItemNotFoundException infe) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.SetUserCmd_USER_NOT_FOUND, (Object)selector));
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.SetUserCmd_TRE, (Object)selector));
        }
        if (!cr.getUserIds().isEmpty()) {
            throw StatusHelper.failure((String)Messages.SetUserCmd_USER_ID_ALREADY_SET, null);
        }
        String userId = cli.getOption(OPT_USER_ID);
        try {
            ScmContributorUtil.setUserId((ITeamRepository)repo, (IContributorRecord)cr, (String)userId, null);
        }
        catch (StaleDataException e) {
            throw StatusHelper.staleData((String)Messages.SetUserCmd_USER_ID_EXISTS);
        }
        catch (PermissionDeniedException e) {
            throw StatusHelper.permissionFailure((String)Messages.SetUserCmd_PERMISSION_DENIED);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.failure((String)Messages.SetUserCmd_COULD_NOT_SET_THE_USER_ID, (Throwable)e);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.SetUserCmd_SUCCESSFUL);
    }
}

