/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.users;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorRecord;
import com.ibm.team.repository.common.IContributorUserId;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.client.internal.ScmContributorUtil;
import java.util.List;
import java.util.StringJoiner;
import org.eclipse.osgi.util.NLS;

public class ListUsersCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final String SINGLE_SPACE = " ";
    private static final String STRING_COMMA = ",";
    public static final NamedOptionDefinition OPT_NOUSERIDS = new NamedOptionDefinition("n", "noUserIds", 0);
    public static final NamedOptionDefinition OPT_BOTH_USERS = new NamedOptionDefinition("b", "both", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_NOUSERIDS, Messages.ListUsersCmd_NO_USER_IDS, false).addOption((INamedOptionDefinition)OPT_BOTH_USERS, Messages.ListUsersCmd_BOTH_USERS, false)).addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, NLS.bind((String)CommonOptions.OPT_MAXRESULTS_HELP, (Object)1024));
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)OPT_NOUSERIDS) && cli.hasOption((IOptionKey)OPT_BOTH_USERS)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListUsersCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object[])new String[]{OPT_NOUSERIDS.getName(), OPT_BOTH_USERS.getName()}));
        }
        int userIdFilter = 1;
        if (cli.hasOption((IOptionKey)OPT_BOTH_USERS)) {
            userIdFilter = 0;
        } else if (cli.hasOption((IOptionKey)OPT_NOUSERIDS)) {
            userIdFilter = 2;
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
        int maxResultsSize = RepoUtil.getMaxResultsOption((ICommandLine)cli, (int)1024);
        List list = null;
        try {
            list = ScmContributorUtil.fetchContributors((ITeamRepository)repo, (int)userIdFilter, (int)maxResultsSize, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.failure((String)Messages.ListUsersCmd_UNABLE_TO_LIST_USERS, null);
        }
        if (list != null) {
            IndentingPrintStream printStream = this.config.getWrappedOutputStream();
            JSONArray recs = this.jsonizeRecords(list, repo);
            if (this.config.isJSONEnabled()) {
                this.config.getOutputStream().print((CharSequence)recs.toString());
                return;
            }
            if (recs.size() == 0) {
                return;
            }
            for (Object obj : recs) {
                Object userId2;
                JSONObject cr = (JSONObject)obj;
                StringJoiner userIdsJoiner = new StringJoiner(STRING_COMMA);
                for (Object userId2 : (JSONArray)cr.get((Object)"userId")) {
                    userIdsJoiner.add((String)userId2);
                }
                userId2 = !userIdsJoiner.toString().isEmpty() ? userIdsJoiner.toString() : Messages.ListUsersCmd_NO_USER_ID;
                printStream.println((CharSequence)(String.valueOf(AliasUtil.selector((String)((String)cr.get((Object)"name")), (UUID)UUID.valueOf((String)((String)cr.get((Object)"uuid"))), (String)((String)cr.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.CONTRIBUTOR)) + SINGLE_SPACE + (String)cr.get((Object)"mail") + SINGLE_SPACE + userId2));
            }
        }
    }

    JSONArray jsonizeRecords(List list, ITeamRepository repo) {
        JSONArray recs = new JSONArray();
        for (Object obj : list) {
            IContributorRecord cr = (IContributorRecord)obj;
            JSONObject rec = JSONPrintUtil.jsonize((String)cr.getName(), (String)cr.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
            JSONArray userIds = new JSONArray(cr.getUserIds().size());
            for (IContributorUserId userId : cr.getUserIds()) {
                userIds.add((Object)userId.getUserId());
            }
            rec.put((Object)"userId", (Object)userIds);
            rec.put((Object)"mail", (Object)cr.getEmailAddress());
            recs.add((Object)rec);
        }
        return recs;
    }
}

