/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.AbstractItemPrinter;
import com.ibm.team.filesystem.cli.client.internal.trs.ExportValidationCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.trs.common.internal.rest.dto.ValidationResultDTO;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ValidationResultPrinter
extends AbstractItemPrinter {
    public ValidationResultPrinter(IScmClientConfiguration config, ITeamRepository repo, boolean verbose) {
        super(config, repo);
    }

    @Override
    public void printResult(List<Object> result, boolean hasMoreItems) throws FileSystemException {
        JSONArray resultsJson = new JSONArray();
        for (Object o : result) {
            JSONObject resultJson = ExportValidationCmd.asJson((ValidationResultDTO)o);
            resultsJson.add((Object)resultJson);
        }
        if (this.config.isJSONEnabled()) {
            JSONObject json = new JSONObject();
            json.put((Object)"results", (Object)resultsJson);
            this.config.getOutputStream().print((CharSequence)json.toString());
            return;
        }
        IndentingPrintStream printStream = this.config.getWrappedOutputStream();
        for (Object object : resultsJson) {
            this.printValidationResult((JSONObject)object, printStream);
        }
        if (hasMoreItems) {
            printStream.println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private void printValidationResult(JSONObject object, IndentingPrintStream printStream) {
        String itemId = (String)object.get((Object)"uuid");
        String feedId = (String)object.get((Object)"feed-id");
        if (object.get((Object)"feed-label") != null) {
            feedId = (String)object.get((Object)"feed-label");
        }
        String status = (String)object.get((Object)"status");
        String description = (String)object.get((Object)"description");
        String alias = AliasUtil.alias((UUID)UUID.valueOf((String)itemId), (String)this.repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.UNKNOWN);
        description = description == null ? Messages.ValidationResultPrinter_NO_DESCRIPTION : SubcommandUtil.sanitizeText((String)description);
        String date = (String)object.get((Object)"creationDate");
        printStream.println((CharSequence)NLS.bind((String)Messages.ValidationResultPrinter_VALIDATION_RESULT, (Object[])new Object[]{alias, feedId, status, description, date}));
    }
}

