/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.AbstractItemPrinter;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmBaseline;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmSnapshot;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspace;
import com.ibm.team.scm.trs.common.internal.rest.dto.PublishedItemDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class PublishedItemPrinter
extends AbstractItemPrinter {
    private static final String BASELINES = "baselines";
    private static final String SNAPSHOTS = "snapshots";
    private static final String WORKSPACES = "workspaces";
    private boolean verbose;

    public PublishedItemPrinter(IScmClientConfiguration config, ITeamRepository repo, boolean verbose) {
        super(config, repo);
        this.verbose = verbose;
    }

    @Override
    public void printResult(List<Object> items, boolean hasMoreItems) throws FileSystemException {
        IndentingPrintStream out;
        String statusDescription;
        String itemId;
        JSONObject jsonObj;
        HashMap<String, String> idToStatusMap = new HashMap<String, String>();
        ArrayList<ScmWorkspace> workspaces = new ArrayList<ScmWorkspace>();
        ArrayList<ScmSnapshot> snapshots = new ArrayList<ScmSnapshot>();
        ArrayList<ScmBaseline> baselines = new ArrayList<ScmBaseline>();
        for (Object item : items) {
            if (!(item instanceof PublishedItemDTO)) continue;
            PublishedItemDTO publishedItem = (PublishedItemDTO)item;
            if (publishedItem.getItem() instanceof ScmWorkspace) {
                ScmWorkspace scmWorkspace = (ScmWorkspace)publishedItem.getItem();
                idToStatusMap.put(scmWorkspace.getItemId(), publishedItem.getStatusDescription());
                workspaces.add(scmWorkspace);
                continue;
            }
            if (publishedItem.getItem() instanceof ScmSnapshot) {
                ScmSnapshot scmSnapshot = (ScmSnapshot)publishedItem.getItem();
                idToStatusMap.put(scmSnapshot.getItemId(), publishedItem.getStatusDescription());
                snapshots.add(scmSnapshot);
                continue;
            }
            if (!(publishedItem.getItem() instanceof ScmBaseline)) continue;
            ScmBaseline scmBaseline = (ScmBaseline)publishedItem.getItem();
            idToStatusMap.put(scmBaseline.getItemId(), publishedItem.getStatusDescription());
            baselines.add(scmBaseline);
        }
        JSONArray jsonizedWorkspaces = this.jsonizeWorkspaces(workspaces, this.verbose);
        JSONArray jsonizedSnapshots = this.jsonizeSnapshots(snapshots);
        JSONArray jsonizedBaselines = this.jsonizeBaselines(baselines);
        for (Object o : jsonizedWorkspaces) {
            if (!(o instanceof JSONObject)) continue;
            jsonObj = (JSONObject)o;
            itemId = (String)jsonObj.get((Object)"uuid");
            statusDescription = (String)idToStatusMap.get(itemId);
            jsonObj.put((Object)"publishStatus", (Object)statusDescription);
        }
        for (Object o : jsonizedSnapshots) {
            if (!(o instanceof JSONObject)) continue;
            jsonObj = (JSONObject)o;
            itemId = (String)jsonObj.get((Object)"uuid");
            statusDescription = (String)idToStatusMap.get(itemId);
            jsonObj.put((Object)"publishStatus", (Object)statusDescription);
        }
        for (Object o : jsonizedBaselines) {
            if (!(o instanceof JSONObject)) continue;
            jsonObj = (JSONObject)o;
            itemId = (String)jsonObj.get((Object)"uuid");
            statusDescription = (String)idToStatusMap.get(itemId);
            jsonObj.put((Object)"publishStatus", (Object)statusDescription);
        }
        if (this.config.isJSONEnabled()) {
            JSONObject itemsByType = new JSONObject();
            if (!workspaces.isEmpty()) {
                itemsByType.put((Object)WORKSPACES, (Object)jsonizedWorkspaces);
            }
            if (!snapshots.isEmpty()) {
                itemsByType.put((Object)SNAPSHOTS, (Object)jsonizedSnapshots);
            }
            if (!baselines.isEmpty()) {
                itemsByType.put((Object)BASELINES, (Object)jsonizedBaselines);
            }
            this.config.getOutputStream().print((CharSequence)itemsByType.toString());
            return;
        }
        IndentingPrintStream printStream = this.config.getWrappedOutputStream();
        if (baselines.isEmpty() && snapshots.isEmpty() && workspaces.isEmpty()) {
            printStream.println((CharSequence)Messages.PublishedItemPrinter_NoPublishedItems);
            return;
        }
        if (!workspaces.isEmpty()) {
            printStream.println((CharSequence)Messages.PublishedItemPrinter_PublishedStreamsHeader);
            out = printStream.indent();
            this.printWorkspaces(jsonizedWorkspaces, out, this.verbose);
            printStream.println();
        }
        if (!snapshots.isEmpty()) {
            printStream.println((CharSequence)Messages.PublishedItemPrinter_PublishedSnapshotsHeader);
            out = printStream.indent();
            for (Object object : jsonizedSnapshots) {
                this.printSnapshot(out, (JSONObject)object);
            }
            printStream.println();
        }
        if (!baselines.isEmpty()) {
            printStream.println((CharSequence)Messages.PublishedItemPrinter_PublishedBaselinesHeader);
            out = printStream.indent();
            for (Object object : jsonizedBaselines) {
                this.printBaseline(out, (JSONObject)object);
            }
            printStream.println();
        }
    }

    private void printBaseline(IndentingPrintStream printStream, JSONObject baseline) {
        String publishStatus = (String)baseline.get((Object)"publishStatus");
        String blSelector = baseline.get((Object)"id") != null ? AliasUtil.selector((int)((Integer)baseline.get((Object)"id")), (String)((String)baseline.get((Object)"name")), (UUID)UUID.valueOf((String)((String)baseline.get((Object)"uuid"))), (String)((String)baseline.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE) : AliasUtil.selectorWithNoIdAndName();
        String comment = (String)baseline.get((Object)"comment");
        if (comment == null || comment.isEmpty() || comment.equals(JSONPrintUtil.getBaselineCommentForJson((String)""))) {
            comment = Messages.ListBaselineCmd_NO_COMMENT;
        }
        String creationBy = NLS.bind((String)Messages.ListBaselineCmd_CREATED_BY, (Object)baseline.get((Object)"contributor"), (Object)baseline.get((Object)"creationDate"));
        String addedBy = null;
        String deliveredBy = (String)baseline.get((Object)"added-by");
        if (deliveredBy != null) {
            String deliveryDate = (String)baseline.get((Object)"date-added");
            addedBy = NLS.bind((String)Messages.ListBaselineCmd_ADDED_BY, (Object)deliveredBy, (Object)deliveryDate);
        }
        if (publishStatus == null) {
            if (deliveredBy == null) {
                printStream.println((CharSequence)NLS.bind((String)Messages.PublishedItemPrinter_Three_Args, (Object[])new String[]{blSelector, comment, creationBy}));
            } else {
                printStream.println((CharSequence)NLS.bind((String)Messages.PublishedItemPrinter_Four_Args, (Object[])new String[]{blSelector, comment, creationBy, addedBy}));
            }
        } else if (deliveredBy == null) {
            printStream.println((CharSequence)NLS.bind((String)Messages.PublishedItemPrinter_Four_Args, (Object[])new String[]{blSelector, comment, publishStatus, creationBy}));
        } else {
            printStream.println((CharSequence)NLS.bind((String)Messages.PublishedItemPrinter_Five_Args, (Object[])new String[]{blSelector, comment, publishStatus, creationBy, addedBy}));
        }
    }
}

