/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.trs.AbstractTrsCmd;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.InsufficientRightsException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.trs.common.IScmTrsRestService;
import org.eclipse.osgi.util.NLS;

public class PublishCmd
extends AbstractTrsCmd {
    @Override
    protected String getBaselinesHelpMessage() {
        return Messages.PublishCmd_ListOfBaselines;
    }

    @Override
    protected String getSnapshotsHelpMessage() {
        return Messages.PublishCmd_ListOfSnapshots;
    }

    @Override
    protected String getWorkspacesHelpMessage() {
        return Messages.PublishCmd_ListOfStreams;
    }

    @Override
    protected String getGcHelpMessage() {
        return Messages.PublishCmd_gcHelpMessage;
    }

    @Override
    protected void printSuccessMessage() {
        this.config.getWrappedOutputStream().println((CharSequence)Messages.PublishCmd_PublishSuccessful);
    }

    @Override
    protected void printGCSuccessMessage() {
        this.config.getWrappedOutputStream().println((CharSequence)Messages.PublishCmd_PublishGCSuccessful);
    }

    @Override
    protected void performServiceCall(ITeamRepository publishInRepo, IScmTrsRestService.ParmsArtifacts parms) throws CLIFileSystemClientException, FileSystemException {
        try {
            IScmTrsRestService scmTrsService = (IScmTrsRestService)((IClientLibraryContext)publishInRepo).getServiceInterface(IScmTrsRestService.class);
            String[] publishedIds = scmTrsService.postPublishArtifacts(parms);
            int previouslyPublished = parms.itemIds.length - publishedIds.length;
            if (previouslyPublished == 1) {
                this.config.getWrappedOutputStream().println((CharSequence)Messages.PublishCmd_PreviouslyPublishedIgnored);
            } else if (previouslyPublished > 1) {
                this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.PublishCmd_PreviouslyPublishedIgnoredPlural, (Object)previouslyPublished));
            }
        }
        catch (InsufficientRightsException e) {
            throw StatusHelper.permissionFailure((String)e.getMessage());
        }
        catch (TeamRepositoryException e) {
            if (e.getCause() instanceof PermissionDeniedException) {
                throw StatusHelper.permissionFailure((String)e.getCause().getMessage());
            }
            throw StatusHelper.wrap((String)Messages.PublishCmd_PublishFailed, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }

    @Override
    protected String getPermissionErrorFooter() {
        return Messages.PublishCmd_PermissionErrorFooter;
    }
}

