/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.trs.ValidationResultPrinter;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.trs.common.ITrsRestService;
import com.ibm.team.rtc.trs.common.internal.rest.dto.ValidationResultsDTO;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class ListValidationResultsCmd
extends AbstractSubcommand
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, NLS.bind((String)CommonOptions.OPT_MAXRESULTS_HELP, (Object)10)).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
        int pageSize = Math.min(512, maxResults);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (!cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            throw StatusHelper.argSyntax((String)Messages.ListValidationResultsCmd_RepositoryUrlMissing);
        }
        String repoUri = cli.getOption((IOptionKey)CommonOptions.OPT_URI);
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUri));
        ArrayList<Object> allResults = new ArrayList<Object>();
        ValidationResultsDTO results = this.fetchResults(repo, null, pageSize);
        allResults.addAll(results.getResults());
        while (allResults.size() < maxResults && results.getNextPage() != null) {
            pageSize = Math.min(512, maxResults - allResults.size());
            results = this.fetchResults(repo, results.getNextPage(), pageSize);
            allResults.addAll(results.getResults());
        }
        boolean hasMore = results.getNextPage() != null;
        ValidationResultPrinter printer = new ValidationResultPrinter(this.config, repo, cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE));
        printer.printResult(allResults, hasMore);
    }

    protected ValidationResultsDTO fetchResults(ITeamRepository repository, String nextPage, int pageSize) throws CLIFileSystemClientException, FileSystemException {
        try {
            ITrsRestService trsService = (ITrsRestService)((IClientLibraryContext)repository).getServiceInterface(ITrsRestService.class);
            ITrsRestService.ParmsGetValidationResults parms = new ITrsRestService.ParmsGetValidationResults();
            parms.pageDescriptor = nextPage;
            parms.pageSize = pageSize;
            return trsService.getValidationResults(parms);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListValidationResultsCmd_FetchFailed, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }
}

