/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.trs.AbstractTrsCmd;
import com.ibm.team.filesystem.cli.client.internal.trs.PublishedItemPrinter;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.trs.common.IScmTrsRestService;
import com.ibm.team.scm.trs.common.internal.rest.dto.PublishedItemDTO;
import com.ibm.team.scm.trs.common.internal.rest.dto.PublishedItemListDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class ListPublishedCmd
extends AbstractSubcommand
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP).addOption((INamedOptionDefinition)AbstractTrsCmd.OPT_STREAMS, Messages.ListPublishedCmd_IncludeStreams, false).addOption((INamedOptionDefinition)AbstractTrsCmd.OPT_SNAPSHOTS, Messages.ListPublishedCmd_IncludeSnapshots, false).addOption((INamedOptionDefinition)AbstractTrsCmd.OPT_BASELINES, Messages.ListPublishedCmd_IncludeBaselines, false).addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, NLS.bind((String)CommonOptions.OPT_MAXRESULTS_HELP, (Object)10), false);
        return options;
    }

    public void run() throws FileSystemException {
        ConnectionInfo connection = this.config.getConnectionInfo();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ITeamRepository repository = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)connection);
        IScmTrsRestService scmTrsRestService = (IScmTrsRestService)((IClientLibraryContext)repository).getServiceInterface(IScmTrsRestService.class);
        boolean hasMoreStreams = false;
        boolean hasMoreSnapshots = false;
        boolean hasMoreBaselines = false;
        try {
            ArtifactsResult result;
            boolean requestAll;
            int maxResultsPerType = cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) ? 0 : RepoUtil.getMaxResultsOption((ICommandLine)cli, (int)10);
            ArrayList<Object> results = new ArrayList<Object>();
            boolean bl = requestAll = !cli.hasOption((IOptionKey)AbstractTrsCmd.OPT_STREAMS) && !cli.hasOption((IOptionKey)AbstractTrsCmd.OPT_SNAPSHOTS) && !cli.hasOption((IOptionKey)AbstractTrsCmd.OPT_BASELINES);
            if (requestAll || cli.hasOption((IOptionKey)AbstractTrsCmd.OPT_STREAMS)) {
                result = this.getPublishedWorkspaces(scmTrsRestService, maxResultsPerType);
                hasMoreStreams = result.hasMore;
                results.addAll(result.artifacts);
            }
            if (requestAll || cli.hasOption((IOptionKey)AbstractTrsCmd.OPT_SNAPSHOTS)) {
                result = this.getPublishedSnapshots(scmTrsRestService, maxResultsPerType);
                hasMoreSnapshots = result.hasMore;
                results.addAll(result.artifacts);
            }
            if (requestAll || cli.hasOption((IOptionKey)AbstractTrsCmd.OPT_BASELINES)) {
                result = this.getPublishedBaselines(scmTrsRestService, maxResultsPerType);
                hasMoreBaselines = result.hasMore;
                results.addAll(result.artifacts);
            }
            PublishedItemPrinter printer = new PublishedItemPrinter(this.config, repository, cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE));
            printer.printResult(results, false);
            if (hasMoreStreams) {
                this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ListPublishedCmd_HasMoreStreams, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
            }
            if (hasMoreSnapshots) {
                this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ListPublishedCmd_HasMoreSnapshots, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
            }
            if (hasMoreBaselines) {
                this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ListPublishedCmd_HasMoreBaselines, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListPublishedCmd_FailedToRetrieve, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }

    private ArtifactsResult getPublishedWorkspaces(IScmTrsRestService scmTrsRestService, int maxResultsPerType) throws TeamRepositoryException {
        String itemType = String.valueOf(IWorkspace.ITEM_TYPE.getNamespaceURI()) + "." + IWorkspace.ITEM_TYPE.getName();
        return this.getPublishedArtifacts(scmTrsRestService, itemType, maxResultsPerType);
    }

    private ArtifactsResult getPublishedSnapshots(IScmTrsRestService scmTrsRestService, int maxResultsPerType) throws TeamRepositoryException {
        String itemType = String.valueOf(IBaselineSet.ITEM_TYPE.getNamespaceURI()) + "." + IBaselineSet.ITEM_TYPE.getName();
        return this.getPublishedArtifacts(scmTrsRestService, itemType, maxResultsPerType);
    }

    private ArtifactsResult getPublishedBaselines(IScmTrsRestService scmTrsRestService, int maxResultsPerType) throws TeamRepositoryException {
        String itemType = String.valueOf(IBaseline.ITEM_TYPE.getNamespaceURI()) + "." + IBaseline.ITEM_TYPE.getName();
        return this.getPublishedArtifacts(scmTrsRestService, itemType, maxResultsPerType);
    }

    private ArtifactsResult getPublishedArtifacts(IScmTrsRestService scmTrsRestService, String itemType, int maxResultsPerType) throws TeamRepositoryException {
        HashSet<PublishedItemDTO> allItems = new HashSet<PublishedItemDTO>();
        IScmTrsRestService.ParmsPublishedItems parms = new IScmTrsRestService.ParmsPublishedItems();
        parms.itemType = itemType;
        parms.maxResultSize = maxResultsPerType;
        PublishedItemListDTO queryResult = null;
        block0: while (queryResult == null || queryResult.getNextPageDescriptor() != null && allItems.size() < maxResultsPerType) {
            if (queryResult != null) {
                parms.pageDescriptor = queryResult.getNextPageDescriptor();
            }
            queryResult = scmTrsRestService.postQueryPublishedItems(parms);
            for (Object o : queryResult.getPublishedItems()) {
                if (allItems.size() >= maxResultsPerType) continue block0;
                if (!(o instanceof PublishedItemDTO)) continue;
                PublishedItemDTO item = (PublishedItemDTO)o;
                allItems.add(item);
            }
        }
        return new ArtifactsResult(allItems, queryResult.getNextPageDescriptor() != null);
    }

    private class ArtifactsResult {
        private Collection<PublishedItemDTO> artifacts;
        private boolean hasMore = false;

        public ArtifactsResult(Set<PublishedItemDTO> items, boolean hasMore) {
            this.artifacts = items;
            this.hasMore = hasMore;
        }
    }
}

