/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.util.ChangeSetUtil;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.InsufficientRightsException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.trs.common.ITrsRestService;
import com.ibm.team.rtc.trs.common.internal.rest.dto.AttributeRepairDataDTO;
import com.ibm.team.rtc.trs.common.internal.rest.dto.ETagRepairDataDTO;
import com.ibm.team.rtc.trs.common.internal.rest.dto.ValidationDataDTO;
import com.ibm.team.rtc.trs.common.internal.rest.dto.ValidationEntryDTO;
import com.ibm.team.rtc.trs.common.internal.rest.dto.ValidationResultDTO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExportValidationCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final IOptionKey OPT_RESULT_SELECTOR = new OptionKey("result", "@");
    public static final PositionalOptionDefinition OPT_LOGFILE = new PositionalOptionDefinition("output", 0, 1);
    private static final NamedOptionDefinition OPT_FORCE = new NamedOptionDefinition("f", "force", 0);
    protected ChangeSetUtil csUtil = new ChangeSetUtil();

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP).addOption((INamedOptionDefinition)OPT_FORCE, Messages.ExportValidationCmd_ForceOption).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_RESULT_SELECTOR, "result", 1, 1, "@"), Messages.ExportValidationCmd_RESULT_ID).addOption((IPositionalOptionDefinition)OPT_LOGFILE, Messages.ExportValidationCmd_OutputFile);
        return options;
    }

    public void run() throws FileSystemException {
        ScmCommandLineArgument resultSelector;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (!cli.hasOption(OPT_RESULT_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.ExportValidationCmd_ResultIdMissing);
        }
        ITeamRepository repo = null;
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            String repoUri = cli.getOption((IOptionKey)CommonOptions.OPT_URI);
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUri));
            this.csUtil.repoStrToRepo.put(repoUri, repo);
        }
        if ((resultSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_RESULT_SELECTOR), (IScmClientConfiguration)this.config)) == null) {
            throw StatusHelper.argSyntax((String)Messages.ExportValidationCmd_ResultIdMissing);
        }
        this.csUtil.validateRepoAndLogin(Collections.singletonList(resultSelector), client, this.config, cli, true);
        if (resultSelector.getRepositorySelector() != null) {
            repo = this.csUtil.repoStrToRepo.get(resultSelector.getRepositorySelector());
        }
        if (repo == null) {
            throw StatusHelper.repositoryLookupFailed((String)Messages.ExportValidationCmd_RepositoryUrlMissing);
        }
        IUuidAliasRegistry.IUuidAlias resultAlias = RepoUtil.lookupUuidAndAlias((String)resultSelector.getItemSelector(), (String)repo.getRepositoryURI());
        if (resultAlias == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ExportValidationCmd_UnknownId, (Object)resultSelector.getItemSelector(), (Object[])new Object[0]));
        }
        ValidationResultDTO fetchResult = this.fetchResult(repo, resultAlias.getId(), null);
        ArrayList<ValidationEntryDTO> entries = new ArrayList<ValidationEntryDTO>(fetchResult.getPageOfEntries());
        ValidationResultDTO page = fetchResult;
        while (page.getNextPageDescriptor() != null) {
            page = this.fetchResult(repo, resultAlias.getId(), page.getNextPageDescriptor());
            entries.addAll(page.getPageOfEntries());
        }
        JSONObject json = ExportValidationCmd.asJson(fetchResult, entries);
        if (cli.hasOption((IOptionKey)OPT_LOGFILE)) {
            String outputName = cli.getOption((IOptionKey)OPT_LOGFILE);
            boolean force = cli.hasOption((IOptionKey)OPT_FORCE);
            this.writeFile(outputName, json, force);
        } else {
            this.config.getOutputStream().println((CharSequence)json.toString());
        }
    }

    private void writeFile(String outputName, JSONObject json, boolean force) throws CLIFileSystemClientException {
        File file = new File(outputName);
        if (file.exists() && !force) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ExportValidationCmd_FileExists, (Object)OPT_FORCE.getShortOpt(), (Object[])new Object[0]));
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
                bufferedWriter.write(json.toString());
                bufferedWriter.write(System.lineSeparator());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw StatusHelper.ioException((String)e.getMessage());
        }
    }

    public static JSONObject asJson(ValidationResultDTO fetchResult, List<ValidationEntryDTO> entries) {
        JSONObject result = ExportValidationCmd.asJson(fetchResult);
        JSONArray array = new JSONArray();
        for (ValidationEntryDTO entry : entries) {
            array.add((Object)ExportValidationCmd.asJson(entry));
        }
        result.put((Object)"entries", (Object)array);
        return result;
    }

    public static JSONObject asJson(ValidationResultDTO fetchResult) {
        JSONObject result = new JSONObject();
        result.put((Object)"uuid", (Object)fetchResult.getItemId());
        result.put((Object)"feed-id", (Object)fetchResult.getFeedId());
        if (fetchResult.getFeedLabel() != null) {
            result.put((Object)"feed-label", (Object)fetchResult.getFeedLabel());
        }
        SimpleDateFormat formatter = new SimpleDateFormat();
        String date = formatter.format(fetchResult.getEventTime());
        result.put((Object)"creationDate", (Object)date);
        result.put((Object)"status-code", (Object)fetchResult.getStatus());
        result.put((Object)"status", (Object)ExportValidationCmd.getStringForStatus(fetchResult.getStatus()));
        if (fetchResult.getDescription() != null) {
            result.put((Object)"description", (Object)fetchResult.getDescription());
        }
        return result;
    }

    private static JSONObject asJson(ValidationEntryDTO entry) {
        JSONObject result = new JSONObject();
        result.put((Object)"uuid", (Object)entry.getItemId());
        result.put((Object)"resource-uri", (Object)entry.getResourceUri());
        result.put((Object)"message", (Object)entry.getMessage());
        result.put((Object)"severity-code", (Object)entry.getSeverity());
        result.put((Object)"severity", (Object)ExportValidationCmd.getStringForSeverity(entry.getSeverity()));
        result.put((Object)"resolved", (Object)entry.isResolved());
        if (entry.getResolution() != null) {
            result.put((Object)"resolution", (Object)entry.getResolution());
        }
        if (entry.getData() != null) {
            result.put((Object)"data", (Object)ExportValidationCmd.asJson(entry.getData()));
        }
        return result;
    }

    private static JSONObject asJson(ValidationDataDTO data) {
        JSONObject result = new JSONObject();
        if (data instanceof AttributeRepairDataDTO) {
            AttributeRepairDataDTO repairData = (AttributeRepairDataDTO)data;
            result.put((Object)"entry-id", (Object)repairData.getEntryId());
            result.put((Object)"attribute-name", (Object)repairData.getAttributeName());
            result.put((Object)"expected-value", (Object)repairData.getExpectedValue());
        } else if (data instanceof ETagRepairDataDTO) {
            ETagRepairDataDTO repairData = (ETagRepairDataDTO)data;
            result.put((Object)"entry-id", (Object)repairData.getEntryId());
            result.put((Object)"expected-value", (Object)repairData.getExpectedValue());
        }
        return result;
    }

    private static String getStringForSeverity(int severity) {
        switch (severity) {
            case 1: {
                return Messages.ExportValidationCmd_SeverityError;
            }
            case 2: {
                return Messages.ExportValidationCmd_SeverityWarning;
            }
            case 3: {
                return Messages.ExportValidationCmd_SeverityInfo;
            }
        }
        return Messages.ExportValidationCmd_SeverityUnknown;
    }

    private static String getStringForStatus(int status) {
        switch (status) {
            case 0: {
                return Messages.ExportValidationCmd_Scheduled;
            }
            case 1: {
                return Messages.ExportValidationCmd_InProgress;
            }
            case 2: {
                return Messages.ExportValidationCmd_CompletedOk;
            }
            case 3: {
                return Messages.ExportValidationCmd_CompletedWithResults;
            }
        }
        return Messages.ExportValidationCmd_UnknowStatus;
    }

    protected ValidationResultDTO fetchResult(ITeamRepository repository, String resultId, String nextPage) throws CLIFileSystemClientException, FileSystemException {
        try {
            ITrsRestService trsService = (ITrsRestService)((IClientLibraryContext)repository).getServiceInterface(ITrsRestService.class);
            ITrsRestService.ParmsGetValidationResult parms = new ITrsRestService.ParmsGetValidationResult();
            parms.validationResultId = resultId;
            parms.pageDescriptor = nextPage;
            parms.pageSize = -1;
            return trsService.getValidationResult(parms);
        }
        catch (InsufficientRightsException e) {
            throw StatusHelper.permissionFailure((String)Messages.ExportValidationCmd_InsufficientPermissions);
        }
        catch (TeamRepositoryException e) {
            if (e.getCause() instanceof PermissionDeniedException) {
                throw StatusHelper.permissionFailure((String)e.getCause().getMessage());
            }
            throw StatusHelper.wrap((String)Messages.ExportValidationCmd_FetchFailed, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }
}

