/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.util.ChangeSetUtil;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.InsufficientRightsException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.trs.common.ITrsRestService;
import java.util.Collections;

public class DeleteValidationResultCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final NamedOptionDefinition OPT_FORCE = new NamedOptionDefinition("f", "force", 0);
    private static final IOptionKey OPT_RESULT_SELECTOR = new OptionKey("result", "@");
    private ChangeSetUtil csUtil = new ChangeSetUtil();

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)OPT_FORCE, Messages.DeleteValidationResultCmd_ForceOption);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_RESULT_SELECTOR, "result", 1, 1, "@"), Messages.DeleteValidationResultCmd_ResultId);
        return options;
    }

    public void run() throws FileSystemException {
        ScmCommandLineArgument selector;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (!cli.hasOption(OPT_RESULT_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.ExportValidationCmd_ResultIdMissing);
        }
        ITeamRepository repo = null;
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            String repoUri = cli.getOption((IOptionKey)CommonOptions.OPT_URI);
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUri));
            this.csUtil.repoStrToRepo.put(repoUri, repo);
        }
        if ((selector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_RESULT_SELECTOR), (IScmClientConfiguration)this.config)) == null) {
            throw StatusHelper.argSyntax((String)Messages.DeleteValidationResultCmd_ResultIdMissing);
        }
        this.csUtil.validateRepoAndLogin(Collections.singletonList(selector), client, this.config, cli, true);
        if (selector.getRepositorySelector() != null) {
            repo = this.csUtil.repoStrToRepo.get(selector.getRepositorySelector());
        }
        if (repo == null) {
            throw StatusHelper.repositoryLookupFailed((String)Messages.DeleteValidationResultCmd_RepositoryUrlMissing);
        }
        ITrsRestService trsService = (ITrsRestService)((IClientLibraryContext)repo).getServiceInterface(ITrsRestService.class);
        IUuidAliasRegistry.IUuidAlias resultAlias = RepoUtil.lookupUuidAndAlias((String)selector.getItemSelector(), (String)repo.getRepositoryURI());
        if (resultAlias == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.DeleteValidationResultCmd_UnknownId, (Object)selector.getItemSelector(), (Object[])new Object[0]));
        }
        ITrsRestService.ParmsDeleteValidationResults parms = new ITrsRestService.ParmsDeleteValidationResults();
        parms.force = cli.hasOption((IOptionKey)OPT_FORCE);
        parms.validationResultIds = new String[]{resultAlias.getId()};
        try {
            String[] deletedValidationResults = trsService.postDeleteValidationResults(parms);
            this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.DeleteValidationResultCmd_CompletedSuccessfully, (Object)deletedValidationResults.length, (Object[])new Object[0]));
            if (deletedValidationResults.length != parms.validationResultIds.length) {
                this.config.getWrappedOutputStream().println((CharSequence)Messages.DeleteValidationResultCmd_SomeNotDeleted);
            }
        }
        catch (InsufficientRightsException e) {
            throw StatusHelper.permissionFailure((String)Messages.DeleteValidationResultCmd_InsufficientPermissions);
        }
        catch (TeamRepositoryException e) {
            if (e.getCause() instanceof PermissionDeniedException) {
                throw StatusHelper.permissionFailure((String)e.getCause().getMessage());
            }
            if (e.getCause() instanceof IllegalStateException) {
                throw StatusHelper.disallowed((String)e.getMessage());
            }
            throw StatusHelper.wrap((String)Messages.DeleteValidationResultCmd_DeleteFailed, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }
}

