/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.trs.AbstractTrsCmd;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.transport.client.InsufficientRightsException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.trs.common.IScmTrsRestService;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractValidateCmd
extends AbstractTrsCmd {
    protected static final NamedOptionDefinition OPT_REPAIR = new NamedOptionDefinition(null, "repair", 0);

    @Override
    protected String getBaselinesHelpMessage() {
        return Messages.ValidateTrsCmd_1;
    }

    @Override
    protected String getSnapshotsHelpMessage() {
        return Messages.ValidateTrsCmd_2;
    }

    @Override
    protected String getWorkspacesHelpMessage() {
        return Messages.ValidateTrsCmd_3;
    }

    @Override
    protected String getGcHelpMessage() {
        return Messages.AbstractValidateCmd_gcHelpMessage;
    }

    @Override
    protected void printSuccessMessage() {
    }

    protected boolean shouldRepair() {
        return false;
    }

    @Override
    protected void performServiceCall(ITeamRepository repo, IScmTrsRestService.ParmsArtifacts parms) throws CLIFileSystemClientException, FileSystemException {
        try {
            parms.repair = this.shouldRepair();
            String[] result = this.requestValidation(repo, parms);
            this.printResult(result, repo);
        }
        catch (InsufficientRightsException e) {
            throw StatusHelper.permissionFailure((String)e.getMessage());
        }
        catch (TeamRepositoryException e) {
            if (e.getCause() instanceof PermissionDeniedException) {
                throw StatusHelper.permissionFailure((String)e.getCause().getMessage());
            }
            throw StatusHelper.wrap((String)Messages.ValidateTrsCmd_0, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }

    private void printResult(String[] result, ITeamRepository repo) {
        if (this.config.isJSONEnabled()) {
            JSONArray array = new JSONArray();
            String[] stringArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                String validateResultUUIDString = stringArray[n2];
                JSONObject jsonValidation = new JSONObject();
                jsonValidation.put((Object)"uuid", (Object)validateResultUUIDString);
                array.add((Object)jsonValidation);
                ++n2;
            }
            JSONObject toPrint = new JSONObject();
            toPrint.put((Object)"ids", (Object)array);
            this.config.getOutputStream().print((CharSequence)toPrint.toString());
            return;
        }
        IndentingPrintStream printStream = this.config.getWrappedOutputStream();
        if (this.shouldRepair()) {
            printStream.println((CharSequence)Messages.AbstractValidateCmd_RepairResultHeader);
        } else {
            printStream.println((CharSequence)Messages.AbstractValidateCmd_ResultHeader);
        }
        String[] stringArray = result;
        int n = result.length;
        int n3 = 0;
        while (n3 < n) {
            String validateResultUUIDString = stringArray[n3];
            String validationAlias = AliasUtil.alias((String)validateResultUUIDString, (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.UNKNOWN);
            printStream.println((CharSequence)NLS.bind((String)this.getResultMessage(this.shouldRepair()), (Object)validationAlias));
            ++n3;
        }
    }

    protected abstract String getResultMessage(boolean var1);

    protected abstract String[] requestValidation(ITeamRepository var1, IScmTrsRestService.ParmsArtifacts var2) throws TeamRepositoryException;
}

