/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.trs;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.util.ChangeSetUtil;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rest.dto.WorkspaceListDTO;
import com.ibm.team.scm.common.internal.rest.dto.WorkspaceListItemDTO;
import com.ibm.team.scm.trs.common.IScmTrsRestService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractTrsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_STREAMS = new NamedOptionDefinition("s", "streams", -1, "@");
    public static final NamedOptionDefinition OPT_SNAPSHOTS = new NamedOptionDefinition(null, "snapshots", -1, "@");
    public static final NamedOptionDefinition OPT_BASELINES = new NamedOptionDefinition("b", "baselines", -1, "@");
    public static final NamedOptionDefinition OPT_GC = new NamedOptionDefinition(null, "gc", 1);
    private static final String QUERY_DELIMITER = "?";
    private static final String EQUALS = "=";
    private static final String GC_SDK_SEGMENT = "gcsdk-api";
    private static final String FLAT_LIST_SEGMENT = "flatListOfContributionsForGcHierarchy";
    private static final String CONFIGURATION_URI_PARM = "configurationUri";
    private static final String CONFIGURATIONS_PROPERTY = "configurations";
    private static final String CONFIGURATION_URI_PROPERTY = "configurationUri";
    private static final String RTC_OSLC_SEGMENT = "/rtcoslc/";
    private static final String STREAM_PREFIX = "rtcoslc/scm/config/s/";
    private static final String SNAPSHOT_PREFIX = "rtcoslc/scm/config/n/";
    private static final String BASELINE_PREFIX = "rtcoslc/scm/config/b/";
    protected ChangeSetUtil csUtil = new ChangeSetUtil();
    private List<String> permissionErrors = new ArrayList<String>();

    protected abstract String getBaselinesHelpMessage();

    protected abstract String getSnapshotsHelpMessage();

    protected abstract String getWorkspacesHelpMessage();

    protected abstract String getGcHelpMessage();

    protected abstract void printSuccessMessage();

    protected abstract void performServiceCall(ITeamRepository var1, IScmTrsRestService.ParmsArtifacts var2) throws CLIFileSystemClientException, FileSystemException;

    protected abstract String getPermissionErrorFooter();

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP).addOption((IOptionGroup)new ContinuousGroup(true).addOption((INamedOptionDefinition)OPT_STREAMS, this.getWorkspacesHelpMessage(), false).addOption((INamedOptionDefinition)OPT_SNAPSHOTS, this.getSnapshotsHelpMessage(), false).addOption((INamedOptionDefinition)OPT_BASELINES, this.getBaselinesHelpMessage(), false).addOption((INamedOptionDefinition)OPT_GC, this.getGcHelpMessage(), false));
        return options;
    }

    public void run() throws FileSystemException {
        Map<ITeamRepository, ItemsFromRepoResult> repoToBaselinesList;
        HashMap<ITeamRepository, ItemsFromRepoResult> repoToSnapshotsList;
        HashMap<ITeamRepository, ItemsFromRepoResult> repoToStreamsList;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (!(cli.hasOption((IOptionKey)OPT_BASELINES) || cli.hasOption((IOptionKey)OPT_SNAPSHOTS) || cli.hasOption((IOptionKey)OPT_STREAMS) || cli.hasOption((IOptionKey)OPT_GC))) {
            throw StatusHelper.argSyntax((String)Messages.PublishCmd_NoItemsProvided);
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            String repoUri = cli.getOption((IOptionKey)CommonOptions.OPT_URI);
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUri));
            this.csUtil.repoStrToRepo.put(repoUri, repo);
        }
        this.validateArgumentRepoAndLogin(cli, client, this.config);
        if (cli.hasOption((IOptionKey)OPT_GC)) {
            repoToStreamsList = new HashMap();
            repoToSnapshotsList = new HashMap();
            repoToBaselinesList = new HashMap<ITeamRepository, ItemsFromRepoResult>();
            this.findItemsInGc(repo, cli.getOption((IOptionKey)OPT_GC), repoToStreamsList, repoToSnapshotsList, repoToBaselinesList);
        } else {
            repoToStreamsList = this.getItems(cli, repo, client, this.config, RepoUtil.ItemType.STREAM);
            repoToSnapshotsList = this.getItems(cli, repo, client, this.config, RepoUtil.ItemType.SNAPSHOT);
            repoToBaselinesList = this.getItems(cli, repo, client, this.config, RepoUtil.ItemType.BASELINE);
        }
        if (!this.permissionErrors.isEmpty()) {
            String errorMessage = Messages.AbstractTrsCmd_ReadPermissionErrorHeader;
            errorMessage = String.valueOf(errorMessage) + "\r\n";
            for (String string : this.permissionErrors) {
                errorMessage = String.valueOf(errorMessage) + string;
                errorMessage = String.valueOf(errorMessage) + "\r\n";
            }
            errorMessage = String.valueOf(errorMessage) + this.getPermissionErrorFooter();
            throw StatusHelper.permissionFailure((String)errorMessage);
        }
        HashSet<Object> repoList = new HashSet<Object>();
        repoList.addAll(repoToStreamsList.keySet());
        repoList.addAll(repoToSnapshotsList.keySet());
        repoList.addAll(repoToBaselinesList.keySet());
        if (repoList.isEmpty()) {
            this.config.getWrappedOutputStream().println((CharSequence)Messages.PublishCmd_NoItemsProvided);
            return;
        }
        for (ITeamRepository iTeamRepository : repoList) {
            ItemsFromRepoResult baselinesList;
            ItemsFromRepoResult snapshotsList;
            ArrayList items = new ArrayList();
            ItemsFromRepoResult streamsList = (ItemsFromRepoResult)repoToStreamsList.get(iTeamRepository);
            if (streamsList != null) {
                items.addAll(streamsList.uniqueResults.values());
            }
            if ((snapshotsList = (ItemsFromRepoResult)repoToSnapshotsList.get(iTeamRepository)) != null) {
                items.addAll(snapshotsList.uniqueResults.values());
            }
            if ((baselinesList = repoToBaselinesList.get(iTeamRepository)) != null) {
                items.addAll(baselinesList.uniqueResults.values());
            }
            IScmTrsRestService.ParmsArtifacts parms = new IScmTrsRestService.ParmsArtifacts(items);
            this.performServiceCall(iTeamRepository, parms);
        }
        if (cli.hasOption((IOptionKey)OPT_GC)) {
            this.printGCSuccessMessage();
        } else {
            this.printSuccessMessage();
        }
    }

    protected void printGCSuccessMessage() {
    }

    private void findItemsInGc(ITeamRepository repository, String gcConfiguratioUrl, Map<ITeamRepository, ItemsFromRepoResult> repoToStreamsList, Map<ITeamRepository, ItemsFromRepoResult> repoToSnapshotsList, Map<ITeamRepository, ItemsFromRepoResult> repoToBaselinesList) throws FileSystemException {
        JSONObject result = this.fetchJson(repository, gcConfiguratioUrl);
        JSONArray configurations = (JSONArray)result.get((Object)CONFIGURATIONS_PROPERTY);
        for (Object object : configurations) {
            IItemHandle itemHandle;
            String itemId;
            String repositoryString;
            JSONObject configJson = (JSONObject)object;
            String configUri = (String)configJson.get((Object)"configurationUri");
            int index = configUri.indexOf(RTC_OSLC_SEGMENT);
            if (index == -1 || !this.isSameRepository(repository, repositoryString = configUri.substring(0, index))) continue;
            String relativeResourceUri = configUri.substring(index + 1);
            if (relativeResourceUri.startsWith(STREAM_PREFIX)) {
                itemId = relativeResourceUri.substring(STREAM_PREFIX.length());
                itemHandle = IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null);
                this.addItemToMap(repository, itemHandle, repoToStreamsList);
                continue;
            }
            if (relativeResourceUri.startsWith(SNAPSHOT_PREFIX)) {
                itemId = relativeResourceUri.substring(SNAPSHOT_PREFIX.length());
                itemHandle = IBaselineSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null);
                this.addItemToMap(repository, itemHandle, repoToSnapshotsList);
                continue;
            }
            if (!relativeResourceUri.startsWith(BASELINE_PREFIX)) continue;
            itemId = relativeResourceUri.substring(BASELINE_PREFIX.length());
            itemHandle = IBaseline.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null);
            this.addItemToMap(repository, itemHandle, repoToBaselinesList);
        }
    }

    private boolean isSameRepository(ITeamRepository repository, String repositoryString) {
        for (Object uri : repository.getAliasRepositoryURIs()) {
            if (!uri.equals(repositoryString)) continue;
            return true;
        }
        return false;
    }

    private void addItemToMap(ITeamRepository repository, IItemHandle itemHandle, Map<ITeamRepository, ItemsFromRepoResult> itemMap) {
        ItemsFromRepoResult list = itemMap.get(repository);
        if (list == null) {
            list = new ItemsFromRepoResult();
            itemMap.put(repository, list);
        }
        list.uniqueResults.put(itemHandle.getItemId().getUuidValue(), itemHandle);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JSONObject fetchJson(ITeamRepository repository, String gcConfiguratioUrl) throws FileSystemException {
        try {
            URI uri = this.getGcSdkApiURI(repository.getRepositoryURI(), gcConfiguratioUrl);
            ITeamRawRestServiceClient.IRawRestClientConnection connection = repository.getRawRestServiceClient().getConnection(uri);
            connection.addRequestHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
            connection.addRequestHeader("Accept", HttpUtil.MediaType.JSON.toString());
            try (ITeamRawRestServiceClient.IRawRestClientConnection.Response response = connection.doGet();){
                int code = response.getStatusCode();
                if (code != 200) {
                    throw new FileSystemException(NLS.bind((String)Messages.AbstractTrsCmd_UnexpectedResponse, (Object)code));
                }
                try {
                    JSONObject jSONObject = this.asJson(response);
                    return jSONObject;
                }
                catch (IOException e) {
                    throw new FileSystemException((Throwable)e);
                }
            }
        }
        catch (FileSystemException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (TeamServiceException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private JSONObject asJson(ITeamRawRestServiceClient.IRawRestClientConnection.Response response) throws IOException {
        InputStreamReader reader = new InputStreamReader(response.getResponseStream(), HttpUtil.CharsetEncoding.UTF8.toString());
        return JSONObject.parse((Reader)reader);
    }

    protected URI getGcSdkApiURI(String repoURI, String gcConfiguratioUrl) throws TeamRepositoryException, UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(repoURI);
        if (!repoURI.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(GC_SDK_SEGMENT);
        buffer.append("/");
        buffer.append(FLAT_LIST_SEGMENT);
        buffer.append(QUERY_DELIMITER);
        buffer.append("configurationUri");
        buffer.append(EQUALS);
        buffer.append(URLEncoder.encode(gcConfiguratioUrl, HttpUtil.CharsetEncoding.ISO8859.toString()));
        try {
            return new URI(buffer.toString());
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private void assertUniqueSelectors(ItemsFromRepoResult itemsFromRepoResult, ITeamRepository repo, RepoUtil.ItemType itemType) throws CLIFileSystemClientException {
        if (itemsFromRepoResult.ambiguousResults.isEmpty()) {
            return;
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        for (Map.Entry entry : itemsFromRepoResult.ambiguousResults.entrySet()) {
            out.println((CharSequence)this.getAmbiguousSelectorErrorMessage((String)entry.getKey(), repo.getRepositoryURI(), itemType));
            IndentingPrintStream indent1 = out.indent();
            indent1.println((CharSequence)"Possible matches:");
            IndentingPrintStream indent2 = indent1.indent();
            for (IItemHandle workspace : (List)entry.getValue()) {
                String selector = AliasUtil.selector((AliasUtil.IAliasOptions)this.config.getAliasConfig(), (String)((String)entry.getKey()), (UUID)workspace.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)itemType);
                indent2.println((CharSequence)selector);
            }
        }
        out.println();
        throw StatusHelper.ambiguousSelector((String)Messages.AbstractTrsCmd_AmbiguousItemStatus);
    }

    private String getAmbiguousSelectorErrorMessage(String selector, String repositoryURI, RepoUtil.ItemType itemType) {
        switch (itemType) {
            case STREAM: {
                return NLS.bind((String)Messages.AbstractTrsCmd_AmbiguousStreamError, (Object)selector, (Object)repositoryURI);
            }
            case SNAPSHOT: {
                return NLS.bind((String)Messages.AbstractTrsCmd_AmbiguousSnapshotError, (Object)selector, (Object)repositoryURI);
            }
            case BASELINE: {
                return NLS.bind((String)Messages.AbstractTrsCmd_AmbiguousBaselineError, (Object)selector, (Object)repositoryURI);
            }
        }
        return NLS.bind((String)Messages.AbstractTrsCmd_AmbiguousItemError, (Object)selector, (Object)repositoryURI);
    }

    private void validateArgumentRepoAndLogin(ICommandLine cli, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        if (cli.hasOption((IOptionKey)OPT_GC)) {
            if (cli.hasOption((IOptionKey)OPT_STREAMS) || cli.hasOption((IOptionKey)OPT_SNAPSHOTS) || cli.hasOption((IOptionKey)OPT_BASELINES)) {
                throw new FileSystemException(NLS.bind((String)Messages.AbstractTrsCmd_gcMustBeUSedAlone, (Object)OPT_GC.getName()));
            }
            if (!cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
                throw new FileSystemException(NLS.bind((String)Messages.AbstractTrsCmd_gcRequiresARepo, (Object)OPT_GC.getName()));
            }
        }
        if (cli.hasOption((IOptionKey)OPT_STREAMS)) {
            List wsSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_STREAMS), (IScmClientConfiguration)config);
            this.csUtil.validateRepoAndLogin(wsSelectors, client, config, cli, true);
        }
        if (cli.hasOption((IOptionKey)OPT_SNAPSHOTS)) {
            List ssSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_SNAPSHOTS), (IScmClientConfiguration)config);
            this.csUtil.validateRepoAndLogin(ssSelectors, client, config, cli, true);
        }
        if (cli.hasOption((IOptionKey)OPT_BASELINES)) {
            List blSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_BASELINES), (IScmClientConfiguration)config);
            this.csUtil.validateRepoAndLogin(blSelectors, client, config, cli, true);
        }
    }

    private Map<ITeamRepository, ItemsFromRepoResult> getItems(ICommandLine cli, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config, RepoUtil.ItemType itemType) throws FileSystemException {
        NamedOptionDefinition opt;
        HashMap<ITeamRepository, ItemsFromRepoResult> result = new HashMap<ITeamRepository, ItemsFromRepoResult>();
        switch (itemType) {
            case STREAM: {
                opt = OPT_STREAMS;
                break;
            }
            case SNAPSHOT: {
                opt = OPT_SNAPSHOTS;
                break;
            }
            case BASELINE: {
                opt = OPT_BASELINES;
                break;
            }
            default: {
                return result;
            }
        }
        if (cli.hasOption((IOptionKey)opt)) {
            List selectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)opt), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((List)selectors, (RepoUtil.ItemType)itemType);
            HashMap<ITeamRepository, ArrayList<String>> repoToSelectors = new HashMap<ITeamRepository, ArrayList<String>>();
            for (IScmCommandLineArgument iScmCommandLineArgument : selectors) {
                ArrayList<String> selectorsForRepo;
                ITeamRepository localRepo = repo;
                if (iScmCommandLineArgument.getRepositorySelector() != null) {
                    localRepo = this.csUtil.repoStrToRepo.get(iScmCommandLineArgument.getRepositorySelector());
                }
                if ((selectorsForRepo = (ArrayList<String>)repoToSelectors.get(localRepo)) == null) {
                    selectorsForRepo = new ArrayList<String>();
                    repoToSelectors.put(localRepo, selectorsForRepo);
                }
                selectorsForRepo.add(iScmCommandLineArgument.getItemSelector());
            }
            for (Map.Entry entry : repoToSelectors.entrySet()) {
                ItemsFromRepoResult itemsFromRepo = this.getItemsFromRepo((List)entry.getValue(), (ITeamRepository)entry.getKey(), config, itemType);
                if (itemsFromRepo.uniqueResults.isEmpty()) continue;
                result.put((ITeamRepository)entry.getKey(), itemsFromRepo);
            }
        }
        return result;
    }

    private List<IItemHandle> getItemsByName(String selector, ITeamRepository repo, RepoUtil.ItemType itemType) throws FileSystemException {
        switch (itemType) {
            case STREAM: {
                return this.getWorkspacesByName(selector, repo);
            }
            case SNAPSHOT: {
                return this.getSnapshotsByName(selector, repo);
            }
            case BASELINE: {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private IItemHandle getItemByAlias(IUuidAliasRegistry.IUuidAlias alias, ITeamRepository repo, RepoUtil.ItemType itemType) throws FileSystemException {
        switch (itemType) {
            case STREAM: {
                return this.getWorkspaceByAlias(alias, repo);
            }
            case SNAPSHOT: {
                return this.getSnapshotByAlias(alias, repo);
            }
            case BASELINE: {
                return this.getBaselineByAlias(alias, repo);
            }
        }
        return null;
    }

    private List<IItemHandle> getSnapshotsByName(String selector, ITeamRepository repo) throws FileSystemException {
        ArrayList<IItemHandle> result = new ArrayList<IItemHandle>();
        List snapshots = RepoUtil.getSnapshotByName(null, (String)selector, (boolean)false, (int)512, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        if (snapshots != null) {
            result.addAll(snapshots);
        }
        return result;
    }

    private IItemHandle getSnapshotByAlias(IUuidAliasRegistry.IUuidAlias alias, ITeamRepository repo) throws FileSystemException {
        return RepoUtil.getSnapshotById((String)alias.getUuid().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
    }

    private List<IItemHandle> getWorkspacesByName(String selector, ITeamRepository repo) throws FileSystemException {
        ArrayList<IItemHandle> result = new ArrayList<IItemHandle>();
        WorkspaceListDTO dto = RepoUtil.getWorkspacesByName((String)selector, (boolean)true, (boolean)true, (boolean)true, (int)512, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        if (dto != null) {
            List workspaces = dto.getItems();
            for (WorkspaceListItemDTO workspace : workspaces) {
                result.add((IItemHandle)workspace.getWorkspace());
            }
        }
        return result;
    }

    private IItemHandle getWorkspaceByAlias(IUuidAliasRegistry.IUuidAlias alias, ITeamRepository repo) throws FileSystemException {
        return RepoUtil.getWorkspaceById((String)alias.getUuid().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
    }

    private IItemHandle getBaselineByAlias(IUuidAliasRegistry.IUuidAlias alias, ITeamRepository repo) throws FileSystemException {
        IBaseline baseline;
        IBaselineHandle handle = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle(alias.getUuid(), null);
        try {
            baseline = (IBaseline)repo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, null);
        }
        catch (PermissionDeniedException e) {
            throw StatusHelper.permissionFailure((String)e.getMessage());
        }
        catch (TeamRepositoryException e) {
            if (e instanceof FileSystemException) {
                throw (FileSystemException)((Object)e);
            }
            throw new FileSystemException((Throwable)e);
        }
        return baseline;
    }

    private ItemsFromRepoResult getItemsFromRepo(List<String> selectors, ITeamRepository repo, IScmClientConfiguration config, RepoUtil.ItemType itemType) throws FileSystemException {
        ItemsFromRepoResult result = new ItemsFromRepoResult();
        for (String selector : selectors) {
            try {
                List<IItemHandle> items = this.getItemsByName(selector, repo, itemType);
                if (items.isEmpty()) {
                    IItemHandle item;
                    IUuidAliasRegistry.IUuidAlias alias = RepoUtil.lookupUuidAndAlias((String)selector, (String)repo.getRepositoryURI());
                    if (alias != null && (item = this.getItemByAlias(alias, repo, itemType)) != null) {
                        result.uniqueResults.put(item.getItemId().getUuidValue(), item);
                    }
                } else if (items.size() == 1) {
                    result.uniqueResults.put(items.get(0).getItemId().getUuidValue(), items.get(0));
                } else {
                    ArrayList<IItemHandle> ambiguousItems = (ArrayList<IItemHandle>)result.ambiguousResults.get(selector);
                    if (ambiguousItems == null) {
                        ambiguousItems = new ArrayList<IItemHandle>();
                        result.ambiguousResults.put(selector, ambiguousItems);
                    }
                    ambiguousItems.addAll(items);
                }
            }
            catch (CLIFileSystemClientException e) {
                if (e.getStatus().getCode() == 18) {
                    this.permissionErrors.add(this.getPermissionError(selector, itemType));
                }
                throw e;
            }
            if (result.uniqueResults.keySet().size() >= 512) break;
        }
        this.assertUniqueSelectors(result, repo, itemType);
        return result;
    }

    private String getPermissionError(String selector, RepoUtil.ItemType itemType) {
        switch (itemType) {
            case STREAM: {
                return NLS.bind((String)Messages.AbstractTrsCmd_StreamPermissionError, (Object)selector);
            }
            case SNAPSHOT: {
                return NLS.bind((String)Messages.AbstractTrsCmd_SnapshotPermissionError, (Object)selector);
            }
            case BASELINE: {
                return NLS.bind((String)Messages.AbstractTrsCmd_BaselinePermissionError, (Object)selector);
            }
        }
        return NLS.bind((String)Messages.AbstractTrsCmd_UnknownTypePermissionError, (Object)selector);
    }

    private class ItemsFromRepoResult {
        private Map<String, IItemHandle> uniqueResults = new HashMap<String, IItemHandle>();
        private Map<String, List<IItemHandle>> ambiguousResults = new HashMap<String, List<IItemHandle>>();

        private ItemsFromRepoResult() {
        }
    }
}

