/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.internal.util.ComponentConfigurationRegistry;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class VersionCmd
extends com.ibm.team.rtc.cli.infrastructure.internal.subcommands.VersionCmd {
    private static final NamedOptionDefinition OPT_SERVER_VERSION = new NamedOptionDefinition("s", "server", 0);
    private static final NamedOptionDefinition OPT_COMMAND_INFO = new NamedOptionDefinition("c", "commands", 0);
    private static final String FOUNDATION_COMPONENT_TAG = "com.ibm.team.jazz.foundation";
    private static final String RTC_COMPONENT_TAG = "com.ibm.team.rtc";
    private static final String RTC_CLIENT_BUNDLE = "com.ibm.team.concert";
    private static final String ABOUT_PROPERTIES_FILE = "about.mappings";
    private static final String VERSION_ID_KEY = "0";

    public int run(IClientConfiguration config) throws CLIClientException {
        Map<String, Object> repoList;
        ICommandLine cli = config.getSubcommandCommandLine();
        IScmClientConfiguration configScm = (IScmClientConfiguration)config;
        configScm.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        JSONObject root = new JSONObject();
        String clientBuildId = null;
        if (Discovery2.RESOLVER.isRunningInEclipse()) {
            Bundle clientBundle = Platform.getBundle((String)RTC_CLIENT_BUNDLE);
            if (clientBundle != null) {
                URL fileURL = clientBundle.getEntry(ABOUT_PROPERTIES_FILE);
                try {
                    InputStream inputStream = fileURL.openConnection().getInputStream();
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    clientBuildId = properties.getProperty(VERSION_ID_KEY);
                }
                catch (IOException iOException) {}
            }
        } else {
            clientBuildId = System.getProperty("scm.daemon.buildId");
        }
        if (clientBuildId == null || clientBuildId.length() == 0) {
            clientBuildId = Messages.VersionCmd_MISSING_VALUE;
        }
        root.put((Object)"client-build-id", (Object)clientBuildId);
        String clientVersion = this.getClientVersion();
        if (clientVersion == null || clientVersion.length() == 0) {
            clientVersion = Messages.VersionCmd_MISSING_VALUE;
        }
        root.put((Object)"client-version", (Object)clientVersion);
        if (cli.hasOption((IOptionKey)OPT_SERVER_VERSION) && cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            try {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.VersionCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object)cli.getDefinition().getOption((IOptionKey)OPT_SERVER_VERSION).getName(), (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_URI).getName()));
            }
            catch (FileSystemException e) {
                throw StatusHelper.toCLIClientException((Exception)((Object)e));
            }
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            repoList = VersionCmd.getRepository(configScm);
            for (Map.Entry<String, Object> entry : repoList.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                root.put((Object)"repository", (Object)this.getJsonOject(entry));
            }
        }
        if (cli.hasOption((IOptionKey)OPT_SERVER_VERSION)) {
            try {
                File file = SubcommandUtil.findAncestorCFARoot((String)configScm.getContext().getCurrentWorkingDirectory());
                if (file == null) {
                    throw StatusHelper.argSyntax((String)Messages.VersionCmd_INVALID_SANDBOX);
                }
                repoList = VersionCmd.getRepository(configScm);
            }
            catch (FileSystemException fileSystemException) {
                throw StatusHelper.toCLIClientException((Exception)((Object)fileSystemException));
            }
            JSONArray jSONArray = new JSONArray();
            for (Map.Entry<Object, Object> entry : repoList.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                jSONArray.add((Object)this.getJsonOject(entry));
            }
            root.put((Object)"sandbox-repositories", (Object)jSONArray);
        }
        if (cli.hasOption((IOptionKey)OPT_COMMAND_INFO)) {
            Map cmdList = this.getCommands((IClientConfiguration)configScm);
            JSONArray jSONArray = new JSONArray();
            for (Map.Entry<Object, Object> entry : cmdList.entrySet()) {
                JSONObject jCmd = new JSONObject();
                for (Map.Entry entry1 : ((Map)entry.getKey()).entrySet()) {
                    if (entry1.getKey() == null || entry1.getValue() == null) continue;
                    String namespace = ((String)entry1.getKey()).toString();
                    String version = ((String)entry1.getValue()).toString();
                    jCmd.put((Object)"namespace", (Object)namespace);
                    jCmd.put((Object)"version", (Object)version);
                    jCmd.put((Object)"sub-commands", (Object)((String)entry.getValue()).toString());
                    jSONArray.add((Object)jCmd);
                }
            }
            root.put((Object)"commands", (Object)jSONArray);
        }
        if (configScm.isJSONEnabled()) {
            configScm.getOutputStream().println((CharSequence)root.toString());
        } else {
            this.printNonJson((IClientConfiguration)configScm, root, configScm.getWrappedOutputStream());
        }
        return 0;
    }

    private JSONObject getJsonOject(Map.Entry<String, Object> entry) {
        JSONObject jRepo = new JSONObject();
        if (entry.getValue() instanceof ITeamRepository) {
            TeamRepository repo = (TeamRepository)entry.getValue();
            jRepo = this.insertServerDetails(repo);
        } else {
            String errMessage = (String)entry.getValue();
            jRepo = this.insertErrServerDetails(entry.getKey(), errMessage);
        }
        return jRepo;
    }

    private JSONObject insertErrServerDetails(String uri, String message) {
        if (uri == null || uri.length() == 0) {
            uri = Messages.VersionCmd_MISSING_VALUE;
        }
        JSONObject jRepo = new JSONObject();
        jRepo.put((Object)"server-uuid", (Object)Messages.VersionCmd_UNKNOWN_VALUE);
        jRepo.put((Object)"server-uri", (Object)uri);
        jRepo.put((Object)"error-message", (Object)message);
        jRepo.put((Object)"server-build-id", (Object)Messages.VersionCmd_UNKNOWN_VALUE);
        jRepo.put((Object)"server-version", (Object)Messages.VersionCmd_UNKNOWN_VALUE);
        return jRepo;
    }

    private JSONObject insertServerDetails(TeamRepository repo) {
        String uuid;
        String uri;
        String buildId;
        String serverVersion = repo.getRepositoryVersion();
        if (serverVersion == null || serverVersion.length() == 0) {
            serverVersion = Messages.VersionCmd_MISSING_VALUE;
        }
        if ((buildId = repo.getRepositoryBuildId()) == null || buildId.length() == 0) {
            buildId = Messages.VersionCmd_MISSING_VALUE;
        }
        if ((uri = repo.getRepositoryURI()) == null || uri.length() == 0) {
            uri = Messages.VersionCmd_MISSING_VALUE;
        }
        if ((uuid = repo.getId().getUuidValue()) == null || uuid.length() == 0) {
            uuid = Messages.VersionCmd_MISSING_VALUE;
        }
        JSONObject jRepo = new JSONObject();
        jRepo.put((Object)"server-uuid", (Object)uuid);
        jRepo.put((Object)"server-uri", (Object)uri);
        jRepo.put((Object)"server-build-id", (Object)buildId);
        jRepo.put((Object)"server-version", (Object)serverVersion);
        return jRepo;
    }

    private void printNonJson(IClientConfiguration config, JSONObject js, IndentingPrintStream out) {
        JSONArray ja1;
        JSONObject jo;
        String ClientBuildId = (String)js.get((Object)"client-build-id");
        out.println((CharSequence)NLS.bind((String)Messages.VersionCmd_BUILD_ID_HEADER, (Object)ClientBuildId));
        String ClientVersion = (String)js.get((Object)"client-version");
        out.println((CharSequence)NLS.bind((String)Messages.VersionCmd_VERSION, (Object)ClientVersion));
        JSONArray ja = (JSONArray)js.get((Object)"sandbox-repositories");
        if (ja != null) {
            int i = 0;
            while (i < ja.size()) {
                JSONObject jo2 = (JSONObject)ja.get(i);
                this.printJsonObject(config, jo2, out);
                ++i;
            }
        }
        if ((jo = (JSONObject)js.get((Object)"repository")) != null) {
            this.printJsonObject(config, jo, out);
        }
        if ((ja1 = (JSONArray)js.get((Object)"commands")) != null) {
            HashMap list = new HashMap();
            int i = 0;
            while (i < ja1.size()) {
                HashMap<String, String> key = new HashMap<String, String>();
                JSONObject jo1 = (JSONObject)ja1.get(i);
                String namespace = (String)jo1.get((Object)"namespace");
                String version = (String)jo1.get((Object)"version");
                String subCommands = (String)jo1.get((Object)"sub-commands");
                key.put(namespace, version);
                list.put(key, subCommands);
                ++i;
            }
            out.println();
            this.displayCommands(config, list);
        }
    }

    private void printJsonObject(IClientConfiguration config, JSONObject jo, IndentingPrintStream out) {
        out.println();
        out.println((CharSequence)NLS.bind((String)Messages.VersionCmd_SERVER_URI, (Object)jo.get((Object)"server-uri")));
        out.println((CharSequence)NLS.bind((String)Messages.VersionCmd_SERVER_BUILD_ID, (Object)jo.get((Object)"server-build-id")));
        out.println((CharSequence)NLS.bind((String)Messages.VersionCmd_SERVER_VERSION, (Object)jo.get((Object)"server-version")));
        if (jo.get((Object)"error-message") != null) {
            out.println((CharSequence)NLS.bind((String)Messages.VersionCmd_Error_MESSAGE, (Object)jo.get((Object)"error-message")));
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = super.getOptions();
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)OPT_SERVER_VERSION, Messages.VersionCmd_OPT_SERVER_VERSION_HELP, false).addOption((INamedOptionDefinition)OPT_COMMAND_INFO, Messages.VersionCmd_OPT_COMMAND_INFO_HELP, false).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.VersionCmd_OPT_JSON_HELP, false).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP, false);
        return options;
    }

    public String getClientVersion() {
        Map compatibilityMap = ComponentConfigurationRegistry.INSTANCE.getClientCompatibilityMap();
        String version = (String)compatibilityMap.get(RTC_COMPONENT_TAG);
        if (version == null) {
            version = (String)compatibilityMap.get(FOUNDATION_COMPONENT_TAG);
        }
        return version;
    }

    public static Map<String, Object> getRepository(IScmClientConfiguration config) {
        HashMap<String, Object> repo = new HashMap();
        try {
            IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
            repo = RepoUtil.loginUrlArgAncs((IScmClientConfiguration)config, (IFilesystemRestClient)client);
        }
        catch (FileSystemException e) {
            config.getWrappedErrorStream().println((CharSequence)e.getMessage());
        }
        return repo;
    }
}

