/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ValidateMetadataCmdOpts;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostValidateSandbox;
import com.ibm.team.filesystem.common.internal.rest.client.corruption.MetadataValidationResultDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import java.io.File;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;

public class ValidateMetadataCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        String logfilePath;
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        File sandboxFile = SubcommandUtil.findAncestorCFARoot((String)this.config.getContext().getCurrentWorkingDirectory());
        if (sandboxFile == null) {
            throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.RepairCmd_NO_SANDBOX_METADATA, (Object)this.config.getContext().getCurrentWorkingDirectory()));
        }
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)ValidateMetadataCmdOpts.OPT_LOGFILE)) {
            ScmCommandLineArgument logfileSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ValidateMetadataCmdOpts.OPT_LOGFILE), (IScmClientConfiguration)this.config);
            logfilePath = logfileSelector.getStringValue();
        } else {
            try {
                File logFile = File.createTempFile("validate_", ".log", new File(this.config.getContext().getCurrentWorkingDirectory()));
                logfilePath = logFile.getAbsolutePath();
            }
            catch (IOException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ValidateMetadataCmd_5, (Object)this.config.getContext().getCurrentWorkingDirectory()), (Throwable)e);
            }
        }
        ParmsPostValidateSandbox validateParms = new ParmsPostValidateSandbox();
        validateParms.sandboxPath = sandboxFile.getAbsolutePath();
        validateParms.logFilePath = logfilePath;
        validateParms.getDump = cli.hasOption((IOptionKey)ValidateMetadataCmdOpts.OPT_DUMP);
        MetadataValidationResultDTO result = null;
        try {
            this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ValidateMetadataCmd_2, (Object)sandboxFile));
            result = client.postValidateSandbox(validateParms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.misconfiguredRemoteFS((String)e.getMessage());
        }
        if (result.isIsValid()) {
            if (validateParms.getDump.booleanValue()) {
                this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ValidateMetadataCmd_7, (Object)validateParms.sandboxPath, (Object)logfilePath));
            } else {
                new File(logfilePath).delete();
                this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ValidateMetadataCmd_6, (Object)validateParms.sandboxPath));
            }
        } else {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.ValidateMetadataCmd_8, (Object)validateParms.sandboxPath, (Object)logfilePath), null);
        }
    }
}

