/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.UndoCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.UndoMergeCmdOpts;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoMerges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.UndoMergesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UndoMergeCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        SyncViewDTO syncView;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        List changeSelectors = subargs.getOptions((IOptionKey)UndoMergeCmdOpts.OPT_CHANGES);
        ArrayList<String> pathSelectors = new ArrayList<String>();
        for (String changeSelector : changeSelectors) {
            ILocation changePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)changeSelector);
            pathSelectors.add(changePath.toOSString());
        }
        ParmsSandboxPaths parmsPaths = new ParmsSandboxPaths();
        parmsPaths.includeNonRegisteredSandboxes = true;
        parmsPaths.pathsToResolve = pathSelectors.toArray(new String[pathSelectors.size()]);
        SandboxPathsResultDTO pathsResult = null;
        try {
            pathsResult = client.getSandboxPaths(parmsPaths, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.Common_UNABLE_TO_GET_SANDBOX_PATHS, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), null);
        }
        List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        HashMap<String, Object> wsIdtoWsInSandboxmap = new HashMap<String, Object>();
        for (ISandboxWorkspace wsInSandbox : wsInSandboxList) {
            wsIdtoWsInSandboxmap.put(wsInSandbox.getWorkspaceItemId(), wsInSandbox);
        }
        ArrayList<UndoCmd.Change> changesToFindList = new ArrayList<UndoCmd.Change>();
        int count = 0;
        for (ShareableDTO shareable : pathsResult.getPaths()) {
            ResourcePropertiesDTO resource = null;
            if (shareable.getSandboxPath() != null && shareable.getSandboxPath().length() > 0 && shareable.getRelativePath() != null && shareable.getRelativePath().getSegments().size() > 0) {
                try {
                    resource = RepoUtil.getResourceProperties((String)((String)pathSelectors.get(count)), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                    ShareDTO share = resource.getShare();
                    if (!wsIdtoWsInSandboxmap.keySet().contains(share.getContextItemId())) {
                        wsIdtoWsInSandboxmap.put(share.getContextItemId(), new SandboxWorkspace(share.getContextItemId(), share.getContextName(), share.getRepositoryId()));
                    }
                }
                catch (Exception share) {
                    // empty catch block
                }
                changesToFindList.add(new UndoCmd.Change((String)changeSelectors.get(count), shareable, resource));
            } else {
                changesToFindList.add(new UndoCmd.Change((String)changeSelectors.get(count), null, null));
            }
            ++count;
        }
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>(wsIdtoWsInSandboxmap.values().size());
        for (ISandboxWorkspace wsInSandbox : wsIdtoWsInSandboxmap.values()) {
            Iterator uri = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(uri));
            wsList.add(new ParmsWorkspace(uri, wsInSandbox.getWorkspaceItemId()));
        }
        if (SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config)) {
            HashMap sandboxToPaths = new HashMap();
            for (UndoCmd.Change change : changesToFindList) {
                if (!change.hasShareInfo()) continue;
                ArrayList<ILocation> pathLocs = (ArrayList<ILocation>)sandboxToPaths.get(change.getSandboxPath());
                if (pathLocs == null) {
                    pathLocs = new ArrayList<ILocation>();
                    sandboxToPaths.put(change.getSandboxPath(), pathLocs);
                }
                ILocation pathLoc = new PathLocation(change.getSandboxPath()).append(change.getRelativePath());
                pathLocs.add(pathLoc);
            }
            for (Map.Entry entry : sandboxToPaths.entrySet()) {
                PathLocation sandboxLoc = new PathLocation((String)entry.getKey());
                SubcommandUtil.refreshPaths((ILocation)sandboxLoc, (List)((List)entry.getValue()), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            }
        }
        if ((syncView = SubcommandUtil.getSyncView(wsList, (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config)).getWorkspaces().size() == 0) {
            throw StatusHelper.itemNotFound((String)Messages.Common_WS_NOT_FOUND);
        }
        syncView = SubcommandUtil.getSyncView(wsList, (boolean)true, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        Map<ParmsWorkspace, List<ParmsUndoChanges>> wsToUndoChanges = null;
        if (changesToFindList.size() > 0) {
            wsToUndoChanges = UndoCmd.generateUndoChanges(changesToFindList, syncView, this.config);
        }
        IndentingPrintStream err = this.config.getWrappedErrorStream();
        if (changesToFindList.size() > 0) {
            err.println((CharSequence)Messages.UndoCmd_3);
            this.printChanges(changesToFindList, err.indent());
            throw StatusHelper.itemNotFound((String)Messages.UndoCmd_6);
        }
        ArrayList<ShareableDTO> deletedContentShareables = new ArrayList<ShareableDTO>();
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (wsToUndoChanges != null && wsToUndoChanges.size() > 0) {
            try {
                this.undoMerges(wsToUndoChanges, deletedContentShareables, client, this.config, out);
            }
            finally {
                if (deletedContentShareables.size() > 0) {
                    SubcommandUtil.showDeletedContent(deletedContentShareables, (IndentingPrintStream)out);
                }
            }
        }
        out.println((CharSequence)Messages.UndoMergeCmd_0);
    }

    private void printChanges(List<UndoCmd.Change> changes, IndentingPrintStream out) {
        for (UndoCmd.Change change : changes) {
            out.println((CharSequence)change.selector);
        }
    }

    private void undoMerges(Map<ParmsWorkspace, List<ParmsUndoChanges>> wsToUndoChanges, List<ShareableDTO> deletedContentShareables, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        ArrayList backupInShedList = new ArrayList();
        for (Map.Entry<ParmsWorkspace, List<ParmsUndoChanges>> entry : wsToUndoChanges.entrySet()) {
            ParmsUndoMerges parmsUndoMerges = new ParmsUndoMerges();
            parmsUndoMerges.workspace = entry.getKey();
            parmsUndoMerges.changesToUndo = entry.getValue().toArray(new ParmsUndoChanges[entry.getValue().size()]);
            parmsUndoMerges.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
            parmsUndoMerges.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
            parmsUndoMerges.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
            parmsUndoMerges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
            parmsUndoMerges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
            parmsUndoMerges.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
            parmsUndoMerges.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
            parmsUndoMerges.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
            UndoMergesResultDTO result = null;
            try {
                result = client.postUndoMerges(parmsUndoMerges, null);
            }
            catch (TeamRepositoryException e) {
                if (backupInShedList.size() > 0) {
                    SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, backupInShedList);
                }
                throw StatusHelper.wrap((String)Messages.UndoMergeCmd_1, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            if (result.isCancelled() && result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
            }
            if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0) {
                backupInShedList.addAll(result.getSandboxUpdateDilemma().getBackedUpToShed());
            }
            if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() <= 0) continue;
            deletedContentShareables.addAll(result.getSandboxUpdateDilemma().getDeletedContentShareables());
        }
        if (backupInShedList.size() > 0) {
            SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, backupInShedList);
        }
    }
}

