/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.UndoCmdOpts;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoCheckedInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoLocalChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoLocalChangesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.UndoCheckedInChangesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.UndoLocalChangesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.LocalChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.UnresolvedFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class UndoCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        SyncViewDTO syncView;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        List changeSelectors = subargs.getOptions((IOptionKey)UndoCmdOpts.OPT_CHANGES);
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        ArrayList<String> pathSelectors = new ArrayList<String>();
        for (String changeSelector : changeSelectors) {
            if (changeSelector.contains("*") || changeSelector.contains("?")) {
                throw StatusHelper.ambiguousDirectorySelector((String)NLS.bind((String)Messages.UndoCmd_CHANGES_DIRECTORY_CONTENT, (Object)changeSelector));
            }
            ILocation changePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)changeSelector);
            pathSelectors.add(changePath.toOSString());
        }
        ParmsSandboxPaths parmsPaths = new ParmsSandboxPaths();
        parmsPaths.includeNonRegisteredSandboxes = true;
        parmsPaths.pathsToResolve = pathSelectors.toArray(new String[pathSelectors.size()]);
        SandboxPathsResultDTO pathsResult = null;
        try {
            pathsResult = client.getSandboxPaths(parmsPaths, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.Common_UNABLE_TO_GET_SANDBOX_PATHS, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), null);
        }
        List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        HashMap<String, Object> wsIdtoWsInSandboxmap = new HashMap<String, Object>();
        for (ISandboxWorkspace wsInSandbox : wsInSandboxList) {
            wsIdtoWsInSandboxmap.put(wsInSandbox.getWorkspaceItemId(), wsInSandbox);
        }
        ArrayList<Change> changesToFindList = new ArrayList<Change>();
        int count = 0;
        for (ShareableDTO shareable : pathsResult.getPaths()) {
            ResourcePropertiesDTO resource = null;
            if (shareable.getSandboxPath() != null && shareable.getSandboxPath().length() > 0 && shareable.getRelativePath() != null && shareable.getRelativePath().getSegments().size() > 0) {
                try {
                    resource = RepoUtil.getResourceProperties((String)((String)pathSelectors.get(count)), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                    ShareDTO share = resource.getShare();
                    if (!wsIdtoWsInSandboxmap.keySet().contains(share.getContextItemId())) {
                        wsIdtoWsInSandboxmap.put(share.getContextItemId(), new SandboxWorkspace(share.getContextItemId(), share.getContextName(), share.getRepositoryId()));
                    }
                }
                catch (Exception share) {
                    // empty catch block
                }
                changesToFindList.add(new Change((String)changeSelectors.get(count), shareable, resource));
            } else {
                changesToFindList.add(new Change((String)changeSelectors.get(count), null, null));
            }
            ++count;
        }
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>(wsIdtoWsInSandboxmap.values().size());
        for (ISandboxWorkspace wsInSandbox : wsIdtoWsInSandboxmap.values()) {
            Iterator uri = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(uri));
            wsList.add(new ParmsWorkspace(uri, wsInSandbox.getWorkspaceItemId()));
        }
        if (SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config)) {
            HashMap sandboxToPaths = new HashMap();
            for (Change change : changesToFindList) {
                if (!change.hasShareInfo()) continue;
                ArrayList<ILocation> pathLocs = (ArrayList<ILocation>)sandboxToPaths.get(change.getSandboxPath());
                if (pathLocs == null) {
                    pathLocs = new ArrayList<ILocation>();
                    sandboxToPaths.put(change.getSandboxPath(), pathLocs);
                }
                ILocation pathLoc = new PathLocation(change.getSandboxPath()).append(change.getRelativePath());
                pathLocs.add(pathLoc);
            }
            for (Map.Entry entry : sandboxToPaths.entrySet()) {
                PathLocation sandboxLoc = new PathLocation((String)entry.getKey());
                SubcommandUtil.refreshPaths((ILocation)sandboxLoc, (List)((List)entry.getValue()), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            }
        }
        if ((syncView = SubcommandUtil.getSyncView(wsList, (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config)).getWorkspaces().size() == 0) {
            throw StatusHelper.itemNotFound((String)Messages.Common_WS_NOT_FOUND);
        }
        syncView = SubcommandUtil.getSyncView(wsList, (boolean)true, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        ArrayList<Change> localChanges = new ArrayList<Change>(changesToFindList);
        List<ParmsUndoLocalChangesRequest> undoLocalChangesRequests = this.generateUndoLocalChangeRequests(changesToFindList, syncView, this.config);
        localChanges.removeAll(changesToFindList);
        Map<ParmsWorkspace, List<ParmsUndoChanges>> wsToUndoChanges = null;
        if (changesToFindList.size() > 0) {
            wsToUndoChanges = UndoCmd.generateUndoChanges(changesToFindList, syncView, this.config);
        }
        IndentingPrintStream err = this.config.getWrappedErrorStream();
        if (changesToFindList.size() > 0) {
            err.println((CharSequence)Messages.UndoCmd_3);
            this.printChanges(changesToFindList, err.indent());
            throw StatusHelper.itemNotFound((String)Messages.UndoCmd_6);
        }
        ArrayList<ShareableDTO> deletedContentShareables = new ArrayList<ShareableDTO>();
        if (undoLocalChangesRequests.size() > 0) {
            this.undoLocalChangesRequests(undoLocalChangesRequests, deletedContentShareables, client, this.config);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (wsToUndoChanges != null && wsToUndoChanges.size() > 0) {
            boolean printLocalChanges = true;
            try {
                this.undoChanges(wsToUndoChanges, deletedContentShareables, client, this.config, out);
                printLocalChanges = false;
            }
            finally {
                if (printLocalChanges) {
                    out.println((CharSequence)Messages.UndoCmd_CHANGES_UNDONE_HEADER);
                    this.printChanges(localChanges, out.indent());
                }
                if (deletedContentShareables.size() > 0) {
                    SubcommandUtil.showDeletedContent(deletedContentShareables, (IndentingPrintStream)out);
                }
            }
        }
        out.println((CharSequence)Messages.UndoCmd_CHANGES_SUCCESSFULLY_UNDONE);
    }

    private void printChanges(List<Change> changes, IndentingPrintStream out) {
        for (Change change : changes) {
            out.println((CharSequence)change.selector);
        }
    }

    private List<ParmsUndoLocalChangesRequest> generateUndoLocalChangeRequests(List<Change> changesToFind, SyncViewDTO syncView, IScmClientConfiguration config) {
        ArrayList<ParmsUndoLocalChangesRequest> undoLocalChangesRequests = new ArrayList<ParmsUndoLocalChangesRequest>();
        Iterator<Change> itChange = changesToFind.iterator();
        block0: while (itChange.hasNext()) {
            Change change = itChange.next();
            ShareDTO share = change.hasResourceInfo() ? change.getResourceProperties().getShare() : null;
            for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
                if (share != null && !share.getContextItemId().equals(wsSync.getWorkspaceItemId())) continue;
                for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                    if (share != null && !share.getComponentItemId().equals(compSync.getComponentItemId())) continue;
                    for (UnresolvedFolderSyncDTO unresolvedFolderSync : compSync.getUnresolved()) {
                        for (LocalChangeSyncDTO localChange : unresolvedFolderSync.getLocalChanges()) {
                            if (change.hasShareInfo() && !localChange.getSandboxPath().equals(change.getSandboxPath()) || (!change.hasItemId() || !localChange.getTargetVersionableItemId().equals(change.getItemId())) && (change.hasResourceInfo() || !localChange.getPath().equals(change.getRelativePath()))) continue;
                            boolean foundChange = false;
                            for (ParmsUndoLocalChangesRequest localCR : undoLocalChangesRequests) {
                                if (!localCR.workspace.workspaceItemId.equals(wsSync.getWorkspaceItemId()) || !localCR.componentItemId.equals(compSync.getComponentItemId()) || !localCR.sandboxPath.equals(localChange.getSandboxPath())) continue;
                                ArrayList<String> versionableIds = new ArrayList<String>(localCR.versionableItemIds.length + 1);
                                String[] stringArray = localCR.versionableItemIds;
                                int n = localCR.versionableItemIds.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String verId = stringArray[n2];
                                    versionableIds.add(verId);
                                    ++n2;
                                }
                                versionableIds.add(localChange.getTargetVersionableItemId());
                                localCR.versionableItemIds = versionableIds.toArray(new String[versionableIds.size()]);
                                foundChange = true;
                                break;
                            }
                            if (!foundChange) {
                                ParmsUndoLocalChangesRequest localChangeRequest = new ParmsUndoLocalChangesRequest();
                                localChangeRequest.workspace = new ParmsWorkspace(wsSync.getRepositoryUrl(), wsSync.getWorkspaceItemId());
                                localChangeRequest.componentItemId = compSync.getComponentItemId();
                                localChangeRequest.sandboxPath = localChange.getSandboxPath();
                                localChangeRequest.versionableItemIds = new String[1];
                                localChangeRequest.versionableItemIds[0] = localChange.getTargetVersionableItemId();
                                undoLocalChangesRequests.add(localChangeRequest);
                            }
                            itChange.remove();
                            continue block0;
                        }
                    }
                }
            }
        }
        return undoLocalChangesRequests;
    }

    protected static Map<ParmsWorkspace, List<ParmsUndoChanges>> generateUndoChanges(List<Change> changesToFind, SyncViewDTO syncView, IScmClientConfiguration config) {
        HashMap<ParmsWorkspace, List<ParmsUndoChanges>> wsToUndoChanges = new HashMap<ParmsWorkspace, List<ParmsUndoChanges>>();
        HashMap<String, ParmsWorkspace> wsIdToWs = new HashMap<String, ParmsWorkspace>();
        Iterator<Change> itChange = changesToFind.iterator();
        block0: while (itChange.hasNext()) {
            Change change = itChange.next();
            ShareDTO share = change.hasResourceInfo() ? change.getResourceProperties().getShare() : null;
            for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
                if (share != null && !share.getContextItemId().equals(wsSync.getWorkspaceItemId())) continue;
                ParmsWorkspace ws = (ParmsWorkspace)wsIdToWs.get(wsSync.getWorkspaceItemId());
                if (ws == null) {
                    ws = new ParmsWorkspace(wsSync.getRepositoryUrl(), wsSync.getWorkspaceItemId());
                    wsIdToWs.put(ws.workspaceItemId, ws);
                }
                for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                    if (share != null && !share.getComponentItemId().equals(compSync.getComponentItemId())) continue;
                    for (ChangeSetSyncDTO changeSetSync : compSync.getOutgoingChangeSetsAfterBasis()) {
                        if (!changeSetSync.isIsActive()) continue;
                        for (ChangeFolderSyncDTO changeFolderSync : changeSetSync.getChanges()) {
                            for (ChangeSyncDTO changeSync : changeFolderSync.getChanges()) {
                                if ((!change.hasItemId() || !changeSync.getVersionableItemId().equals(change.getItemId())) && (change.hasResourceInfo() || !changeSync.getPathHint().equals(change.getRelativePathToComponent(compSync.getComponentName())))) continue;
                                boolean foundChange = false;
                                ArrayList<ParmsUndoChanges> undoChanges = (ArrayList<ParmsUndoChanges>)wsToUndoChanges.get(ws);
                                if (undoChanges != null) {
                                    for (ParmsUndoChanges changes : undoChanges) {
                                        if (!changes.changeSetItemId.equals(changeSetSync.getChangeSetItemId())) continue;
                                        ArrayList<String> versionableIds = new ArrayList<String>(changes.versionableItemIds.length);
                                        String[] stringArray = changes.versionableItemIds;
                                        int n = changes.versionableItemIds.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String verId = stringArray[n2];
                                            versionableIds.add(verId);
                                            ++n2;
                                        }
                                        versionableIds.add(changeSync.getVersionableItemId());
                                        changes.versionableItemIds = versionableIds.toArray(new String[versionableIds.size()]);
                                        foundChange = true;
                                        break;
                                    }
                                }
                                if (!foundChange) {
                                    ParmsUndoChanges changes;
                                    changes = new ParmsUndoChanges();
                                    changes.changeSetItemId = changeSetSync.getChangeSetItemId();
                                    changes.versionableItemIds = new String[1];
                                    changes.versionableItemIds[0] = changeSync.getVersionableItemId();
                                    if (undoChanges == null) {
                                        undoChanges = new ArrayList<ParmsUndoChanges>();
                                        wsToUndoChanges.put(ws, undoChanges);
                                    }
                                    undoChanges.add(changes);
                                }
                                itChange.remove();
                                continue block0;
                            }
                        }
                    }
                }
            }
        }
        return wsToUndoChanges;
    }

    private void undoLocalChangesRequests(List<ParmsUndoLocalChangesRequest> undoLocalChangesRequests, List<ShareableDTO> deletedContentShareables, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ParmsUndoLocalChanges parmsLocalChanges = new ParmsUndoLocalChanges();
        parmsLocalChanges.undoRequests = undoLocalChangesRequests.toArray(new ParmsUndoLocalChangesRequest[undoLocalChangesRequests.size()]);
        parmsLocalChanges.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parmsLocalChanges.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parmsLocalChanges.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = false;
        parmsLocalChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parmsLocalChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        parmsLocalChanges.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parmsLocalChanges.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parmsLocalChanges.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parmsLocalChanges.autoReleaseLocks = !cli.hasOption((IOptionKey)CommonOptions.OPT_RELEASE_LOCK) ? Boolean.valueOf(((ScmClientConfiguration)config).getPersistentPreferences().getReleaseLockForUndo()) : Boolean.valueOf(Boolean.parseBoolean(cli.getOption((IOptionKey)CommonOptions.OPT_RELEASE_LOCK).toString()));
        UndoLocalChangesResultDTO result = null;
        try {
            result = client.postUndoLocalChanges(parmsLocalChanges, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.UndoCmd_6, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        if (result.isCancelled() && result.getOutOfSyncShares().size() > 0) {
            AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
        }
        if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
            deletedContentShareables.addAll(result.getSandboxUpdateDilemma().getDeletedContentShareables());
        }
    }

    private void undoChanges(Map<ParmsWorkspace, List<ParmsUndoChanges>> wsToUndoChanges, List<ShareableDTO> deletedContentShareables, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        ArrayList backupInShedList = new ArrayList();
        for (Map.Entry<ParmsWorkspace, List<ParmsUndoChanges>> entry : wsToUndoChanges.entrySet()) {
            ParmsUndoCheckedInChanges parmsUnCheckedInChanges = new ParmsUndoCheckedInChanges();
            parmsUnCheckedInChanges.workspace = entry.getKey();
            parmsUnCheckedInChanges.changesToUndo = entry.getValue().toArray(new ParmsUndoChanges[entry.getValue().size()]);
            parmsUnCheckedInChanges.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
            parmsUnCheckedInChanges.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
            parmsUnCheckedInChanges.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
            parmsUnCheckedInChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
            parmsUnCheckedInChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
            parmsUnCheckedInChanges.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
            parmsUnCheckedInChanges.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
            parmsUnCheckedInChanges.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
            UndoCheckedInChangesResultDTO result = null;
            try {
                result = client.postUndoCheckedInChanges(parmsUnCheckedInChanges, null);
            }
            catch (TeamRepositoryException e) {
                if (backupInShedList.size() > 0) {
                    SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, backupInShedList);
                }
                throw StatusHelper.wrap((String)Messages.UndoCmd_6, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            if (result.isCancelled() && result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
            }
            if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0) {
                backupInShedList.addAll(result.getSandboxUpdateDilemma().getBackedUpToShed());
            }
            if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() <= 0) continue;
            deletedContentShareables.addAll(result.getSandboxUpdateDilemma().getDeletedContentShareables());
        }
        if (backupInShedList.size() > 0) {
            SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, backupInShedList);
        }
    }

    public static class Change {
        String selector;
        ShareableDTO shareable;
        ResourcePropertiesDTO resource;

        public Change(String selector, ShareableDTO shareable, ResourcePropertiesDTO resource) {
            this.selector = selector;
            this.shareable = shareable;
            this.resource = resource;
        }

        public String getSelector() {
            return this.selector;
        }

        public String getSandboxPath() {
            if (this.shareable != null) {
                return this.shareable.getSandboxPath();
            }
            return null;
        }

        public String getRelativePath() {
            return this.getRelativePathToComponent(null);
        }

        public String getRelativePathToComponent() {
            String compName = null;
            if (this.resource != null) {
                ShareDTO share = this.resource.getShare();
                compName = share.getComponentName();
            }
            return this.getRelativePathToComponent(compName);
        }

        public String getRelativePathToComponent(String compName) {
            if (this.shareable != null) {
                List changeSegments = this.shareable.getRelativePath().getSegments();
                if (compName != null && compName.equalsIgnoreCase((String)changeSegments.get(0))) {
                    changeSegments.remove(0);
                }
                String relPath = StringUtil.createPathString((String[])changeSegments.toArray(new String[changeSegments.size()]));
                return relPath;
            }
            return null;
        }

        public String getFullPath() {
            if (this.shareable != null) {
                Path path = new Path(this.shareable.getSandboxPath());
                return path.append(this.getRelativePath()).toOSString();
            }
            return null;
        }

        public String getItemId() {
            if (this.resource != null) {
                return this.resource.getItemId();
            }
            IUuidAliasRegistry.IUuidAlias alias = RepoUtil.lookupUuidAndAlias((String)this.selector);
            if (alias != null) {
                return alias.getUuid().getUuidValue();
            }
            return null;
        }

        public boolean hasItemId() {
            return this.getItemId() != null;
        }

        public boolean hasResourceInfo() {
            return this.resource != null;
        }

        public boolean hasShareInfo() {
            return this.shareable != null;
        }

        public ResourcePropertiesDTO getResourceProperties() {
            return this.resource;
        }
    }
}

