/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdLauncher;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.StatusCmdOpts;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;

public class StatusCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)StatusCmdOpts.OPT_INCLUDE) && cli.hasOption((IOptionKey)StatusCmdOpts.OPT_EXCLUDE)) {
            throw StatusHelper.failure((String)Messages.StatusCmd_BOTH_SPECIFIED, null);
        }
        if (cli.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_CURRENT_PORT) && cli.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_CURRENT_PORT_UNRESOLVED)) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.StatusCmd_BOTH_EXPAND_SPECIFIED, (Object)StatusCmdOpts.OPT_EXPAND_CURRENT_PORT.toString(), (Object)StatusCmdOpts.OPT_EXPAND_CURRENT_PORT_UNRESOLVED.toString()), null);
        }
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ResourcesPlugin.getWorkspace();
        JSONObject root = new JSONObject();
        SubcommandUtil.isCorrupt((JSONObject)root, (subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE) || this.config.isJSONEnabled() ? 1 : 0) != 0, (IScmClientConfiguration)this.config);
        PendingChangesUtil.PendingChangesOptions options = this.getPendingChangesOptions();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        PendingChangesUtil.printPendingChanges((JSONObject)root, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)this.config.getWrappedOutputStream(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        JSONArray status = new JSONArray();
        if (options.isFilesystemOutOfSync()) {
            ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, LoadCmdLauncher.class);
            String outOfSyncMessage = NLS.bind((String)Messages.CheckInCmd_9, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), ((OptionKey)LoadCmdOptions.OPT_FORCE).getName(), ((OptionKey)LoadCmdOptions.OPT_RESYNC).getName()});
            if (!this.config.isJSONEnabled()) {
                this.config.getWrappedOutputStream().println((CharSequence)outOfSyncMessage);
            } else {
                JSONObject warning = new JSONObject();
                warning.put((Object)"code", (Object)8);
                warning.put((Object)"message", (Object)outOfSyncMessage);
                warning.put((Object)"severity", (Object)Constants.Severity.warning.toString());
                status.add((Object)warning);
            }
        }
        if (this.config.isJSONEnabled()) {
            root.put((Object)"status", (Object)status);
            this.config.getOutputStream().print((CharSequence)root.toString());
        }
        if (options.areAllLoadedWorkspaceUnreachable()) {
            throw StatusHelper.returnValue((int)3);
        }
        if (options.isPartialStatus()) {
            throw StatusHelper.partialStatus();
        }
    }

    private void setOption(FilterType filterType, PendingChangesUtil.PendingChangesOptions options, int item) {
        if (filterType == FilterType.EXCLUSION) {
            options.disablePrinter(item);
        } else {
            options.enablePrinter(item);
        }
    }

    private void setIncludeTypeOptions(PendingChangesUtil.PendingChangesOptions options) throws FileSystemException {
        options.enablePrinter(0);
        if (options.isPrinterEnabled(16) || options.isPrinterEnabled(15) || options.isPrinterEnabled(9) || options.isPrinterEnabled(8)) {
            if (options.isPrinterEnabled(16) || options.isPrinterEnabled(15)) {
                options.enablePrinter(11);
            }
            options.enablePrinter(5);
            options.enablePrinter(1);
            options.enablePrinter(4);
            options.enablePrinter(22);
            options.enablePrinter(23);
        }
    }

    private void enableDefaultOptions(PendingChangesUtil.PendingChangesOptions options) {
        options.enablePrinter(0);
        options.enablePrinter(1);
        options.enablePrinter(24);
        options.enablePrinter(25);
        options.enablePrinter(11);
        options.enablePrinter(17);
        options.enablePrinter(2);
        options.enablePrinter(9);
        options.enablePrinter(8);
        options.enablePrinter(10);
        options.enablePrinter(4);
        options.enablePrinter(22);
        options.enablePrinter(23);
        options.enablePrinter(15);
        options.enablePrinter(16);
        options.enablePrinter(5);
        options.enablePrinter(3);
        options.enablePrinter(40);
    }

    private void enableUserSpecifiedOptions(PendingChangesUtil.PendingChangesOptions opts) throws FileSystemException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        boolean xitem = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_ID);
        boolean xbaseline = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_BASELINE);
        boolean xchangeset = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_CHANGESET);
        boolean xcurrentport = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_CURRENT_PORT);
        boolean xunresolved = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_CURRENT_PORT_UNRESOLVED);
        boolean locateConflicts = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_FIND_COMPONENTS_OF_CONFLICTS);
        boolean refreshLocal = SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config) && !subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_NO_LOCAL_REFRESH_DEPRECATED);
        opts.setFilesystemScan(refreshLocal);
        opts.setFilterUnloadedComponents(!subargs.hasOption((IOptionKey)CommonOptions.OPT_ALL));
        opts.setMaxPorts(RepoUtil.getMaxResultsOption((ICommandLine)subargs, (NamedOptionDefinition)StatusCmdOpts.OPT_MAX_PORTS, (String)Messages.StatusCmd_MAX_PORTS_NUMBER_FORMAT_EXCEPTION));
        opts.setShowOutTargetLockedContributor(true);
        if (verbose || this.config.isJSONEnabled()) {
            opts.enablePrinter(13);
            opts.setVerbose(verbose);
        }
        if (xitem || this.config.isJSONEnabled()) {
            opts.enablePrinter(14);
        }
        if (xbaseline || this.config.isJSONEnabled()) {
            opts.enablePrinter(12);
        }
        if (xchangeset || this.config.isJSONEnabled()) {
            opts.enablePrinter(7);
            opts.enablePrinter(21);
            opts.enablePrinter(6);
            opts.enablePrinter(31);
            opts.setMaxChanges(CommonOptions.getMaxChangesToInterpret((IClientConfiguration)this.config));
        }
        if (xcurrentport || xunresolved || this.config.isJSONEnabled()) {
            opts.enablePrinter(32);
        }
        if (xunresolved || this.config.isJSONEnabled()) {
            opts.enablePrinter(33);
        }
        if (locateConflicts) {
            opts.enablePrinter(42);
        }
    }

    private PendingChangesUtil.PendingChangesOptions getPendingChangesOptions() throws FileSystemException {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        this.enableUserSpecifiedOptions(options);
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (!cli.hasOption((IOptionKey)StatusCmdOpts.OPT_INCLUDE)) {
            this.enableDefaultOptions(options);
            if (!cli.hasOption((IOptionKey)StatusCmdOpts.OPT_EXCLUDE)) {
                return options;
            }
        }
        int idx = 0;
        int nextDirChar = 32;
        boolean endofDir = false;
        Direction currentFilterDir = Direction.INCOMING;
        FilterType filterType = cli.hasOption((IOptionKey)StatusCmdOpts.OPT_INCLUDE) ? FilterType.INCLUSION : FilterType.EXCLUSION;
        String str = cli.hasOption((IOptionKey)StatusCmdOpts.OPT_INCLUDE) ? cli.getOption((IOptionKey)StatusCmdOpts.OPT_INCLUDE) : cli.getOption((IOptionKey)StatusCmdOpts.OPT_EXCLUDE);
        if ((str = str.trim().replace("\"", "")).length() > 2 && str.substring(0, 3).equals(Direction.INCOMING.getDirectionValue())) {
            nextDirChar = 111;
            idx = 3;
        } else if (str.length() > 3 && str.substring(0, 4).equals(Direction.OUTGOING.getDirectionValue())) {
            currentFilterDir = Direction.OUTGOING;
            nextDirChar = 105;
            idx = 4;
        } else {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.StatusCmd_INVALID_DIRECTION, (Object[])new String[]{Direction.INCOMING.getDirectionValue(), Direction.OUTGOING.getDirectionValue()}), null);
        }
        if (str.length() <= idx) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.StatusCmd_NO_FILTER_VALUE, (Object)currentFilterDir.getDirectionName()), null);
        }
        do {
            if (str.charAt(idx) == 'c') {
                if (currentFilterDir == Direction.INCOMING) {
                    this.setOption(filterType, options, 9);
                } else {
                    this.setOption(filterType, options, 8);
                }
            } else if (str.charAt(idx) == 'b') {
                if (currentFilterDir == Direction.INCOMING) {
                    this.setOption(filterType, options, 16);
                } else {
                    this.setOption(filterType, options, 15);
                }
            } else if (str.charAt(idx) == 'C') {
                if (currentFilterDir == Direction.INCOMING) {
                    this.setOption(filterType, options, 24);
                } else {
                    this.setOption(filterType, options, 25);
                }
            } else if (str.charAt(idx) == nextDirChar) {
                if (nextDirChar == 122) continue;
                boolean fail = false;
                if (nextDirChar == 105) {
                    if (str.length() <= idx + 2 || !Direction.INCOMING.getDirectionValue().equals(str.substring(idx, idx + 3))) {
                        fail = true;
                    } else {
                        currentFilterDir = Direction.INCOMING;
                        idx += 2;
                    }
                } else if (nextDirChar == 111) {
                    if (str.length() <= idx + 3 || !Direction.OUTGOING.getDirectionValue().equals(str.substring(idx, idx + 4))) {
                        fail = true;
                    } else {
                        currentFilterDir = Direction.OUTGOING;
                        idx += 3;
                    }
                }
                if (fail || endofDir) {
                    throw StatusHelper.failure((String)NLS.bind((String)Messages.StatusCmd_INVALID_DIRECTION, (Object[])new String[]{Direction.INCOMING.getDirectionValue(), Direction.OUTGOING.getDirectionValue()}), null);
                }
                if (str.length() <= idx + 1) {
                    throw StatusHelper.failure((String)NLS.bind((String)Messages.StatusCmd_NO_FILTER_VALUE, (Object)currentFilterDir.getDirectionName()), null);
                }
                endofDir = true;
                nextDirChar = 122;
            }
            ++idx;
        } while (idx < str.length());
        if (filterType == FilterType.INCLUSION) {
            this.setIncludeTypeOptions(options);
        }
        return options;
    }

    public static enum Direction {
        INCOMING("incoming", "in:"),
        OUTGOING("outgoing", "out:");

        private final String directionValue;
        private final String directionName;

        private Direction(String directionName, String directionValue) {
            this.directionName = directionName;
            this.directionValue = directionValue;
        }

        public String getDirectionValue() {
            return this.directionValue;
        }

        public String getDirectionName() {
            return this.directionName;
        }
    }

    public static enum FilterType {
        INCLUSION,
        EXCLUSION;

    }
}

