/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdLauncher;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.SandboxStructureCmdOpts;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class SandboxStructureCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        File cfaRoot = SubcommandUtil.findAncestorCFARoot((String)this.config.getContext().getCurrentWorkingDirectory());
        if (cfaRoot == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.SandboxStructureCmd_INVALID_SANDBOX, (Object)CommonOptions.OPT_DIRECTORY));
        }
        JSONObject root = new JSONObject();
        SubcommandUtil.isCorrupt((JSONObject)root, (boolean)false, (IScmClientConfiguration)this.config);
        ScmCommandLineArgument wsSelector = null;
        if (cli.hasOption((IOptionKey)SandboxStructureCmdOpts.OPT_WORKSPACE)) {
            wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)SandboxStructureCmdOpts.OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE});
        }
        ScmCommandLineArgument compSelector = null;
        if (cli.hasOption((IOptionKey)SandboxStructureCmdOpts.OPT_COMPONENT)) {
            compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)SandboxStructureCmdOpts.OPT_COMPONENT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(17);
        options.enablePrinter(0);
        if (wsSelector != null) {
            ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            options.addFilter((IItemHandle)wsFound, 0);
        }
        JSONObject pendingChanges = JSONPrintUtil.jsonizePendingChanges((PendingChangesUtil.PendingChangesOptions)options, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        JSONArray activeWsArr = (JSONArray)pendingChanges.get((Object)"workspaces");
        JSONArray unreachableWsArr = (JSONArray)pendingChanges.get((Object)"unreachable-workspaces");
        if (activeWsArr != null && activeWsArr.size() == 0 && unreachableWsArr != null && unreachableWsArr.size() == 0) {
            throw StatusHelper.misconfiguredLocalFS((String)Messages.SandboxStructureCmd_LOADED_WS_NOT_FOUND);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        JSONArray jShares = new JSONArray();
        ArrayList<IPath> sharePaths = new ArrayList<IPath>();
        boolean compFound = false;
        if (activeWsArr != null) {
            for (Object val : activeWsArr) {
                JSONObject ws = (JSONObject)val;
                if ((JSONArray)ws.get((Object)"out-of-sync") != null) {
                    options.setFilesystemOutOfSync(true);
                }
                if (wsSelector != null && !this.isWorkspaceInSandbox((IScmCommandLineArgument)wsSelector, ws)) continue;
                WorkspaceComponentDTO comp = null;
                String wsId = (String)ws.get((Object)"uuid");
                String wsUrl = (String)ws.get((Object)"url");
                if (compSelector != null) {
                    block17: {
                        ParmsWorkspace wsParms = new ParmsWorkspace(wsUrl, wsId);
                        try {
                            comp = RepoUtil.getComponent((ParmsWorkspace)wsParms, (String)compSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                            if (comp != null) {
                                compFound = true;
                            }
                            if (!this.isComponentInWorkspace(comp, ws, client)) {
                            }
                            break block17;
                        }
                        catch (CLIFileSystemClientException exp) {
                            if (!compFound) break block17;
                        }
                        continue;
                    }
                    if (!compFound) {
                        throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.SandboxStructureCmd_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
                    }
                }
                List shares = RepoUtil.getSharesInSandbox((String)wsId, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                for (ShareDTO share : shares) {
                    if (comp != null && !comp.getItemId().equals(share.getComponentItemId())) continue;
                    this.populateSharePaths(share, sharePaths);
                }
            }
        }
        unreachableWsArr = (JSONArray)pendingChanges.get((Object)"unreachable-workspaces");
        this.populateShareJson(jShares, sharePaths, client);
        this.showResult(root, jShares, cfaRoot.getAbsolutePath(), out, unreachableWsArr, options.isFilesystemOutOfSync());
        if (options.areAllLoadedWorkspaceUnreachable()) {
            throw StatusHelper.returnValue((int)3);
        }
        if (options.isPartialStatus()) {
            throw StatusHelper.partialStatus();
        }
    }

    private void populateSharePaths(ShareDTO share, List<IPath> sharePaths) {
        Path sharePath = new Path(share.getSandboxPath());
        PathDTO sharePathDto = share.getPath();
        for (String segment : sharePathDto.getSegments()) {
            sharePath = sharePath.append(segment);
        }
        sharePaths.add((IPath)sharePath);
    }

    private void populateShareJson(JSONArray jShares, List<IPath> sharePaths, IFilesystemRestClient client) {
        ArrayList<String> localPaths = new ArrayList<String>();
        for (IPath sharePath : sharePaths) {
            localPaths.add(sharePath.toOSString());
        }
        ParmsResourceProperties parms = new ParmsResourceProperties();
        parms.fullResourcePaths = localPaths.toArray(new String[localPaths.size()]);
        parms.computeFully = true;
        try {
            ResourcesDTO resources = client.postFetchResourceProperties(parms, null);
            for (ResourcePropertiesDTO properties : resources.getResourceProperties()) {
                String localPath = properties.getFullPath();
                PathDTO remotePathDto = properties.getRemotePath();
                if (remotePathDto == null) continue;
                Path shareRemotePath = new Path("");
                for (String segment : remotePathDto.getSegments()) {
                    shareRemotePath = shareRemotePath.append(segment);
                }
                StringBuilder remotePath = new StringBuilder(shareRemotePath.toOSString());
                if (properties.getShare().getRootVersionableItemType().equals("folder")) {
                    remotePath.append('/');
                }
                JSONObject remoteJson = new JSONObject();
                JSONObject jShare = new JSONObject();
                JSONObject workspaceJson = new JSONObject();
                JSONObject componentJson = new JSONObject();
                JSONObject pathJson = new JSONObject();
                jShare.put((Object)"local", (Object)localPath);
                pathJson.put((Object)"path", (Object)remotePath.toString());
                pathJson.put((Object)"uuid", (Object)properties.getShare().getRootVersionableItemId());
                pathJson.put((Object)"type", (Object)properties.getShare().getRootVersionableItemType());
                workspaceJson.put((Object)"name", (Object)properties.getShare().getContextName());
                workspaceJson.put((Object)"uuid", (Object)properties.getShare().getContextItemId());
                componentJson.put((Object)"name", (Object)properties.getShare().getComponentName());
                componentJson.put((Object)"uuid", (Object)properties.getShare().getComponentItemId());
                remoteJson.put((Object)"workspace", (Object)workspaceJson);
                remoteJson.put((Object)"component", (Object)componentJson);
                remoteJson.put((Object)"path", (Object)pathJson);
                jShare.put((Object)"remote", (Object)remoteJson);
                jShares.add((Object)jShare);
            }
        }
        catch (TeamRepositoryException e) {
            StatusHelper.propertiesUnavailable((String)Messages.SandboxStructureCmd_COULD_NOT_FETCH_PROPERTIES);
        }
    }

    private void showResult(JSONObject root, JSONArray shares, String sandboxRoot, IndentingPrintStream out, JSONArray unreachableWsArr, boolean isFilesystemOutOfSync) {
        String outOfSyncMessage = null;
        if (isFilesystemOutOfSync) {
            ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, LoadCmdLauncher.class);
            outOfSyncMessage = NLS.bind((String)Messages.CheckInCmd_9, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), ((OptionKey)LoadCmdOptions.OPT_FORCE).getName(), ((OptionKey)LoadCmdOptions.OPT_RESYNC).getName()});
        }
        if (this.config.isJSONEnabled()) {
            JSONArray array = new JSONArray();
            array.addAll((Collection)shares);
            root.put((Object)"sandbox", (Object)sandboxRoot);
            root.put((Object)"shares", (Object)array);
            JSONArray status = new JSONArray();
            if (isFilesystemOutOfSync) {
                JSONObject warning = new JSONObject();
                warning.put((Object)"code", (Object)8);
                warning.put((Object)"message", (Object)outOfSyncMessage);
                warning.put((Object)"severity", (Object)Constants.Severity.warning.toString());
                status.add((Object)warning);
            }
            root.put((Object)"status", (Object)status);
            if (unreachableWsArr != null && unreachableWsArr.size() > 0) {
                root.put((Object)"unreachable-workspaces", (Object)unreachableWsArr);
            }
            this.config.getOutputStream().print((CharSequence)root.toString());
            return;
        }
        out.println((CharSequence)(String.valueOf(Messages.SandboxStructureCmd_SANDBOX) + sandboxRoot));
        out = out.indent();
        if (shares.size() == 0) {
            out.println((CharSequence)Messages.SandboxStructureCmd_PROJECTS_NOT_FOUND);
        }
        for (Object share : shares) {
            JSONObject result = (JSONObject)share;
            out.println((CharSequence)(String.valueOf(Messages.SandboxStructureCmd_LOCAL) + (String)result.get((Object)"local")));
            JSONObject remotePathObj = (JSONObject)result.get((Object)"remote");
            String workspace = (String)((JSONObject)remotePathObj.get((Object)"workspace")).get((Object)"name");
            String component = (String)((JSONObject)remotePathObj.get((Object)"component")).get((Object)"name");
            String path = (String)((JSONObject)remotePathObj.get((Object)"path")).get((Object)"path");
            String remotePath = String.valueOf(workspace) + '/' + component + '/';
            if (!path.equals("/")) {
                remotePath = String.valueOf(remotePath) + path;
            }
            out.indent().println((CharSequence)(String.valueOf(Messages.SandboxStructureCmd_REMOTE) + remotePath));
        }
        if (unreachableWsArr != null && unreachableWsArr.size() > 0) {
            PendingChangesUtil.printUnreacableWorkspaces((JSONArray)unreachableWsArr, (IndentingPrintStream)out, (IScmClientConfiguration)this.config);
        }
        if (isFilesystemOutOfSync) {
            this.config.getWrappedOutputStream().println((CharSequence)outOfSyncMessage);
        }
    }

    private boolean isWorkspaceInSandbox(IScmCommandLineArgument sourceSelector, JSONObject ws) {
        IUuidAliasRegistry.IUuidAlias uuidAlias = RepoUtil.lookupUuidAndAlias((String)sourceSelector.getItemSelector());
        if (uuidAlias != null) {
            String uuid = (String)ws.get((Object)"uuid");
            if (uuidAlias.getUuid().toString().equals(uuid)) {
                return true;
            }
        } else {
            String name = (String)ws.get((Object)"name");
            if (sourceSelector.getItemSelector().equals(name)) {
                return true;
            }
        }
        return false;
    }

    private boolean isComponentInWorkspace(WorkspaceComponentDTO comp, JSONObject ws, IFilesystemRestClient client) {
        String wsId = (String)ws.get((Object)"uuid");
        Map comps = new HashMap();
        try {
            comps = RepoUtil.getComponentsInSandbox((String)wsId, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return comps.size() > 0 && comps.keySet().contains(comp.getItemId());
    }
}

