/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ExternalToolUtils;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.InPlaceConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.portcommand.AbstractPortSubcommand;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmdOpts;
import com.ibm.team.filesystem.cli.client.internal.subcommands.UndoCmd;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ITypedPreferenceRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAutoMerge;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCommitDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConflictedItemToResolve;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConflictsToResolve;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConflictsToResolveWithProposed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsExternalTool;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLocalConflictToResolve;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMissingStorageMergerDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveAsMerged;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveLocalConflicts;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveWithProposed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoLocalChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoLocalChangesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.AutoResolveLocalConflictsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ConflictedChangeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.FailedMergeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveAsMergedResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveAutoMergeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveWithProposedResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.UpdateCurrentPatchResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ConflictSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.LocalConflictSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.UnresolvedFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenConflictInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ResolveCmd
extends AbstractSubcommand {
    private final char COMPONENT_DELIMITER = (char)47;

    public void run() throws FileSystemException {
        Map<ParmsWorkspace, List<ConflictToResolve>> ws2ConflictItemsMap;
        List<String> resources;
        String commandName;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        Mode mode = Mode.UNDEFINED;
        Operation operation = Operation.NORESOLUTION;
        int defined = 0;
        String opt_option = null;
        if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_AUTO)) {
            ++defined;
            mode = Mode.AUTO;
        }
        if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_MERGED)) {
            ++defined;
            mode = Mode.MERGED;
            opt_option = ResolveCmdOpts.OPT_RESOLVE_MERGED.getName();
        }
        if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_PROPOSED)) {
            ++defined;
            mode = Mode.PROPOSED;
            opt_option = ResolveCmdOpts.OPT_RESOLVE_PROPOSED.getName();
        }
        if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_EXTERNAL_COMPARE)) {
            ++defined;
            mode = Mode.COMPARE;
            opt_option = ResolveCmdOpts.OPT_RESOLVE_EXTERNAL_COMPARE.getName();
        }
        if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_MOVE)) {
            ++defined;
            mode = Mode.MOVE;
            opt_option = ResolveCmdOpts.OPT_RESOLVE_MOVE.getName();
        }
        if (subargs.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER)) {
            switch (mode) {
                case AUTO: {
                    mode = Mode.AUTO_INLINE_MARKERS;
                    break;
                }
                case MERGED: 
                case PROPOSED: 
                case COMPARE: 
                case MOVE: {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_6, (Object[])new String[]{opt_option, AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER.getName()}));
                }
                default: {
                    mode = Mode.INLINE_MARKERS;
                }
            }
        }
        if (mode == Mode.INLINE_MARKERS && !subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_LOCAL)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_INVALID_INPLACE_CONFLICT_MARKER_REQUEST, (Object)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER.getName()));
        }
        if (defined > 1 || defined == 0 && (mode != Mode.INLINE_MARKERS || !subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_LOCAL))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_1, (Object[])new String[]{ResolveCmdOpts.OPT_RESOLVE_MERGED.getName(), ResolveCmdOpts.OPT_RESOLVE_PROPOSED.getName(), ResolveCmdOpts.OPT_RESOLVE_AUTO.getName(), ResolveCmdOpts.OPT_RESOLVE_EXTERNAL_COMPARE.getName(), ResolveCmdOpts.OPT_RESOLVE_MOVE.getName()}));
        }
        if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_RESTORE_DELETED) && mode != Mode.PROPOSED) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_NEED_PROPOSED, (Object[])new String[]{ResolveCmdOpts.OPT_RESOLVE_RESTORE_DELETED.getName(), ResolveCmdOpts.OPT_RESOLVE_PROPOSED.getName()}));
        }
        String externalCompareTool = null;
        if (mode == Mode.AUTO || mode == Mode.AUTO_INLINE_MARKERS) {
            if (!subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_LOCAL) && subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_TO_RESOLVE)) {
                commandName = SubcommandUtil.getExecutionString((ISubcommandDefinition)this.config.getSubcommandDefinition()).toString();
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_EXTRA_ARGUMENTS, (Object)commandName, (Object)ResolveCmdOpts.OPT_TO_RESOLVE.getName()));
            }
            if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_LOCAL) && !subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_TO_RESOLVE)) {
                commandName = SubcommandUtil.getExecutionString((ISubcommandDefinition)this.config.getSubcommandDefinition()).toString();
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_MISSING_ARGUMENTS, (Object)commandName, (Object)ResolveCmdOpts.OPT_TO_RESOLVE.getName()));
            }
        } else if (mode == Mode.COMPARE) {
            if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_TO_RESOLVE)) {
                throw StatusHelper.argSyntax((String)Messages.ResolveCmd_EXTERNAL_COMPARE_ONE_FILE);
            }
            externalCompareTool = ExternalToolUtils.getExternalCompareTool((ScmClientConfiguration)this.config, true);
        } else if (!(mode != Mode.MERGED && mode != Mode.PROPOSED && mode != Mode.MOVE || subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_TO_RESOLVE))) {
            commandName = SubcommandUtil.getExecutionString((ISubcommandDefinition)this.config.getSubcommandDefinition()).toString();
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_MISSING_ARGUMENTS, (Object)commandName, (Object)ResolveCmdOpts.OPT_TO_RESOLVE.getName()));
        }
        ResourcesPlugin.getWorkspace();
        File cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)this.config.getContext().getCurrentWorkingDirectory());
        if (cfaRootPath == null && (mode == Mode.AUTO || mode == Mode.AUTO_INLINE_MARKERS)) {
            throw StatusHelper.argSyntax((String)Messages.ResolveCmd_INVALID_SANDBOX);
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        HashMap<String, ISandboxWorkspace> wsIdtoWsInSandboxMap = new HashMap<String, ISandboxWorkspace>();
        for (ISandboxWorkspace wsInSandbox : wsInSandboxList) {
            wsIdtoWsInSandboxMap.put(wsInSandbox.getWorkspaceItemId(), wsInSandbox);
        }
        List<UndoCmd.Change> changesToResolveList = null;
        if (mode != Mode.AUTO && mode != Mode.AUTO_INLINE_MARKERS) {
            resources = mode == Mode.COMPARE ? Collections.singletonList(subargs.getOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_EXTERNAL_COMPARE)) : subargs.getOptions((IOptionKey)ResolveCmdOpts.OPT_TO_RESOLVE);
            this.checkIfInvalidSandbox(resources);
            changesToResolveList = this.getChangesToResolve(wsIdtoWsInSandboxMap, client, resources);
        } else if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_LOCAL)) {
            resources = subargs.getOptions((IOptionKey)ResolveCmdOpts.OPT_TO_RESOLVE);
            this.checkIfInvalidSandbox(resources);
            changesToResolveList = this.getChangesToResolve(wsIdtoWsInSandboxMap, client, subargs.getOptions((IOptionKey)ResolveCmdOpts.OPT_TO_RESOLVE));
        }
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>(wsIdtoWsInSandboxMap.values().size());
        for (ISandboxWorkspace wsInSandbox : wsIdtoWsInSandboxMap.values()) {
            String uri = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(uri));
            wsList.add(new ParmsWorkspace(uri, wsInSandbox.getWorkspaceItemId()));
        }
        SyncViewDTO syncView = SubcommandUtil.getSyncView(wsList, (boolean)true, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_LOCAL)) {
            operation = Operation.RESOLVE;
            switch (mode) {
                case MERGED: {
                    ws2ConflictItemsMap = this.findLocalConflictsToResolve(syncView, changesToResolveList, client, this.config);
                    this.resolveLocalConflictsAsMerged(ws2ConflictItemsMap, client, this.config);
                    break;
                }
                case PROPOSED: {
                    List<ParmsUndoLocalChangesRequest> undoLocalChangeRequests = this.generateUndoLocalChangeRequests(changesToResolveList, syncView, client, this.config);
                    this.resolveLocalConflictsAsProposed(undoLocalChangeRequests, client, this.config);
                    break;
                }
                case AUTO: 
                case AUTO_INLINE_MARKERS: {
                    ws2ConflictItemsMap = this.findLocalConflictsToResolve(syncView, changesToResolveList, client, this.config);
                    this.resolveAutomaticallyLocalConflicts(ws2ConflictItemsMap, client, this.config, subargs);
                    break;
                }
                case INLINE_MARKERS: {
                    ws2ConflictItemsMap = this.findLocalConflictsToResolve(syncView, changesToResolveList, client, this.config);
                    this.resolveLocalConflictsInlineMarkers(ws2ConflictItemsMap, client, this.config, subargs);
                    break;
                }
                case COMPARE: {
                    ws2ConflictItemsMap = this.findLocalConflictsToResolve(syncView, changesToResolveList, client, this.config);
                    LocalConflictToResolve conflict = (LocalConflictToResolve)ws2ConflictItemsMap.values().iterator().next().get(0);
                    ResolveCmd.resolveExternally(conflict.conflictItem, client, this.config, subargs, externalCompareTool);
                    operation = Operation.NORESOLUTION;
                }
            }
            if (operation == Operation.RESOLVE) {
                this.config.getWrappedOutputStream().println((CharSequence)Messages.ResolveCmd_Success);
            }
            return;
        }
        ws2ConflictItemsMap = this.findConflictsToResolve(syncView, changesToResolveList, client, this.config);
        operation = this.checkIfResolutionisRequired(ws2ConflictItemsMap);
        if (operation == Operation.RESOLVE) {
            switch (mode) {
                case MERGED: {
                    this.resolveAsMerged(ws2ConflictItemsMap, client, this.config);
                    break;
                }
                case PROPOSED: {
                    if (subargs.hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_RESTORE_DELETED)) {
                        this.resolveAsProposed(ws2ConflictItemsMap, client, this.config, true);
                        break;
                    }
                    this.resolveAsProposed(ws2ConflictItemsMap, client, this.config, false);
                    break;
                }
                case MOVE: {
                    List<ConflictToResolve> conflictsToMove = null;
                    ParmsWorkspace ws = null;
                    if (ws2ConflictItemsMap.size() != 1) {
                        throw StatusHelper.argSyntax((String)Messages.ResolveCmd_0);
                    }
                    for (Map.Entry<ParmsWorkspace, List<ConflictToResolve>> entry : ws2ConflictItemsMap.entrySet()) {
                        ws = entry.getKey();
                        conflictsToMove = entry.getValue();
                    }
                    String compSelector = subargs.getOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_MOVE);
                    WorkspaceComponentDTO component = RepoUtil.getComponent((ParmsWorkspace)ws, (String)compSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                    this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ResolveCmd_3, (Object)component.getName()));
                    this.createCurrentPatch(ws, component, conflictsToMove, client, this.config);
                    this.config.getWrappedOutputStream().println((CharSequence)Messages.ResolveCmd_5);
                    operation = Operation.NORESOLUTION;
                    break;
                }
                case COMPARE: {
                    operation = Operation.NORESOLUTION;
                    ConflictToResolve conflict = (ConflictToResolve)((Object)ws2ConflictItemsMap.values().iterator().next().get(0));
                    ResolveCmd.resolveExternally(conflict.conflictItem, client, this.config, subargs, externalCompareTool);
                    break;
                }
                case AUTO: 
                case AUTO_INLINE_MARKERS: {
                    this.resolveAutomatically(ws2ConflictItemsMap, client, this.config, subargs);
                    break;
                }
                case INLINE_MARKERS: {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_INVALID_INPLACE_CONFLICT_MARKER_REQUEST, (Object)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER.getName()));
                }
            }
            if (operation == Operation.RESOLVE) {
                this.config.getWrappedOutputStream().println((CharSequence)Messages.ResolveCmd_Success);
            }
        }
    }

    private Operation checkIfResolutionisRequired(Map<ParmsWorkspace, List<ConflictToResolve>> ws2ConflictItemsMap) {
        if (ws2ConflictItemsMap.isEmpty()) {
            this.config.getWrappedOutputStream().println((CharSequence)Messages.ResolveCmd_No_CONFLICTS);
        }
        for (Map.Entry<ParmsWorkspace, List<ConflictToResolve>> entry : ws2ConflictItemsMap.entrySet()) {
            List<ConflictToResolve> conflictsToResolve = entry.getValue();
            if (conflictsToResolve.isEmpty()) continue;
            return Operation.RESOLVE;
        }
        return Operation.NORESOLUTION;
    }

    private void createCurrentPatch(ParmsWorkspace ws, WorkspaceComponentDTO component, List<ConflictToResolve> conflictsToMove, IFilesystemRestClient client, IScmClientConfiguration config) throws CLIFileSystemClientException, FileSystemException {
        UpdateCurrentPatchResultDTO result;
        ParmsCreateCurrentPatch parms = new ParmsCreateCurrentPatch();
        parms.workspace = ws;
        parms.componentItemId = component.getItemId();
        parms.conflicts = new ParmsConflictsToResolve[conflictsToMove.size()];
        int i = 0;
        for (ConflictToResolve conflictToResolve : conflictsToMove) {
            ParmsConflictsToResolve conflictParm = new ParmsConflictsToResolve();
            conflictParm.versionableItemId = conflictToResolve.getConflictItem().getVersionableItemId();
            conflictParm.conflictType = conflictToResolve.getConflictItem().getConflictType();
            conflictParm.kind = conflictToResolve.getConflictItem().getKind();
            conflictParm.componentItemId = conflictToResolve.getComponentId();
            parms.conflicts[i++] = conflictParm;
        }
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = "no";
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        try {
            result = client.postCreateCurrentPatch(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ResolveCmd_2, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.workspace.repositoryUrl);
        }
        if (result.isCancelled() && result.getOutOfSyncShares().size() > 0) {
            AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
        }
        if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
            SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)config.getWrappedOutputStream());
        }
        IndentingPrintStream out = config.getWrappedOutputStream();
        AbstractPortSubcommand.printPorts(ws, component.getItemId(), client, out, config);
    }

    private List<UndoCmd.Change> getChangesToResolve(Map<String, ISandboxWorkspace> wsIdtoWsInSandboxMap, IFilesystemRestClient client, List<String> resources) throws FileSystemException {
        List<UndoCmd.Change> remainingChangesToResolveList;
        ArrayList<String> unProcessedResources = new ArrayList<String>();
        List<UndoCmd.Change> changesToResolveList = this.getChangesToResolve(wsIdtoWsInSandboxMap, client, resources, false, unProcessedResources);
        if (unProcessedResources.size() > 0 && (remainingChangesToResolveList = this.getChangesToResolve(wsIdtoWsInSandboxMap, client, resources, true, null)).size() > 0) {
            changesToResolveList.addAll(remainingChangesToResolveList);
        }
        return changesToResolveList;
    }

    private void checkIfInvalidSandbox(List<String> pathsToCheck) throws FileSystemException {
        ArrayList<String> invalidPath = new ArrayList<String>();
        for (String resource : pathsToCheck) {
            ILocation changePathComp;
            String compResource = this.splitComponentAndItem(resource, null, null)[1];
            IUuidAliasRegistry.IUuidAlias isUuidAlias1 = RepoUtil.lookupUuidAndAlias((String)resource);
            if (isUuidAlias1 != null) continue;
            ILocation changePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)resource);
            File cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)changePath.toString());
            IUuidAliasRegistry.IUuidAlias isUuidAlias2 = RepoUtil.lookupUuidAndAlias((String)compResource);
            if (cfaRootPath != null || isUuidAlias2 != null || (cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)(changePathComp = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)compResource)).toString())) != null) continue;
            invalidPath.add(resource);
        }
        if (!invalidPath.isEmpty()) {
            IndentingPrintStream stream = this.config.getWrappedErrorStream();
            stream.println((CharSequence)Messages.ResolveCmd_INVALID_SANDBOX_ARGUMENT_1);
            for (String path : invalidPath) {
                stream.indent().println((CharSequence)path);
            }
            throw StatusHelper.inappropriateArgument((String)Messages.ResolveCmd_INVALID_SANDBOX_ARGUMENT_2);
        }
    }

    private List<UndoCmd.Change> getChangesToResolve(Map<String, ISandboxWorkspace> wsIdtoWsInSandboxMap, IFilesystemRestClient client, List<String> resources, boolean componentPrefixMode, List<String> unprocessedResources) throws FileSystemException {
        if (unprocessedResources != null) {
            unprocessedResources.clear();
        }
        ArrayList<Resource> resourceList = new ArrayList<Resource>(resources.size());
        Iterator<String> iterator = resources.iterator();
        while (iterator.hasNext()) {
            String resource;
            String selector = resource = iterator.next();
            String componentSelector = null;
            if (componentPrefixMode) {
                String[] result = this.splitComponentAndItem(resource, null, null);
                componentSelector = result[0];
                selector = result[1];
            }
            ILocation changePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)selector);
            String osPath = changePath.toOSString();
            resourceList.add(new Resource(resource, osPath, componentSelector));
        }
        ParmsSandboxPaths parmsPaths = new ParmsSandboxPaths();
        parmsPaths.includeNonRegisteredSandboxes = true;
        parmsPaths.pathsToResolve = new String[resourceList.size()];
        int count = 0;
        while (count < resourceList.size()) {
            parmsPaths.pathsToResolve[count] = ((Resource)resourceList.get((int)count)).osPath;
            ++count;
        }
        SandboxPathsResultDTO pathsResult = null;
        try {
            pathsResult = client.getSandboxPaths(parmsPaths, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.Common_UNABLE_TO_GET_SANDBOX_PATHS, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), null);
        }
        ArrayList<UndoCmd.Change> changesToResolveList = new ArrayList<UndoCmd.Change>();
        int count2 = 0;
        for (ShareableDTO shareable : pathsResult.getPaths()) {
            Resource resource = (Resource)resourceList.get(count2);
            ResourcePropertiesDTO resourceProps = null;
            boolean foundShareable = false;
            if (shareable.getSandboxPath() != null && shareable.getSandboxPath().length() > 0 && shareable.getRelativePath() != null && shareable.getRelativePath().getSegments().size() > 0) {
                try {
                    resourceProps = RepoUtil.getResourceProperties((String)resource.osPath, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                    ShareDTO share = resourceProps.getShare();
                    if (!wsIdtoWsInSandboxMap.keySet().contains(share.getContextItemId())) {
                        wsIdtoWsInSandboxMap.put(share.getContextItemId(), (ISandboxWorkspace)new SandboxWorkspace(share.getContextItemId(), share.getContextName(), share.getRepositoryId()));
                    }
                    if (componentPrefixMode) {
                        if (resource.componentSelector != null) {
                            ITeamRepository repository = RepoUtil.getTeamRepository((UUID)UUID.valueOf((String)share.getRepositoryId()));
                            RepoUtil.getComponent((ParmsWorkspace)new ParmsWorkspace(repository.getRepositoryURI(), share.getContextItemId()), (String)resource.componentSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                            foundShareable = true;
                        }
                    } else {
                        foundShareable = true;
                    }
                    if (foundShareable) {
                        changesToResolveList.add(new UndoCmd.Change(resource.selector, shareable, resourceProps));
                    }
                }
                catch (Exception share) {
                    // empty catch block
                }
            }
            if (!foundShareable) {
                IUuidAliasRegistry.IUuidAlias uuidAlias = RepoUtil.lookupUuidAndAlias((String)resource.selector);
                if (uuidAlias != null || componentPrefixMode) {
                    changesToResolveList.add(new UndoCmd.Change(resource.selector, null, null));
                } else if (unprocessedResources != null) {
                    unprocessedResources.add(resource.selector);
                }
            }
            ++count2;
        }
        return changesToResolveList;
    }

    private void resolveAsProposed(Map<ParmsWorkspace, List<ConflictToResolve>> ws2ConflictItemsMap, IFilesystemRestClient client, IScmClientConfiguration config, boolean restore) throws FileSystemException {
        for (Map.Entry<ParmsWorkspace, List<ConflictToResolve>> entry : ws2ConflictItemsMap.entrySet()) {
            ResolveWithProposedResultDTO result;
            ParmsResolveWithProposed parms = new ParmsResolveWithProposed();
            parms.workspace = entry.getKey();
            ArrayList<ParmsConflictsToResolveWithProposed> conflictsToResolve = new ArrayList<ParmsConflictsToResolveWithProposed>();
            for (ConflictToResolve conflict : entry.getValue()) {
                ParmsConflictsToResolveWithProposed parmsConflict = new ParmsConflictsToResolveWithProposed();
                parmsConflict.componentItemId = conflict.getComponentId();
                parmsConflict.versionableItemId = conflict.getConflictItem().getVersionableItemId();
                parmsConflict.kind = conflict.getConflictItem().getKind();
                parmsConflict.conflictType = conflict.getConflictItem().getConflictType();
                if (conflict.getConflictItem().getConflictType().equals("modify_delete")) {
                    if (restore) {
                        parmsConflict.newParentFolderItemId = conflict.getConflictItem().getParentItemId();
                        parmsConflict.newName = conflict.getConflictItem().getName();
                    } else {
                        String commandName = SubcommandUtil.getExecutionString((ISubcommandDefinition)config.getSubcommandDefinition()).toString();
                        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_MISSING_RESTORE_ARGUMENT, (Object)commandName, (Object)ResolveCmdOpts.OPT_RESOLVE_RESTORE_DELETED.getName()));
                    }
                }
                conflictsToResolve.add(parmsConflict);
            }
            parms.conflictsToResolve = conflictsToResolve.toArray(new ParmsConflictsToResolveWithProposed[conflictsToResolve.size()]);
            parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
            parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
            parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
            parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
            parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
            parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
            parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
            parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
            parms.missingRequiredChangesDilemmaHandler = "cancel";
            if (config.getSubcommandCommandLine().hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_DEPENDENT)) {
                parms.missingRequiredChangesDilemmaHandler = "continue";
            }
            try {
                result = client.postResolveWithProposed(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ResolveCmd_4, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.workspace.repositoryUrl);
            }
            if (result.isCancelled()) {
                int noOfMissingRequiredChanges;
                if (result.getOutOfSyncShares().size() > 0) {
                    AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
                }
                if ((noOfMissingRequiredChanges = result.getMissingRequiredChanges().size()) > 0) {
                    String repoUri = parms.workspace.repositoryUrl;
                    this.showMissingRequiredChanges(result.getMissingRequiredChanges(), repoUri);
                }
            }
            if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() <= 0) continue;
            SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)config.getWrappedOutputStream());
        }
    }

    private void resolveAsMerged(Map<ParmsWorkspace, List<ConflictToResolve>> ws2ConflictItemsMap, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        for (Map.Entry<ParmsWorkspace, List<ConflictToResolve>> entry : ws2ConflictItemsMap.entrySet()) {
            int noOfUncheckedInChanges;
            ResolveAsMergedResultDTO result;
            ParmsResolveAsMerged parms = new ParmsResolveAsMerged();
            parms.workspace = entry.getKey();
            ArrayList<ParmsConflictsToResolve> conflictsToResolve = new ArrayList<ParmsConflictsToResolve>();
            for (ConflictToResolve conflict : entry.getValue()) {
                ParmsConflictsToResolve parmsConflict = new ParmsConflictsToResolve();
                parmsConflict.componentItemId = conflict.getComponentId();
                parmsConflict.versionableItemId = conflict.getConflictItem().getVersionableItemId();
                parmsConflict.kind = conflict.getConflictItem().getKind();
                parmsConflict.conflictType = conflict.getConflictItem().getConflictType();
                conflictsToResolve.add(parmsConflict);
            }
            parms.conflictsToResolve = conflictsToResolve.toArray(new ParmsConflictsToResolve[conflictsToResolve.size()]);
            parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
            parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
            parms.pendingChangesDilemmaHandler.pendingChangesInstruction = config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
            parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
            parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
            parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
            parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
            parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
            parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
            parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
            parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
            parms.missingRequiredChangesDilemmaHandler = "cancel";
            if (config.getSubcommandCommandLine().hasOption((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_DEPENDENT)) {
                parms.missingRequiredChangesDilemmaHandler = "continue";
            }
            parms.unmergedChangesDilemmaHandler = "continue";
            try {
                result = client.postResolveAsMerged(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ResolveCmd_4, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.workspace.repositoryUrl);
            }
            if (!result.isCancelled()) continue;
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
            }
            if ((noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
            }
            int noOfMissingRequiredChanges = result.getMissingRequiredChanges().size();
            if (noOfMissingRequiredChanges > 0) {
                String repoUri = parms.workspace.repositoryUrl;
                this.showMissingRequiredChanges(result.getMissingRequiredChanges(), repoUri);
            }
            if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() <= 0) continue;
            SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)config.getWrappedOutputStream());
        }
    }

    private void resolveLocalConflictsAsMerged(Map<ParmsWorkspace, List<LocalConflictToResolve>> ws2ConflictItemsMap, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        for (Map.Entry<ParmsWorkspace, List<LocalConflictToResolve>> entry : ws2ConflictItemsMap.entrySet()) {
            ParmsResolveLocalConflicts parms = new ParmsResolveLocalConflicts();
            parms.workspace = entry.getKey();
            ArrayList<ParmsLocalConflictToResolve> conflictsToResolve = new ArrayList<ParmsLocalConflictToResolve>();
            for (LocalConflictToResolve conflict : entry.getValue()) {
                ParmsLocalConflictToResolve parmsConflict = new ParmsLocalConflictToResolve();
                parmsConflict.componentItemId = conflict.getComponentId();
                parmsConflict.versionableItemId = conflict.getLocalConflictItem().getVersionableItemId();
                parms.sandboxPath = conflict.getLocalConflictItem().getSandboxPath();
                conflictsToResolve.add(parmsConflict);
            }
            parms.localConflictsToResolve = conflictsToResolve.toArray(new ParmsLocalConflictToResolve[conflictsToResolve.size()]);
            try {
                client.postResolveLocalConflictsAsMerged(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ResolveCmd_4, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.workspace.repositoryUrl);
            }
        }
    }

    private void resolveLocalConflictsAsProposed(List<ParmsUndoLocalChangesRequest> undoLocalChangesRequests, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsUndoLocalChanges parmsLocalChanges = new ParmsUndoLocalChanges();
        parmsLocalChanges.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parmsLocalChanges.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parmsLocalChanges.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = false;
        parmsLocalChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parmsLocalChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        parmsLocalChanges.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parmsLocalChanges.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parmsLocalChanges.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parmsLocalChanges.undoRequests = undoLocalChangesRequests.toArray(new ParmsUndoLocalChangesRequest[undoLocalChangesRequests.size()]);
        try {
            client.postUndoLocalChanges(parmsLocalChanges, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.UndoCmd_6, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
    }

    private Map<ParmsWorkspace, List<ConflictToResolve>> findConflictsToResolve(SyncViewDTO syncView, List<UndoCmd.Change> changesToResolveList, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ParmsWorkspace, List<ConflictToResolve>> ws2ConflictItemsMap = new HashMap<ParmsWorkspace, List<ConflictToResolve>>();
        HashMap<String, ParmsWorkspace> wsId2WsMap = new HashMap<String, ParmsWorkspace>();
        HashMap<String, HashSet<String>> itemToComponentMap = new HashMap<String, HashSet<String>>();
        for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            ParmsWorkspace ws = (ParmsWorkspace)wsId2WsMap.get(wsSync.getWorkspaceItemId());
            if (ws == null) {
                ws = new ParmsWorkspace(wsSync.getRepositoryUrl(), wsSync.getWorkspaceItemId());
                wsId2WsMap.put(wsSync.getWorkspaceItemId(), ws);
            }
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                for (UnresolvedFolderSyncDTO unresolvedFolderSync : compSync.getUnresolved()) {
                    for (ConflictSyncDTO conflictSync : unresolvedFolderSync.getConflicts()) {
                        ArrayList<ConflictToResolve> conflicts = (ArrayList<ConflictToResolve>)ws2ConflictItemsMap.get(ws);
                        if (conflicts == null) {
                            conflicts = new ArrayList<ConflictToResolve>();
                            ws2ConflictItemsMap.put(ws, conflicts);
                        }
                        conflicts.add(new ConflictToResolve(compSync.getComponentItemId(), conflictSync));
                        HashSet<String> components = (HashSet<String>)itemToComponentMap.get(conflictSync.getVersionableItemId());
                        if (components == null) {
                            components = new HashSet<String>();
                            itemToComponentMap.put(conflictSync.getVersionableItemId(), components);
                        }
                        components.add(compSync.getComponentItemId());
                    }
                }
            }
        }
        if (changesToResolveList == null) {
            return ws2ConflictItemsMap;
        }
        HashMap<ParmsWorkspace, List<ConflictToResolve>> ws2ConflictItemsToResolveMap = new HashMap<ParmsWorkspace, List<ConflictToResolve>>();
        for (UndoCmd.Change change : changesToResolveList) {
            boolean found = false;
            String componentId = null;
            String changeSelector = null;
            ShareDTO share = change.hasResourceInfo() ? change.getResourceProperties().getShare() : null;
            block7: for (Map.Entry map : ws2ConflictItemsMap.entrySet()) {
                if (share != null && !share.getContextItemId().equals(((ParmsWorkspace)map.getKey()).workspaceItemId)) continue;
                for (ConflictToResolve toResolve : (List)map.getValue()) {
                    if (share != null && !share.getComponentItemId().equals(toResolve.componentId)) continue;
                    boolean matched = ResolveCmd.matchItem(change, toResolve.getConflictItem());
                    if (!matched) {
                        try {
                            if (changeSelector == null) {
                                String[] result = this.splitComponentAndItem(change.getSelector(), ((ParmsWorkspace)map.getKey()).getTeamRepository(), config);
                                componentId = result[0];
                                changeSelector = result[1];
                            }
                            if (componentId != null && componentId.equals(toResolve.componentId)) {
                                change = new UndoCmd.Change(changeSelector, change.shareable, change.resource);
                                matched = ResolveCmd.matchItem(change, toResolve.getConflictItem());
                            }
                        }
                        catch (TeamRepositoryException e) {
                            matched = false;
                            changeSelector = change.getSelector();
                        }
                    }
                    if (!matched) continue;
                    if (share == null && componentId == null && itemToComponentMap.containsKey(change.getItemId()) && ((Set)itemToComponentMap.get(change.getItemId())).size() > 1) {
                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ResolveCmd_MULTIPLE_CONFLICTS_SAME_ITEM, (Object)change.getSelector()));
                    }
                    ArrayList<ConflictToResolve> conflicts = (ArrayList<ConflictToResolve>)ws2ConflictItemsToResolveMap.get(map.getKey());
                    if (conflicts == null) {
                        conflicts = new ArrayList<ConflictToResolve>();
                        ws2ConflictItemsToResolveMap.put((ParmsWorkspace)map.getKey(), conflicts);
                    }
                    conflicts.add(toResolve);
                    found = true;
                    break block7;
                }
            }
            if (found) continue;
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ResolveCmd_PATH_NOT_IN_CONFLICT, (Object)change.getSelector()));
        }
        return ws2ConflictItemsToResolveMap;
    }

    private String[] splitComponentAndItem(String selector, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        String[] result = new String[2];
        int index = selector.indexOf(47);
        if (index > 0) {
            result[0] = selector.substring(0, index);
            result[1] = selector.substring(index + 1);
            if (repo != null && config != null) {
                IComponent component = RepoUtil.getComponent((String)result[0], (ITeamRepository)repo, (IScmClientConfiguration)config);
                result[0] = component.getItemId().getUuidValue();
            }
        } else {
            result[1] = selector;
        }
        return result;
    }

    private Map<ParmsWorkspace, List<LocalConflictToResolve>> findLocalConflictsToResolve(SyncViewDTO syncView, List<UndoCmd.Change> changesToResolveList, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ParmsWorkspace, List<LocalConflictToResolve>> ws2ConflictItemsMap = new HashMap<ParmsWorkspace, List<LocalConflictToResolve>>();
        HashMap<String, ParmsWorkspace> wsId2WsMap = new HashMap<String, ParmsWorkspace>();
        HashMap<String, HashSet<String>> itemToComponentMap = new HashMap<String, HashSet<String>>();
        for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            ParmsWorkspace ws = (ParmsWorkspace)wsId2WsMap.get(wsSync.getWorkspaceItemId());
            if (ws == null) {
                ws = new ParmsWorkspace(wsSync.getRepositoryUrl(), wsSync.getWorkspaceItemId());
                wsId2WsMap.put(wsSync.getWorkspaceItemId(), ws);
            }
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                for (UnresolvedFolderSyncDTO unresolvedFolderSync : compSync.getUnresolved()) {
                    for (LocalConflictSyncDTO conflictSync : unresolvedFolderSync.getLocalConflicts()) {
                        ArrayList<LocalConflictToResolve> conflicts = (ArrayList<LocalConflictToResolve>)ws2ConflictItemsMap.get(ws);
                        if (conflicts == null) {
                            conflicts = new ArrayList<LocalConflictToResolve>();
                            ws2ConflictItemsMap.put(ws, conflicts);
                        }
                        conflicts.add(new LocalConflictToResolve(compSync.getComponentItemId(), conflictSync));
                        HashSet<String> components = (HashSet<String>)itemToComponentMap.get(conflictSync.getVersionableItemId());
                        if (components == null) {
                            components = new HashSet<String>();
                            itemToComponentMap.put(conflictSync.getVersionableItemId(), components);
                        }
                        components.add(compSync.getComponentItemId());
                    }
                }
            }
        }
        if (changesToResolveList == null) {
            return ws2ConflictItemsMap;
        }
        HashMap<ParmsWorkspace, List<LocalConflictToResolve>> ws2ConflictItemsToResolveMap = new HashMap<ParmsWorkspace, List<LocalConflictToResolve>>();
        for (UndoCmd.Change change : changesToResolveList) {
            boolean found = false;
            String componentId = null;
            String changeSelector = null;
            ShareDTO share = change.hasResourceInfo() ? change.getResourceProperties().getShare() : null;
            block7: for (Map.Entry map : ws2ConflictItemsMap.entrySet()) {
                if (share != null && !share.getContextItemId().equals(((ParmsWorkspace)map.getKey()).workspaceItemId)) continue;
                for (LocalConflictToResolve toResolve : (List)map.getValue()) {
                    if (share != null && !share.getComponentItemId().equals(toResolve.componentId)) continue;
                    boolean matched = ResolveCmd.matchItem(change, toResolve.getLocalConflictItem());
                    if (!matched) {
                        try {
                            if (changeSelector == null) {
                                String[] result = this.splitComponentAndItem(change.getSelector(), ((ParmsWorkspace)map.getKey()).getTeamRepository(), config);
                                componentId = result[0];
                                changeSelector = result[1];
                            }
                            if (componentId != null && componentId.equals(toResolve.componentId)) {
                                change = new UndoCmd.Change(changeSelector, change.shareable, change.resource);
                                matched = ResolveCmd.matchItem(change, toResolve.getLocalConflictItem());
                            }
                        }
                        catch (TeamRepositoryException e) {
                            matched = false;
                            changeSelector = change.getSelector();
                        }
                    }
                    if (!matched) continue;
                    if (share == null && componentId == null && itemToComponentMap.containsKey(change.getItemId()) && ((Set)itemToComponentMap.get(change.getItemId())).size() > 1) {
                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ResolveCmd_MULTIPLE_CONFLICTS_SAME_ITEM, (Object)change.getSelector()));
                    }
                    ArrayList<LocalConflictToResolve> conflicts = (ArrayList<LocalConflictToResolve>)ws2ConflictItemsToResolveMap.get(map.getKey());
                    if (conflicts == null) {
                        conflicts = new ArrayList<LocalConflictToResolve>();
                        ws2ConflictItemsToResolveMap.put((ParmsWorkspace)map.getKey(), conflicts);
                    }
                    conflicts.add(toResolve);
                    found = true;
                    break block7;
                }
            }
            if (found) continue;
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ResolveCmd_PATH_NOT_IN_CONFLICT, (Object)change.getSelector()));
        }
        return ws2ConflictItemsToResolveMap;
    }

    private List<ParmsUndoLocalChangesRequest> generateUndoLocalChangeRequests(List<UndoCmd.Change> changesToFind, SyncViewDTO syncView, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        Map<ParmsWorkspace, List<LocalConflictToResolve>> ws2ConflictItemsMap = this.findLocalConflictsToResolve(syncView, changesToFind, client, config);
        ArrayList<ParmsUndoLocalChangesRequest> undoLocalChangesRequests = new ArrayList<ParmsUndoLocalChangesRequest>();
        for (Map.Entry<ParmsWorkspace, List<LocalConflictToResolve>> map : ws2ConflictItemsMap.entrySet()) {
            String workspaceItemId = map.getKey().workspaceItemId;
            String repositoryUrl = map.getKey().repositoryUrl;
            for (LocalConflictToResolve localConflict : map.getValue()) {
                boolean foundChange = false;
                for (ParmsUndoLocalChangesRequest localCR : undoLocalChangesRequests) {
                    if (!localCR.workspace.workspaceItemId.equals(workspaceItemId) || !localCR.componentItemId.equals(localConflict.getComponentId()) || !localCR.sandboxPath.equals(localConflict.getLocalConflictItem().getSandboxPath())) continue;
                    this.addConflictToUndoRequest(localCR, localConflict.getLocalConflictItem());
                    foundChange = true;
                    break;
                }
                if (foundChange) continue;
                ParmsUndoLocalChangesRequest localChangeRequest = new ParmsUndoLocalChangesRequest();
                localChangeRequest.workspace = new ParmsWorkspace(repositoryUrl, workspaceItemId);
                localChangeRequest.componentItemId = localConflict.getComponentId();
                localChangeRequest.sandboxPath = localConflict.getLocalConflictItem().getSandboxPath();
                localChangeRequest.versionableItemIds = new String[0];
                this.addConflictToUndoRequest(localChangeRequest, localConflict.getLocalConflictItem());
                undoLocalChangesRequests.add(localChangeRequest);
            }
        }
        return undoLocalChangesRequests;
    }

    private void addConflictToUndoRequest(ParmsUndoLocalChangesRequest localCR, LocalConflictSyncDTO localConflict) {
        int length = localCR.versionableItemIds.length;
        String[] newValue = localConflict.getDeletedDuringReplayVersionableItemId() == null ? new String[length + 1] : new String[length + 2];
        System.arraycopy(localCR.versionableItemIds, 0, newValue, 0, length);
        newValue[length] = localConflict.getVersionableItemId();
        if (localConflict.getDeletedDuringReplayVersionableItemId() != null) {
            newValue[length + 1] = localConflict.getDeletedDuringReplayVersionableItemId();
        }
        localCR.versionableItemIds = newValue;
    }

    public static boolean matchItem(UndoCmd.Change change, ConflictSyncDTO conflictSync) {
        if (conflictSync.getVersionableItemId().equals(change.getItemId())) {
            return true;
        }
        if (!conflictSync.isSetCommonAncestorVersionableStateId() && change.hasShareInfo()) {
            String path;
            String string = path = conflictSync.isSetNewPathHint() ? conflictSync.getNewPathHint() : conflictSync.getPathHint();
            if (path != null && path.equalsIgnoreCase(change.getRelativePathToComponent())) {
                return true;
            }
        }
        return false;
    }

    public static boolean matchItem(UndoCmd.Change change, LocalConflictSyncDTO localConflictSync) {
        return localConflictSync.getVersionableItemId().equals(change.getItemId());
    }

    private void resolveLocalConflictsInlineMarkers(Map<ParmsWorkspace, List<LocalConflictToResolve>> ws2ConflictItemsMap, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine subargs) throws FileSystemException {
        IndentingPrintStream out = config.getWrappedOutputStream();
        File cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)config.getContext().getCurrentWorkingDirectory());
        if (cfaRootPath != null) {
            Path cfaRoot = new Path(cfaRootPath.getAbsolutePath());
            InPlaceConflictHandler handler = new InPlaceConflictHandler();
            handler.handleLocalConflicts((IPath)cfaRoot, ws2ConflictItemsMap, client, config);
            out.println((CharSequence)Messages.LocalConflicts_InPlaceMarkers_Help);
        }
    }

    private void resolveAutomaticallyLocalConflicts(Map<ParmsWorkspace, List<LocalConflictToResolve>> ws2ConflictItemsMap, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine subargs) throws FileSystemException {
        ArrayList<ParmsWorkspace> unresolvedWorkspaces = new ArrayList<ParmsWorkspace>();
        ArrayList deletedContentShareables = new ArrayList();
        IndentingPrintStream out = config.getWrappedOutputStream();
        for (Map.Entry<ParmsWorkspace, List<LocalConflictToResolve>> entryMap : ws2ConflictItemsMap.entrySet()) {
            ITypedPreferenceRegistry prefs = ((ScmClientConfiguration)config).getPersistentPreferences();
            String tool = prefs.getExternalAutoResolveTool();
            ParmsResolveLocalConflicts parms = new ParmsResolveLocalConflicts();
            parms.externalAutoResolveTool = tool;
            if (tool != null && !tool.isEmpty()) {
                ParmsExternalTool parmsTool = new ParmsExternalTool();
                parmsTool.externalTool = tool;
                parmsTool.filePatterns = prefs.getExternalAutoResolveToolFilePatterns();
                parmsTool.policy = prefs.getExternalAutoResolveToolPolicy();
                parms.externalTool = parmsTool;
            }
            parms.workspace = new ParmsWorkspace();
            parms.workspace.repositoryUrl = entryMap.getKey().repositoryUrl;
            parms.workspace.workspaceItemId = entryMap.getKey().workspaceItemId;
            parms.localConflictsToResolve = new ParmsLocalConflictToResolve[entryMap.getValue().size()];
            int count = 0;
            String sandboxPath = null;
            for (LocalConflictToResolve conflictToResolve : entryMap.getValue()) {
                ParmsLocalConflictToResolve itemToResolve = new ParmsLocalConflictToResolve();
                itemToResolve.componentItemId = conflictToResolve.getComponentId();
                itemToResolve.versionableItemId = conflictToResolve.getLocalConflictItem().getVersionableItemId();
                if (sandboxPath == null) {
                    sandboxPath = conflictToResolve.getLocalConflictItem().getSandboxPath();
                }
                parms.localConflictsToResolve[count++] = itemToResolve;
            }
            parms.sandboxPath = sandboxPath;
            AutoResolveLocalConflictsResultDTO result = null;
            try {
                result = client.postAutoResolveLocalConflicts(parms, null);
            }
            catch (TeamRepositoryException e) {
                String wsName = entryMap.getKey().workspaceItemId;
                try {
                    entryMap.getKey().getWorkspaceConnection(null).getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                config.getWrappedErrorStream().println((CharSequence)NLS.bind((String)Messages.AcceptCmd_CONFLICT_RESOLUTION_FAILED, (Object)wsName));
                LoggingHelper.log((String)"com.ibm.team.filesystem.cli.client", (TeamRepositoryException)e);
            }
            if (result != null && result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
                deletedContentShareables.addAll(result.getSandboxUpdateDilemma().getDeletedContentShareables());
            }
            if (result != null && result.getNumberConflictsResolved() == parms.localConflictsToResolve.length) continue;
            unresolvedWorkspaces.add(entryMap.getKey());
        }
        if (deletedContentShareables.size() > 0) {
            SubcommandUtil.showDeletedContent((String)Messages.AcceptResultDisplayer_DELETED_CONTENT_WHEN_AUTOMERGING, deletedContentShareables, (IndentingPrintStream)out);
        }
        if (unresolvedWorkspaces.size() > 0 && subargs.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER)) {
            this.resolveLocalConflictsInlineMarkers(ws2ConflictItemsMap, client, config, subargs);
        }
        if (unresolvedWorkspaces.size() > 0) {
            throw StatusHelper.conflict((String)NLS.bind((String)Messages.ResolveCmd_CONFILCTS, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)config.getSubcommandDefinition()).toString(), ResolveCmdOpts.OPT_RESOLVE_PROPOSED.getName(), ResolveCmdOpts.OPT_RESOLVE_MERGED.getName()}));
        }
    }

    private void resolveAutomatically(Map<ParmsWorkspace, List<ConflictToResolve>> ws2ConflictItemsMap, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine subargs) throws FileSystemException {
        File cfaRootPath;
        ArrayList<ParmsWorkspace> unresolvedWorkspaces = new ArrayList<ParmsWorkspace>();
        ArrayList deletedContentShareables = new ArrayList();
        ArrayList<FailedMergeDTO> failedMerges = new ArrayList<FailedMergeDTO>();
        IndentingPrintStream out = config.getWrappedOutputStream();
        for (Map.Entry<ParmsWorkspace, List<ConflictToResolve>> entryMap : ws2ConflictItemsMap.entrySet()) {
            String tool;
            ParmsAutoMerge pam = new ParmsAutoMerge();
            ITypedPreferenceRegistry prefs = ((ScmClientConfiguration)config).getPersistentPreferences();
            pam.externalAutoResolveTool = tool = prefs.getExternalAutoResolveTool();
            if (tool != null && !tool.isEmpty()) {
                ParmsExternalTool parmsTool = new ParmsExternalTool();
                parmsTool.externalTool = tool;
                parmsTool.filePatterns = prefs.getExternalAutoResolveToolFilePatterns();
                parmsTool.policy = prefs.getExternalAutoResolveToolPolicy();
                pam.externalTool = parmsTool;
            }
            pam.workspace = new ParmsWorkspace();
            pam.workspace.repositoryUrl = entryMap.getKey().repositoryUrl;
            pam.workspace.workspaceItemId = entryMap.getKey().workspaceItemId;
            pam.itemsToResolve = new ParmsConflictedItemToResolve[entryMap.getValue().size()];
            int count = 0;
            for (ConflictToResolve conflictToResolve : entryMap.getValue()) {
                ParmsConflictedItemToResolve itemToResolve = new ParmsConflictedItemToResolve();
                itemToResolve.componentItemId = conflictToResolve.getComponentId();
                itemToResolve.versionableItemId = conflictToResolve.getConflictItem().getVersionableItemId();
                pam.itemsToResolve[count++] = itemToResolve;
            }
            pam.missingRequiredChangesDilemmaHandler = "continue";
            pam.missingStorageMergerDilemmaHandler = new ParmsMissingStorageMergerDilemmaHandler();
            pam.missingStorageMergerDilemmaHandler.generalStorageMergerInstruction = "continue";
            pam.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
            pam.pendingChangesDilemmaHandler.pendingChangesInstruction = "continue";
            pam.pendingChangesDilemmaHandler.commitDilemmaHandler = new ParmsCommitDilemmaHandler();
            pam.pendingChangesDilemmaHandler.commitDilemmaHandler.lineDelimiterDilemmaHandler = new ParmsLineDelimiterDilemmaHandler();
            pam.pendingChangesDilemmaHandler.commitDilemmaHandler.lineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction = "continue";
            pam.pendingChangesDilemmaHandler.commitDilemmaHandler.predecessorContentDeletedInstruction = "no";
            ResolveAutoMergeResultDTO mergeResult = null;
            try {
                mergeResult = client.postAutoResolve(pam, null);
            }
            catch (TeamRepositoryException e) {
                String wsName = entryMap.getKey().workspaceItemId;
                try {
                    entryMap.getKey().getWorkspaceConnection(null).getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                config.getWrappedErrorStream().println((CharSequence)NLS.bind((String)Messages.AcceptCmd_CONFLICT_RESOLUTION_FAILED, (Object)wsName));
                LoggingHelper.log((String)"com.ibm.team.filesystem.cli.client", (TeamRepositoryException)e);
            }
            if (mergeResult != null) {
                if (mergeResult.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
                    deletedContentShareables.addAll(mergeResult.getSandboxUpdateDilemma().getDeletedContentShareables());
                }
                if (mergeResult.getMissingStorageMergers().size() > 0) {
                    failedMerges.addAll(mergeResult.getMissingStorageMergers());
                }
            }
            if (mergeResult != null && mergeResult.getNumberConflictsResolved() == pam.itemsToResolve.length) continue;
            unresolvedWorkspaces.add(entryMap.getKey());
        }
        if (deletedContentShareables.size() > 0) {
            SubcommandUtil.showDeletedContent((String)Messages.AcceptResultDisplayer_DELETED_CONTENT_WHEN_AUTOMERGING, deletedContentShareables, (IndentingPrintStream)out);
        }
        if (failedMerges.size() > 0) {
            ResolveCmd.showFailedMerges(failedMerges, out, config);
        }
        if (unresolvedWorkspaces.size() > 0 && subargs.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER) && (cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)config.getContext().getCurrentWorkingDirectory())) != null) {
            Path cfaRoot = new Path(cfaRootPath.getAbsolutePath());
            InPlaceConflictHandler handler = new InPlaceConflictHandler();
            for (ParmsWorkspace ws : unresolvedWorkspaces) {
                handler.handleConflicts((IPath)cfaRoot, ws, client, config);
            }
            out.println((CharSequence)Messages.Conflicts_InPlaceMarkers_Help);
        }
        if (unresolvedWorkspaces.size() > 0) {
            throw StatusHelper.conflict((String)NLS.bind((String)Messages.ResolveCmd_CONFILCTS, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)config.getSubcommandDefinition()).toString(), ResolveCmdOpts.OPT_RESOLVE_PROPOSED.getName(), ResolveCmdOpts.OPT_RESOLVE_MERGED.getName()}));
        }
    }

    public static JSONObject showFailedMerges(List<FailedMergeDTO> failedMerges, IndentingPrintStream out, IScmClientConfiguration config) {
        ArrayList<String> failedItems = new ArrayList<String>(failedMerges.size());
        for (FailedMergeDTO failedMerge : failedMerges) {
            failedItems.add(StringUtil.createPathString((List)failedMerge.getPath().getSegments()));
        }
        return SubcommandUtil.showError(failedItems, (String)Messages.ResolveCmd_FAILED_CONTENT_MERGES, (int)76, (Constants.Severity)Constants.Severity.info, (IndentingPrintStream)out, (IScmClientConfiguration)config);
    }

    public static void resolveExternally(ConflictSyncDTO conflictDTO, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine subargs, String externalCompareTool) throws FileSystemException {
        if (!conflictDTO.isContentConflict() && conflictDTO.isPropertyConflict()) {
            throw StatusHelper.inappropriateArgument((String)Messages.ResolveCmd_CANNOT_EXTERNAL_COMPARE_PROPERTY);
        }
        Object element = SyncViewDTOUtil.find((Object)ComponentSyncModel.getInstance(), (int)conflictDTO.getId());
        if (!(element instanceof IConflictItem)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_PATH_NOT_IN_CONFLICT, (Object)conflictDTO.getName()));
        }
        IConflictItem conflictItem = (IConflictItem)element;
        OpenConflictInExternalCompareOperation externalCompareOperation = new OpenConflictInExternalCompareOperation(externalCompareTool, (IAbstractConflictItem)conflictItem, null, true);
        try {
            externalCompareOperation.setEnvironment(config.getContext().environment());
            externalCompareOperation.run(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.failure((String)Messages.DiffCmd_ERROR_EXTERNAL_COMPARE, (Throwable)e);
        }
        ISubcommandDefinition resolveDefn = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ResolveCmd.class);
        config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ResolveCmd_COMPARE_FOLLOWUP_ACTION, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)resolveDefn).toString(), ResolveCmdOpts.OPT_RESOLVE_MERGED.getName()}));
        if (externalCompareOperation.returnValue() != 0) {
            throw StatusHelper.returnValue((int)externalCompareOperation.returnValue());
        }
    }

    public static void resolveExternally(LocalConflictSyncDTO conflictDTO, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine subargs, String externalCompareTool) throws FileSystemException {
        if (!conflictDTO.isContentType() && conflictDTO.isSetAttributesType()) {
            throw StatusHelper.inappropriateArgument((String)Messages.ResolveCmd_CANNOT_EXTERNAL_COMPARE_PROPERTY);
        }
        Object element = SyncViewDTOUtil.find((Object)ComponentSyncModel.getInstance(), (int)conflictDTO.getId());
        if (!(element instanceof ILocalConflictItem)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_PATH_NOT_IN_CONFLICT, (Object)conflictDTO.getName()));
        }
        ILocalConflictItem conflictItem = (ILocalConflictItem)element;
        OpenConflictInExternalCompareOperation externalCompareOperation = new OpenConflictInExternalCompareOperation(externalCompareTool, (IAbstractConflictItem)conflictItem, null, true);
        try {
            externalCompareOperation.setEnvironment(config.getContext().environment());
            externalCompareOperation.run(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.failure((String)Messages.DiffCmd_ERROR_EXTERNAL_COMPARE, (Throwable)e);
        }
        ISubcommandDefinition resolveDefn = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ResolveCmd.class);
        config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ResolveCmd_COMPARE_LOCAL_CONFLICTS_FOLLOWUP_ACTION, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)resolveDefn).toString(), ResolveCmdOpts.OPT_RESOLVE_LOCAL.getName(), ResolveCmdOpts.OPT_RESOLVE_MERGED.getName()}));
        if (externalCompareOperation.returnValue() != 0) {
            throw StatusHelper.returnValue((int)externalCompareOperation.returnValue());
        }
    }

    private void showMissingRequiredChanges(List<ConflictedChangeDTO> missingRequiredChanges, String repoUri) throws CLIFileSystemClientException {
        int noOfMissingRequiredChanges = missingRequiredChanges.size();
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        out.println((CharSequence)Messages.ResolveCmd_DEPENDENT_CONFLICTS);
        for (ConflictedChangeDTO requiredChange : missingRequiredChanges) {
            Path requiredChangePath = new Path("");
            for (String segment : requiredChange.getPath().getSegments()) {
                requiredChangePath = requiredChangePath.append(segment);
            }
            out.println((CharSequence)AliasUtil.selector((String)requiredChangePath.toOSString(), (UUID)UUID.valueOf((String)requiredChange.getVersionableItemId()), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE));
        }
        throw StatusHelper.unresolvedDependentChanges((String)NLS.bind((String)Messages.ResolveCmd_UNRESOLVED_DEPENDENT_CONFLICTS, (Object[])new String[]{Integer.toString(noOfMissingRequiredChanges), ResolveCmdOpts.OPT_RESOLVE_DEPENDENT.getName()}));
    }

    private class ConflictToResolve {
        String componentId;
        ConflictSyncDTO conflictItem;

        public ConflictToResolve(String compId, ConflictSyncDTO conflictItem) {
            this.componentId = compId;
            this.conflictItem = conflictItem;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public ConflictSyncDTO getConflictItem() {
            return this.conflictItem;
        }
    }

    public static class LocalConflictToResolve {
        String componentId;
        LocalConflictSyncDTO conflictItem;

        public LocalConflictToResolve(String compId, LocalConflictSyncDTO conflictItem) {
            this.componentId = compId;
            this.conflictItem = conflictItem;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public LocalConflictSyncDTO getLocalConflictItem() {
            return this.conflictItem;
        }
    }

    static enum Mode {
        AUTO,
        MERGED,
        PROPOSED,
        COMPARE,
        MOVE,
        INLINE_MARKERS,
        AUTO_INLINE_MARKERS,
        UNDEFINED;

    }

    static enum Operation {
        RESOLVE,
        NORESOLUTION;

    }

    private class Resource {
        String selector;
        String osPath;
        String componentSelector;

        public Resource(String selector, String osPath, String componentSelector) {
            this.selector = selector;
            this.osPath = osPath;
            this.componentSelector = componentSelector;
        }
    }
}

