/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRebuildSandbox;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.corruption.RebuildCopyFileAreaDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class RepairCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        File sandboxPath = SubcommandUtil.findAncestorCFARoot((String)this.config.getContext().getCurrentWorkingDirectory());
        if (sandboxPath == null) {
            throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.RepairCmd_NO_SANDBOX_METADATA, (Object)this.config.getContext().getCurrentWorkingDirectory()));
        }
        PathLocation sandboxLoc = new PathLocation(sandboxPath.getAbsolutePath());
        List shares = RepoUtil.getSharesInSandbox(null, (ILocation)sandboxLoc, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        if (shares.size() == 0) {
            throw StatusHelper.misconfiguredLocalFS((String)Messages.RepairCmd_4);
        }
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ITeamRepository repo = null;
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            String repoUriSelector = cli.getOption((IOptionKey)CommonOptions.OPT_URI, null);
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUriSelector));
        }
        ArrayList<String> repoIds = new ArrayList<String>();
        for (ShareDTO share : shares) {
            if (repoIds.contains(share.getRepositoryId())) continue;
            repoIds.add(share.getRepositoryId());
        }
        boolean repoMatched = false;
        for (String repoId : repoIds) {
            if (repo == null) {
                try {
                    String repoUri = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)repoId);
                    RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUri));
                    continue;
                }
                catch (Exception e) {
                    String errMsg = String.valueOf(e.getLocalizedMessage()) + System.getProperty("line.separator") + NLS.bind((String)Messages.RepairCmd_REPO_SUGGESTION, (Object)CommonOptions.OPT_URI.getName());
                    throw StatusHelper.login((String)errMsg, null);
                }
            }
            if (!repo.getId().getUuidValue().equals(repoId)) continue;
            repoMatched = true;
        }
        if (repo != null && !repoMatched) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.RepairCmd_INVALID_REPOURI, (Object)repo.getRepositoryURI()));
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.RepairCmd_0);
        ParmsRebuildSandbox parms = new ParmsRebuildSandbox();
        parms.sandboxPath = sandboxPath.getAbsolutePath();
        RebuildCopyFileAreaDTO result = null;
        try {
            result = client.postRebuildCopyFileArea(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.failure((String)Messages.RepairCmd_6, (Throwable)e);
        }
        if (result.isNoDescriptorsFound()) {
            this.config.getWrappedErrorStream().println((CharSequence)Messages.RepairCmd_4);
            throw StatusHelper.failure((String)Messages.RepairCmd_6, null);
        }
        if (result.isIgnoredErrors()) {
            this.config.getWrappedErrorStream().println((CharSequence)Messages.RepairCmd_5);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.RepairCmd_1);
    }
}

