/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.RefreshCmdOpts;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRecomputeLocalChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxPaths;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class RefreshCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ArrayList<String> selectors = cli.hasOption(RefreshCmdOpts.OPT_REFRESH.getId()) ? cli.getOptions(RefreshCmdOpts.OPT_REFRESH.getId()) : new ArrayList<String>(Arrays.asList(this.config.getContext().getCurrentWorkingDirectory()));
        ArrayList<String> pathSelectors = new ArrayList<String>();
        for (String selector : selectors) {
            ILocation path = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)selector);
            pathSelectors.add(path.toOSString());
        }
        ParmsSandboxPaths parmsPaths = new ParmsSandboxPaths();
        parmsPaths.includeNonRegisteredSandboxes = true;
        parmsPaths.pathsToResolve = pathSelectors.toArray(new String[pathSelectors.size()]);
        SandboxPathsResultDTO pathsResult = null;
        try {
            pathsResult = client.getSandboxPaths(parmsPaths, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.Common_UNABLE_TO_GET_SANDBOX_PATHS, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), null);
        }
        HashMap sandboxToPath = new HashMap();
        int count = 0;
        for (ShareableDTO shareables : pathsResult.getPaths()) {
            if (shareables.getSandboxPath() == null || shareables.getSandboxPath().length() == 0) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_NOT_SHARED, pathSelectors.get(count)));
            }
            HashSet<String> paths = (HashSet<String>)sandboxToPath.get(shareables.getSandboxPath());
            if (paths == null) {
                paths = new HashSet<String>();
                sandboxToPath.put(shareables.getSandboxPath(), paths);
            }
            if (shareables.getRelativePath().getSegments().size() == 0) {
                List shares = RepoUtil.getSharesInSandbox(null, (ILocation)new PathLocation(shareables.getSandboxPath()), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                if (shares.size() > 0) {
                    for (ShareDTO share : shares) {
                        paths.add(StringUtil.createPathString((List)share.getPath().getSegments()));
                    }
                }
            } else {
                ResourcePropertiesDTO resource = RepoUtil.getResourceProperties((String)((String)pathSelectors.get(count)), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                paths.add(StringUtil.createPathString((List)resource.getPath().getRelativePath().getSegments()));
            }
            ++count;
        }
        SubcommandUtil.registerSandboxes((String[])sandboxToPath.keySet().toArray(new String[sandboxToPath.keySet().size()]), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        ParmsRecomputeLocalChanges parm = new ParmsRecomputeLocalChanges();
        Iterator iterator = sandboxToPath.keySet().iterator();
        while (iterator.hasNext()) {
            String sandbox;
            parm.sandboxPath = sandbox = (String)iterator.next();
            parm.paths = new String[((Set)sandboxToPath.get(sandbox)).size()];
            ((Set)sandboxToPath.get(sandbox)).toArray(parm.paths);
            try {
                client.postGetRecomputeLocalChanges(parm, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.RefreshCmd_REFRESH_FAILED, (Object)sandbox), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
        }
    }
}

