/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class OperationsCmdLabelGenerator {
    public static final String OPERATION_ACCEPT = "ACCEPT";
    public static final String OPERATION_ACCEPT_COMBINED = "ACCEPT_COMBINED";
    public static final String OPERATION_DELIVER = "DELIVER";
    public static final String OPERATION_CREATE_CHANGE_SET = "CREATE_CHANGE_SET";
    public static final String OPERATION_COMMIT = "COMMIT";
    public static final String OPERATION_CLOSE_CHANGE_SET = "CLOSE_CHANGE_SET";
    public static final String OPERATION_DISCARD = "DISCARD";
    public static final String OPERATION_SUSPEND = "SUSPEND";
    public static final String OPERATION_ADD_COMPONENT = "ADD_COMPONENT";
    public static final String OPERATION_REPLACE_COMPONENT = "REPLACE_COMPONENT";
    public static final String OPERATION_REMOVE_COMPONENT = "REMOVE_COMPONENT";
    public static final String OPERATION_MOVE_WITH_HISTORY = "MOVE_WITH_HISTORY";
    public static final String OPERATION_HARMONIZE_WORKSPACE_HISTORY = "HARMONIZE_WORKSPACE_HISTORY";
    public static final String OPERATION_RELOCATE_CHANGES = "RELOCATE_CHANGES";
    public static final String OPERATION_IMPORT_CHANGE_SET = "IMPORT_CHANGE_SET";
    public static final String OPERATION_CREATE_BASELINE = "CREATE_BASELINE";
    public static final String OPERATION_CREATE_BASELINE_SET = "CREATE_BASELINE_SET";
    public static final String OPERATION_CREATE_POST_IMPORT_BASELINE = "CREATE_POST_IMPORT_BASELINE";
    public static final String OPERATION_RESUME = "RESUME";
    public static final String OPERATION_UPDATE_LOCKS = "UPDATE_LOCKS";
    public static final String OPERATION_SET_CURRENT = "SET_CURRENT";
    public static final String OPERATION_UNSET_CURRENT = "UNSET_CURRENT";
    public static final String OPERATION_CREATE_CHANGE_SET_STREAM = "CREATE_CHANGE_SET_STREAM";
    public static final String OPERATION_DELIVER_COMBINED = "DELIVER_COMBINED";
    public static final String OPERATION_DISCARD_BASIS = "DISCARD_BASIS";
    public static final String OPERATION_CREATE_PORT = "CREATE_PORT";
    public static final String OPERATION_PORT_ABORT = "PORT_ABORT";
    public static final String OPERATION_COMPLETE_PORT = "COMPLETE_PORT";
    public static final String OPERATION_UPDATE_PORT = "UPDATE_PORT";
    public static final String OPERATION_COMMIT_SUBCOMPONENT_DATA = "COMMIT_SUBCOMPONENT_DATA";
    public static final String OPERATION_COMBINE_CHANGE_SETS = "COMBINE_CHANGE_SETS";
    public static final String OPERATION_DUPLICATE_CHANGE_SET = "DUPLICATE_CHANGE_SET";
    public static final String OPERATION_ROLLBACK = "ROLLBACK";
    public static final String OPERATION_REPLACE_WORKSPACE = "REPLACE_WORKSPACE";
    public static final String OPERATION_REPLACE_STREAM = "REPLACE_STREAM";
    public static final String OPERATION_DELETED_WORKSPACE = "DELETED_WORKSPACE";
    public static final String INACCESSIBLE_ITEM = "scm.inaccessible.item";
    public static final String INACCESSIBLE_BASELINE = "scm.inaccessible.baseline";
    private static final String SUBSTITUTION_PATTERN = "{0}";
    private static OperationsCmdLabelGenerator instance;
    private Map<String, String[]> operationStrings;

    private OperationsCmdLabelGenerator() {
        this.init();
    }

    private void init() {
        this.operationStrings = new HashMap<String, String[]>();
        this.add(OPERATION_ACCEPT, Messages.WorkspaceHistory_AcceptedChanges, Messages.WorkspaceHistory_AcceptedChangesInComponents);
        this.add(OPERATION_ACCEPT_COMBINED, Messages.WorkspaceHistory_AcceptedChanges, Messages.WorkspaceHistory_AcceptedChangesInComponents);
        this.add(OPERATION_DELIVER, Messages.WorkspaceHistory_DeliveredChanges, Messages.WorkspaceHistory_DeliveredChangesInComponents);
        this.add(OPERATION_DELIVER_COMBINED, Messages.WorkspaceHistory_DeliveredChanges, Messages.WorkspaceHistory_DeliveredChangesInComponents);
        this.add(OPERATION_ADD_COMPONENT, Messages.WorkspaceHistory_AddedComponent, Messages.WorkspaceHistory_AddedNComponents);
        this.add(OPERATION_REPLACE_COMPONENT, Messages.WorkspaceHistory_ReplacedComponent, Messages.WorkspaceHistory_ReplacedNComponents);
        this.add(OPERATION_REMOVE_COMPONENT, Messages.WorkspaceHistory_RemovedComponent, Messages.WorkspaceHistory_RemovedNComponents);
        this.add(OPERATION_DISCARD, Messages.WorkspaceHistory_DiscardedChanges, Messages.WorkspaceHistory_DiscardedChangesInComponents);
        this.add(OPERATION_DISCARD_BASIS, Messages.WorkspaceHistory_DiscardedBasisSummary, Messages.WorkspaceHistory_DiscardedBasisInComponentsSummary);
        this.add(OPERATION_SUSPEND, Messages.WorkspaceHistory_SuspendedComponent, Messages.WorkspaceHistory_SuspendNComponents);
        this.add(OPERATION_RESUME, Messages.WorkspaceHistory_ResumedComponent, Messages.WorkspaceHistory_ResumedNComponents);
        this.add(OPERATION_CLOSE_CHANGE_SET, Messages.WorkspaceHistory_ClosedChangeSets, Messages.WorkspaceHistory_ClosedChangeSetNComponents);
        this.add(OPERATION_CREATE_BASELINE, Messages.WorkspaceHistory_CreatedBaseline, Messages.WorkspaceHistory_CreatedBaselineNComponents);
        this.add(OPERATION_CREATE_BASELINE_SET, Messages.WorkspaceHistory_CreatedSnapshot, Messages.WorkspaceHistory_CreatedSnapshotUnknown);
        this.add(OPERATION_CREATE_CHANGE_SET, Messages.WorkspaceHistory_CreatedChangeSet);
        this.add(OPERATION_RELOCATE_CHANGES, Messages.WorkspaceHistory_RelocateChanges);
        this.add(OPERATION_CREATE_CHANGE_SET_STREAM, Messages.WorkspaceHistory_CreatedChangeSet);
        this.add(OPERATION_COMMIT, Messages.WorkspaceHistory_CommitChangeSet, Messages.WorkspaceHistory_CommitChangeSetNComponents);
        this.add(OPERATION_MOVE_WITH_HISTORY, Messages.WorkspaceHistory_CrossComponentMove, Messages.WorkspaceHistory_CrossComponentMove);
        this.add(OPERATION_CREATE_PORT, Messages.WorkspaceHistory_CreatePort, Messages.WorkspaceHistory_CreatePortNComponents);
        this.add(OPERATION_PORT_ABORT, Messages.WorkspaceHistory_PortAbort, Messages.WorkspaceHistory_PortAbortNComponents);
        this.add(OPERATION_COMPLETE_PORT, Messages.WorkspaceHistory_CompletePort, Messages.WorkspaceHistory_CompletePortNComponents);
        this.add(OPERATION_COMMIT_SUBCOMPONENT_DATA, Messages.WorkspaceHistory_CommitSubComponentChanges);
        this.add(OPERATION_COMBINE_CHANGE_SETS, Messages.OperationsCmdLabelGenerator_CombinedChangeSets);
        this.add(OPERATION_DUPLICATE_CHANGE_SET, Messages.OperationsCmdLabelGenerator_DuplicatedChangeSet);
        this.add(OPERATION_CREATE_POST_IMPORT_BASELINE, Messages.WorkspaceHistory_PostImportBaseline);
        this.add(OPERATION_IMPORT_CHANGE_SET, Messages.WorkspaceHistory_ImportedChangeSet);
        this.add(OPERATION_ROLLBACK, Messages.WorkspaceHistory_RollbackComponentToDate, Messages.WorkspaceHistory_RollbackToDate);
        this.add(OPERATION_REPLACE_STREAM, Messages.WorkspaceHistory_ReplacedStream);
        this.add(OPERATION_REPLACE_WORKSPACE, Messages.WorkspaceHistory_ReplacedWorkspace);
        this.add(OPERATION_DELETED_WORKSPACE, Messages.WorkspaceHistory_DeletedWorkspace);
    }

    private void add(String key, String ... details) {
        this.operationStrings.put(key, details);
    }

    public static String getLabel(String operation, List<String> detailList, int size, PendingChangesUtil.PendingChangesOptions printOptions) {
        if (instance == null) {
            instance = new OperationsCmdLabelGenerator();
        }
        Object[] details = detailList != null ? detailList.toArray(new String[detailList.size()]) : new String[]{};
        String[] messages = OperationsCmdLabelGenerator.instance.operationStrings.get(operation);
        if (messages == null || messages.length == 0) {
            return operation;
        }
        String message = OPERATION_CREATE_BASELINE_SET.equals(operation) ? (details.length > 0 ? messages[0] : messages[1]) : (messages.length == 2 && size > 1 ? messages[1] : messages[0]);
        if (!message.contains(SUBSTITUTION_PATTERN)) {
            return message;
        }
        int i = 0;
        while (i < details.length) {
            if (INACCESSIBLE_ITEM.equals(details[i])) {
                details[i] = Messages.WorkspaceHistory_InaccessibleComponent;
            } else if (INACCESSIBLE_BASELINE.equals(details[i])) {
                details[i] = Messages.WorkspaceHistory_InaccessibleBaseline;
            }
            ++i;
        }
        if (OPERATION_ROLLBACK.equals(operation)) {
            long date = Long.valueOf(details[0]);
            details[0] = printOptions.getDateFormat().format(new Date(date));
            return NLS.bind((String)message, (Object[])details);
        }
        if (details.length == 0) {
            return NLS.bind((String)message, (Object)size);
        }
        return NLS.bind((String)message, (Object[])details);
    }

    public static String getLabel(String operation, String sourceName, boolean isStream) {
        String message = null;
        if (OperationsCmdLabelGenerator.isAccept(operation)) {
            message = isStream ? Messages.WorkspaceHistory_ChangesAcceptedFromStream : Messages.WorkspaceHistory_ChangesAcceptedFromWorkspace;
        } else if (OperationsCmdLabelGenerator.isDeliver(operation)) {
            message = isStream ? Messages.WorkspaceHistory_ChangesDeliveredFromStream : Messages.WorkspaceHistory_ChangesDeliveredFromWorkspace;
        } else if (OperationsCmdLabelGenerator.isReplace(operation)) {
            message = isStream ? Messages.WorkspaceHistory_ComponentReplacedFromStream : Messages.WorkspaceHistory_ComponentReplacedFromWorkspace;
        } else {
            return null;
        }
        return NLS.bind((String)message, (Object)sourceName);
    }

    private static boolean isReplace(String operation) {
        return operation.equals(OPERATION_REPLACE_COMPONENT);
    }

    private static boolean isDeliver(String operation) {
        return operation.equals(OPERATION_DELIVER) || operation.equals(OPERATION_DELIVER_COMBINED);
    }

    private static boolean isAccept(String operation) {
        return operation.equals(OPERATION_ACCEPT) || operation.equals(OPERATION_ACCEPT_COMBINED);
    }
}

