/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.OperationsCmdLabelGenerator;
import com.ibm.team.filesystem.cli.client.internal.subcommands.OperationsCmdOpts;
import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmBaseline;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponentOperationDescription;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmReason;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmSnapshot;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceHistory;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceHistoryChangeSet;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceHistoryEntry;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceOperationDescription;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class OperationsCmd
extends AbstractSubcommand {
    public static final String TRUNCATED_ADDED_CHANGES = "truncated.added.changes";
    public static final String TRUNCATED_REMOVED_CHANGES = "truncated.removed.changes";
    public static final String TRUNCATED_REMOVED_BASELINES = "truncated.removed.baselines";
    private PendingChangesUtil.PendingChangesOptions printOptions;
    private boolean detailsTruncated = false;

    public void run() throws FileSystemException {
        int index;
        IWorkspace wsFound;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        boolean includeCheckins = subargs.hasOption(OperationsCmdOpts.OPT_CHECKIN_FILTER);
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument itemSelectorArg = null;
        if (!subargs.hasOption(OperationsCmdOpts.OPT_ITEM_SELECTOR)) {
            return;
        }
        itemSelectorArg = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(OperationsCmdOpts.OPT_ITEM_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)itemSelectorArg, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM, RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        if (this.config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            ConnectionInfo connectionInfo = this.config.getConnectionInfo();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)connectionInfo);
        } else {
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(itemSelectorArg.getRepositorySelector()));
        }
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        IndentingPrintStream printStream = this.config.getWrappedOutputStream();
        int entriesToFetch = RepoUtil.getMaxResultsOption((ICommandLine)subargs);
        IAlias alias = RepoUtil.lookupByIdOrAlias((String)itemSelectorArg.getItemSelector(), (String)repo.getRepositoryURI());
        String workspaceId = null;
        String historyReferenceId = null;
        ParmsHistoryReference historyReference = null;
        if (alias == null) {
            historyReference = SubcommandUtil.createParmsHistoryReference((String)itemSelectorArg.getItemSelector(), (String)repo.getRepositoryURI());
            if (historyReference == null) {
                try {
                    workspaceId = UUID.valueOf((String)itemSelectorArg.getItemSelector()).getUuidValue();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (workspaceId == null) {
                    wsFound = RepoUtil.getWorkspace((String)itemSelectorArg.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                    workspaceId = wsFound.getItemId().getUuidValue();
                }
            }
        } else if (alias.getItemType() == RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE) {
            historyReference = SubcommandUtil.createParmsHistoryReference((String)itemSelectorArg.getItemSelector(), (String)repo.getRepositoryURI());
            if (historyReference == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_NOT_A_HISTORY_REF, (Object)itemSelectorArg.getItemSelector()));
            }
        } else {
            wsFound = RepoUtil.getWorkspace((String)itemSelectorArg.getItemSelector(), (boolean)true, (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            workspaceId = wsFound != null ? wsFound.getItemId().getUuidValue() : alias.getId();
        }
        if (historyReference != null) {
            workspaceId = historyReference.workspaceId;
            historyReferenceId = alias != null ? alias.getId() : itemSelectorArg.getItemSelector();
            verbose = true;
            entriesToFetch = 1;
        }
        this.printOptions = new PendingChangesUtil.PendingChangesOptions();
        this.printOptions.enablePrinter(0);
        this.printOptions.setDateFormat(new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss a"));
        this.printOptions.setVerbose(verbose);
        JSONObject workspaceJson = null;
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), workspaceId);
        try {
            WorkspaceDetailsDTO workspaceDetail = RepoUtil.getWorkspaceDetail((ParmsWorkspace)ws, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            WorkspaceDetailsDTO incomingFlowDetail = RepoUtil.getFlowTargetDetails((WorkspaceDetailsDTO)workspaceDetail, (RepoUtil.FlowType)RepoUtil.FlowType.INCOMING, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            WorkspaceDetailsDTO outgoingFlowDetail = RepoUtil.getFlowTargetDetails((WorkspaceDetailsDTO)workspaceDetail, (RepoUtil.FlowType)RepoUtil.FlowType.OUTGOING, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            workspaceJson = JSONPrintUtil.jsonizeWorkspace((WorkspaceDetailsDTO)workspaceDetail, (WorkspaceDetailsDTO)incomingFlowDetail, (WorkspaceDetailsDTO)outgoingFlowDetail, (ITeamRepository)repo, (PendingChangesUtil.PendingChangesOptions)this.printOptions);
        }
        catch (CLIFileSystemClientException e) {
            if (e.getStatus().getCode() == 25 || e.getStatus().getCode() == 3 && e.getMessage().contains("CRJAZ0215E")) {
                workspaceJson = new JSONObject();
                workspaceJson.put((Object)"uuid", (Object)workspaceId);
                workspaceJson.put((Object)"name", (Object)NLS.bind((String)Messages.WorkspaceHistory_DeletedItem, (Object)workspaceId));
                verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
                this.printOptions.setVerbose(verbose);
                entriesToFetch = RepoUtil.getMaxResultsOption((ICommandLine)subargs);
            }
            throw e;
        }
        if (!this.config.isJSONEnabled()) {
            PendingChangesUtil.printWorkspaceHeader((JSONObject)workspaceJson, (IndentingPrintStream)printStream, (PendingChangesUtil.PendingChangesOptions)this.printOptions);
        }
        IScmRichClientRestService.ParmsGetWorkspaceHistory parms = new IScmRichClientRestService.ParmsGetWorkspaceHistory();
        parms.workspaceId = workspaceId;
        parms.historyReferenceId = historyReferenceId;
        parms.includeDetails = verbose;
        parms.includeCheckins = includeCheckins;
        parms.startTime = SubcommandUtil.getTimeArgument((ICommandLine)subargs, (IOptionKey)OperationsCmdOpts.OPT_BEFORE, (boolean)true, (IScmClientConfiguration)this.config);
        parms.endTime = SubcommandUtil.getTimeArgument((ICommandLine)subargs, (IOptionKey)OperationsCmdOpts.OPT_AFTER, (boolean)false, (IScmClientConfiguration)this.config);
        if (subargs.hasOption(OperationsCmdOpts.OPT_MAX_DETAILS)) {
            ICommandLineArgument optionValue = subargs.getOptionValue(OperationsCmdOpts.OPT_MAX_DETAILS);
            String value = optionValue.getValue();
            if (value.equals("all") || value.equals("-")) {
                parms.maxDetailSize = -1;
            } else {
                try {
                    parms.maxDetailSize = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.OperationsCmd_NOT_A_NUMBER, (Object)OperationsCmdOpts.OPT_MAX_DETAILS.getName()));
                }
            }
        }
        if (subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
            List componentSelectors = ScmCommandLineArgument.createList((List)subargs.getOptionValues((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)componentSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            String[] components = new String[componentSelectors.size()];
            index = 0;
            for (IScmCommandLineArgument componentSelector : componentSelectors) {
                IComponent component = RepoUtil.getComponent((String)componentSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                components[index++] = component.getItemId().getUuidValue();
            }
            parms.componentFilter = components;
        }
        if (subargs.hasOption(OperationsCmdOpts.OPT_USER_FILTER)) {
            List userSelectors = ScmCommandLineArgument.createList((List)subargs.getOptionValues(OperationsCmdOpts.OPT_USER_FILTER), (IScmClientConfiguration)this.config);
            if (userSelectors.isEmpty()) {
                parms.userFilter = new String[]{"current"};
            } else {
                String[] userUUIDs = new String[userSelectors.size()];
                index = 0;
                for (IScmCommandLineArgument userSelector : userSelectors) {
                    IContributor contributor = RepoUtil.getContributorForContributorRecord((String)userSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                    userUUIDs[index++] = contributor.getItemId().getUuidValue();
                }
                parms.userFilter = userUUIDs;
            }
        }
        try {
            int MAX_PAGE_SIZE = 512;
            ScmWorkspaceHistory workspaceHistory = null;
            String nextPage = null;
            String previousPage = null;
            ArrayList<ScmWorkspaceHistoryEntry> historyEntries = new ArrayList<ScmWorkspaceHistoryEntry>();
            do {
                parms.maxResultSize = Math.min(entriesToFetch, 512);
                parms.pageToken = nextPage;
                workspaceHistory = scmService.postGetWorkspaceHistory(parms);
                historyEntries.addAll(workspaceHistory.getHistoryEntries());
                nextPage = workspaceHistory.getNextPage();
                if (previousPage != null) continue;
                previousPage = workspaceHistory.getPreviousPage();
            } while (nextPage != null && (entriesToFetch -= 512) > 0);
            this.printWorkspaceHistory(historyEntries, previousPage, nextPage, printStream.indent(), repo);
            if (!this.config.isJSONEnabled()) {
                if (this.detailsTruncated) {
                    printStream.println((CharSequence)NLS.bind((String)Messages.OperationsCmd_MORE_DETAILS_AVAILABLE, (Object)OperationsCmdOpts.OPT_MAX_DETAILS.getName()));
                }
                if (workspaceHistory.getNextPage() != null && !subargs.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS)) {
                    printStream.println();
                    printStream.println((CharSequence)NLS.bind((String)Messages.OperationsCmd_MORE_OPERATIONS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
                }
            }
        }
        catch (TeamRepositoryException e) {
            String message = NLS.bind((String)Messages.OperationsCmd_OPERATION_FETCH_ERROR, (Object)e.getMessage());
            throw StatusHelper.wrap((String)message, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }

    private void printWorkspaceHistory(List<ScmWorkspaceHistoryEntry> historyEntries, String previousPage, String nextPage, IndentingPrintStream printStream, ITeamRepository repo) {
        if (this.config.isJSONEnabled()) {
            JSONObject workspaceHistoryJson = JSONPrintUtil.jsonizeWorkspaceHistory(historyEntries, (String)previousPage, (String)nextPage, (PendingChangesUtil.PendingChangesOptions)this.printOptions, (ITeamRepository)repo);
            JSONObject root = new JSONObject();
            root.put((Object)"workspace_history", (Object)workspaceHistoryJson);
            this.config.getOutputStream().print((CharSequence)root.toString());
        } else {
            for (ScmWorkspaceHistoryEntry historyEntry : historyEntries) {
                String message;
                String operation = OperationsCmdLabelGenerator.getLabel(historyEntry.getOperation(), historyEntry.getDetails(), historyEntry.getAffectedComponentCount(), this.printOptions);
                String date = this.printOptions.getDateFormat().format(new Date(historyEntry.getDate()));
                String operationAlias = AliasUtil.alias((AliasUtil.IAliasOptions)((ScmClientConfiguration)CommandLineCore.getConfig()), (String)historyEntry.getWorkspaceComponentStateId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE);
                if (this.printOptions.isVerbose()) {
                    message = NLS.bind((String)Messages.OperationsCmd_OPERATION_LABEL_VERBOSE, (Object)operationAlias, (Object)operation);
                    printStream.println((CharSequence)message);
                    String performedMessage = NLS.bind((String)Messages.OperationsCmd_OPERATION_CONTRIBUTOR, (Object)historyEntry.getContributor().getName(), (Object)date);
                    printStream.println((CharSequence)performedMessage);
                    ScmWorkspaceOperationDescription description = historyEntry.getDescription();
                    int numAffectedComponents = historyEntry.getAffectedComponentCount();
                    this.printOperationDescriptions(description, printStream, repo, numAffectedComponents);
                    continue;
                }
                message = NLS.bind((String)Messages.OperationsCmd_OPERATION_LABEL, (Object[])new String[]{operationAlias, operation, historyEntry.getContributor().getName(), date});
                printStream.println((CharSequence)message);
            }
        }
    }

    private void printOperationDescriptions(ScmWorkspaceOperationDescription operationDescription, IndentingPrintStream printStream, ITeamRepository repo, int numAffectedComponents) {
        this.printWorkspaceHistoryOperationDetail(operationDescription, printStream);
        if (operationDescription.getSnapshot() != null) {
            ScmSnapshot snapshot = operationDescription.getSnapshot();
            printStream.println((CharSequence)NLS.bind((String)Messages.OperationsCmd_SNAPSHOT, (Object[])new String[]{AliasUtil.selector((String)snapshot.getName(), (UUID)UUID.valueOf((String)snapshot.getItemId()), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT)}));
        }
        this.printWorkspaceHistoryOperationChildren(operationDescription, printStream.indent(), repo, numAffectedComponents);
        printStream.println();
    }

    private void printWorkspaceHistoryOperationDetail(ScmWorkspaceOperationDescription operationDescription, IndentingPrintStream printStream) {
        List componentOperations = operationDescription.getComponentDescriptions();
        HashSet<String> sources = new HashSet<String>();
        for (ScmComponentOperationDescription componentOperation : componentOperations) {
            String sourceWorkspaceItemId = componentOperation.getSourceWorkspaceItemId();
            if (sourceWorkspaceItemId == null || sources.contains(sourceWorkspaceItemId)) continue;
            sources.add(sourceWorkspaceItemId);
            String message = OperationsCmdLabelGenerator.getLabel(componentOperation.getOperation(), componentOperation.getSourceName(), componentOperation.isSourceIsStream());
            printStream.println((CharSequence)message);
        }
    }

    private void printWorkspaceHistoryOperationChildren(ScmWorkspaceOperationDescription workspaceOperationDescription, IndentingPrintStream printStream, ITeamRepository repo, int numAffectedComponents) {
        int numDescribedComponents;
        int extra;
        List componentDescriptions = workspaceOperationDescription.getComponentDescriptions();
        int inaccessibleComponentCount = workspaceOperationDescription.getInaccessibleComponents();
        if (componentDescriptions.size() == 1 && inaccessibleComponentCount == 0) {
            this.printComponent((ScmComponentOperationDescription)componentDescriptions.get(0), printStream, repo);
        } else {
            for (ScmComponentOperationDescription componentOperationDescription : componentDescriptions) {
                this.printComponent(componentOperationDescription, printStream, repo);
            }
        }
        if (inaccessibleComponentCount > 0) {
            String inaccessibleLabel = NLS.bind((String)Messages.WorkspaceHistory_ChangesInInaccessibleComponents, (Object)inaccessibleComponentCount);
            printStream.println((CharSequence)inaccessibleLabel);
        }
        if ((extra = numAffectedComponents - (numDescribedComponents = workspaceOperationDescription.getComponentDescriptions().size()) - inaccessibleComponentCount) > 0) {
            String moreLabel = extra == 1 ? NLS.bind((String)Messages.WorkspaceHistory_MoreComponent, (Object)extra) : NLS.bind((String)Messages.WorkspaceHistory_MoreComponents, (Object)extra);
            printStream.println((CharSequence)moreLabel);
        }
    }

    private void printComponent(ScmComponentOperationDescription componentOperationDescription, IndentingPrintStream printStream, ITeamRepository repo) {
        boolean hasAddedBaseline = componentOperationDescription.getBaseline() != null && componentOperationDescription.isBasisChanged();
        boolean hasRemovedBaseline = componentOperationDescription.getRemovedBaselines() != null && !componentOperationDescription.getRemovedBaselines().isEmpty();
        boolean hasBackupBaseline = componentOperationDescription.getBackupBaseline() != null;
        boolean hasAddedChangeSets = componentOperationDescription.getAddedChangeSets() != null && !componentOperationDescription.getAddedChangeSets().isEmpty();
        boolean hasRemovedChangeSets = componentOperationDescription.getRemovedChangeSets() != null && !componentOperationDescription.getRemovedChangeSets().isEmpty();
        String name = componentOperationDescription.getComponent().getName();
        UUID uuid = UUID.valueOf((String)componentOperationDescription.getComponent().getItemId());
        String label = AliasUtil.selector((String)name, (UUID)uuid, (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        printStream.println((CharSequence)NLS.bind((String)com.ibm.team.filesystem.cli.core.internal.Messages.PendingChangesUtil_61, (Object)label));
        IndentingPrintStream contentPrintStream = printStream;
        if (hasAddedBaseline || hasAddedChangeSets) {
            if (componentOperationDescription.getOperation().equals("REPLACE_COMPONENT") || componentOperationDescription.getOperation().equals("COMBINE_CHANGE_SETS") || componentOperationDescription.getOperation().equals("DUPLICATE_CHANGE_SET")) {
                contentPrintStream = printStream.indent();
                contentPrintStream.println((CharSequence)Messages.WorkspaceHistory_ChangeSetsAdded);
            }
            ScmBaseline baseline = componentOperationDescription.isBasisChanged() ? componentOperationDescription.getBaseline() : null;
            ChangeSetSorter changeSetSorter = new ChangeSetSorter(baseline, (List<ScmWorkspaceHistoryChangeSet>)componentOperationDescription.getAddedChangeSets());
            this.printChangeSets(componentOperationDescription, contentPrintStream.indent(), changeSetSorter, true, repo);
        }
        if (hasRemovedChangeSets || hasRemovedBaseline) {
            if (componentOperationDescription.getOperation().equals("REPLACE_COMPONENT") || componentOperationDescription.getOperation().equals("DISCARD_BASIS") || componentOperationDescription.getOperation().equals("COMBINE_CHANGE_SETS") || componentOperationDescription.getOperation().equals("DUPLICATE_CHANGE_SET")) {
                contentPrintStream = printStream.indent();
                contentPrintStream.println((CharSequence)Messages.WorkspaceHistory_ChangeSetsRemoved);
            }
            ChangeSetSorter changeSetSorter = new ChangeSetSorter(componentOperationDescription.getRemovedBaselines(), (List<ScmWorkspaceHistoryChangeSet>)componentOperationDescription.getRemovedChangeSets());
            this.printChangeSets(componentOperationDescription, contentPrintStream.indent(), changeSetSorter, false, repo);
        }
        if (hasBackupBaseline) {
            this.printBaseline(componentOperationDescription.getBackupBaseline(), componentOperationDescription.getOperation(), contentPrintStream.indent(), repo);
        }
    }

    private void printChangeSets(ScmComponentOperationDescription componentOperationDescription, IndentingPrintStream level0Stream, ChangeSetSorter changeSetSorter, boolean printingAdded, ITeamRepository repo) {
        if (changeSetSorter.getUnassociatedChangesets().size() > 0) {
            level0Stream.println((CharSequence)com.ibm.team.filesystem.cli.core.internal.Messages.PendingChangesUtil_49);
            IndentingPrintStream level1Stream = level0Stream.indent();
            for (ScmWorkspaceHistoryChangeSet changeSet : changeSetSorter.getUnassociatedChangesets()) {
                this.printChangeSet(changeSet, level1Stream, repo);
            }
            this.detailsTruncated |= this.printTruncatedMessage(componentOperationDescription, level1Stream, printingAdded);
        }
        for (ChangeSetSorter.BaselineNode baseline : changeSetSorter.getBaselineNodes()) {
            this.printBaseline(baseline.getBaselineDTO(), componentOperationDescription.getOperation(), level0Stream, repo);
            if (baseline.changeSets.size() <= 0) continue;
            IndentingPrintStream level1Stream = level0Stream.indent();
            level1Stream.println((CharSequence)com.ibm.team.filesystem.cli.core.internal.Messages.PendingChangesUtil_49);
            IndentingPrintStream level2Stream = level1Stream.indent();
            for (ScmWorkspaceHistoryChangeSet changeSet : baseline.getChangeSets()) {
                this.printChangeSet(changeSet, level2Stream, repo);
            }
            this.detailsTruncated |= this.printTruncatedMessage(componentOperationDescription, level1Stream, printingAdded);
        }
    }

    private boolean printTruncatedMessage(ScmComponentOperationDescription componentOperationDescription, IndentingPrintStream level1Stream, boolean printingAdded) {
        boolean wasTruncated = false;
        String additionalDetailsData = componentOperationDescription.getAdditionalDetailsJSON();
        if (additionalDetailsData != null) {
            try {
                String key;
                JSONObject additionDetails = JSONObject.parse((Reader)new StringReader(additionalDetailsData));
                String string = key = printingAdded ? TRUNCATED_ADDED_CHANGES : TRUNCATED_REMOVED_CHANGES;
                if (additionDetails.containsKey((Object)key)) {
                    wasTruncated = true;
                    Long count = (Long)additionDetails.get((Object)key);
                    level1Stream.println((CharSequence)NLS.bind((String)Messages.OperationsCmd_MORE_CHANGE_SETS, (Object)count));
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.OperationsCmd_OPERATION_FETCH_ERROR, (Object)e.getMessage());
                StatusHelper.logException((String)message, (Throwable)e);
            }
        }
        return wasTruncated;
    }

    private void printBaseline(ScmBaseline baseline, String operation, IndentingPrintStream printStream, ITeamRepository repo) {
        String id = baseline.getId();
        String name = baseline.getName();
        if ("DISCARD_BASIS".equals(operation)) {
            printStream.println((CharSequence)Messages.WorkspaceHistory_DiscardedBasis);
        }
        printStream.println((CharSequence)NLS.bind((String)com.ibm.team.filesystem.cli.core.internal.Messages.PendingChangesUtil_36, (Object)AliasUtil.selector((int)Integer.parseInt(id), (String)name, (UUID)UUID.valueOf((String)baseline.getItemId()), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE)));
    }

    private void printChangeSet(ScmWorkspaceHistoryChangeSet changeSet, IndentingPrintStream printStream, ITeamRepository repo) {
        String comment;
        boolean hasReason;
        String reason = "";
        boolean bl = hasReason = !changeSet.getReasons().isEmpty();
        if (hasReason) {
            reason = ((ScmReason)changeSet.getReasons().get(0)).getLabel();
        }
        comment = (comment = changeSet.getComment()) == null || comment.isEmpty() ? Messages.OperationsCmd_NO_COMMENT : comment.replaceAll("\\r\\n|\\r|\\n", " ");
        String alias = AliasUtil.alias((AliasUtil.IAliasOptions)((ScmClientConfiguration)CommandLineCore.getConfig()), (UUID)UUID.valueOf((String)changeSet.getItemId()), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        String dateModified = this.printOptions.getDateFormat().format(new Date(changeSet.getDateModified()));
        printStream.println((CharSequence)NLS.bind((String)Messages.OperationsCmd_CHANGE_SET_DESCRIPTION, (Object[])new String[]{alias, dateModified, reason, comment}));
    }

    public class ChangeSetSorter {
        private static final String NO_PARENT = "NO_PARENT";
        Map<String, List<ScmWorkspaceHistoryChangeSet>> baselineMap;
        List<ScmBaseline> baselines;

        public ChangeSetSorter(List<ScmBaseline> baselines, List<ScmWorkspaceHistoryChangeSet> changeSets) {
            this.init(baselines, changeSets);
        }

        public ChangeSetSorter(ScmBaseline baseline, List<ScmWorkspaceHistoryChangeSet> changeSets) {
            if (baseline == null) {
                this.init(Collections.emptyList(), changeSets);
            } else {
                this.init(Collections.singletonList(baseline), changeSets);
            }
        }

        private void init(List<ScmBaseline> baselines, List<ScmWorkspaceHistoryChangeSet> changeSets) {
            this.baselineMap = new HashMap<String, List<ScmWorkspaceHistoryChangeSet>>();
            this.baselines = baselines;
            this.baselineMap.put(NO_PARENT, new ArrayList());
            for (ScmWorkspaceHistoryChangeSet changeSet : changeSets) {
                List<ScmWorkspaceHistoryChangeSet> changeSetBucket;
                String id = changeSet.getParentBaselineId();
                if (id == null) {
                    id = NO_PARENT;
                }
                if ((changeSetBucket = this.baselineMap.get(id)) == null) {
                    changeSetBucket = new ArrayList<ScmWorkspaceHistoryChangeSet>();
                    this.baselineMap.put(id, changeSetBucket);
                }
                changeSetBucket.add(changeSet);
            }
        }

        public List<ScmWorkspaceHistoryChangeSet> getUnassociatedChangesets() {
            return this.baselineMap.get(NO_PARENT);
        }

        public List<BaselineNode> getBaselineNodes() {
            ArrayList<BaselineNode> result = new ArrayList<BaselineNode>();
            for (ScmBaseline baselineDTO : this.baselines) {
                List<ScmWorkspaceHistoryChangeSet> changeSets = this.baselineMap.get(baselineDTO.getItemId());
                result.add(new BaselineNode(baselineDTO, changeSets));
            }
            return result;
        }

        public class BaselineNode {
            private ScmBaseline baselineDTO;
            private List<ScmWorkspaceHistoryChangeSet> changeSets;

            public BaselineNode(ScmBaseline baselineDTO, List<ScmWorkspaceHistoryChangeSet> changeSets) {
                this.baselineDTO = baselineDTO;
                this.changeSets = changeSets == null ? Collections.emptyList() : changeSets;
            }

            ScmBaseline getBaselineDTO() {
                return this.baselineDTO;
            }

            List<ScmWorkspaceHistoryChangeSet> getChangeSets() {
                return this.changeSets;
            }
        }
    }
}

