/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.MoveInRepositoryCmdOpts;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveVersionablesAcrossComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveVersionablesInWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveVersionablesWithinComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.MoveFoldersInWorkspaceResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePath;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class MoveInRepositoryCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        String[] path;
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(MoveInRepositoryCmdOpts.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        if (wsSelector != null) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        } else {
            repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
            ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        ScmCommandLineArgument sourceComponentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)MoveInRepositoryCmdOpts.OPT_SOURCE_COMPONENT_SELECTOR, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)sourceComponentSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        String sourceComponent = sourceComponentSelector.getItemSelector();
        UUID sourceComponentUUID = UUID.valueOf((String)RepoUtil.getComponent((ParmsWorkspace)ws, (String)sourceComponent, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).getItemId());
        UUID targetComponentUUID = null;
        ScmCommandLineArgument targetComponentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)MoveInRepositoryCmdOpts.OPT_COMPONENT_SELECTOR, null), (IScmClientConfiguration)this.config);
        if (targetComponentSelector != null) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)targetComponentSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            String targetComponent = targetComponentSelector.getItemSelector();
            targetComponentUUID = UUID.valueOf((String)RepoUtil.getComponent((ParmsWorkspace)ws, (String)targetComponent, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).getItemId());
        } else {
            targetComponentUUID = sourceComponentUUID;
        }
        String givenPath = null;
        givenPath = cli.hasOption(MoveInRepositoryCmdOpts.OPT_TARGET_KEY) ? ((path = StringUtil.splitEscapedPath((String)(givenPath = cli.getOption(MoveInRepositoryCmdOpts.OPT_TARGET_KEY)))).length == 0 ? Character.toString('/') : this.toPath(path, false)) : Character.toString('/');
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        ScmVersionablePath targetPath = null;
        try {
            targetPath = RepoUtil.getVersionable2((IScmRichClientRestService)scmService, (IItemHandle)ws.getWorkspaceHandle(), (String)targetComponentUUID.getUuidValue(), (String)givenPath, (IScmClientConfiguration)this.config);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (targetPath == null || targetPath.getVersionable() == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.MoveInRepositoryCmd_RemoteTargetPathNotFound, (Object)givenPath));
        }
        IVersionableHandle targetVersionable = targetPath.getVersionable();
        if (!IFolder.ITEM_TYPE.equals(targetVersionable.getItemType())) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.MoveInRepositoryCmd_InvalidItemType, (Object)givenPath));
        }
        givenPath = cli.getOption(MoveInRepositoryCmdOpts.OPT_SOURCE_KEY);
        String[] path2 = StringUtil.splitEscapedPath((String)givenPath);
        givenPath = path2.length == 0 ? Character.toString('/') : this.toPath(path2, false);
        ScmVersionablePath sourcePath = null;
        try {
            sourcePath = RepoUtil.getVersionable2((IScmRichClientRestService)scmService, (IItemHandle)ws.getWorkspaceHandle(), (String)sourceComponentUUID.getUuidValue(), (String)givenPath, (IScmClientConfiguration)this.config);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (sourcePath == null || sourcePath.getVersionable() == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.MoveInRepositoryCmd_RemoteSourcePathNotFound, (Object)givenPath));
        }
        IVersionableHandle sourceVersionable = sourcePath.getVersionable();
        String destinationComment = cli.getOption((IOptionKey)MoveInRepositoryCmdOpts.OPT_DESTINATION_CS_COMMENT, null);
        String sourceComment = cli.getOption((IOptionKey)MoveInRepositoryCmdOpts.OPT_SOURCE_CS_COMMENT, null);
        ParmsMoveVersionablesInWorkspace moveParms = new ParmsMoveVersionablesInWorkspace();
        if (sourceComponentUUID.equals((Object)targetComponentUUID)) {
            ParmsMoveVersionablesWithinComponentRequest parmsMoveWithinComponentRequest = new ParmsMoveVersionablesWithinComponentRequest();
            moveParms.moveWithinComponentRequests = new ParmsMoveVersionablesWithinComponentRequest[]{parmsMoveWithinComponentRequest};
            parmsMoveWithinComponentRequest.workspace = ws;
            parmsMoveWithinComponentRequest.componentItemId = sourceComponentUUID.getUuidValue();
            parmsMoveWithinComponentRequest.versionablesToMove = new ParmsVersionable[]{new ParmsVersionable(sourceVersionable)};
            parmsMoveWithinComponentRequest.parentFolderItemIds = new String[]{targetVersionable.getItemId().getUuidValue()};
            parmsMoveWithinComponentRequest.changeSetComment = destinationComment == null ? "" : destinationComment;
        } else {
            ParmsMoveVersionablesAcrossComponentRequest parmsMoveAcrossComponentRequest = new ParmsMoveVersionablesAcrossComponentRequest();
            moveParms.moveAcrossComponentRequests = new ParmsMoveVersionablesAcrossComponentRequest[]{parmsMoveAcrossComponentRequest};
            parmsMoveAcrossComponentRequest.workspace = ws;
            parmsMoveAcrossComponentRequest.sourceComponentItemId = sourceComponentUUID.getUuidValue();
            parmsMoveAcrossComponentRequest.versionablesToMove = new ParmsVersionable[]{new ParmsVersionable(sourceVersionable)};
            parmsMoveAcrossComponentRequest.targetComponentItemId = targetComponentUUID.getUuidValue();
            parmsMoveAcrossComponentRequest.parentFolderItemIds = new String[]{targetVersionable.getItemId().getUuidValue()};
            parmsMoveAcrossComponentRequest.targetChangeSetComment = destinationComment == null ? "" : destinationComment;
            parmsMoveAcrossComponentRequest.sourceChangeSetComment = sourceComment == null ? "" : sourceComment;
        }
        moveParms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        moveParms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED)) {
            moveParms.pendingChangesDilemmaHandler.pendingChangesInstruction = "no";
            moveParms.pendingChangesDilemmaHandler.pendingChangesInSubcomponentsInstruction = "no";
        } else {
            moveParms.pendingChangesDilemmaHandler.pendingChangesInstruction = "cancel";
            moveParms.pendingChangesDilemmaHandler.pendingChangesInSubcomponentsInstruction = "cancel";
        }
        MoveFoldersInWorkspaceResultDTO result = null;
        try {
            result = client.postMoveVersionablesInWorkspace(moveParms, null);
        }
        catch (TeamRepositoryException e) {
            PermissionDeniedException pde = (PermissionDeniedException)((Object)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e));
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)((Object)pde), (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.MoveInRepositoryCmd_MoveFailed, (Object)givenPath), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), null);
        }
        if (result.isCancelled()) {
            int noOfUncheckedInChanges;
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), this.config);
            }
            if ((noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
            }
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.MoveInRepositoryCmd_SUCCESSFULLY_COMPLETED);
    }

    private String toPath(String[] path, boolean isFolder) {
        return String.valueOf(StringUtil.createPathString((String[])path)) + (isFolder ? Character.valueOf('/') : "");
    }
}

