/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.MoveCmdOpts;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveResource;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveResources;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class MoveCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ICommandLine cli = this.config.getSubcommandCommandLine();
        String srcOpt = cli.getOption((IOptionKey)MoveCmdOpts.OPT_SOURCE);
        ILocation source = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)srcOpt);
        File sourceFile = (File)source.getAdapter(File.class);
        if (!sourceFile.exists()) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)srcOpt));
        }
        SandboxPathsResultDTO pathsResult = RepoUtil.getSandboxPathsAndRegister((String)source.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        ShareableDTO shareableSource = (ShareableDTO)pathsResult.getPaths().get(0);
        if (shareableSource.getRelativePath().getSegments().size() == 1) {
            throw StatusHelper.moveFailure((String)Messages.MoveCmd_PROJECT_FOLDER_MOVE_NOT_SUPPORTED);
        }
        if (SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config)) {
            PathLocation sandboxLoc = new PathLocation(shareableSource.getSandboxPath());
            SubcommandUtil.refreshPaths((ILocation)sandboxLoc, Collections.singletonList(source), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        if (!sourceFile.exists()) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)srcOpt));
        }
        String tgtOpt = cli.getOption((IOptionKey)MoveCmdOpts.OPT_TARGET);
        ILocation target = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)tgtOpt);
        File targetParentFile = (File)target.getParent().getAdapter(File.class);
        if (!targetParentFile.exists()) {
            throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_TARGET_HAS_NO_PARENT, (Object)tgtOpt));
        }
        pathsResult = RepoUtil.getSandboxPathsAndRegister((String)target.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        ShareableDTO shareableTarget = (ShareableDTO)pathsResult.getPaths().get(0);
        if (shareableTarget.getRelativePath().getSegments().size() == 0) {
            throw StatusHelper.moveFailure((String)Messages.MoveCmd_PROJECT_FOLDER_MOVE_NOT_SUPPORTED);
        }
        if (SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config)) {
            PathLocation sandboxLoc = new PathLocation(shareableTarget.getSandboxPath());
            SubcommandUtil.refreshPaths((ILocation)sandboxLoc, Collections.singletonList(target), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        if (!targetParentFile.exists()) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)tgtOpt));
        }
        File targetFile = (File)target.getAdapter(File.class);
        if (!targetFile.exists() && shareableTarget.getRelativePath().getSegments().size() == 1) {
            throw StatusHelper.moveFailure((String)Messages.MoveCmd_PROJECT_FOLDER_MOVE_NOT_SUPPORTED);
        }
        if (!shareableTarget.getSandboxPath().equals(shareableSource.getSandboxPath())) {
            throw StatusHelper.argSyntax((String)Messages.MoveCmd_MOVE_ACROSS_SANDBOXES_NOT_ALLOWED);
        }
        if (source.isPrefixOf(target)) {
            throw StatusHelper.disallowed((String)Messages.MoveCmd_SOURCE_IS_ANCESTOR_OF_TARGET);
        }
        IRelativeLocation sourceRelativeToSandbox = source.getLocationRelativeTo((ILocation)new PathLocation(shareableSource.getSandboxPath()));
        boolean targetIsDirectory = false;
        boolean renameChangeCase = false;
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                ILocation wouldBeTarget = target.append(sourceRelativeToSandbox.getName());
                File wouldBeTargetFile = (File)wouldBeTarget.getAdapter(File.class);
                if (wouldBeTargetFile.exists()) {
                    throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_TARGET_FILE_OR_FOLDER_EXISTS, (Object)sourceRelativeToSandbox.getName()));
                }
                targetIsDirectory = true;
            } else {
                try {
                    String targetName;
                    String sourceName;
                    if (Files.isSameFile(sourceFile.toPath(), targetFile.toPath()) && (sourceName = sourceFile.getName()).equalsIgnoreCase(targetName = targetFile.getName()) && !sourceName.equals(targetName)) {
                        renameChangeCase = true;
                    }
                    if (!renameChangeCase) {
                        throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_4, (Object)tgtOpt));
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException((Throwable)e);
                }
            }
        }
        if (source.isPrefixOf(target)) {
            throw StatusHelper.moveFailure((String)Messages.MoveCmd_5);
        }
        String relTargetPath = StringUtil.createPathString((List)shareableTarget.getRelativePath().getSegments());
        if (targetIsDirectory) {
            relTargetPath = String.valueOf(relTargetPath) + '/' + source.getName();
        } else if (renameChangeCase) {
            int pathSeparatorIndex = relTargetPath.lastIndexOf(47);
            if (pathSeparatorIndex == -1) {
                relTargetPath = targetFile.getName();
            } else {
                relTargetPath = relTargetPath.substring(0, pathSeparatorIndex + 1);
                relTargetPath = relTargetPath.concat(targetFile.getName());
            }
        }
        ParmsMoveResources moveParms = new ParmsMoveResources(new ParmsMoveResource[]{new ParmsMoveResource(shareableSource.getSandboxPath(), StringUtil.createPathString((List)shareableSource.getRelativePath().getSegments()), relTargetPath)});
        try {
            client.postMoveResources(moveParms, null);
        }
        catch (TeamRepositoryException e) {
            PermissionDeniedException pde = (PermissionDeniedException)((Object)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e));
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)((Object)pde), (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.MoveCmd_9, (Object)srcOpt), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), null);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.MoveCmd_SUCCESSFULLY_COMPLETED);
    }
}

