/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLogout;
import com.ibm.team.filesystem.client.util.IRepositoryRecord;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;

public class LogoutCmd
extends AbstractSubcommand
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        options.setLongHelp(Messages.LogoutCmd_0);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_URI, Messages.LogoutCmd_1, true);
        options.setHideCommonOptions(false);
        return options;
    }

    public void run() throws FileSystemException {
        IRepositoryRecord rec;
        String repoURI;
        block6: {
            ICommandLine subargs = this.config.getSubcommandCommandLine();
            repoURI = subargs.getOption((IOptionKey)CommonOptions.OPT_URI, null);
            if (repoURI == null) {
                throw StatusHelper.argSyntax((String)Messages.LogoutCmd_2);
            }
            rec = this.config.getRepositoryRegistry().getRecord(repoURI);
            if (rec != null) {
                repoURI = rec.getUrl();
            }
            IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
            ParmsLogout parms = new ParmsLogout();
            parms.repositoryUrl = repoURI;
            try {
                client.postLogout(parms, null);
            }
            catch (IllegalArgumentException e) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LogoutCmd_5, (Object)repoURI));
            }
            catch (TeamRepositoryException e) {
                if (rec != null) break block6;
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LogoutCmd_3, (Object)repoURI));
            }
        }
        if (rec == null) {
            throw StatusHelper.createException((String)NLS.bind((String)Messages.LogoutCmd_CONCATENATE, (Object)NLS.bind((String)Messages.LogoutCmd_6, (Object)repoURI), (Object)NLS.bind((String)Messages.LogoutCmd_7, (Object)CommandLineCore.getConfig().getContext().getAppName())), (int)1, null);
        }
        this.config.getRepositoryRegistry().removeRecord(rec);
        this.config.getWrappedOutputStream().println((CharSequence)(String.valueOf(Messages.LogoutCmd_4) + repoURI));
        this.config.removeConnectionInfo(repoURI);
    }
}

