/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.RepositoryRegistry;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.util.IRepositoryRecord;
import com.ibm.team.filesystem.client.util.IRepositoryRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import java.io.File;
import org.eclipse.osgi.util.NLS;

public class LoginCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_NICKNAME = new OptionKey("nick");
    public static final IOptionKey OPT_CACHE = new OptionKey("cache");
    public static final IOptionKey OPT_GENERATEPASSWORDFILE = new OptionKey("genPassFile");
    public static final IOptionKey OPT_OVERWRITE_PASSWD_FILE = new OptionKey("overwrite");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        options.setLongHelp(Messages.LoginCmd_0);
        SubcommandUtil.addRepoLocationToOptions((Options)options, (boolean)true, (boolean)true);
        options.addOption(OPT_NICKNAME, "n", "nickname", Messages.LoginCmd_1, 1);
        options.addOption(OPT_CACHE, "c", "cache", Messages.LoginCmdOptions_CACHE_HELP, 0);
        options.addOption(OPT_GENERATEPASSWORDFILE, "g", "generatePasswordFile", Messages.LoginCmd_GENERATE_PASSWORD_FILE, 1);
        options.addOption(OPT_OVERWRITE_PASSWD_FILE, "o", "overwrite", Messages.LoginCmd_OVERWRITE_PASSWORD_FILE, 0);
        options.setHideCommonOptions(false);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        String url = subargs.getOption((IOptionKey)CommonOptions.OPT_URI, null);
        if (url == null) {
            throw StatusHelper.argSyntax((String)Messages.LoginCmd_2);
        }
        String passwdFileAbsolutePath = null;
        if (subargs.hasOption(OPT_GENERATEPASSWORDFILE)) {
            String passwdFilePath = subargs.getOption(OPT_GENERATEPASSWORDFILE, null);
            if (passwdFilePath != null) {
                if (passwdFilePath.length() < 1) {
                    throw StatusHelper.disallowed((String)Messages.LoginCmd_InvalidGenPassFilePath);
                }
                passwdFileAbsolutePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)passwdFilePath).toOSString();
                File file = new File(passwdFileAbsolutePath);
                if (file.isFile() && !subargs.hasOption(OPT_OVERWRITE_PASSWD_FILE)) {
                    throw StatusHelper.disallowed((String)NLS.bind((String)Messages.LoginCmd_OverwritePasswdFileError, (Object)passwdFileAbsolutePath, (Object)OPT_OVERWRITE_PASSWD_FILE.getName()));
                }
            }
        } else if (subargs.hasOption(OPT_OVERWRITE_PASSWD_FILE)) {
            throw StatusHelper.disallowed((String)NLS.bind((String)Messages.LoginCmd_OvewriteOnlyWithGenPass, (Object)OPT_OVERWRITE_PASSWD_FILE.getName()));
        }
        ConnectionInfo info = this.config.getConnectionInfo(url, null, true, false);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)info);
        String passwordToStore = null;
        String passwordFileLocationToStore = null;
        if (subargs.hasOption((IOptionKey)CommonOptions.OPT_PASSWORD_FILE)) {
            passwordFileLocationToStore = info.getPasswordFile().toOSString();
        } else if (subargs.hasOption((IOptionKey)CommonOptions.OPT_PASSWORD) || subargs.hasOption(OPT_CACHE) && info.getPassword() != null) {
            passwordToStore = info.getPassword();
        }
        if (passwdFileAbsolutePath != null) {
            ScmClientConfiguration.generatePasswordFile((String)passwdFileAbsolutePath, (String)info.getPassword());
        }
        String nick = subargs.getOption(OPT_NICKNAME, null);
        UUID userid = info.getUserUUID();
        IRepositoryRegistry repoReg = this.config.getRepositoryRegistry();
        RepositoryRegistry.RepositoryRecord record = new RepositoryRegistry.RepositoryRecord(info.getURI(), nick, info.getUsername(), passwordToStore, passwordFileLocationToStore, info.getCertificateFile() != null ? info.getCertificateFile().toOSString() : null, info.isSmartCard(), info.isKerberos(), info.isIntegratedWindows(), repo.getId(), userid);
        repoReg.addRecord((IRepositoryRecord)record);
        this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.LoginCmd_7, (Object)url));
    }
}

