/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class LoadCmdLauncher
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        File cfaRoot;
        List cSelectors = null;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(LoadCmdOptions.OPT_WORKSPACE_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        String loadTargetStr = subargs.getOption(LoadCmdOptions.OPT_LOAD_TARGET, null);
        String alternativeName = subargs.getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME, null);
        boolean getAll = subargs.hasOption((IOptionKey)CommonOptions.OPT_ALL);
        if (getAll && alternativeName != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_TOO_MANY_COMPONENTS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
        }
        if (subargs.hasOption(LoadCmdOptions.OPT_REMOTE_PATHS)) {
            cSelectors = ScmCommandLineArgument.createList((List)subargs.getOptionValues(LoadCmdOptions.OPT_REMOTE_PATHS), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)cSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            if (cSelectors.size() > 1 && loadTargetStr != null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_TOO_MANY_REMOTE_PATHS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOAD_TARGET).getName()));
            }
            if (cSelectors.size() > 1 && alternativeName != null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_TOO_MANY_REMOTE_PATHS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
            }
        }
        if (cSelectors == null && alternativeName != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_NO_REMOTE_PATHS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
        }
        boolean loadCompRoots = subargs.hasOption(LoadCmdOptions.OPT_LOAD_COMPONENT_ROOTS);
        if (loadCompRoots && alternativeName != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_SPECIFY_ONE_OF_COMPROOT_OR_ALTNAME, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOAD_COMPONENT_ROOTS).getName(), (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
        }
        boolean quiet = subargs.hasOption((IOptionKey)CommonOptions.OPT_QUIET);
        LoadRuleConfig loadRuleConfig = this.consumeLoadRuleArgs(subargs, cSelectors);
        IRelativeLocation loadTarget = null;
        File cwd = new File(this.config.getContext().getCurrentWorkingDirectory());
        File loc = null;
        loc = subargs.hasOption((IOptionKey)CommonOptions.OPT_DIRECTORY) || !subargs.hasOption((IOptionKey)LoadCmdOptions.OPT_DIR) ? cwd : new File(SubcommandUtil.makeAbsolutePath((String)cwd.getAbsolutePath(), (String)subargs.getOption((IOptionKey)LoadCmdOptions.OPT_DIR)).toOSString());
        File cfaAncestor = SubcommandUtil.findAncestorCFARoot((File)loc);
        if (cfaAncestor == null) {
            ResourceType resourceType = SubcommandUtil.getResourceType((IPath)new Path(loc.getPath()), null);
            if (resourceType == null) {
                if (!loc.mkdirs()) {
                    throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.LoadCmdLauncher_27, (Object)loc.getAbsolutePath()));
                }
            } else if (resourceType != ResourceType.FOLDER) {
                throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.LoadCmdLauncher_NOT_A_FOLDER, (Object)loc.getAbsolutePath()));
            }
            cfaRoot = loc;
        } else {
            if (!loc.equals(cfaAncestor)) {
                String metaDataName = "";
                String[] stringArray = Constants.METADATA_ROOT_NAMES;
                int n = Constants.METADATA_ROOT_NAMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    File metadir = new File(cfaAncestor, name);
                    if (metadir.exists()) {
                        metaDataName = name;
                    }
                    ++n2;
                }
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_MUST_LOAD_IN_ROOT_OR_SPECIFY_PATH, (Object[])new String[]{cfaAncestor.getAbsolutePath(), metaDataName, this.config.getSubcommandCommandLine().getDefinition().getOption(LoadCmdOptions.OPT_LOAD_TARGET).getName()}));
            }
            cfaRoot = cfaAncestor;
        }
        if (!SubcommandUtil.isEclipseWorkspaceRootSet()) {
            SubcommandUtil.initializeEclipseWorkspaceRoot((File)cfaRoot);
        }
        PathLocation cfaRootPath = new PathLocation(SubcommandUtil.canonicalize((File)cfaRoot).getAbsolutePath());
        if (loadTargetStr != null) {
            PathLocation fullLoadTarget;
            File loadTargetFile = new File(loadTargetStr);
            if (!loadTargetFile.isAbsolute()) {
                loadTargetFile = new File(cwd, loadTargetStr);
            }
            if (!cfaRootPath.isPrefixOf((ILocation)(fullLoadTarget = new PathLocation(SubcommandUtil.canonicalize((File)loadTargetFile).getAbsolutePath())))) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_LOAD_TARGET_PATH_NOT_DESCENDENT_OF_SANDBOX_PATH, (Object)fullLoadTarget.toOSString(), (Object)cfaRootPath.toOSString()));
            }
            loadTarget = fullLoadTarget.getLocationRelativeTo((ILocation)cfaRootPath);
        }
        new LoadCmd().run(this.config, (ILocation)cfaRootPath, (IScmCommandLineArgument)wsSelector, cSelectors, getAll, loadCompRoots, loadTarget, loadRuleConfig, quiet, alternativeName);
    }

    private LoadRuleConfig consumeLoadRuleArgs(ICommandLine subargs, List<IScmCommandLineArgument> cSelectors) throws FileSystemException {
        LoadRuleConfig rule;
        boolean hasLocal = subargs.hasOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH);
        boolean hasRemote = subargs.hasOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH);
        if (!hasLocal && !hasRemote) {
            return null;
        }
        if (hasLocal && hasRemote) {
            String remoteName = subargs.getDefinition().getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH).getName();
            String localName = subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH).getName();
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_1, (Object)localName, (Object)remoteName));
        }
        if (subargs.hasOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME) || subargs.hasOption(LoadCmdOptions.OPT_LOAD_COMPONENT_ROOTS)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_LOAD_RULE_INVALID_OPTIONS, (Object[])new String[]{subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName(), subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOAD_COMPONENT_ROOTS).getName(), subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH).getName(), subargs.getDefinition().getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH).getName()}));
        }
        if (hasRemote) {
            rule = new RemoteLoadRuleConfig();
            rule.remotePath = subargs.getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH);
        } else {
            assert (hasLocal);
            rule = new LocalLoadRuleConfig();
            ((LocalLoadRuleConfig)rule).localPath = subargs.getOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH);
        }
        return rule;
    }

    public static class LoadRuleConfig {
    }

    public static class LocalLoadRuleConfig
    extends LoadRuleConfig {
        public String localPath;
    }

    public static class RemoteLoadRuleConfig
    extends LoadRuleConfig {
        public String remotePath;
    }
}

