/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdLauncher;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoad;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadComponentVersionables;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadRule;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.StatusDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.CollisionDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.InvalidLoadRequestDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadEvaluationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadLocationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.MultipleSandboxLoadDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionable;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class LoadCmd {
    public void run(IScmClientConfiguration config, ILocation cfaRoot, IScmCommandLineArgument wsSelector, List<IScmCommandLineArgument> cSelectors, boolean getAll, boolean loadCompRoots, IRelativeLocation relativeLoadTarget, LoadCmdLauncher.LoadRuleConfig loadRuleConfig, boolean quiet, String alternativeName) throws FileSystemException {
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
        ITeamRepository repo = null;
        if (config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            ConnectionInfo connectionInfo = config.getConnectionInfo();
            repo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)connectionInfo);
        } else {
            repo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)config.getConnectionInfo(wsSelector.getRepositorySelector()));
        }
        IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)config);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        RepoUtil.validateWorkspaceIsTracked((ParmsWorkspace)ws, (String)Messages.LoadCmd_UNTRACKED_WORKSPACE, (IScmClientConfiguration)config);
        if (cSelectors != null) {
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, cSelectors, (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        if (loadRuleConfig != null && getAll) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_GET_ALL_ARGUMENT_MAY_NOT_BE_SPECIFIED_WITH_LOAD_RULE, (Object)CommonOptions.OPT_ALL.getName()));
        }
        if (relativeLoadTarget != null && loadRuleConfig == null && (cSelectors == null || cSelectors.size() != 1)) {
            String message = NLS.bind((String)Messages.LoadCmd_TARGET_OPTION_ERROR_1, (Object[])new String[]{LoadCmdOptions.OPT_LOAD_TARGET.getName(), LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH.getName(), LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH.getName()});
            throw StatusHelper.argSyntax((String)message);
        }
        List compSelectors = null;
        if (cSelectors != null) {
            compSelectors = RepoUtil.getSelectors(cSelectors);
        }
        ParmsLoad parms = null;
        if (loadRuleConfig == null) {
            parms = this.generateLoadParms(ws, compSelectors, getAll, loadCompRoots, cfaRoot, relativeLoadTarget, alternativeName, client, repo, config);
        } else {
            if (relativeLoadTarget != null && relativeLoadTarget.segmentCount() != 1) {
                throw StatusHelper.argSyntax((String)Messages.LoadCmd_TARGET_OPTION_ERROR_2);
            }
            parms = this.generateLoadParms(ws, compSelectors, loadRuleConfig, cfaRoot, relativeLoadTarget, client, repo, config);
        }
        IndentingPrintStream out = config.getWrappedOutputStream();
        if (parms.componentVersionablesToLoad == null && parms.versionablesToLoad == null && parms.loadRule == null && !quiet) {
            out.println((CharSequence)Messages.LoadCmd_NO_LOAD_REQUESTS);
            return;
        }
        this.evaluateLoad(parms, config.getSubcommandCommandLine().hasOption(LoadCmdOptions.OPT_FORCE), config.getSubcommandCommandLine().hasOption((IOptionKey)LoadCmdOptions.OPT_ALLOW), client, repo, config);
        LoadResultDTO result = null;
        try {
            result = client.postLoadCFA(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.LoadCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        config.getSandboxHistoryRegistry().addWorkspace(cfaRoot, repo.getId().getUuidValue(), ws.workspaceItemId);
        if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0) {
            SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getSandboxUpdateDilemma().getBackedUpToShed());
        }
        if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
            SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)out);
        }
        if (result.isSetEclipseReadFailureMessage()) {
            IndentingPrintStream err = config.getWrappedErrorStream();
            for (Object nextMsg : result.getEclipseReadFailureMessage()) {
                err.println((CharSequence)((String)nextMsg));
            }
        }
        if (!quiet) {
            out.println((CharSequence)Messages.LoadCmd_SUCCESSFULLY_COMPLETED);
        }
    }

    private ParmsLoad generateLoadParms(ParmsWorkspace ws, List<String> compSelectors, boolean getAll, boolean loadCompRoots, ILocation cfaRoot, IRelativeLocation relativeLoadTarget, String alternativeName, IFilesystemRestClient client, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        ParmsLoad parms = new ParmsLoad();
        parms.deleteRemovedShares = true;
        parms.preserveLocalChanges = config.getSubcommandCommandLine().hasOption(LoadCmdOptions.OPT_RESYNC);
        parms.preserveFileTimestamps = config.getSubcommandCommandLine().hasOption((IOptionKey)LoadCmdOptions.OPT_PRESERVE_TIMESTAMPS);
        parms.expandKeywords = config.getSubcommandCommandLine().hasOption((IOptionKey)LoadCmdOptions.OPT_EXPAND_KEYWORDS);
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        ArrayList<ParmsLoadComponentVersionables> compVersionables = new ArrayList<ParmsLoadComponentVersionables>();
        ArrayList<ParmsLoadVersionable> versionables = new ArrayList<ParmsLoadVersionable>();
        if (compSelectors == null || compSelectors.size() == 0) {
            compSelectors = new ArrayList<String>(1);
            compSelectors.add(Character.toString('/'));
        }
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        for (String selector : compSelectors) {
            WorkspaceComponentDTO comp2;
            String[] path = StringUtil.splitEscapedPath((String)selector);
            if (path.length == 0) {
                if (alternativeName != null) {
                    ICommandLine subargs = config.getSubcommandCommandLine();
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_TOO_MANY_COMPONENTS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
                }
                if (relativeLoadTarget != null) {
                    throw StatusHelper.argSyntax((String)Messages.LoadCmd_REMOTE_PATH_DISALLOWED);
                }
                for (WorkspaceComponentDTO comp2 : wsDetails.getComponents()) {
                    if (alternativeName != null || loadCompRoots) {
                        versionables.add(this.generateVersionables(ws, comp2, cfaRoot, relativeLoadTarget, alternativeName, loadCompRoots, null));
                        continue;
                    }
                    compVersionables.add(this.generateComponentVersionables(ws, comp2, cfaRoot, relativeLoadTarget));
                }
                continue;
            }
            comp2 = RepoUtil.getComponent((WorkspaceDetailsDTO)wsDetails, (String)path[0], (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            ScmVersionable remoteItem = null;
            if (path.length > 1) {
                String[] componentPath = new String[path.length - 1];
                System.arraycopy(path, 1, componentPath, 0, componentPath.length);
                remoteItem = RepoUtil.getVersionableByPath((IScmRichClientRestService)scmService, (String)wsDetails.getItemId(), (String)comp2.getItemId(), (String)StringUtil.createPathString((String[])componentPath), (IScmClientConfiguration)config);
            }
            if (remoteItem != null || alternativeName != null || loadCompRoots) {
                ParmsLoadVersionable ver = this.generateVersionables(ws, comp2, cfaRoot, relativeLoadTarget, alternativeName, loadCompRoots, remoteItem);
                versionables.add(ver);
                continue;
            }
            ParmsLoadComponentVersionables compVer = this.generateComponentVersionables(ws, comp2, cfaRoot, relativeLoadTarget);
            compVersionables.add(compVer);
        }
        if (compVersionables.size() > 0) {
            parms.componentVersionablesToLoad = compVersionables.toArray(new ParmsLoadComponentVersionables[compVersionables.size()]);
        }
        if (versionables.size() > 0) {
            parms.versionablesToLoad = versionables.toArray(new ParmsLoadVersionable[versionables.size()]);
        }
        return parms;
    }

    private ParmsLoadComponentVersionables generateComponentVersionables(ParmsWorkspace ws, WorkspaceComponentDTO comp, ILocation cfaRoot, IRelativeLocation relativeLoadTarget) {
        ParmsLoadComponentVersionables parms = new ParmsLoadComponentVersionables();
        parms.workspace = ws;
        parms.componentItemId = comp.getItemId();
        parms.sandboxPath = cfaRoot.toOSString();
        if (relativeLoadTarget != null) {
            parms.relativeLoadPath = relativeLoadTarget.toPath().toOSString();
        }
        return parms;
    }

    private ParmsLoadVersionable generateVersionables(ParmsWorkspace ws, WorkspaceComponentDTO comp, ILocation cfaRoot, IRelativeLocation relativeLoadTarget, String alternativeName, boolean loadCompRoots, ScmVersionable remoteItem) {
        ParmsLoadVersionable parms = new ParmsLoadVersionable();
        parms.workspace = ws;
        parms.componentItemId = comp.getItemId();
        parms.sandboxPath = cfaRoot.toOSString();
        if (relativeLoadTarget != null) {
            parms.relativeLoadPath = relativeLoadTarget.toPath().toOSString();
        }
        if (alternativeName != null || loadCompRoots && remoteItem == null) {
            String string = parms.alternativeName = loadCompRoots ? comp.getName() : alternativeName;
        }
        if (remoteItem != null) {
            parms.versionableItemType = remoteItem.getVersionable() instanceof IFolderHandle ? "folder" : (remoteItem.getVersionable() instanceof IFileItemHandle ? "file" : "symbolic_link");
            parms.versionableItemId = remoteItem.getVersionable().getItemId().getUuidValue();
        } else {
            parms.versionableItemType = "folder";
            parms.versionableItemId = comp.getRootFolder();
        }
        return parms;
    }

    private ParmsLoad generateLoadParms(ParmsWorkspace ws, List<String> compSelectors, LoadCmdLauncher.LoadRuleConfig loadRuleConfig, ILocation cfaRoot, IRelativeLocation relativeLoadTarget, IFilesystemRestClient client, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        assert (loadRuleConfig != null);
        ParmsLoad parms = new ParmsLoad();
        parms.deleteRemovedShares = true;
        parms.loadRule = new ParmsLoadRule();
        parms.preserveLocalChanges = config.getSubcommandCommandLine().hasOption(LoadCmdOptions.OPT_RESYNC);
        parms.preserveFileTimestamps = config.getSubcommandCommandLine().hasOption((IOptionKey)LoadCmdOptions.OPT_PRESERVE_TIMESTAMPS);
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        ParmsLoadRule parmsLoadRule = new ParmsLoadRule();
        parmsLoadRule.workspace = ws;
        parmsLoadRule.sandboxPath = cfaRoot.toOSString();
        if (loadRuleConfig instanceof LoadCmdLauncher.RemoteLoadRuleConfig) {
            LoadCmdLauncher.RemoteLoadRuleConfig remoteRule = (LoadCmdLauncher.RemoteLoadRuleConfig)loadRuleConfig;
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            String[] path = StringUtil.splitEscapedPath((String)remoteRule.remotePath);
            WorkspaceComponentDTO comp = null;
            try {
                comp = RepoUtil.getComponent((WorkspaceDetailsDTO)wsDetails, (String)path[0], (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                String[] newPath = new String[path.length - 1];
                System.arraycopy(path, 1, newPath, 0, path.length - 1);
                path = newPath;
            }
            catch (Exception newPath) {
                // empty catch block
            }
            if (comp == null) {
                if (compSelectors == null || compSelectors.size() != 1) {
                    throw StatusHelper.argSyntax((String)Messages.LoadCmd_COMP_NOT_FOUND_IN_PATH);
                }
                comp = RepoUtil.getComponent((WorkspaceDetailsDTO)wsDetails, (String)compSelectors.get(0), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            }
            String remotePath = StringUtil.createPathString((String[])path);
            ScmVersionable verDTO = RepoUtil.getVersionableByPath((IScmRichClientRestService)scmService, (String)ws.workspaceItemId, (String)comp.getItemId(), (String)remotePath, (IScmClientConfiguration)config);
            if (!(verDTO.getVersionable() instanceof IFileItemHandle)) {
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_28, (Object)remotePath));
            }
            parmsLoadRule.componentItemId = comp.getItemId();
            parmsLoadRule.loadRuleFileItemId = verDTO.getVersionable().getItemId().getUuidValue();
            if (compSelectors != null) {
                parmsLoadRule.componentItemIdFilter = new String[compSelectors.size()];
                int count = 0;
                for (String compSelector : compSelectors) {
                    WorkspaceComponentDTO component = RepoUtil.getComponent((WorkspaceDetailsDTO)wsDetails, (String)compSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                    parmsLoadRule.componentItemIdFilter[count] = component.getItemId();
                }
            }
        } else {
            assert (loadRuleConfig instanceof LoadCmdLauncher.LocalLoadRuleConfig);
            LoadCmdLauncher.LocalLoadRuleConfig localRule = (LoadCmdLauncher.LocalLoadRuleConfig)loadRuleConfig;
            parmsLoadRule.loadRuleFileContents = this.getFileContent(localRule.localPath, config);
            if (compSelectors != null) {
                parmsLoadRule.componentItemIdFilter = new String[compSelectors.size()];
                int count = 0;
                for (String compSelector : compSelectors) {
                    WorkspaceComponentDTO component = RepoUtil.getComponent((WorkspaceDetailsDTO)wsDetails, (String)compSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                    parmsLoadRule.componentItemIdFilter[count] = component.getItemId();
                }
            }
        }
        if (relativeLoadTarget != null) {
            parmsLoadRule.subFolder = relativeLoadTarget.getName();
        }
        parms.loadRule = parmsLoadRule;
        return parms;
    }

    private String getFileContent(String path, IScmClientConfiguration config) throws FileSystemException {
        String filename;
        InputStream in;
        if ("-".equals(path)) {
            in = config.getContext().stdin();
            filename = Messages.LoadCmd_30;
        } else {
            try {
                filename = SubcommandUtil.canonicalize((String)path);
            }
            catch (FileSystemException e) {
                filename = path;
            }
            Path localFile = new Path(filename);
            ResourceType resourceType = SubcommandUtil.getResourceType((IPath)localFile, null);
            if (resourceType == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_31, (Object)filename));
            }
            if (resourceType != ResourceType.FILE) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_32, (Object)filename));
            }
            try {
                in = new FileInputStream(localFile.toFile());
            }
            catch (FileNotFoundException e) {
                throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.LoadCmd_33, (Object)filename, (Object)e.getMessage()));
            }
        }
        StringBuilder out = new StringBuilder();
        char[] buffer = new char[65536];
        try {
            try {
                int read;
                InputStreamReader inReader = new InputStreamReader(in);
                while ((read = inReader.read(buffer, 0, buffer.length)) != -1) {
                    out.append(buffer, 0, read);
                }
            }
            catch (Exception e) {
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_34, (Object)filename, (Object)e.getMessage()));
            }
        }
        finally {
            try {
                if (!filename.equals(Messages.LoadCmd_30)) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return out.toString();
    }

    private void evaluateLoad(ParmsLoad parms, boolean overwrite, boolean allowMultipleLocations, IFilesystemRestClient client, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        boolean doNotReportOutOfSyncOrCollisions;
        LoadEvaluationDTO result = null;
        try {
            result = client.postValidateLoadCFA(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.LoadCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        IndentingPrintStream err = config.getWrappedErrorStream();
        if (result.isInvalidFilterForOldLoadRuleFormat()) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_INVALID_OLD_LOAD_RULE_FILTER, (Object)((OptionKey)LoadCmdOptions.OPT_REMOTE_PATHS).getName()));
        }
        if (result.getLoadRuleProblems().size() > 0) {
            this.processLoadRuleProblems(result.getLoadRuleProblems(), err, client, config);
        }
        boolean bl = doNotReportOutOfSyncOrCollisions = overwrite || parms.preserveLocalChanges != false;
        if (result.getCollisions().size() > 0) {
            this.processCollisions(result.getCollisions(), doNotReportOutOfSyncOrCollisions, err, client, config);
        }
        if (result.getInvalidLoadLocations().size() > 0) {
            this.processInvalidLoadRequests(result.getInvalidLoadLocations(), err, client, config);
        }
        if (result.getInvalidLoadRequests().size() > 0) {
            this.processInvalidLoadRequests(result.getInvalidLoadRequests(), err, client, config);
        }
        if (result.getOverlappingLoadRequests().size() > 0) {
            this.processOverlappingLoadRequests(result.getOverlappingLoadRequests(), err, client, config);
        }
        if (!doNotReportOutOfSyncOrCollisions && result.getSharesOutOfSync().size() > 0) {
            AcceptResultDisplayer.showOutOfSync(result.getSharesOutOfSync(), config);
        }
        if (!allowMultipleLocations && result.getMultipleSandboxLoads().size() > 0) {
            this.processMultipleSandboxLoads(result.getMultipleSandboxLoads(), err, client, config);
        }
    }

    private void processLoadRuleProblems(List<StatusDTO> loadRuleProblems, IndentingPrintStream err, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        Iterator<StatusDTO> iterator = loadRuleProblems.iterator();
        if (iterator.hasNext()) {
            StatusDTO status = iterator.next();
            throw StatusHelper.createException((String)status.getMessage(), (int)44, null);
        }
    }

    private void processMultipleSandboxLoads(List<MultipleSandboxLoadDTO> multipleSandboxLoads, IndentingPrintStream err, IFilesystemRestClient client, IScmClientConfiguration config) throws CLIFileSystemClientException {
        if (((ScmClientConfiguration)config).getPersistentPreferences().getAllowMultipleSandboxLoad()) {
            return;
        }
        for (MultipleSandboxLoadDTO multipleSandboxLoadDTO : multipleSandboxLoads) {
            boolean error = false;
            String conflictWorkspaceName = multipleSandboxLoadDTO.getRemoteLoadConflictWorkspaceName();
            if (!conflictWorkspaceName.isEmpty()) {
                String lastLoadHost = multipleSandboxLoadDTO.getRemoteLoadConflictHostName();
                String lastLoadPath = multipleSandboxLoadDTO.getRemoteLoadConflictPath();
                err.println((CharSequence)NLS.bind((String)Messages.LoadCmd_MULTIPLE_SANDBOX_LOAD_DETAIL, (Object[])new String[]{conflictWorkspaceName, lastLoadPath, lastLoadHost}));
                error = true;
            }
            if (!error) continue;
            String msg = NLS.bind((String)Messages.LoadCmd_MULTIPLE_SANDBOX_LOAD_SUMMARY, (Object)LoadCmdOptions.OPT_ALLOW.getName());
            throw StatusHelper.collision((String)msg);
        }
    }

    private void processCollisions(List<CollisionDTO> collisions, boolean overwrite, IndentingPrintStream err, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        StringBuffer msg;
        boolean collisionWithExistingShare = false;
        boolean collisionWithExistingItem = false;
        for (CollisionDTO collision : collisions) {
            if (!overwrite || collision.getLoadLocations().size() > 1) {
                err.println((CharSequence)collision.getDetail());
                ArrayList<String> compList = new ArrayList<String>();
                for (LoadLocationDTO location : collision.getLoadLocations()) {
                    if (compList.contains(location.getComponentItemId())) continue;
                    this.printComponent(location, err.indent(), client, config);
                    compList.add(location.getComponentItemId());
                }
                collisionWithExistingShare = true;
            }
            if (!collision.isCollidedWithExistingContent() || overwrite) continue;
            PathDTO path = collision.getPath();
            config.getWrappedErrorStream().println((CharSequence)NLS.bind((String)Messages.LoadCmd_16, (Object)StringUtil.createPathString((List)path.getSegments())));
            collisionWithExistingItem = true;
        }
        if (collisionWithExistingShare) {
            msg = new StringBuffer(Messages.LoadCmd_7).append(overwrite ? Messages.LoadCmd_8 : NLS.bind((String)Messages.LoadCmd_8_1, (Object)LoadCmdOptions.OPT_FORCE.getName()));
            throw StatusHelper.collision((String)msg.toString());
        }
        if (collisionWithExistingItem) {
            msg = new StringBuffer(Messages.LoadCmd_7).append(NLS.bind((String)Messages.LoadCmd_9, (Object)LoadCmdOptions.OPT_FORCE.getName()));
            throw StatusHelper.collision((String)msg.toString());
        }
    }

    private void printComponent(LoadLocationDTO location, IndentingPrintStream err, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(new ParmsWorkspace(location.getRepositoryURL(), location.getContextItemId())), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        WorkspaceComponentDTO compDTO = RepoUtil.getComponent((WorkspaceDetailsDTO)wsDetails, (String)location.getComponentItemId(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        err.println((CharSequence)NLS.bind((String)Messages.LoadCmd_24, (Object)AliasUtil.selector((String)compDTO.getName(), (UUID)UUID.valueOf((String)compDTO.getItemId()), (String)location.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
    }

    private void processInvalidLoadRequests(List<InvalidLoadRequestDTO> invalidLoadRequests, IndentingPrintStream err, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        err.println((CharSequence)Messages.LoadCmd_INVALID_LOAD_REQUEST);
        for (InvalidLoadRequestDTO invalidLoadRequest : invalidLoadRequests) {
            if (invalidLoadRequest.isSetReason()) {
                err.println((CharSequence)invalidLoadRequest.getReason().toString());
            }
            LoadLocationDTO location = invalidLoadRequest.getLoadLocation();
            this.printComponent(location, err.indent(), client, config);
        }
        throw StatusHelper.collision((String)new StringBuffer(Messages.LoadCmd_7).append(Messages.LoadCmd_OVERLAPPING_SHARES_SUMMARY).toString());
    }

    private void processOverlappingLoadRequests(List<LoadOverlapDTO> overlappingLoadRequests, IndentingPrintStream err, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<String> overlappedShares = new ArrayList<String>();
        ArrayList<String> compList = new ArrayList<String>();
        for (LoadOverlapDTO overlapLoadRequest : overlappingLoadRequests) {
            LoadLocationDTO location;
            if (overlapLoadRequest.getOverlappingShares().size() > 0) {
                if (overlapLoadRequest.getOverlappingShares().size() == 0) {
                    err.println((CharSequence)Messages.LoadCmd_OVERLAPPING_SHARE_COMPLAINT);
                }
                for (ShareDTO share : overlapLoadRequest.getOverlappingShares()) {
                    String overlappedShare = StringUtil.createPathString((List)share.getPath().getSegments());
                    if (overlappedShares.contains(overlappedShare)) continue;
                    overlappedShares.add(overlappedShare);
                    err.indent().println((CharSequence)overlappedShare);
                }
            }
            if (overlappedShares.size() > 0 || overlapLoadRequest.getOverlappingItems().size() <= 0) continue;
            if (compList.size() == 0) {
                err.println((CharSequence)Messages.LoadCmd_OVERLAPPING_ITEM_COMPLAINT);
            }
            if (compList.contains((location = overlapLoadRequest.getLoadLocation()).getComponentItemId())) continue;
            this.printComponent(location, err.indent(), client, config);
            compList.add(location.getComponentItemId());
        }
        StringBuffer msg = new StringBuffer(Messages.LoadCmd_7).append(overlappedShares.size() > 0 ? Messages.LoadCmd_OVERLAPPING_SHARES_SUMMARY : Messages.LoadCmd_OVERLAPPING_ITEMS_SUMMARY);
        throw StatusHelper.collision((String)msg.toString());
    }
}

